/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.request.components.editor.views.source;

import com.eviware.soapui.impl.wsdl.panels.request.components.editor.XmlEditor;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.XmlLocation;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.support.AbstractEditorView;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.support.ValidationError;
import com.eviware.soapui.support.DocumentListenerAdapter;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.swing.SoapUISplitPaneUI;
import com.eviware.soapui.support.xml.JXEditTextArea;
import com.eviware.soapui.support.xml.actions.FormatXmlAction;
import com.eviware.soapui.support.xml.actions.SaveXmlTextAreaAction;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;

public class XmlSourceEditorView
extends AbstractEditorView
implements PropertyChangeListener {
    private JXEditTextArea editArea;
    private ValidateMessageXmlAction validateXmlAction;
    private JSplitPane splitter;
    private JScrollPane errorScrollPane;
    private DefaultListModel errorListModel;
    private FormatXmlAction formatXmlAction;
    private SaveXmlTextAreaAction saveXmlTextAreaAction;
    private boolean updating;
    private JPopupMenu editorPopup;
    public boolean isLocating;

    public XmlSourceEditorView(XmlEditor xmlEditor) {
        super("XML");
    }

    protected void buildUI() {
        this.editArea = JXEditTextArea.createXmlEditor();
        this.editArea.setMinimumSize(new Dimension(50, 50));
        this.editArea.setCaretPosition(0);
        this.editArea.setDiscardEditsOnSet(false);
        this.editArea.setEnabled(false);
        this.errorListModel = new DefaultListModel();
        JList list = new JList(this.errorListModel);
        list.addMouseListener(new ValidationListMouseAdapter(list, this.editArea));
        this.errorScrollPane = new JScrollPane(list);
        this.errorScrollPane.setVisible(false);
        this.splitter = new JSplitPane(0){

            public void requestFocus() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        XmlSourceEditorView.this.editArea.requestFocusInWindow();
                    }
                });
            }

            public boolean hasFocus() {
                return XmlSourceEditorView.this.editArea.hasFocus();
            }
        };
        this.splitter.setUI(new SoapUISplitPaneUI());
        this.splitter.setDividerSize(0);
        this.splitter.setOneTouchExpandable(true);
        this.editorPopup = new JPopupMenu();
        this.buildPopup(this.editorPopup, this.editArea);
        this.editArea.setRightClickPopup(this.editorPopup);
        this.editArea.getDocument().addDocumentListener(new DocumentListenerAdapter(){

            public void update(Document document) {
                if (!XmlSourceEditorView.this.updating && XmlSourceEditorView.this.getXmlDocument() != null) {
                    XmlSourceEditorView.this.updating = true;
                    XmlSourceEditorView.this.getXmlDocument().setXml(XmlSourceEditorView.this.editArea.getText());
                    XmlSourceEditorView.this.updating = false;
                }
            }
        });
        this.editArea.getInputHandler().addKeyBinding("A+V", this.validateXmlAction);
        this.editArea.getInputHandler().addKeyBinding("A+F", this.formatXmlAction);
        this.editArea.getInputHandler().addKeyBinding("C+S", this.saveXmlTextAreaAction);
        this.splitter.setTopComponent(new JScrollPane(this.editArea));
        this.splitter.setBottomComponent(this.errorScrollPane);
        this.splitter.setDividerLocation(1.0);
        this.splitter.setBorder(null);
    }

    protected void buildPopup(JPopupMenu inputPopup, JXEditTextArea editArea) {
        this.validateXmlAction = new ValidateMessageXmlAction();
        this.formatXmlAction = new FormatXmlAction(editArea);
        this.saveXmlTextAreaAction = new SaveXmlTextAreaAction(editArea, "Save");
        inputPopup.add(this.validateXmlAction);
        inputPopup.add(this.formatXmlAction);
        inputPopup.addSeparator();
        inputPopup.add(editArea.getUndoAction());
        inputPopup.add(editArea.getRedoAction());
        inputPopup.add(editArea.getCopyAction());
        inputPopup.add(editArea.getCutAction());
        inputPopup.add(editArea.getPasteAction());
        inputPopup.addSeparator();
        inputPopup.add(editArea.getFindAndReplaceAction());
        inputPopup.addSeparator();
        inputPopup.add(this.saveXmlTextAreaAction);
    }

    public JXEditTextArea getInputArea() {
        this.getComponent();
        return this.editArea;
    }

    public void setEditable(boolean enabled) {
        this.getComponent();
        this.editArea.setEditable(enabled);
    }

    protected ValidationError[] validateXml(String xml) {
        return null;
    }

    public boolean activate(XmlLocation location) {
        super.activate(location);
        if (location != null) {
            this.setLocation(location);
        }
        this.editArea.requestFocus();
        return true;
    }

    public JComponent getComponent() {
        if (this.splitter == null) {
            this.buildUI();
        }
        return this.splitter;
    }

    public XmlLocation getLocation() {
        return new XmlLocation(this.getCurrentLine(), this.getCurrentColumn());
    }

    public void setLocation(XmlLocation location) {
        if (location != null && location.getLine() >= 0) {
            int offset = this.editArea.getLineStartOffset(location.getLine());
            try {
                this.editArea.setCaretPosition(offset + location.getColumn());
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
    }

    public int getCurrentLine() {
        if (this.editArea == null) {
            return -1;
        }
        return this.editArea.getCaretLine();
    }

    public int getCurrentColumn() {
        if (this.editArea == null) {
            return -1;
        }
        return this.editArea.getCaretColumn();
    }

    public String getText() {
        if (this.editArea == null) {
            return null;
        }
        return this.editArea.getText();
    }

    public boolean validate() {
        ValidationError[] errors = this.validateXml(this.editArea.getText());
        this.errorListModel.clear();
        if (errors == null || errors.length == 0) {
            this.splitter.setDividerLocation(1.0);
            this.splitter.setDividerSize(0);
            this.errorScrollPane.setVisible(false);
            return true;
        }
        Toolkit.getDefaultToolkit().beep();
        for (int c = 0; c < errors.length; ++c) {
            this.errorListModel.addElement(errors[c]);
        }
        this.errorScrollPane.setVisible(true);
        this.splitter.setDividerLocation(0.8);
        this.splitter.setDividerSize(10);
        return false;
    }

    protected void setXml(String xml) {
        if (!this.updating) {
            this.updating = true;
            if (xml == null) {
                this.editArea.setText("");
                this.editArea.setEnabled(false);
            } else {
                this.editArea.setEnabled(true);
                this.editArea.setText(xml);
                this.editArea.setCaretPosition(0);
            }
            this.updating = false;
        }
    }

    public boolean saveDocument(boolean validate) {
        return validate ? this.validate() : true;
    }

    public void locationChanged(XmlLocation location) {
        this.isLocating = true;
        this.setLocation(location);
        this.isLocating = false;
    }

    public JPopupMenu getEditorPopup() {
        return this.editorPopup;
    }

    public boolean hasFocus() {
        return this.editArea.hasFocus();
    }

    public boolean isInspectable() {
        return true;
    }

    public String getViewId() {
        return "Source";
    }

    public class ValidateMessageXmlAction
    extends AbstractAction {
        public ValidateMessageXmlAction() {
            super("Validate");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("alt V"));
        }

        public void actionPerformed(ActionEvent e) {
            if (XmlSourceEditorView.this.validate()) {
                UISupport.showInfoMessage("Validation OK");
            }
        }
    }

    private static final class ValidationListMouseAdapter
    extends MouseAdapter {
        private final JList list;
        private final JXEditTextArea textArea;

        public ValidationListMouseAdapter(JList list, JXEditTextArea textArea) {
            this.list = list;
            this.textArea = textArea;
        }

        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() < 2) {
                return;
            }
            int ix = this.list.getSelectedIndex();
            if (ix == -1) {
                return;
            }
            Object obj = this.list.getModel().getElementAt(ix);
            if (obj instanceof ValidationError) {
                ValidationError error = (ValidationError)obj;
                if (error.getLineNumber() >= 0) {
                    this.textArea.setCaretPosition(this.textArea.getLineStartOffset(error.getLineNumber() - 1));
                    this.textArea.requestFocus();
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

