/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.panels.mockoperation;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.AbstractWsdlModelItem;
import com.eviware.soapui.impl.wsdl.actions.support.ShowOnlineHelpAction;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockRequest;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResponse;
import com.eviware.soapui.impl.wsdl.mock.WsdlMockResult;
import com.eviware.soapui.impl.wsdl.panels.attachments.MockAttachmentPanel;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.MockRequestXmlDocument;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.MockResponseXmlDocument;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.actions.CreateEmptyMockResponseAction;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.actions.CreateFaultMockResponseAction;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.actions.OpenRequestForMockOperationAction;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.actions.RecreateMockResponseAction;
import com.eviware.soapui.impl.wsdl.panels.mockoperation.actions.WSIValidateResponseAction;
import com.eviware.soapui.impl.wsdl.panels.request.StringToStringMapTableModel;
import com.eviware.soapui.impl.wsdl.panels.request.components.RequestMessageXmlEditor;
import com.eviware.soapui.impl.wsdl.panels.request.components.ResponseMessageXmlEditor;
import com.eviware.soapui.impl.wsdl.panels.request.components.SoapMessageXmlEditor;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.XmlDocument;
import com.eviware.soapui.impl.wsdl.panels.request.components.editor.views.source.XmlSourceEditorView;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditor;
import com.eviware.soapui.impl.wsdl.panels.teststeps.support.GroovyEditorModel;
import com.eviware.soapui.model.ModelItem;
import com.eviware.soapui.model.mock.MockRunner;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.support.AbstractModelItem;
import com.eviware.soapui.settings.UISettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.actions.ChangeSplitPaneOrientationAction;
import com.eviware.soapui.support.components.JEditorStatusBarWithProgress;
import com.eviware.soapui.support.components.JXToolBar;
import com.eviware.soapui.support.swing.SoapUISplitPaneUI;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.soapui.support.xml.JXEditTextArea;
import com.eviware.soapui.ui.support.ModelItemDesktopPanel;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractWsdlMockResponseDesktopPanel<T extends ModelItem, T2 extends WsdlMockResponse>
extends ModelItemDesktopPanel<T> {
    private JEditorStatusBarWithProgress statusBar;
    private JButton splitButton;
    private MockRunner mockRunner;
    private JButton recreateButton;
    private JButton createEmptyButton;
    private JSplitPane requestSplitPane;
    private MoveFocusAction moveFocusAction;
    private ClosePanelAction closePanelAction = new ClosePanelAction();
    private RunScriptAction runScriptAction = new RunScriptAction();
    private SoapMessageXmlEditor requestEditor;
    private SoapMessageXmlEditor responseEditor;
    public WSIValidateResponseAction wsiValidateAction;
    private JTabbedPane requestTabs;
    private JPanel requestTabPanel;
    private JToggleButton tabsButton;
    public boolean responseHasFocus;
    private JTabbedPane requestEditorTabs;
    private JTabbedPane responseEditorTabs;
    private JPanel requestEditorTabPanel;
    private JPanel responseEditorTabPanel;
    private InternalPropertyChangeListener propertyChangeListener = new InternalPropertyChangeListener();
    private StringToStringMapTableModel responseHeadersModel;
    private JTable responseHeadersTable;
    private StringToStringMapTableModel requestHeadersModel;
    private GroovyEditor responseScriptEditor;
    private JButton createFaultButton;
    private T2 mockResponse;
    private JButton openRequestButton;

    public AbstractWsdlMockResponseDesktopPanel(T modelItem) {
        super(modelItem);
    }

    protected void init(T2 mockResponse) {
        this.mockResponse = mockResponse;
        this.add((Component)this.buildContent(), "Center");
        this.add((Component)this.buildToolbar(), "North");
        this.add((Component)this.buildStatusLabel(), "South");
        this.setPreferredSize(new Dimension(600, 500));
        ((AbstractModelItem)mockResponse).addPropertyChangeListener(this.propertyChangeListener);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (AbstractWsdlMockResponseDesktopPanel.this.requestTabs.getSelectedIndex() == 1 || AbstractWsdlMockResponseDesktopPanel.this.responseHasFocus) {
                    AbstractWsdlMockResponseDesktopPanel.this.responseEditor.requestFocus();
                } else {
                    AbstractWsdlMockResponseDesktopPanel.this.requestEditor.requestFocus();
                }
            }
        });
    }

    protected WsdlMockResponse getMockResponse() {
        return this.mockResponse;
    }

    public final SoapMessageXmlEditor getRequestEditor() {
        return this.requestEditor;
    }

    public final SoapMessageXmlEditor getResponseEditor() {
        return this.responseEditor;
    }

    public MockRunner getSubmit() {
        return this.mockRunner;
    }

    protected JComponent buildStatusLabel() {
        this.statusBar = new JEditorStatusBarWithProgress();
        this.statusBar.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
        return this.statusBar;
    }

    public JEditorStatusBarWithProgress getStatusBar() {
        return this.statusBar;
    }

    protected JComponent buildContent() {
        this.requestSplitPane = UISupport.createHorizontalSplit();
        this.requestSplitPane.setResizeWeight(0.5);
        this.requestSplitPane.setBorder(null);
        this.splitButton = this.createActionButton(new ChangeSplitPaneOrientationAction(this.requestSplitPane), true);
        this.tabsButton = new JToggleButton(new ChangeToTabsAction());
        this.tabsButton.setPreferredSize(UISupport.TOOLBAR_BUTTON_DIMENSION);
        this.openRequestButton = this.createActionButton(new OpenRequestForMockOperationAction(((WsdlMockResponse)this.mockResponse).getMockOperation()), true);
        this.recreateButton = this.createActionButton(new RecreateMockResponseAction((WsdlMockResponse)this.mockResponse), true);
        this.createEmptyButton = this.createActionButton(new CreateEmptyMockResponseAction((WsdlMockResponse)this.mockResponse), true);
        this.createFaultButton = this.createActionButton(new CreateFaultMockResponseAction((WsdlMockResponse)this.mockResponse), true);
        this.moveFocusAction = new MoveFocusAction();
        this.wsiValidateAction = new WSIValidateResponseAction((WsdlMockResponse)this.mockResponse);
        this.requestEditor = this.buildRequestEditor();
        this.responseEditor = this.buildResponseEditor();
        JComponent scriptEditor = this.buildResponseScriptEditor();
        WsdlMockResult mockResult = ((WsdlMockResponse)this.mockResponse).getMockResult();
        int requestHeadersSize = mockResult == null ? -1 : mockResult.getMockRequest().getRequestHeaders().size();
        int requestAttachmentsSize = mockResult == null ? -1 : mockResult.getMockRequest().getRequestAttachments().length;
        this.requestEditorTabs = new JTabbedPane(3);
        this.requestEditorTabs.setTabLayoutPolicy(1);
        this.requestEditorTabs.addTab("SOAP Request", this.requestEditor);
        this.requestEditorTabs.addTab("Request Attachments (" + (requestAttachmentsSize == -1 ? "-" : Integer.valueOf(requestAttachmentsSize)) + ")", new MockAttachmentPanel((WsdlMockResponse)this.mockResponse, false));
        this.requestEditorTabs.addTab("HTTP Headers (" + (requestHeadersSize == -1 ? "-" : Integer.valueOf(requestHeadersSize)) + ")", this.createRequestHttpHeadersPanel());
        this.responseEditorTabs = new JTabbedPane(3);
        this.responseEditorTabs.setTabLayoutPolicy(1);
        this.responseEditorTabs.addTab("Mock Response", this.responseEditor);
        this.responseEditorTabs.addTab("Response Script", scriptEditor);
        this.responseEditorTabs.addTab("Response Attachments (" + ((WsdlMockResponse)this.mockResponse).getAttachments().length + ")", new MockAttachmentPanel((WsdlMockResponse)this.mockResponse, true));
        this.responseEditorTabs.addTab("Response HTTP Headers", this.createResponseHttpHeadersPanel());
        this.responseEditorTabs.setTitleAt(3, "Response HTTP Headers (" + this.responseHeadersModel.getRowCount() + ")");
        this.requestTabs = new JTabbedPane();
        this.requestTabPanel = UISupport.createTabPanel(this.requestTabs, true);
        this.requestEditorTabPanel = UISupport.createTabPanel(this.requestEditorTabs, false);
        this.responseEditorTabPanel = UISupport.createTabPanel(this.responseEditorTabs, false);
        JComponent component = null;
        if (((AbstractWsdlModelItem)this.mockResponse).getSettings().getBoolean(UISettings.START_WITH_REQUEST_TABS)) {
            this.requestTabs.addTab("Last Request", this.requestEditorTabPanel);
            this.requestTabs.addTab("Mock Response", this.responseEditorTabPanel);
            this.splitButton.setEnabled(false);
            this.tabsButton.setSelected(true);
            component = this.requestTabPanel;
            this.requestTabs.setSelectedIndex(1);
        } else {
            this.requestSplitPane.setTopComponent(this.requestEditorTabPanel);
            this.requestSplitPane.setBottomComponent(this.responseEditorTabPanel);
            this.requestSplitPane.setDividerLocation(0.5);
            component = this.requestSplitPane;
        }
        return component;
    }

    private Component createRequestHttpHeadersPanel() {
        this.requestHeadersModel = new StringToStringMapTableModel(new StringToStringMap(), "Header", "Value", false);
        this.requestHeadersModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent arg0) {
                AbstractWsdlMockResponseDesktopPanel.this.requestEditorTabs.setTitleAt(2, "HTTP Headers (" + AbstractWsdlMockResponseDesktopPanel.this.requestHeadersModel.getRowCount() + ")");
            }
        });
        JTable requestHeadersTable = new JTable(this.requestHeadersModel);
        return new JScrollPane(requestHeadersTable);
    }

    private Component createResponseHttpHeadersPanel() {
        this.responseHeadersModel = new StringToStringMapTableModel(((WsdlMockResponse)this.mockResponse).getResponseHeaders(), "Header", "Value", true);
        this.responseHeadersModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent arg0) {
                AbstractWsdlMockResponseDesktopPanel.this.mockResponse.setResponseHeaders(AbstractWsdlMockResponseDesktopPanel.this.responseHeadersModel.getData());
                AbstractWsdlMockResponseDesktopPanel.this.responseEditorTabs.setTitleAt(3, "Response HTTP Headers (" + AbstractWsdlMockResponseDesktopPanel.this.responseHeadersModel.getRowCount() + ")");
            }
        });
        this.responseHeadersTable = new JTable(this.responseHeadersModel);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.responseHeadersTable), "Center");
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addFixed((JComponent)new JButton(new AbstractAction("Add"){

            public void actionPerformed(ActionEvent arg0) {
                String header = UISupport.prompt("Specify name of header to add", "Add HTTP Header", "");
                if (header != null) {
                    AbstractWsdlMockResponseDesktopPanel.this.responseHeadersModel.add(header.toString(), "");
                }
            }
        }));
        builder.addRelatedGap();
        builder.addFixed((JComponent)new JButton(new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent arg0) {
                int row = AbstractWsdlMockResponseDesktopPanel.this.responseHeadersTable.getSelectedRow();
                if (row != -1 && UISupport.confirm("Delete selected header?", "Remove Header")) {
                    AbstractWsdlMockResponseDesktopPanel.this.responseHeadersModel.remove(row);
                }
            }
        }));
        builder.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        panel.add((Component)builder.getPanel(), "South");
        return panel;
    }

    protected JComponent buildResponseScriptEditor() {
        this.responseScriptEditor = new GroovyEditor(new MockResponseGroovyEditorModel());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.buildScriptToolbar(), "North");
        panel.add((Component)new JScrollPane(this.responseScriptEditor), "Center");
        return panel;
    }

    private JComponent buildScriptToolbar() {
        JXToolBar toolBar = UISupport.createToolbar();
        JButton runButton = UISupport.createToolbarButton(this.runScriptAction);
        toolBar.add(runButton);
        toolBar.add(Box.createHorizontalGlue());
        JLabel label = new JLabel("<html>Script is invoked with <code>log</code>, <code>context</code>, <code>mockRequest</code> and <code>mockResponse</code> variables</html>");
        label.setToolTipText(label.getText());
        label.setMaximumSize(label.getPreferredSize());
        toolBar.add(label);
        toolBar.addUnrelatedGap();
        toolBar.addFixed(this.createActionButton(new ShowOnlineHelpAction("http://www.soapui.org/userguide/mock/responses.html#Response_Scripts"), true));
        return toolBar;
    }

    protected SoapMessageXmlEditor buildResponseEditor() {
        return new ResponseMessageEditor(new MockResponseXmlDocument((WsdlMockResponse)this.mockResponse));
    }

    protected SoapMessageXmlEditor buildRequestEditor() {
        return new RequestMessageEditor(new MockRequestXmlDocument((WsdlMockResponse)this.mockResponse));
    }

    protected JComponent buildToolbar() {
        JXToolBar toolbar = UISupport.createToolbar();
        toolbar.add(this.openRequestButton);
        toolbar.addUnrelatedGap();
        toolbar.add(this.recreateButton);
        toolbar.add(this.createEmptyButton);
        toolbar.add(this.createFaultButton);
        this.createToolbar(toolbar);
        toolbar.add(Box.createHorizontalGlue());
        toolbar.add(this.tabsButton);
        toolbar.add(this.splitButton);
        toolbar.add(UISupport.createToolbarButton(new ShowOnlineHelpAction(this.getHelpUrl())));
        return toolbar;
    }

    protected void createToolbar(JXToolBar toolbar) {
    }

    protected String getHelpUrl() {
        return "http://www.soapui.org/userguide/requests.html#The_Request_Editor";
    }

    protected void insertButtons(JToolBar toolbar) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.requestEditor.getSourceEditor().setEditable(enabled);
        this.responseEditor.getSourceEditor().setEditable(enabled);
        this.recreateButton.setEnabled(enabled);
        this.createEmptyButton.setEnabled(enabled);
        this.statusBar.setIndeterminate(!enabled);
    }

    @Override
    public boolean dependsOn(ModelItem modelItem) {
        return modelItem == this.getModelItem() || modelItem == ((WsdlMockResponse)this.mockResponse).getMockOperation() || modelItem == ((WsdlMockResponse)this.mockResponse).getMockOperation().getMockService() || modelItem == ((WsdlMockResponse)this.mockResponse).getMockOperation().getMockService().getProject();
    }

    @Override
    public String getDescription() {
        return "MockResponse: [" + this.getModelItem().getName() + "] for " + ((WsdlMockResponse)this.mockResponse).getMockOperation().getName();
    }

    public void setContent(JComponent content) {
        this.add((Component)content, "Center");
    }

    public void removeContent(JComponent content) {
        this.remove(content);
    }

    @Override
    public boolean onClose(boolean canCancel) {
        ((AbstractModelItem)this.mockResponse).removePropertyChangeListener(this.propertyChangeListener);
        return this.release();
    }

    private class MockResponseGroovyEditorModel
    implements GroovyEditorModel {
        private MockResponseGroovyEditorModel() {
        }

        public String[] getKeywords() {
            return new String[]{"context", "mockRequest", "mockResponse"};
        }

        public Action getRunAction() {
            return AbstractWsdlMockResponseDesktopPanel.this.runScriptAction;
        }

        public String getScript() {
            return AbstractWsdlMockResponseDesktopPanel.this.mockResponse.getScript();
        }

        public void setScript(String text) {
            AbstractWsdlMockResponseDesktopPanel.this.mockResponse.setScript(text);
        }

        public Settings getSettings() {
            return SoapUI.getSettings();
        }
    }

    private class RunScriptAction
    extends AbstractAction {
        public RunScriptAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/run_groovy_script.gif"));
            this.putValue("ShortDescription", "Runs this script using mock httpRequest/httpResponse objects");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                AbstractWsdlMockResponseDesktopPanel.this.mockResponse.evaluateScript(AbstractWsdlMockResponseDesktopPanel.this.mockResponse.getMockResult() == null ? null : AbstractWsdlMockResponseDesktopPanel.this.mockResponse.getMockResult().getMockRequest());
                HashMap values = null;
                if (AbstractWsdlMockResponseDesktopPanel.this.mockResponse.getMockResult() != null) {
                    values = AbstractWsdlMockResponseDesktopPanel.this.mockResponse.getMockResult().getMockRequest().getContext().toStringToStringMap();
                }
                if (values == null || values.isEmpty()) {
                    UISupport.showInfoMessage("No values were returned");
                } else {
                    String msg = "<html><body>Returned values:<br>";
                    for (String name : values.keySet()) {
                        msg = msg + name + " : " + (String)values.get(name) + "<br>";
                    }
                    msg = msg + "</body></html>";
                    UISupport.showInfoMessage(msg);
                }
            }
            catch (RuntimeException e1) {
                AbstractWsdlMockResponseDesktopPanel.this.responseScriptEditor.selectError(e1.getMessage());
                UISupport.showErrorMessage(e1);
            }
        }
    }

    private final class ChangeToTabsAction
    extends AbstractAction {
        public ChangeToTabsAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/toggle_tabs.gif"));
            this.putValue("ShortDescription", "Toggles to tab-based layout");
        }

        public void actionPerformed(ActionEvent e) {
            if (AbstractWsdlMockResponseDesktopPanel.this.splitButton.isEnabled()) {
                AbstractWsdlMockResponseDesktopPanel.this.splitButton.setEnabled(false);
                AbstractWsdlMockResponseDesktopPanel.this.removeContent(AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane);
                AbstractWsdlMockResponseDesktopPanel.this.setContent(AbstractWsdlMockResponseDesktopPanel.this.requestTabPanel);
                AbstractWsdlMockResponseDesktopPanel.this.requestTabs.addTab("Last Request", AbstractWsdlMockResponseDesktopPanel.this.requestEditorTabPanel);
                AbstractWsdlMockResponseDesktopPanel.this.requestTabs.addTab("Mock Response", AbstractWsdlMockResponseDesktopPanel.this.responseEditorTabPanel);
                if (AbstractWsdlMockResponseDesktopPanel.this.responseHasFocus) {
                    AbstractWsdlMockResponseDesktopPanel.this.requestTabs.setSelectedIndex(1);
                    AbstractWsdlMockResponseDesktopPanel.this.requestEditorTabs.requestFocus();
                } else {
                    AbstractWsdlMockResponseDesktopPanel.this.responseEditorTabs.requestFocus();
                }
            } else {
                int selectedIndex = AbstractWsdlMockResponseDesktopPanel.this.requestTabs.getSelectedIndex();
                AbstractWsdlMockResponseDesktopPanel.this.splitButton.setEnabled(true);
                AbstractWsdlMockResponseDesktopPanel.this.removeContent(AbstractWsdlMockResponseDesktopPanel.this.requestTabPanel);
                AbstractWsdlMockResponseDesktopPanel.this.setContent(AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane);
                AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.setTopComponent(AbstractWsdlMockResponseDesktopPanel.this.requestEditorTabPanel);
                AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.setBottomComponent(AbstractWsdlMockResponseDesktopPanel.this.responseEditorTabPanel);
                AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.setDividerLocation(0.5);
                if (selectedIndex == 0) {
                    AbstractWsdlMockResponseDesktopPanel.this.requestEditor.requestFocus();
                } else {
                    AbstractWsdlMockResponseDesktopPanel.this.responseEditor.requestFocus();
                }
            }
            AbstractWsdlMockResponseDesktopPanel.this.revalidate();
        }
    }

    private class MoveFocusAction
    extends AbstractAction {
        private MoveFocusAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (AbstractWsdlMockResponseDesktopPanel.this.requestEditor.hasFocus()) {
                AbstractWsdlMockResponseDesktopPanel.this.responseEditor.requestFocus();
            } else {
                AbstractWsdlMockResponseDesktopPanel.this.requestEditor.requestFocus();
            }
        }
    }

    private class ClosePanelAction
    extends AbstractAction {
        private ClosePanelAction() {
        }

        public void actionPerformed(ActionEvent e) {
            SoapUI.getDesktop().closeDesktopPanel((ModelItem)AbstractWsdlMockResponseDesktopPanel.this.getModelItem());
        }
    }

    protected final class ResultAreaFocusListener
    implements FocusListener {
        protected ResultAreaFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            int maximumDividerLocation;
            AbstractWsdlMockResponseDesktopPanel.this.responseHasFocus = true;
            AbstractWsdlMockResponseDesktopPanel.this.statusBar.setTarget(AbstractWsdlMockResponseDesktopPanel.this.responseEditor.getSourceEditor().getInputArea());
            if (!AbstractWsdlMockResponseDesktopPanel.this.splitButton.isEnabled()) {
                AbstractWsdlMockResponseDesktopPanel.this.requestTabs.setSelectedIndex(1);
                return;
            }
            if (AbstractWsdlMockResponseDesktopPanel.this.getModelItem().getSettings().getBoolean(UISettings.NO_RESIZE_REQUEST_EDITOR)) {
                return;
            }
            if (((SoapUISplitPaneUI)AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.getUI()).hasBeenDragged()) {
                return;
            }
            int pos = AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.getDividerLocation();
            if (pos + 600 < (maximumDividerLocation = AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.getMaximumDividerLocation())) {
                return;
            }
            if (maximumDividerLocation > 700) {
                AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.setDividerLocation(maximumDividerLocation - 600);
            } else {
                AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.setDividerLocation(0.2);
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }

    protected final class InputAreaFocusListener
    implements FocusListener {
        protected InputAreaFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            AbstractWsdlMockResponseDesktopPanel.this.responseHasFocus = false;
            AbstractWsdlMockResponseDesktopPanel.this.statusBar.setTarget(AbstractWsdlMockResponseDesktopPanel.this.requestEditor.getSourceEditor().getInputArea());
            if (!AbstractWsdlMockResponseDesktopPanel.this.splitButton.isEnabled()) {
                AbstractWsdlMockResponseDesktopPanel.this.requestTabs.setSelectedIndex(0);
                return;
            }
            if (AbstractWsdlMockResponseDesktopPanel.this.getModelItem().getSettings().getBoolean(UISettings.NO_RESIZE_REQUEST_EDITOR)) {
                return;
            }
            if (((SoapUISplitPaneUI)AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.getUI()).hasBeenDragged()) {
                return;
            }
            int pos = AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.getDividerLocation();
            if (pos >= 600) {
                return;
            }
            if (AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.getMaximumDividerLocation() > 700) {
                AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.setDividerLocation(600);
            } else {
                AbstractWsdlMockResponseDesktopPanel.this.requestSplitPane.setDividerLocation(0.8);
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ResponseMessageEditor
    extends ResponseMessageXmlEditor<WsdlMockResponse> {
        public ResponseMessageEditor(XmlDocument document) {
            super(document, AbstractWsdlMockResponseDesktopPanel.this.mockResponse);
        }

        protected XmlSourceEditorView buildSourceEditor() {
            XmlSourceEditorView editor = this.getSourceEditor();
            JXEditTextArea inputArea = editor.getInputArea();
            inputArea.addFocusListener(new ResultAreaFocusListener());
            inputArea.getInputHandler().addKeyBinding("AC+TAB", AbstractWsdlMockResponseDesktopPanel.this.moveFocusAction);
            inputArea.getInputHandler().addKeyBinding("C+F4", AbstractWsdlMockResponseDesktopPanel.this.closePanelAction);
            JPopupMenu inputPopup = editor.getEditorPopup();
            inputPopup.insert(new JSeparator(), 2);
            inputPopup.insert(AbstractWsdlMockResponseDesktopPanel.this.wsiValidateAction, 3);
            return editor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RequestMessageEditor
    extends RequestMessageXmlEditor<WsdlMockResponse> {
        public RequestMessageEditor(XmlDocument document) {
            super(document, AbstractWsdlMockResponseDesktopPanel.this.mockResponse);
        }

        protected XmlSourceEditorView buildSourceEditor() {
            XmlSourceEditorView editor = this.getSourceEditor();
            JXEditTextArea inputArea = editor.getInputArea();
            inputArea.addFocusListener(new InputAreaFocusListener());
            inputArea.getInputHandler().addKeyBinding("AC+TAB", AbstractWsdlMockResponseDesktopPanel.this.moveFocusAction);
            inputArea.getInputHandler().addKeyBinding("F5", AbstractWsdlMockResponseDesktopPanel.this.recreateButton.getAction());
            inputArea.getInputHandler().addKeyBinding("C+F4", AbstractWsdlMockResponseDesktopPanel.this.closePanelAction);
            return editor;
        }
    }

    private final class InternalPropertyChangeListener
    implements PropertyChangeListener {
        private InternalPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals(WsdlMockResponse.MOCKRESULT_PROPERTY)) {
                WsdlMockRequest mockRequest = AbstractWsdlMockResponseDesktopPanel.this.mockResponse.getMockResult().getMockRequest();
                AbstractWsdlMockResponseDesktopPanel.this.requestEditor.getXmlDocument().setXml(mockRequest == null ? "" : mockRequest.getRequestContent());
                AbstractWsdlMockResponseDesktopPanel.this.requestHeadersModel.setData(mockRequest.getRequestHeaders());
                AbstractWsdlMockResponseDesktopPanel.this.requestEditorTabs.setTitleAt(2, "HTTP Headers (" + (mockRequest == null ? "-" : mockRequest.getRequestHeaders().size() + ")"));
                AbstractWsdlMockResponseDesktopPanel.this.requestEditorTabs.setTitleAt(1, "Request Attachments (" + (mockRequest == null ? 0 : mockRequest.getRequestAttachments().length) + ")");
                AbstractWsdlMockResponseDesktopPanel.this.wsiValidateAction.setEnabled(true);
            }
        }
    }
}

