/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest.log;

import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLogEntry;
import com.eviware.soapui.model.testsuite.TestStep;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.support.action.ActionList;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import javax.swing.ImageIcon;

public class LoadTestLogErrorEntry
implements LoadTestLogEntry {
    private final String error;
    private TestStepResult result;
    private String type;
    private ImageIcon icon;
    private long timestamp;

    public LoadTestLogErrorEntry(String type, String error, TestStepResult result, ImageIcon icon) {
        this.icon = icon;
        this.type = type;
        this.error = error;
        this.result = result;
        this.timestamp = result == null ? System.currentTimeMillis() : result.getTimeStamp();
    }

    public LoadTestLogErrorEntry(String type, String message, ImageIcon icon) {
        this.type = type;
        this.error = message;
        this.icon = icon;
        this.timestamp = System.currentTimeMillis();
    }

    public String getMessage() {
        return this.error;
    }

    public TestStepResult getTestStepResult() {
        return this.result;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public TestStep getTargetStep() {
        return this.result == null ? null : this.result.getTestStep();
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public String getType() {
        return this.type;
    }

    public boolean isError() {
        return true;
    }

    public ActionList getActions() {
        return this.result == null ? null : this.result.getActions();
    }

    public void exportToFile(String fileName) throws IOException {
        PrintWriter writer = new PrintWriter(fileName);
        writer.write(new Date(this.timestamp).toString());
        writer.write(":");
        writer.write(this.error);
        writer.println();
        if (this.result != null) {
            writer.println("----------------------------------------------------");
            this.result.writeTo(writer);
        }
        writer.close();
    }
}

