/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.loadtest;

import com.eviware.soapui.config.LoadTestConfig;
import com.eviware.soapui.config.LoadTestLimitTypesConfig;
import com.eviware.soapui.config.TestCaseConfig;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTest;
import com.eviware.soapui.impl.wsdl.loadtest.WsdlLoadTestContext;
import com.eviware.soapui.impl.wsdl.loadtest.log.LoadTestLogMessageEntry;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCase;
import com.eviware.soapui.impl.wsdl.testcase.WsdlTestCaseRunner;
import com.eviware.soapui.model.settings.Settings;
import com.eviware.soapui.model.support.PropertiesMap;
import com.eviware.soapui.model.testsuite.LoadTest;
import com.eviware.soapui.model.testsuite.LoadTestRunListener;
import com.eviware.soapui.model.testsuite.LoadTestRunner;
import com.eviware.soapui.model.testsuite.TestRunContext;
import com.eviware.soapui.model.testsuite.TestRunListener;
import com.eviware.soapui.model.testsuite.TestRunner;
import com.eviware.soapui.model.testsuite.TestStepResult;
import com.eviware.soapui.settings.HttpSettings;
import com.eviware.soapui.support.UISupport;
import com.eviware.x.dialogs.Worker;
import com.eviware.x.dialogs.XProgressDialog;
import com.eviware.x.dialogs.XProgressMonitor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class WsdlLoadTestRunner
implements LoadTestRunner {
    private final WsdlLoadTest loadTest;
    private ThreadGroup threadGroup;
    private Set<TestCaseRunner> runners = new HashSet<TestCaseRunner>();
    private long startTime = 0L;
    private InternalPropertyChangeListener internalPropertyChangeListener = new InternalPropertyChangeListener();
    private InternalTestRunListener testRunListener = new InternalTestRunListener();
    private LoadTestRunListener[] listeners;
    private long runCount;
    private LoadTestRunner.Status status;
    private WsdlLoadTestContext context;
    private String reason;
    private int threadCount;

    public WsdlLoadTestRunner(WsdlLoadTest test) {
        this.loadTest = test;
        this.threadGroup = new ThreadGroup(this.loadTest.getName());
        this.status = LoadTestRunner.Status.INITIALIZED;
    }

    public LoadTestRunner.Status getStatus() {
        return this.status;
    }

    void start() {
        this.startTime = System.currentTimeMillis();
        this.runners.clear();
        this.loadTest.addPropertyChangeListener(WsdlLoadTest.THREADCOUNT_PROPERTY, this.internalPropertyChangeListener);
        this.runCount = 0L;
        this.threadCount = 0;
        this.context = new WsdlLoadTestContext(this);
        this.status = LoadTestRunner.Status.RUNNING;
        for (LoadTestRunListener listener : this.listeners = this.loadTest.getLoadTestRunListeners()) {
            listener.beforeLoadTest(this, this.context);
        }
        this.loadTest.getLoadTestLog().addEntry(new LoadTestLogMessageEntry("LoadTest started at " + new Date(this.startTime)));
        int startDelay = this.loadTest.getStartDelay();
        if (startDelay > 0) {
            XProgressDialog progressDialog = UISupport.getDialogs().createProgressDialog("Starting threads", (int)this.loadTest.getThreadCount(), "", true);
            try {
                progressDialog.run(new Worker.WorkerAdapter(){
                    private List<WsdlTestCase> testCases = new ArrayList<WsdlTestCase>();

                    public Object construct(XProgressMonitor monitor) {
                        int startDelay = WsdlLoadTestRunner.this.loadTest.getStartDelay();
                        int c = 0;
                        while ((long)c < WsdlLoadTestRunner.this.loadTest.getThreadCount()) {
                            this.testCases.add(WsdlLoadTestRunner.this.createTestCase());
                            ++c;
                        }
                        int cnt = 0;
                        while (!this.testCases.isEmpty()) {
                            if (startDelay > 0) {
                                try {
                                    Thread.sleep(startDelay);
                                }
                                catch (InterruptedException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (WsdlLoadTestRunner.this.status != LoadTestRunner.Status.RUNNING || WsdlLoadTestRunner.this.getProgress() >= 1.0f || WsdlLoadTestRunner.this.loadTest.getLimitType() == LoadTestLimitTypesConfig.COUNT && (long)WsdlLoadTestRunner.this.runners.size() >= WsdlLoadTestRunner.this.loadTest.getTestLimit()) break;
                            if (this.testCases.isEmpty()) continue;
                            WsdlLoadTestRunner.this.startTestCase(this.testCases.remove(0));
                            monitor.setProgress(1, "Started thread " + ++cnt);
                        }
                        return null;
                    }

                    public boolean onCancel() {
                        WsdlLoadTestRunner.this.cancel("Stopped from UI during start-up");
                        while (!this.testCases.isEmpty()) {
                            this.testCases.remove(0).release();
                        }
                        return false;
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ArrayList<WsdlTestCase> testCases = new ArrayList<WsdlTestCase>();
            int c = 0;
            while ((long)c < this.loadTest.getThreadCount()) {
                testCases.add(this.createTestCase());
                ++c;
            }
            c = 0;
            while ((long)c < this.loadTest.getThreadCount() && (this.loadTest.getLimitType() != LoadTestLimitTypesConfig.COUNT || (long)this.runners.size() < this.loadTest.getTestLimit())) {
                this.startTestCase((WsdlTestCase)testCases.get(c));
                ++c;
            }
        }
        if (this.status == LoadTestRunner.Status.RUNNING) {
            for (LoadTestRunListener listener : this.listeners) {
                listener.loadTestStarted(this, this.context);
            }
        }
    }

    private TestCaseRunner startTestCase(WsdlTestCase testCase) {
        TestCaseRunner testCaseRunner = new TestCaseRunner(testCase, this.threadCount++);
        Thread thread = new Thread(this.threadGroup, testCaseRunner);
        thread.start();
        this.runners.add(testCaseRunner);
        return testCaseRunner;
    }

    public void cancel(String reason) {
        TestCaseRunner[] r;
        if (this.status != LoadTestRunner.Status.RUNNING) {
            return;
        }
        this.reason = reason;
        this.status = LoadTestRunner.Status.CANCELED;
        String msg = "LoadTest [" + this.loadTest.getName() + "] canceled";
        if (reason != null) {
            msg = msg + "; " + reason;
        }
        this.loadTest.getLoadTestLog().addEntry(new LoadTestLogMessageEntry(msg));
        for (LoadTestRunListener listener : this.listeners) {
            listener.loadTestStopped(this, this.context);
        }
        for (TestCaseRunner runner : r = this.runners.toArray(new TestCaseRunner[this.runners.size()])) {
            runner.cancel(reason, true);
        }
    }

    public void fail(String reason) {
        TestCaseRunner[] r;
        if (this.status != LoadTestRunner.Status.RUNNING) {
            return;
        }
        this.reason = reason;
        this.status = LoadTestRunner.Status.FAILED;
        String msg = "LoadTest [" + this.loadTest.getName() + "] failed";
        if (reason != null) {
            msg = msg + "; " + reason;
        }
        this.loadTest.getLoadTestLog().addEntry(new LoadTestLogMessageEntry(msg));
        for (LoadTestRunListener listener : this.listeners) {
            listener.loadTestStopped(this, this.context);
        }
        for (TestCaseRunner runner : r = this.runners.toArray(new TestCaseRunner[this.runners.size()])) {
            runner.cancel(reason, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        ThreadGroup threadGroup = this.threadGroup;
        synchronized (threadGroup) {
            try {
                if (this.threadGroup.activeCount() > 0) {
                    this.threadGroup.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void finishTestCase(String reason, WsdlTestCase testCase) {
        for (TestCaseRunner runner : this.runners) {
            if (runner.getTestCase() != testCase) continue;
            runner.cancel(reason, false);
            break;
        }
    }

    public void finishRunner(TestCaseRunner runner) {
        if (!this.runners.contains(runner)) {
            throw new RuntimeException("Trying to finish unknown runner.. ");
        }
        this.runners.remove(runner);
        if (this.runners.size() == 0) {
            this.loadTest.removePropertyChangeListener(WsdlLoadTest.THREADCOUNT_PROPERTY, this.internalPropertyChangeListener);
            if (this.status == LoadTestRunner.Status.RUNNING) {
                this.status = LoadTestRunner.Status.FINISHED;
            }
            this.loadTest.getLoadTestLog().addEntry(new LoadTestLogMessageEntry("LoadTest ended at " + new Date(System.currentTimeMillis())));
            for (LoadTestRunListener listener : this.listeners) {
                listener.afterLoadTest(this, this.context);
            }
        }
    }

    public int getRunningThreadCount() {
        return this.runners.size();
    }

    public float getProgress() {
        long testLimit = this.loadTest.getTestLimit();
        if (testLimit == 0L) {
            return -1.0f;
        }
        if (this.loadTest.getLimitType() == LoadTestLimitTypesConfig.COUNT) {
            return (float)this.runCount / (float)testLimit;
        }
        if (this.loadTest.getLimitType() == LoadTestLimitTypesConfig.TIME) {
            return (float)this.getTimeTaken() / (float)(testLimit * 1000L);
        }
        return -1.0f;
    }

    private boolean afterRun(TestCaseRunner runner) {
        if (this.status != LoadTestRunner.Status.RUNNING) {
            return false;
        }
        if (this.loadTest.getTestLimit() < 1L) {
            return true;
        }
        if (this.loadTest.getLimitType() == LoadTestLimitTypesConfig.COUNT) {
            return this.runCount++ + (long)this.runners.size() < this.loadTest.getTestLimit();
        }
        if (this.loadTest.getLimitType() == LoadTestLimitTypesConfig.TIME) {
            return this.getTimeTaken() < this.loadTest.getTestLimit() * 1000L;
        }
        return true;
    }

    public LoadTest getLoadTest() {
        return this.loadTest;
    }

    public synchronized void updateThreadCount() {
        block10: {
            long diff;
            block9: {
                if (this.status != LoadTestRunner.Status.RUNNING) {
                    return;
                }
                long newCount = this.loadTest.getThreadCount();
                Iterator<TestCaseRunner> iterator = this.runners.iterator();
                ArrayList<TestCaseRunner> activeRunners = new ArrayList<TestCaseRunner>();
                while (iterator.hasNext()) {
                    TestCaseRunner runner = iterator.next();
                    if (runner.isCanceled()) continue;
                    activeRunners.add(runner);
                }
                diff = newCount - (long)activeRunners.size();
                if (diff == 0L) {
                    return;
                }
                if (diff >= 0L) break block9;
                diff = Math.abs(diff);
                for (int c = 0; (long)c < diff && c < activeRunners.size(); ++c) {
                    ((TestCaseRunner)activeRunners.get(c)).cancel("excessive thread", false);
                }
                break block10;
            }
            if (diff <= 0L) break block10;
            int c = 0;
            while ((long)c < diff) {
                int startDelay = this.loadTest.getStartDelay();
                if (startDelay > 0) {
                    try {
                        Thread.sleep(startDelay);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                if (this.status == LoadTestRunner.Status.RUNNING) {
                    this.startTestCase(this.createTestCase());
                }
                ++c;
            }
        }
    }

    private WsdlTestCase createTestCase() {
        WsdlTestCase testCase = this.loadTest.getTestCase();
        TestCaseConfig config = (TestCaseConfig)((TestCaseConfig)testCase.getConfig()).copy();
        config.setLoadTestArray(new LoadTestConfig[0]);
        WsdlTestCase tc = new WsdlTestCase(testCase.getTestSuite(), config);
        tc.addTestRunListener(this.testRunListener);
        Settings settings = tc.getSettings();
        settings.setBoolean(HttpSettings.INCLUDE_REQUEST_IN_TIME_TAKEN, this.loadTest.getSettings().getBoolean(HttpSettings.INCLUDE_REQUEST_IN_TIME_TAKEN));
        settings.setBoolean(HttpSettings.INCLUDE_RESPONSE_IN_TIME_TAKEN, this.loadTest.getSettings().getBoolean(HttpSettings.INCLUDE_RESPONSE_IN_TIME_TAKEN));
        settings.setBoolean(HttpSettings.CLOSE_CONNECTIONS, this.loadTest.getSettings().getBoolean(HttpSettings.CLOSE_CONNECTIONS));
        tc.setDiscardOkResults(false);
        return tc;
    }

    public String getReason() {
        return this.reason;
    }

    public long getTimeTaken() {
        return System.currentTimeMillis() - this.startTime;
    }

    private class InternalTestRunListener
    implements TestRunListener {
        private InternalTestRunListener() {
        }

        public void beforeRun(TestRunner testRunner, TestRunContext runContext) {
            for (LoadTestRunListener listener : WsdlLoadTestRunner.this.listeners) {
                listener.beforeTestCase(WsdlLoadTestRunner.this, WsdlLoadTestRunner.this.context, testRunner, runContext);
            }
        }

        public void beforeStep(TestRunner testRunner, TestRunContext runContext) {
            for (LoadTestRunListener listener : WsdlLoadTestRunner.this.listeners) {
                listener.beforeTestStep(WsdlLoadTestRunner.this, WsdlLoadTestRunner.this.context, testRunner, runContext, runContext.getCurrentStep());
            }
        }

        public void afterStep(TestRunner testRunner, TestRunContext runContext, TestStepResult result) {
            for (LoadTestRunListener listener : WsdlLoadTestRunner.this.listeners) {
                listener.afterTestStep(WsdlLoadTestRunner.this, WsdlLoadTestRunner.this.context, testRunner, runContext, result);
            }
        }

        public void afterRun(TestRunner testRunner, TestRunContext runContext) {
            for (LoadTestRunListener listener : WsdlLoadTestRunner.this.listeners) {
                listener.afterTestCase(WsdlLoadTestRunner.this, WsdlLoadTestRunner.this.context, testRunner, runContext);
            }
        }
    }

    public class InternalPropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            WsdlLoadTestRunner.this.updateThreadCount();
        }
    }

    public class TestCaseRunner
    implements Runnable {
        private final WsdlTestCase testCase;
        private boolean canceled;
        private long runCount;
        private WsdlTestCaseRunner runner;
        private final int threadIndex;

        public TestCaseRunner(WsdlTestCase testCase, int threadIndex) {
            this.testCase = testCase;
            this.threadIndex = threadIndex;
        }

        public void run() {
            this.runner = new WsdlTestCaseRunner(this.testCase, PropertiesMap.EMPTY_MAP);
            while (!this.canceled) {
                try {
                    this.runner.getRunContext().reset();
                    this.runner.getRunContext().setProperty("ThreadIndex", this.threadIndex);
                    this.runner.getRunContext().setProperty("RunCount", this.runCount);
                    this.runner.getRunContext().setProperty("LoadTestRunner", WsdlLoadTestRunner.this);
                    this.runner.getRunContext().setProperty("LoadTestContext", WsdlLoadTestRunner.this.context);
                    this.runner.run();
                }
                catch (Throwable e) {
                    System.err.println("Error running testcase: " + e);
                    e.printStackTrace();
                }
                ++this.runCount;
                if (WsdlLoadTestRunner.this.afterRun(this)) continue;
            }
            WsdlLoadTestRunner.this.finishRunner(this);
            this.testCase.release();
        }

        public void cancel(String reason, boolean cancelRunner) {
            if (this.runner != null && cancelRunner) {
                this.runner.cancel(reason);
            }
            this.canceled = true;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        public long getRunCount() {
            return this.runCount;
        }

        public WsdlTestCase getTestCase() {
            return this.testCase;
        }
    }
}

