/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.wsdl.actions.iface.tools.jbossws;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.wsdl.WsdlInterface;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.jbossws.WSToolsRegenerateJava2WsdlAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.AbstractToolsAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ArgumentBuilder;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ProcessToolRunner;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.RunnerContext;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ShowConfigFileAction;
import com.eviware.soapui.impl.wsdl.actions.iface.tools.support.ToolHost;
import com.eviware.soapui.settings.ToolsSettings;
import com.eviware.soapui.support.SoapUIException;
import com.eviware.soapui.support.Tools;
import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.action.ActionList;
import com.eviware.soapui.support.types.StringToStringMap;
import com.eviware.x.form.XForm;
import com.eviware.x.form.XFormDialog;
import com.eviware.x.form.XFormDialogBuilder;
import com.eviware.x.form.XFormFactory;
import java.io.File;
import java.io.IOException;
import org.jboss.jbosswsTools.ConfigurationDocument;
import org.jboss.jbosswsTools.ConfigurationType;
import org.jboss.jbosswsTools.JavaToWsdlType;
import org.jboss.jbosswsTools.MappingType;
import org.jboss.jbosswsTools.NamespacesType;
import org.jboss.jbosswsTools.ServiceType;
import org.jboss.jbosswsTools.WsxmlType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSToolsJava2WsdlAction
extends AbstractToolsAction<WsdlProject> {
    private static final String CLASSPATH = "Classpath";
    private static final String OUTPUT = "Output Directory";
    private static final String ENDPOINT = "Endpoint";
    private static final String MAPPING = "Mapping file";
    private static final String SERVICE_NAME = "Service Name";
    private static final String STYLE = "Style";
    private static final String PARAMETER_STYLE = "Parameter Style";
    private static final String TARGET_NAMESPACE = "Target Namespace";
    private static final String TYPES_NAMESPACE = "Types Namespace";
    private static final String EJB_LINK = "ejb-link";
    private static final String SERVLET_LINK = "servlet-link";

    public WSToolsJava2WsdlAction(WsdlProject project) {
        super(project, "Generate WSDL with JBossWS", "Generates WSDL with the jbossws wstools utility");
    }

    @Override
    protected XFormDialog buildDialog() {
        XFormDialogBuilder builder = XFormFactory.createDialogBuilder("Generate JBossWS WSDL Artifacts");
        XForm mainForm = builder.createForm("Basic");
        mainForm.addTextField(ENDPOINT, "Serice Endpoint Interface", XForm.FieldType.JAVA_CLASS);
        mainForm.addTextField(SERVICE_NAME, "The name of the generated Service", XForm.FieldType.TEXT);
        mainForm.addComboBox(STYLE, new String[]{ServiceType.Style.DOCUMENT.toString(), ServiceType.Style.RPC.toString()}, "The style to use");
        mainForm.addComboBox(PARAMETER_STYLE, new String[]{ServiceType.ParameterStyle.BARE.toString(), ServiceType.ParameterStyle.WRAPPED.toString()}, "The style to use");
        mainForm.addTextField(CLASSPATH, "Classpath to use", XForm.FieldType.PROJECT_FOLDER);
        mainForm.addTextField(OUTPUT, "The root directory for all emitted files.", XForm.FieldType.PROJECT_FOLDER);
        mainForm.addTextField(MAPPING, "mapping file to generate", XForm.FieldType.PROJECT_FILE);
        mainForm.addTextField(TARGET_NAMESPACE, "The target namespace for the generated WSDL", XForm.FieldType.TEXT);
        mainForm.addTextField(TYPES_NAMESPACE, "The namespace for the generated types", XForm.FieldType.TEXT);
        mainForm.addTextField(EJB_LINK, "The name of the source EJB to link to", XForm.FieldType.TEXT);
        mainForm.addTextField(SERVLET_LINK, "The name of the source Servlet to link to", XForm.FieldType.TEXT);
        this.buildArgsForm(builder, false, "wstools");
        ActionList actions = this.buildDefaultActions("http://labs.jboss.com/portal/jbossws/user-guide/en/html/index.html");
        actions.addAction(new ShowConfigFileAction("JBossWS Java2Wsdl", "Contents of generated wsconfig.xml file"){

            protected String getConfigFile() {
                ConfigurationDocument configDocument = WSToolsJava2WsdlAction.this.createConfigFile(WSToolsJava2WsdlAction.this.dialog.getValues());
                return configDocument.toString();
            }
        });
        return builder.buildDialog(actions, "Specify arguments for JBossWS wstools java2wsdl functionality", UISupport.TOOL_ICON);
    }

    @Override
    protected void generate(StringToStringMap values, ToolHost toolHost) throws Exception {
        String wstoolsDir = SoapUI.getSettings().getString(ToolsSettings.JBOSSWS_WSTOOLS_LOCATION, null);
        if (Tools.isEmpty(wstoolsDir)) {
            UISupport.showErrorMessage("wstools directory must be set in global preferences");
            return;
        }
        String wsToolsExtension = UISupport.isWindows() ? ".bat" : ".sh";
        File wstoolsFile = new File(wstoolsDir + File.separatorChar + "wstools" + wsToolsExtension);
        if (!wstoolsFile.exists()) {
            UISupport.showErrorMessage("Could not find wstools script at [" + wstoolsFile + "]");
            return;
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        ArgumentBuilder args = this.buildArgs(UISupport.isWindows());
        builder.command(args.getArgs());
        builder.directory(new File(wstoolsDir));
        toolHost.run(new ToolRunner(builder, new File((String)values.get(OUTPUT)), (String)values.get(SERVICE_NAME)));
    }

    private ArgumentBuilder buildArgs(boolean isWindows) throws IOException {
        StringToStringMap values = this.dialog.getValues();
        values.put(OUTPUT, Tools.ensureDir((String)values.get(OUTPUT), ""));
        ArgumentBuilder builder = new ArgumentBuilder(values);
        builder.startScript("wstools");
        builder.addString(CLASSPATH, "-cp");
        builder.addArgs("-config", this.buildConfigFile(values));
        builder.addString(OUTPUT, "-dest");
        this.addToolArgs(values, builder);
        return builder;
    }

    private String buildConfigFile(StringToStringMap values) throws IOException {
        File file = File.createTempFile("wstools-config", ".xml");
        ConfigurationDocument configDocument = this.createConfigFile(values);
        configDocument.save(file);
        return file.getAbsolutePath();
    }

    private ConfigurationDocument createConfigFile(StringToStringMap values) {
        ConfigurationDocument configDocument = ConfigurationDocument.Factory.newInstance();
        ConfigurationType config = configDocument.addNewConfiguration();
        JavaToWsdlType java2Wsdl = config.addNewJavaWsdl();
        ServiceType service = java2Wsdl.addNewService();
        service.setEndpoint((String)values.get(ENDPOINT));
        service.setStyle(ServiceType.Style.Enum.forString((String)((String)values.get(STYLE))));
        service.setParameterStyle(ServiceType.ParameterStyle.Enum.forString((String)((String)values.get(PARAMETER_STYLE))));
        service.setName((String)values.get(SERVICE_NAME));
        MappingType mapping = java2Wsdl.addNewMapping();
        mapping.setFile((String)values.get(MAPPING));
        NamespacesType namespaces = java2Wsdl.addNewNamespaces();
        namespaces.setTargetNamespace((String)values.get(TARGET_NAMESPACE));
        namespaces.setTypeNamespace((String)values.get(TYPES_NAMESPACE));
        WsxmlType webservices = java2Wsdl.addNewWebservices();
        webservices.setEjbLink((String)values.get(EJB_LINK));
        webservices.setServletLink((String)values.get(SERVLET_LINK));
        return configDocument;
    }

    private class ToolRunner
    extends ProcessToolRunner {
        private final File outDir;
        private final String serviceName;

        public ToolRunner(ProcessBuilder builder, File outDir, String serviceName) {
            super(builder, "JBossWS wstools", WSToolsJava2WsdlAction.this.modelItem);
            this.outDir = outDir;
            this.serviceName = serviceName;
        }

        protected void afterRun(RunnerContext context) {
            if (context.getStatus() != RunnerContext.RunnerStatus.FINISHED) {
                return;
            }
            try {
                String wsdlUrl = "file:" + this.outDir.getAbsolutePath() + File.separatorChar + "wsdl" + File.separatorChar + this.serviceName + ".wsdl";
                WsdlInterface[] ifaces = ((WsdlProject)WSToolsJava2WsdlAction.this.modelItem).importWsdl(wsdlUrl, true);
                if (ifaces.length > 0) {
                    context.log("Added Interface [" + ifaces[0].getName() + "] to project");
                    ifaces[0].getSettings().setString(WSToolsRegenerateJava2WsdlAction.class.getName() + "@values", WSToolsJava2WsdlAction.this.dialog.getValues().toXml());
                    SoapUI.selectModelItem(ifaces[0]);
                }
            }
            catch (SoapUIException e) {
                e.printStackTrace();
            }
        }
    }
}

