/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.impl.actions;

import com.eviware.soapui.SoapUI;
import com.eviware.soapui.impl.WorkspaceImpl;
import com.eviware.soapui.impl.wsdl.WsdlProject;
import com.eviware.soapui.support.UISupport;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;

public class ImportWsdlProjectAction
extends AbstractAction {
    private final WorkspaceImpl workspace;

    public ImportWsdlProjectAction(WorkspaceImpl workspace) {
        super("Import Project");
        this.workspace = workspace;
        this.putValue("ShortDescription", "Adds an existing project into this workspace");
        this.putValue("AcceleratorKey", UISupport.getKeyStroke("menu I"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        File file = UISupport.getFileDialogs().openXML(this, "Select soapui project file");
        if (file == null) {
            return;
        }
        String fileName = file.getAbsolutePath();
        if (fileName == null) {
            return;
        }
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(SoapUI.class.getClassLoader());
        try {
            WsdlProject project = (WsdlProject)this.workspace.importProject(fileName);
            if (project != null) {
                SoapUI.selectModelItem(project);
            }
        }
        catch (Exception ex) {
            UISupport.showErrorMessage(ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }
}

