/*
 * Decompiled with CFR 0.152.
 */
package com.eviware.soapui.actions;

import com.eviware.soapui.support.UISupport;
import com.eviware.soapui.support.xml.JXEditTextArea;
import com.eviware.soapui.support.xml.XmlUtils;
import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class XQueryXPathTesterAction
extends AbstractAction {
    private JDialog dialog;
    private JSplitPane mainSplit;
    private JXEditTextArea resultArea;
    private JSplitPane querySplit;
    private JXEditTextArea inputArea;
    private JTextArea xqueryArea;
    private JTextArea xpathArea;
    private JTabbedPane queryTabs;
    private JLabel statusLabel;

    public XQueryXPathTesterAction() {
        super("XQuery/XPath Tester");
    }

    public void actionPerformed(ActionEvent e) {
        if (this.dialog == null) {
            this.buildDialog();
        }
        this.dialog.setVisible(true);
    }

    private void buildDialog() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.mainSplit = UISupport.createHorizontalSplit(this.createQueryPanel(), this.createResultPanel());
        this.mainSplit.setResizeWeight(0.4);
        panel.add((Component)this.mainSplit, "Center");
        panel.add((Component)this.createStatusBar(), "South");
        this.dialog = new JDialog(UISupport.getMainFrame(), "XQuery / XPath Tester", false);
        this.dialog.getContentPane().add((Component)panel, "Center");
        this.dialog.setPreferredSize(new Dimension(600, 400));
        this.dialog.pack();
        this.mainSplit.setDividerLocation(0.5);
        this.querySplit.setDividerLocation(0.3);
    }

    private JPanel createToolbar() {
        ButtonBarBuilder builder = new ButtonBarBuilder();
        JButton runButton = UISupport.createToolbarButton(new RunAction());
        builder.addFixed((JComponent)runButton);
        builder.addRelatedGap();
        JButton declareNsButton = UISupport.createToolbarButton(new DeclareNSAction());
        builder.addFixed((JComponent)declareNsButton);
        builder.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        return builder.getPanel();
    }

    private JComponent createStatusBar() {
        JPanel panel = new JPanel(new BorderLayout());
        this.statusLabel = new JLabel();
        panel.add((Component)this.statusLabel, "West");
        return panel;
    }

    private JPanel createQueryPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.querySplit = UISupport.createVerticalSplit(this.buildQueryTabs(), this.buildInputArea());
        this.querySplit.setBorder(null);
        this.querySplit.setResizeWeight(0.2);
        panel.add((Component)this.querySplit, "Center");
        return panel;
    }

    private JComponent buildQueryTabs() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.createToolbar(), "North");
        this.queryTabs = new JTabbedPane();
        this.queryTabs.addTab("XQuery query", this.buildXQueryArea());
        this.queryTabs.addTab("XPath query", this.buildXPathArea());
        this.queryTabs.setTabPlacement(3);
        panel.setBackground(Color.LIGHT_GRAY);
        panel.add((Component)this.queryTabs, "Center");
        return panel;
    }

    private JComponent buildXQueryArea() {
        this.xqueryArea = new JTextArea();
        return new JScrollPane(this.xqueryArea);
    }

    private JComponent buildXPathArea() {
        this.xpathArea = new JTextArea();
        return new JScrollPane(this.xpathArea);
    }

    private JComponent buildInputArea() {
        this.inputArea = JXEditTextArea.createXmlEditor();
        return this.inputArea;
    }

    private JPanel createResultPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        this.resultArea = JXEditTextArea.createXmlEditor();
        panel.add((Component)this.resultArea, "Center");
        return panel;
    }

    private class DeclareNSAction
    extends AbstractAction {
        public DeclareNSAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/declareNs.gif"));
            this.putValue("ShortDescription", "Declares namespaces in current input in xpath expression");
        }

        public void actionPerformed(ActionEvent e) {
            try {
                String namespaceDeclarations = XmlUtils.declareXPathNamespaces(XQueryXPathTesterAction.this.inputArea.getText());
                XQueryXPathTesterAction.this.xpathArea.setText(namespaceDeclarations + XQueryXPathTesterAction.this.xpathArea.getText());
                XQueryXPathTesterAction.this.xqueryArea.setText(namespaceDeclarations + XQueryXPathTesterAction.this.xqueryArea.getText());
            }
            catch (XmlException e1) {
                e1.printStackTrace();
            }
        }
    }

    private class RunAction
    extends AbstractAction {
        public RunAction() {
            this.putValue("SmallIcon", UISupport.createImageIcon("/submit_request.gif"));
            this.putValue("ShortDescription", "Execute current query");
            this.putValue("AcceleratorKey", UISupport.getKeyStroke("alt ENTER"));
        }

        public void actionPerformed(ActionEvent e) {
            try {
                XmlObject xmlObject = XmlObject.Factory.parse((String)XQueryXPathTesterAction.this.inputArea.getText());
                XmlObject[] objects = XQueryXPathTesterAction.this.queryTabs.getSelectedIndex() == 0 ? xmlObject.execQuery(XQueryXPathTesterAction.this.xqueryArea.getText()) : xmlObject.selectPath(XQueryXPathTesterAction.this.xpathArea.getText());
                StringBuffer result = new StringBuffer();
                XmlOptions options = new XmlOptions();
                options.setSaveOuter();
                for (int c = 0; c < objects.length; ++c) {
                    result.append(objects[c].xmlText(options));
                    result.append("\n");
                }
                XQueryXPathTesterAction.this.resultArea.setText(result.toString());
                XQueryXPathTesterAction.this.statusLabel.setText("Expression returned " + objects.length + " hits");
            }
            catch (Throwable e1) {
                if (e1 instanceof RuntimeException && (e1 = ((RuntimeException)e1).getCause()) instanceof InvocationTargetException) {
                    e1 = ((InvocationTargetException)e1).getTargetException();
                }
                XQueryXPathTesterAction.this.statusLabel.setText(e1.getMessage());
            }
        }
    }
}

