/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.Lookup;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;

public class InvalidJUnitTest
extends BytecodeScanningDetector {
    private static final int SEEN_NOTHING = 0;
    private static final int SEEN_ALOAD_0 = 1;
    private BugReporter bugReporter;
    private int state;
    boolean directChildOfTestCase;
    private boolean sawSuperCall;

    public InvalidJUnitTest(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        if (!this.enabled()) {
            return;
        }
        JavaClass jClass = classContext.getJavaClass();
        XClass xClass = classContext.getXClass();
        try {
            if (!this.isJunit3TestCase(xClass)) {
                return;
            }
            if ((jClass.getAccessFlags() & 0x400) == 0 && !this.hasTestMethods(jClass)) {
                this.bugReporter.reportBug(new BugInstance(this, "IJU_NO_TESTS", 3).addClass(jClass));
            }
            this.directChildOfTestCase = "junit.framework.TestCase".equals(jClass.getSuperclassName());
            jClass.accept(this);
        }
        catch (ClassNotFoundException cnfe) {
            this.bugReporter.reportMissingClass(cnfe);
        }
    }

    private boolean isJunit3TestCase(XClass jClass) throws ClassNotFoundException {
        ClassDescriptor sDesc = jClass.getSuperclassDescriptor();
        if (sDesc == null) {
            return false;
        }
        String sName = sDesc.getClassName();
        if (sName.equals("junit/framework/TestCase")) {
            return true;
        }
        if (sName.equals("java/lang/Object")) {
            return false;
        }
        try {
            XClass sClass = Global.getAnalysisCache().getClassAnalysis(XClass.class, sDesc);
            if (sClass == null) {
                return false;
            }
            return this.isJunit3TestCase(sClass);
        }
        catch (CheckedAnalysisException e) {
            return false;
        }
    }

    private boolean hasTestMethods(JavaClass jClass) {
        Method[] methods;
        boolean foundTest = false;
        for (Method m : methods = jClass.getMethods()) {
            if (m.isPublic() && m.getName().startsWith("test") && m.getSignature().equals("()V")) {
                return true;
            }
            if (!m.getName().startsWith("runTest") || !m.getSignature().endsWith("()V")) continue;
            return true;
        }
        if (this.hasSuite(methods)) {
            return true;
        }
        try {
            JavaClass sClass = jClass.getSuperClass();
            if (sClass != null) {
                return this.hasTestMethods(sClass);
            }
        }
        catch (ClassNotFoundException e) {
            AnalysisContext.reportMissingClass(e);
        }
        return false;
    }

    private boolean hasSuite(Method[] methods) {
        for (Method m : methods) {
            if (!m.getName().equals("suite") || !m.isPublic() || !m.isStatic() || !m.getSignature().equals("()Ljunit/framework/Test;")) continue;
            return true;
        }
        return false;
    }

    private boolean enabled() {
        return true;
    }

    public void visit(Method obj) {
        if (this.getMethodName().equals("suite") && !obj.isStatic()) {
            this.bugReporter.reportBug(new BugInstance(this, "IJU_SUITE_NOT_STATIC", 2).addClassAndMethod(this));
        }
        if (this.getMethodName().equals("suite") && obj.getSignature().startsWith("()") && obj.isStatic() && (!obj.getSignature().equals("()Ljunit/framework/Test;") && !obj.getSignature().equals("()Ljunit/framework/TestSuite;") || !obj.isPublic())) {
            this.bugReporter.reportBug(new BugInstance(this, "IJU_BAD_SUITE_METHOD", 2).addClassAndMethod(this));
        }
    }

    public void visit(Code obj) {
        if (!this.directChildOfTestCase && (this.getMethodName().equals("setUp") || this.getMethodName().equals("tearDown")) && !this.getMethod().isPrivate()) {
            this.sawSuperCall = false;
            super.visit(obj);
            if (this.sawSuperCall) {
                return;
            }
            JavaClass we = Lookup.findSuperImplementor(this.getThisClass(), this.getMethodName(), "()V", this.bugReporter);
            if (we != null && !we.getClassName().equals("junit.framework.TestCase")) {
                this.bugReporter.reportBug(new BugInstance(this, this.getMethodName().equals("setUp") ? "IJU_SETUP_NO_SUPER" : "IJU_TEARDOWN_NO_SUPER", 2).addClassAndMethod(this));
            }
        }
    }

    public void sawOpcode(int seen) {
        switch (this.state) {
            case 0: {
                if (seen != 42) break;
                this.state = 1;
                break;
            }
            case 1: {
                if (seen == 183 && this.getNameConstantOperand().equals(this.getMethodName()) && this.getMethodSig().equals("()V")) {
                    this.sawSuperCall = true;
                }
                this.state = 0;
                break;
            }
            default: {
                this.state = 0;
            }
        }
    }
}

