/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.StatelessDetector;
import org.apache.bcel.classfile.Method;

public class IncompatMask
extends BytecodeScanningDetector
implements StatelessDetector {
    int state = 0;
    long arg0;
    long arg1;
    int bitop;
    boolean isLong;
    private BugReporter bugReporter;

    public IncompatMask(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visit(Method obj) {
        super.visit(obj);
        this.state = 0;
    }

    private void checkState(int expectedState) {
        this.state = this.state == expectedState ? ++this.state : 0;
    }

    private void noteVal(long val) {
        if (this.state == 0) {
            this.arg0 = val;
        } else if (this.state == 2) {
            this.arg1 = val;
        } else {
            this.state = -1;
        }
        ++this.state;
    }

    public void sawInt(int val) {
        this.noteVal(val);
    }

    public void sawLong(long val) {
        this.noteVal(val);
    }

    public void sawOpcode(int seen) {
        String t;
        long dif;
        switch (seen) {
            case 2: {
                this.noteVal(-1L);
                return;
            }
            case 3: {
                this.noteVal(0L);
                return;
            }
            case 4: {
                this.noteVal(1L);
                return;
            }
            case 5: {
                this.noteVal(2L);
                return;
            }
            case 6: {
                this.noteVal(3L);
                return;
            }
            case 7: {
                this.noteVal(4L);
                return;
            }
            case 8: {
                this.noteVal(5L);
                return;
            }
            case 9: {
                this.noteVal(0L);
                return;
            }
            case 10: {
                this.noteVal(1L);
                return;
            }
            case 16: {
                return;
            }
            case 20: {
                return;
            }
            case 17: {
                return;
            }
            case 18: 
            case 19: {
                return;
            }
            case 126: 
            case 127: {
                this.bitop = 126;
                this.isLong = seen == 127;
                this.checkState(1);
                return;
            }
            case 128: 
            case 129: {
                this.bitop = 128;
                this.isLong = seen == 129;
                this.checkState(1);
                return;
            }
            case 148: {
                if (this.state == 3) {
                    this.isLong = true;
                    return;
                }
                this.state = 0;
                return;
            }
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                if (this.state == 3) {
                    boolean highbit;
                    boolean bl = highbit = !this.isLong && (this.arg0 & Integer.MIN_VALUE) != 0L;
                    BugInstance bug = highbit ? new BugInstance(this, "BIT_SIGNED_CHECK_HIGH_BIT", seen == 158 || seen == 157 ? 1 : 2) : new BugInstance(this, "BIT_SIGNED_CHECK", 2);
                    this.bugReporter.reportBug(bug.addClassAndMethod(this).addSourceLine(this));
                }
                this.state = 0;
                return;
            }
            case 153: 
            case 154: {
                if (this.state == 2) {
                    this.arg1 = 0L;
                    this.state = 3;
                }
            }
            case 159: 
            case 160: {
                this.checkState(3);
                if (this.state == 4) break;
                return;
            }
            case 167: {
                this.state = -1;
                return;
            }
            default: {
                this.state = 0;
                return;
            }
        }
        if (this.bitop == 128) {
            dif = this.arg0 & (this.arg1 ^ 0xFFFFFFFFFFFFFFFFL);
            t = "BIT_IOR";
        } else if (this.arg0 != 0L || this.arg1 != 0L) {
            dif = this.arg1 & (this.arg0 ^ 0xFFFFFFFFFFFFFFFFL);
            t = "BIT_AND";
        } else {
            dif = 1L;
            t = "BIT_AND_ZZ";
        }
        if (dif != 0L) {
            BugInstance bug = new BugInstance(this, t, 2).addClassAndMethod(this);
            if (!t.equals("BIT_AND_ZZ")) {
                bug.addString("0x" + Long.toHexString(this.arg0)).addString("0x" + Long.toHexString(this.arg1));
            }
            bug.addSourceLine(this);
            this.bugReporter.reportBug(bug);
        }
        this.state = 0;
    }
}

