/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.AnalysisError;
import edu.umd.cs.findbugs.AppVersion;
import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.BugAnnotationWithSourceLines;
import edu.umd.cs.findbugs.BugCollection;
import edu.umd.cs.findbugs.BugDesignation;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.ClassAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.IntAnnotation;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.MethodAnnotation;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.StringAnnotation;
import edu.umd.cs.findbugs.TypeAnnotation;
import edu.umd.cs.findbugs.ba.ClassHash;
import edu.umd.cs.findbugs.filter.AndMatcher;
import edu.umd.cs.findbugs.filter.BugMatcher;
import edu.umd.cs.findbugs.filter.ClassMatcher;
import edu.umd.cs.findbugs.filter.CompoundMatcher;
import edu.umd.cs.findbugs.filter.DesignationMatcher;
import edu.umd.cs.findbugs.filter.FieldMatcher;
import edu.umd.cs.findbugs.filter.Filter;
import edu.umd.cs.findbugs.filter.FirstVersionMatcher;
import edu.umd.cs.findbugs.filter.LastVersionMatcher;
import edu.umd.cs.findbugs.filter.LocalMatcher;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.MethodMatcher;
import edu.umd.cs.findbugs.filter.OrMatcher;
import edu.umd.cs.findbugs.filter.PriorityMatcher;
import edu.umd.cs.findbugs.model.ClassFeatureSet;
import edu.umd.cs.findbugs.util.Strings;
import java.io.File;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SAXBugCollectionHandler
extends DefaultHandler {
    private static final String FIND_BUGS_FILTER = "FindBugsFilter";
    private static final String PROJECT = "Project";
    private static final String BUG_COLLECTION = "BugCollection";
    private BugCollection bugCollection;
    private Project project;
    private Stack<CompoundMatcher> matcherStack = new Stack();
    private Filter filter;
    private ArrayList<String> elementStack;
    private StringBuilder textBuffer;
    private BugInstance bugInstance;
    private BugAnnotationWithSourceLines bugAnnotationWithSourceLines;
    private AnalysisError analysisError;
    private ClassFeatureSet classFeatureSet;
    private ArrayList<String> stackTrace;
    private int nestingOfIgnoredElements = 0;
    private final File base;
    private final String topLevelName;
    Pattern ignoredElement = Pattern.compile("Message|ShortMessage|LongMessage");
    private static boolean DEBUG = false;
    boolean nextMatchedIsDisabled;

    public SAXBugCollectionHandler(String topLevelName, BugCollection bugCollection, Project project, File base) {
        this.topLevelName = topLevelName;
        this.bugCollection = bugCollection;
        this.project = project;
        this.elementStack = new ArrayList();
        this.textBuffer = new StringBuilder();
        this.stackTrace = new ArrayList();
        this.base = base;
    }

    public SAXBugCollectionHandler(BugCollection bugCollection, Project project, File base) {
        this(BUG_COLLECTION, bugCollection, project, base);
    }

    public SAXBugCollectionHandler(Project project, File base) {
        this(PROJECT, null, project, base);
    }

    public SAXBugCollectionHandler(Filter filter, File base) {
        this(FIND_BUGS_FILTER, null, null, base);
        this.filter = filter;
        this.pushCompoundMatcher(filter);
    }

    public boolean discardedElement(String qName) {
        return this.ignoredElement.matcher(qName).matches();
    }

    public String getTextContents() {
        return StringEscapeUtils.unescapeXml((String)this.textBuffer.toString());
    }

    public void startElement(String uri, String name, String qName, Attributes attributes) throws SAXException {
        if (this.discardedElement(qName)) {
            ++this.nestingOfIgnoredElements;
        } else if (this.nestingOfIgnoredElements <= 0) {
            if (this.elementStack.isEmpty() && !qName.equals(this.topLevelName)) {
                throw new SAXException("Invalid top-level element (expected " + this.topLevelName + ", saw " + qName + ")");
            }
            if (qName.equals(BUG_COLLECTION)) {
                String releaseName;
                String analysisVersion;
                String version = attributes.getValue("version");
                if (this.bugCollection instanceof SortedBugCollection) {
                    ((SortedBugCollection)this.bugCollection).setAnalysisVersion(version);
                }
                String sequence = attributes.getValue("sequence");
                long seqval = this.parseLong(sequence, 0L);
                this.bugCollection.setSequenceNumber(seqval);
                String timestamp = attributes.getValue("timestamp");
                long tsval = this.parseLong(timestamp, -1L);
                this.bugCollection.setTimestamp(tsval);
                String analysisTimestamp = attributes.getValue("analysisTimestamp");
                if (analysisTimestamp != null) {
                    this.bugCollection.setAnalysisTimestamp(this.parseLong(analysisTimestamp, -1L));
                }
                if ((analysisVersion = attributes.getValue("version")) != null) {
                    this.bugCollection.setAnalysisVersion(analysisVersion);
                }
                this.bugCollection.setReleaseName((releaseName = attributes.getValue("release")) != null ? releaseName : "");
            } else if (this.isTopLevelFilter(qName)) {
                if (this.project != null) {
                    this.filter = new Filter();
                    this.project.setSuppressionFilter(this.filter);
                }
                this.matcherStack.clear();
                this.pushCompoundMatcher(this.filter);
            } else if (qName.equals(PROJECT)) {
                String projectName;
                String filename = attributes.getValue("filename");
                if (filename != null) {
                    this.project.setProjectFileName(filename);
                }
                if ((projectName = attributes.getValue("projectName")) != null) {
                    this.project.setProjectName(projectName);
                }
            } else {
                String outerElement = this.elementStack.get(this.elementStack.size() - 1);
                if (outerElement.equals(BUG_COLLECTION)) {
                    if (qName.equals("BugInstance")) {
                        String oldInstanceHash;
                        String removedByChange;
                        String lastVersion;
                        String firstVersion;
                        String type = SAXBugCollectionHandler.getRequiredAttribute(attributes, "type", qName);
                        String priority = SAXBugCollectionHandler.getRequiredAttribute(attributes, "priority", qName);
                        try {
                            int prio = Integer.parseInt(priority);
                            this.bugInstance = new BugInstance(type, prio);
                        }
                        catch (NumberFormatException e) {
                            throw new SAXException("BugInstance with invalid priority value \"" + priority + "\"", e);
                        }
                        String uniqueId = attributes.getValue("uid");
                        if (uniqueId != null) {
                            this.bugInstance.setUniqueId(uniqueId);
                        }
                        if ((firstVersion = attributes.getValue("first")) != null) {
                            this.bugInstance.setFirstVersion(Long.parseLong(firstVersion));
                        }
                        if ((lastVersion = attributes.getValue("last")) != null) {
                            this.bugInstance.setLastVersion(Long.parseLong(lastVersion));
                        }
                        if (this.bugInstance.isDead() && this.bugInstance.getFirstVersion() > this.bugInstance.getLastVersion()) {
                            throw new IllegalStateException("huh");
                        }
                        String introducedByChange = attributes.getValue("introducedByChange");
                        if (introducedByChange != null) {
                            this.bugInstance.setIntroducedByChangeOfExistingClass(Boolean.parseBoolean(introducedByChange));
                        }
                        if ((removedByChange = attributes.getValue("removedByChange")) != null) {
                            this.bugInstance.setRemovedByChangeOfPersistingClass(Boolean.parseBoolean(removedByChange));
                        }
                        if ((oldInstanceHash = attributes.getValue("instanceHash")) != null) {
                            this.bugInstance.setOldInstanceHash(oldInstanceHash);
                        }
                    } else if (qName.equals("FindBugsSummary")) {
                        String timestamp = SAXBugCollectionHandler.getRequiredAttribute(attributes, "timestamp", qName);
                        String vmVersion = attributes.getValue("vm_version");
                        this.bugCollection.getProjectStats().setVMVersion(vmVersion);
                        try {
                            this.bugCollection.getProjectStats().setTimestamp(timestamp);
                        }
                        catch (ParseException e) {
                            throw new SAXException("Unparseable sequence number: '" + timestamp + "'", e);
                        }
                    }
                } else if (outerElement.equals("BugInstance")) {
                    this.parseBugInstanceContents(qName, attributes);
                } else if (outerElement.equals("Method") || outerElement.equals("Field") || outerElement.equals("Class") || outerElement.equals("Type")) {
                    if (qName.equals("SourceLine")) {
                        this.bugAnnotationWithSourceLines.setSourceLines(this.createSourceLineAnnotation(qName, attributes));
                    }
                } else if (outerElement.equals("Errors")) {
                    if (qName.equals("AnalysisError") || qName.equals("Error")) {
                        this.analysisError = new AnalysisError("Unknown error");
                        this.stackTrace.clear();
                    }
                } else if (outerElement.equals("PackageStats")) {
                    if (qName.equals("ClassStats")) {
                        String className = SAXBugCollectionHandler.getRequiredAttribute(attributes, "class", qName);
                        Boolean isInterface = Boolean.valueOf(SAXBugCollectionHandler.getRequiredAttribute(attributes, "interface", qName));
                        int size = Integer.valueOf(SAXBugCollectionHandler.getRequiredAttribute(attributes, "size", qName));
                        String sourceFile = attributes.getValue("sourceFile");
                        this.bugCollection.getProjectStats().addClass(className, sourceFile, isInterface, size);
                    }
                } else if (this.isTopLevelFilter(outerElement) || outerElement.equals("Match") || outerElement.equals("And") || outerElement.equals("Or")) {
                    this.parseMatcher(qName, attributes);
                } else if (outerElement.equals("ClassFeatures")) {
                    if (qName.equals("ClassFeatureSet")) {
                        String className = SAXBugCollectionHandler.getRequiredAttribute(attributes, "class", qName);
                        this.classFeatureSet = new ClassFeatureSet();
                        this.classFeatureSet.setClassName(className);
                    }
                } else if (outerElement.equals("ClassFeatureSet")) {
                    if (qName.equals("Feature")) {
                        String value = SAXBugCollectionHandler.getRequiredAttribute(attributes, "value", qName);
                        this.classFeatureSet.addFeature(value);
                    }
                } else if (outerElement.equals("History") && qName.equals("AppVersion")) {
                    try {
                        String sequence = SAXBugCollectionHandler.getRequiredAttribute(attributes, "sequence", qName);
                        String timestamp = attributes.getValue("timestamp");
                        String releaseName = attributes.getValue("release");
                        String codeSize = attributes.getValue("codeSize");
                        String numClasses = attributes.getValue("numClasses");
                        AppVersion appVersion = new AppVersion(Long.valueOf(sequence));
                        if (timestamp != null) {
                            appVersion.setTimestamp(Long.valueOf(timestamp));
                        }
                        if (releaseName != null) {
                            appVersion.setReleaseName(releaseName);
                        }
                        if (codeSize != null) {
                            appVersion.setCodeSize(Integer.parseInt(codeSize));
                        }
                        if (numClasses != null) {
                            appVersion.setNumClasses(Integer.parseInt(numClasses));
                        }
                        this.bugCollection.addAppVersion(appVersion);
                    }
                    catch (NumberFormatException e) {
                        throw new SAXException("Invalid AppVersion element", e);
                    }
                }
            }
        }
        this.textBuffer.delete(0, this.textBuffer.length());
        this.elementStack.add(qName);
    }

    private boolean isTopLevelFilter(String qName) {
        return qName.equals(FIND_BUGS_FILTER) || qName.equals("SuppressionFilter");
    }

    private void addMatcher(Matcher m) {
        if (m == null) {
            throw new IllegalArgumentException("matcher must not be null");
        }
        CompoundMatcher peek = this.matcherStack.peek();
        if (peek == null) {
            throw new NullPointerException("Top of stack is null");
        }
        peek.addChild(m);
        if (this.nextMatchedIsDisabled) {
            if (peek instanceof Filter) {
                ((Filter)peek).disable(m);
            } else assert (false);
            this.nextMatchedIsDisabled = false;
        }
    }

    private void pushCompoundMatcherAsChild(CompoundMatcher m) {
        this.addMatcher(m);
        this.pushCompoundMatcher(m);
    }

    private void pushCompoundMatcher(CompoundMatcher m) {
        if (m == null) {
            throw new IllegalArgumentException("matcher must not be null");
        }
        this.matcherStack.push(m);
    }

    private void parseMatcher(String qName, Attributes attributes) throws SAXException {
        if (DEBUG) {
            System.out.println(this.elementStack + " " + qName + " " + this.matcherStack);
        }
        String disabled = attributes.getValue("disabled");
        this.nextMatchedIsDisabled = "true".equals(disabled);
        if (qName.equals("Bug")) {
            this.addMatcher(new BugMatcher(attributes.getValue("code"), attributes.getValue("pattern"), attributes.getValue("category")));
        } else if (qName.equals("Class")) {
            this.addMatcher(new ClassMatcher(attributes.getValue("name")));
        } else if (qName.equals("FirstVersion")) {
            this.addMatcher(new FirstVersionMatcher(SAXBugCollectionHandler.getRequiredAttribute(attributes, "value", qName), SAXBugCollectionHandler.getRequiredAttribute(attributes, "relOp", qName)));
        } else if (qName.equals("LastVersion")) {
            this.addMatcher(new LastVersionMatcher(SAXBugCollectionHandler.getRequiredAttribute(attributes, "value", qName), SAXBugCollectionHandler.getRequiredAttribute(attributes, "relOp", qName)));
        } else if (qName.equals("Designation")) {
            this.addMatcher(new DesignationMatcher(SAXBugCollectionHandler.getRequiredAttribute(attributes, "designation", qName)));
        } else if (qName.equals("BugCode")) {
            this.addMatcher(new BugMatcher(attributes.getValue("name"), "", ""));
        } else if (qName.equals("Local")) {
            this.addMatcher(new LocalMatcher(attributes.getValue("name")));
        } else if (qName.equals("BugPattern")) {
            this.addMatcher(new BugMatcher("", attributes.getValue("name"), ""));
        } else if (qName.equals("Priority")) {
            this.addMatcher(new PriorityMatcher(attributes.getValue("value")));
        } else if (qName.equals("Package")) {
            String pName = attributes.getValue("name");
            pName = pName.startsWith("~") ? pName : "~" + Strings.replace(pName, ".", "\\.");
            this.addMatcher(new ClassMatcher(pName + "\\.[^.]+"));
        } else if (qName.equals("Method")) {
            String name = attributes.getValue("name");
            String params = attributes.getValue("params");
            String returns = attributes.getValue("returns");
            this.addMatcher(new MethodMatcher(name, params, returns));
        } else if (qName.equals("Field")) {
            String name = attributes.getValue("name");
            String type = attributes.getValue("type");
            this.addMatcher(new FieldMatcher(name, type));
        } else if (qName.equals("Or")) {
            OrMatcher matcher = new OrMatcher();
            this.pushCompoundMatcherAsChild(matcher);
        } else if (qName.equals("And") || qName.equals("Match")) {
            AndMatcher matcher = new AndMatcher();
            this.pushCompoundMatcherAsChild(matcher);
            if (qName.equals("Match")) {
                String classregex = attributes.getValue("classregex");
                String classMatch = attributes.getValue("class");
                if (classregex != null) {
                    this.addMatcher(new ClassMatcher("~" + classregex));
                } else if (classMatch != null) {
                    this.addMatcher(new ClassMatcher(classMatch));
                }
            }
        }
        this.nextMatchedIsDisabled = false;
    }

    private void parseBugInstanceContents(String qName, Attributes attributes) throws SAXException {
        String value;
        BugAnnotation bugAnnotation = null;
        if (qName.equals("Class")) {
            String className = SAXBugCollectionHandler.getRequiredAttribute(attributes, "classname", qName);
            this.bugAnnotationWithSourceLines = new ClassAnnotation(className);
            bugAnnotation = this.bugAnnotationWithSourceLines;
        } else if (qName.equals("Type")) {
            String typeDescriptor = SAXBugCollectionHandler.getRequiredAttribute(attributes, "descriptor", qName);
            TypeAnnotation typeAnnotation = new TypeAnnotation(typeDescriptor);
            this.bugAnnotationWithSourceLines = typeAnnotation;
            bugAnnotation = typeAnnotation;
            String typeParameters = attributes.getValue("typeParameters");
            if (typeParameters != null) {
                typeAnnotation.setTypeParameters(StringEscapeUtils.unescapeXml((String)typeParameters));
            }
        } else if (qName.equals("Method") || qName.equals("Field")) {
            String classname = SAXBugCollectionHandler.getRequiredAttribute(attributes, "classname", qName);
            String fieldOrMethodName = SAXBugCollectionHandler.getRequiredAttribute(attributes, "name", qName);
            String signature = SAXBugCollectionHandler.getRequiredAttribute(attributes, "signature", qName);
            if (qName.equals("Method")) {
                String isStatic = attributes.getValue("isStatic");
                if (isStatic == null) {
                    isStatic = "false";
                }
                this.bugAnnotationWithSourceLines = new MethodAnnotation(classname, fieldOrMethodName, signature, Boolean.valueOf(isStatic));
                bugAnnotation = this.bugAnnotationWithSourceLines;
            } else {
                String isStatic = SAXBugCollectionHandler.getRequiredAttribute(attributes, "isStatic", qName);
                this.bugAnnotationWithSourceLines = new FieldAnnotation(classname, fieldOrMethodName, signature, Boolean.valueOf(isStatic));
                bugAnnotation = this.bugAnnotationWithSourceLines;
            }
        } else if (qName.equals("SourceLine")) {
            SourceLineAnnotation sourceAnnotation = this.createSourceLineAnnotation(qName, attributes);
            if (!sourceAnnotation.isSynthetic()) {
                bugAnnotation = sourceAnnotation;
            }
        } else if (qName.equals("Int")) {
            try {
                value = SAXBugCollectionHandler.getRequiredAttribute(attributes, "value", qName);
                bugAnnotation = new IntAnnotation(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                throw new SAXException("Bad integer value in Int");
            }
        } else if (qName.equals("String")) {
            value = SAXBugCollectionHandler.getRequiredAttribute(attributes, "value", qName);
            bugAnnotation = StringAnnotation.fromXMLEscapedString(value);
        } else if (qName.equals("LocalVariable")) {
            try {
                String varName = SAXBugCollectionHandler.getRequiredAttribute(attributes, "name", qName);
                int register = Integer.parseInt(SAXBugCollectionHandler.getRequiredAttribute(attributes, "register", qName));
                int pc = Integer.parseInt(SAXBugCollectionHandler.getRequiredAttribute(attributes, "pc", qName));
                bugAnnotation = new LocalVariableAnnotation(varName, register, pc);
            }
            catch (NumberFormatException e) {
                throw new SAXException("Invalid integer value in attribute of LocalVariable element");
            }
        } else if (qName.equals("Property")) {
            String propName = SAXBugCollectionHandler.getRequiredAttribute(attributes, "name", qName);
            String propValue = SAXBugCollectionHandler.getRequiredAttribute(attributes, "value", qName);
            this.bugInstance.setProperty(propName, propValue);
        } else if (qName.equals("UserAnnotation")) {
            String s = attributes.getValue("designation");
            BugDesignation userDesignation = this.bugInstance.getNonnullUserDesignation();
            if (s != null) {
                userDesignation.setDesignationKey(s);
            }
            if ((s = attributes.getValue("user")) != null) {
                userDesignation.setUser(s);
            }
            if ((s = attributes.getValue("timestamp")) != null) {
                try {
                    long timestamp = Long.valueOf(s);
                    userDesignation.setTimestamp(timestamp);
                }
                catch (NumberFormatException nfe) {}
            }
        } else {
            throw new SAXException("Unknown bug annotation named " + qName);
        }
        if (bugAnnotation != null) {
            String role = attributes.getValue("role");
            if (role != null) {
                bugAnnotation.setDescription(role);
            }
            this.setAnnotationRole(attributes, bugAnnotation);
            this.bugInstance.add(bugAnnotation);
        }
    }

    private long parseLong(String s, long defaultValue) {
        long value;
        try {
            value = s != null ? Long.parseLong(s) : defaultValue;
        }
        catch (NumberFormatException e) {
            value = defaultValue;
        }
        return value;
    }

    private byte[] extractHash(String qName, Attributes attributes) throws SAXException {
        byte[] hash;
        String encodedHash = SAXBugCollectionHandler.getRequiredAttribute(attributes, "value", qName);
        try {
            hash = ClassHash.stringToHash(encodedHash);
        }
        catch (IllegalArgumentException e) {
            throw new SAXException("Invalid class hash", e);
        }
        return hash;
    }

    private void setAnnotationRole(Attributes attributes, BugAnnotation bugAnnotation) {
        String role = attributes.getValue("role");
        if (role != null) {
            bugAnnotation.setDescription(role);
        }
    }

    private SourceLineAnnotation createSourceLineAnnotation(String qName, Attributes attributes) throws SAXException {
        String classname = SAXBugCollectionHandler.getRequiredAttribute(attributes, "classname", qName);
        String sourceFile = attributes.getValue("sourcefile");
        if (sourceFile == null) {
            sourceFile = "<Unknown>";
        }
        String startLine = attributes.getValue("start");
        String endLine = attributes.getValue("end");
        String startBytecode = attributes.getValue("startBytecode");
        String endBytecode = attributes.getValue("endBytecode");
        try {
            int sl = startLine != null ? Integer.parseInt(startLine) : -1;
            int el = endLine != null ? Integer.parseInt(endLine) : -1;
            int sb = startBytecode != null ? Integer.parseInt(startBytecode) : -1;
            int eb = endBytecode != null ? Integer.parseInt(endBytecode) : -1;
            SourceLineAnnotation annotation = new SourceLineAnnotation(classname, sourceFile, sl, el, sb, eb);
            return annotation;
        }
        catch (NumberFormatException e) {
            throw new SAXException("Bad integer value in SourceLine element", e);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (this.discardedElement(qName)) {
            --this.nestingOfIgnoredElements;
        } else if (this.nestingOfIgnoredElements <= 0 && this.elementStack.size() > 1) {
            String outerElement = this.elementStack.get(this.elementStack.size() - 2);
            if (qName.equals("Or") || qName.equals("And") || qName.equals("Match") || this.isTopLevelFilter(qName)) {
                if (DEBUG) {
                    System.out.println("  ending " + this.elementStack + " " + qName + " " + this.matcherStack);
                }
                this.matcherStack.pop();
            } else if (outerElement.equals(BUG_COLLECTION)) {
                if (qName.equals("BugInstance")) {
                    this.bugCollection.add(this.bugInstance, false);
                    if (!this.bugInstance.isDead()) {
                        this.bugCollection.getProjectStats().addBug(this.bugInstance);
                    }
                }
            } else if (outerElement.equals(PROJECT)) {
                if (qName.equals("Jar")) {
                    this.project.addFile(this.getTextContents());
                } else if (qName.equals("SrcDir")) {
                    this.project.addSourceDir(this.getTextContents());
                } else if (qName.equals("AuxClasspathEntry")) {
                    this.project.addAuxClasspathEntry(this.getTextContents());
                }
            } else if (outerElement.equals("BugInstance")) {
                if (qName.equals("UserAnnotation")) {
                    this.bugInstance.setAnnotationText(this.getTextContents());
                }
            } else if (outerElement.equals("Errors")) {
                if (qName.equals("AnalysisError")) {
                    this.analysisError.setMessage(this.getTextContents());
                    this.bugCollection.addError(this.analysisError);
                } else if (qName.equals("Error")) {
                    if (this.stackTrace.size() > 0) {
                        this.analysisError.setStackTrace(this.stackTrace.toArray(new String[this.stackTrace.size()]));
                    }
                    this.bugCollection.addError(this.analysisError);
                } else if (qName.equals("MissingClass")) {
                    this.bugCollection.addMissingClass(this.getTextContents());
                }
            } else if (outerElement.equals("Error")) {
                if (qName.equals("ErrorMessage")) {
                    this.analysisError.setMessage(this.getTextContents());
                } else if (qName.equals("Exception")) {
                    this.analysisError.setExceptionMessage(this.getTextContents());
                } else if (qName.equals("StackTrace")) {
                    this.stackTrace.add(this.getTextContents());
                }
            } else if (outerElement.equals("ClassFeatures") && qName.equals("ClassFeatureSet")) {
                this.bugCollection.setClassFeatureSet(this.classFeatureSet);
                this.classFeatureSet = null;
            }
        }
        this.elementStack.remove(this.elementStack.size() - 1);
    }

    public void characters(char[] ch, int start, int length) {
        this.textBuffer.append(ch, start, length);
    }

    private static String getRequiredAttribute(Attributes attributes, String attrName, String elementName) throws SAXException {
        String value = attributes.getValue(attrName);
        if (value == null) {
            throw new SAXException(elementName + " element missing " + attrName + " attribute");
        }
        return StringEscapeUtils.unescapeXml((String)value);
    }
}

