/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.client.modeldriven.brl.DSLSentence;
import org.drools.lang.dsl.DSLMappingEntry;

public class SuggestionCompletionEngineBuilder {
    private SuggestionCompletionEngine instance = new SuggestionCompletionEngine();
    private List factTypes = new ArrayList();
    private Map fieldsForType = new HashMap();
    private Map modifiersForType = new HashMap();
    private Map fieldTypes = new HashMap();
    private Map globalTypes = new HashMap();
    private List actionDSLSentences = new ArrayList();
    private List conditionDSLSentences = new ArrayList();
    private List keywordDSLItems = new ArrayList();
    private List anyScopeDSLItems = new ArrayList();
    private List<String> globalCollections = new ArrayList<String>();

    public void newCompletionEngine() {
        this.instance = new SuggestionCompletionEngine();
        this.factTypes = new ArrayList();
        this.fieldsForType = new HashMap();
        this.modifiersForType = new HashMap();
        this.fieldTypes = new HashMap();
        this.globalTypes = new HashMap();
        this.actionDSLSentences = new ArrayList();
        this.conditionDSLSentences = new ArrayList();
        this.keywordDSLItems = new ArrayList();
        this.anyScopeDSLItems = new ArrayList();
        this.globalCollections = new ArrayList<String>();
    }

    public void addFactType(String factType) {
        this.factTypes.add(factType);
    }

    public void addFieldsForType(String type, String[] fields) {
        this.fieldsForType.put(type, fields);
    }

    public void addModifiersForType(String type, String[] fields) {
        this.modifiersForType.put(type, fields);
    }

    public boolean hasFieldsForType(String type) {
        return this.fieldsForType.containsKey(type);
    }

    public void addFieldType(String field, String type) {
        this.fieldTypes.put(field, type);
    }

    public void addGlobalType(String global, String type) {
        this.globalTypes.put(global, type);
    }

    public void addGlobalCollection(String global) {
        this.globalCollections.add(global);
    }

    public void addDSLActionSentence(String sentence) {
        DSLSentence sen = new DSLSentence();
        sen.sentence = sentence;
        this.actionDSLSentences.add(sen);
    }

    public void addDSLConditionSentence(String sentence) {
        DSLSentence sen = new DSLSentence();
        sen.sentence = sentence;
        this.conditionDSLSentences.add(sen);
    }

    public SuggestionCompletionEngine getInstance() {
        this.instance.factTypes = this.factTypes.toArray(new String[this.factTypes.size()]);
        this.instance.fieldsForType = this.fieldsForType;
        this.instance.modifiers = this.modifiersForType;
        this.instance.fieldTypes = this.fieldTypes;
        this.instance.globalTypes = this.globalTypes;
        this.instance.actionDSLSentences = this.makeArray(this.actionDSLSentences);
        this.instance.conditionDSLSentences = this.makeArray(this.conditionDSLSentences);
        this.instance.keywordDSLItems = this.makeArray(this.keywordDSLItems);
        this.instance.anyScopeDSLItems = this.makeArray(this.anyScopeDSLItems);
        this.instance.globalCollections = this.globalCollections.toArray(new String[this.globalCollections.size()]);
        return this.instance;
    }

    private DSLSentence[] makeArray(List ls) {
        return ls.toArray(new DSLSentence[ls.size()]);
    }

    public void addDSLMapping(DSLMappingEntry entry) {
        DSLSentence sen = new DSLSentence();
        sen.sentence = entry.getMappingKey();
        if (entry.getSection() == DSLMappingEntry.CONDITION) {
            this.conditionDSLSentences.add(sen);
        } else if (entry.getSection() == DSLMappingEntry.CONSEQUENCE) {
            this.actionDSLSentences.add(sen);
        } else if (entry.getSection() == DSLMappingEntry.KEYWORD) {
            this.keywordDSLItems.add(sen);
        } else if (entry.getSection() == DSLMappingEntry.ANY) {
            this.anyScopeDSLItems.add(sen);
        }
    }
}

