/*
 * Decompiled with CFR 0.152.
 */
package com.sun.liberty.jaxrpc;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.meta.IDFFMetaUtils;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.liberty.ws.disco.DiscoveryException;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.liberty.jaxrpc.LibertyManagerIF;
import java.rmi.RemoteException;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LibertyManagerImpl
implements LibertyManagerIF {
    public String getDiscoveryResourceOffering(String tokenID, String hostProviderID) throws RemoteException {
        try {
            Object token = SessionManager.getProvider().getSession(tokenID);
            FSSession session = FSSessionManager.getInstance(IDFFMetaUtils.getMetaAlias("/", hostProviderID, "SP", token)).getSession(token);
            if (session == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("LibertyManagerImpl.getDiscovery:ResourceOffering: no FSSession found");
                }
                return null;
            }
            NodeList bootStrapRO = session.getBootStrapResourceOfferings();
            if (bootStrapRO == null || bootStrapRO.getLength() == 0) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("LibertyManagerImpl.getDiscovery:ResourceOffering: bootstrap resource offering is null");
                }
                return null;
            }
            ResourceOffering offering = new ResourceOffering((Element)bootStrapRO.item(0));
            return offering.toString();
        }
        catch (SessionException se) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("LibertyManagerImpl.getDiscoveryResourceOffering: SessionException", (Throwable)((Object)se));
            }
            throw new RemoteException(FSUtils.bundle.getString("invalidSSOToken"));
        }
        catch (DiscoveryException de) {
            FSUtils.debug.error("LibertyManagerImpl.getDiscoveryResourceOffering: Resource Offering parsing error", (Throwable)((Object)de));
            throw new RemoteException(FSUtils.bundle.getString("invalidResourceOffering"));
        }
    }

    public String getDiscoveryServiceCredential(String tokenID, String hostProviderID) throws RemoteException {
        try {
            Object token = SessionManager.getProvider().getSession(tokenID);
            FSSession session = FSSessionManager.getInstance(IDFFMetaUtils.getMetaAlias("/", hostProviderID, "SP", token)).getSession(token);
            if (session == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("LibertyManagerImpl.getDiscoveryServiceCredential:ResourceOffering: no FSSession found");
                }
                return null;
            }
            List creds = session.getBootStrapCredential();
            if (creds == null || creds.size() == 0) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("LibertyManagerImpl.getDiscovery:ServiceCredential: bootstrap credential is null");
                }
                return null;
            }
            return ((SecurityAssertion)creds.get(0)).toString();
        }
        catch (SessionException se) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("LibertyManagerImpl.getDiscoveryServiceCredential: SessionException", (Throwable)((Object)se));
            }
            throw new RemoteException(FSUtils.bundle.getString("invalidSSOToken"));
        }
    }
}

