/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xacml.policy.impl;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xacml.common.XACMLConstants;
import com.sun.identity.xacml.common.XACMLException;
import com.sun.identity.xacml.common.XACMLSDKUtils;
import com.sun.identity.xacml.policy.Obligation;
import com.sun.identity.xacml.policy.Obligations;
import com.sun.identity.xacml.policy.PolicyFactory;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObligationsImpl
implements Obligations {
    private List obligations = new ArrayList();
    private boolean mutable = true;

    public ObligationsImpl() {
    }

    public ObligationsImpl(String xml) throws XACMLException {
        Document document = XMLUtils.toDOMDocument((String)xml, (Debug)XACMLSDKUtils.debug);
        if (document == null) {
            XACMLSDKUtils.debug.error("ResponseImpl.processElement(): invalid XML input");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
    }

    public ObligationsImpl(Element element) throws XACMLException {
        this.processElement(element);
        this.makeImmutable();
    }

    public List getObligations() {
        return this.obligations;
    }

    public void setObligations(List obligations) throws XACMLException {
        if (!this.mutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (obligations != null) {
            Iterator iter = obligations.iterator();
            this.obligations = new ArrayList();
            while (iter.hasNext()) {
                Obligation obligation = (Obligation)iter.next();
                this.obligations.add(obligation);
            }
        } else {
            obligations = null;
        }
    }

    public void addObligation(Obligation obligation) throws XACMLException {
        if (!this.mutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (this.obligations == null) {
            this.obligations = new ArrayList();
        }
        this.obligations.add(obligation);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws XACMLException {
        StringBuffer sb = new StringBuffer(2000);
        String nsPrefix = "";
        String nsDeclaration = "";
        if (includeNSPrefix) {
            nsPrefix = XACMLConstants.XACML_NS_PREFIX + ":";
        }
        if (declareNS) {
            nsDeclaration = XACMLConstants.XACML_NS_DECLARATION;
        }
        sb.append("<").append(nsPrefix).append(XACMLConstants.OBLIGATIONS).append(" ").append(nsDeclaration).append(">\n");
        int length = 0;
        if (this.obligations != null) {
            length = this.obligations.size();
            for (int i = 0; i < length; ++i) {
                Obligation obligation = (Obligation)this.obligations.get(i);
                sb.append(obligation.toXMLString(includeNSPrefix, false));
            }
        }
        sb.append("</").append(nsPrefix).append(XACMLConstants.OBLIGATIONS).append(">\n");
        return sb.toString();
    }

    public String toXMLString() throws XACMLException {
        return this.toXMLString(true, false);
    }

    public void makeImmutable() {
        this.mutable = false;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    private void processElement(Element element) throws XACMLException {
        if (element == null) {
            XACMLSDKUtils.debug.error("ResponseImpl.processElement(): invalid root element");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_element"));
        }
        String elemName = element.getLocalName();
        if (elemName == null) {
            XACMLSDKUtils.debug.error("ResponseImpl.processElement(): local name missing");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_local_name"));
        }
        if (!elemName.equals(XACMLConstants.OBLIGATIONS)) {
            XACMLSDKUtils.debug.error("ResponseImpl.processElement(): invalid local name " + elemName);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_local_name"));
        }
        NodeList nodes = element.getChildNodes();
        int numOfNodes = nodes.getLength();
        for (int nextElem = 0; nextElem < numOfNodes; ++nextElem) {
            String childName;
            Node child = nodes.item(nextElem);
            if (child.getNodeType() != 1 || (childName = child.getLocalName()) == null) continue;
            if (childName.equals(XACMLConstants.OBLIGATION)) {
                this.obligations.add(PolicyFactory.getInstance().createObligation((Element)child));
                continue;
            }
            XACMLSDKUtils.debug.error("ObligationsImpl.processElement():  invalid child element: " + elemName);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_child_name"));
        }
    }
}

