/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.xacml.context.impl;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.xacml.common.XACMLConstants;
import com.sun.identity.xacml.common.XACMLException;
import com.sun.identity.xacml.common.XACMLSDKUtils;
import com.sun.identity.xacml.context.Attribute;
import com.sun.identity.xacml.context.ContextFactory;
import com.sun.identity.xacml.context.Subject;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SubjectImpl
implements Subject {
    private List attributes;
    private URI subjectCategory;
    private Attribute subjectCategoryAttribute;
    private boolean isMutable = true;
    private boolean needToCreateSubjectCategory = false;

    public SubjectImpl() {
    }

    public SubjectImpl(String xml) throws XACMLException {
        Document document = XMLUtils.toDOMDocument((String)xml, (Debug)XACMLSDKUtils.debug);
        if (document == null) {
            XACMLSDKUtils.debug.error("SubjectImpl.processElement(): invalid XML input");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
    }

    public SubjectImpl(Element element) throws XACMLException {
        this.processElement(element);
        this.makeImmutable();
    }

    private void processElement(Element element) throws XACMLException {
        if (element == null) {
            XACMLSDKUtils.debug.error("SubjectImpl.processElement(): invalid root element");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_element"));
        }
        String elemName = element.getLocalName();
        if (elemName == null) {
            XACMLSDKUtils.debug.error("SubjectImpl.processElement(): local name missing");
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("missing_local_name"));
        }
        if (!elemName.equals(XACMLConstants.SUBJECT)) {
            XACMLSDKUtils.debug.error("SubjectImpl.processElement(): invalid local name " + elemName);
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_local_name"));
        }
        NodeList nodes = element.getChildNodes();
        int numOfNodes = nodes.getLength();
        if (numOfNodes >= 1) {
            ContextFactory factory = ContextFactory.getInstance();
            for (int nextElem = 0; nextElem < numOfNodes; ++nextElem) {
                Node child = nodes.item(nextElem);
                if (child.getNodeType() != 1 && child.getNodeType() != 2) continue;
                String attrChildName = child.getLocalName();
                if (attrChildName.equals(XACMLConstants.ATTRIBUTE)) {
                    if (this.attributes == null) {
                        this.attributes = new ArrayList();
                    }
                    Attribute attribute = factory.getInstance().createAttribute((Element)child);
                    this.attributes.add(attribute);
                    continue;
                }
                if (attrChildName.equals(XACMLConstants.SUBJECT_CATEGORY)) {
                    try {
                        this.subjectCategory = new URI(child.getNodeValue());
                        continue;
                    }
                    catch (Exception e) {
                        throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("attribute_not_uri"));
                    }
                }
                XACMLSDKUtils.debug.error("RequestImpl.processElement(): Invalid element :" + attrChildName);
                throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("invalid_element"));
            }
        }
    }

    public List getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List attributes) throws XACMLException {
        if (!this.isMutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (attributes != null && !attributes.isEmpty()) {
            if (this.attributes == null) {
                this.attributes = new ArrayList();
            }
            this.attributes.addAll(attributes);
        }
    }

    public URI getSubjectCategory() {
        try {
            if (this.subjectCategory == null) {
                this.subjectCategory = new URI(XACMLConstants.ACCESS_SUBJECT);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.subjectCategory;
    }

    public void setSubjectCategory(URI subjectCategory) throws XACMLException {
        if (!this.isMutable) {
            throw new XACMLException(XACMLSDKUtils.xacmlResourceBundle.getString("objectImmutable"));
        }
        if (subjectCategory != null) {
            this.subjectCategory = subjectCategory;
        }
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws XACMLException {
        StringBuffer sb = new StringBuffer(2000);
        StringBuffer NS = new StringBuffer(100);
        includeNSPrefix = false;
        declareNS = false;
        String appendNS = "";
        if (declareNS) {
            NS.append(XACMLConstants.CONTEXT_NS_DECLARATION).append(XACMLConstants.SPACE);
            NS.append(XACMLConstants.XSI_NS_URI).append(XACMLConstants.SPACE).append(XACMLConstants.CONTEXT_SCHEMA_LOCATION);
        }
        if (includeNSPrefix) {
            appendNS = XACMLConstants.CONTEXT_NS_PREFIX + ":";
        }
        sb.append("<").append(appendNS).append(XACMLConstants.SUBJECT).append(NS);
        if (this.subjectCategory != null) {
            sb.append(" ").append(XACMLConstants.SUBJECT_CATEGORY).append("=");
            sb.append("\"").append(this.subjectCategory.toString()).append("\"");
        }
        sb.append(">");
        int length = 0;
        if (this.attributes != null) {
            sb.append("\n");
            length = this.attributes.size();
            for (int i = 0; i < length; ++i) {
                Attribute attr = (Attribute)this.attributes.get(i);
                sb.append(attr.toXMLString(includeNSPrefix, false));
            }
        }
        sb.append("</").append(appendNS).append(XACMLConstants.SUBJECT);
        sb.append(">\n");
        return sb.toString();
    }

    public String toXMLString() throws XACMLException {
        return this.toXMLString(true, false);
    }

    public void makeImmutable() {
    }

    public boolean isMutable() {
        return this.isMutable;
    }
}

