/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.servlet;

import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.wsfederation.common.WSFederationException;
import com.sun.identity.wsfederation.common.WSFederationUtils;
import com.sun.identity.wsfederation.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.FederationElement;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import com.sun.identity.wsfederation.meta.WSFederationMetaUtils;
import com.sun.identity.wsfederation.servlet.WSFederationAction;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RPSigninRequest
extends WSFederationAction {
    private static Debug debug = WSFederationUtils.debug;
    String whr;
    String wreply;
    String wctx;
    String wct;

    public RPSigninRequest(HttpServletRequest request, HttpServletResponse response, String whr, String wct, String wctx, String wreply) {
        super(request, response);
        this.whr = whr;
        this.wct = wct;
        this.wctx = wctx;
        this.wreply = wreply;
    }

    public void process() throws WSFederationException, IOException {
        String accountRealmCookieName;
        String spMetaAlias;
        String classMethod = "RPSigninRequest.process: ";
        if (debug.messageEnabled()) {
            debug.message(classMethod + "entered method");
        }
        if (this.wctx == null || this.wctx.length() == 0) {
            String string = this.wctx = this.wreply != null && this.wreply.length() > 0 ? WSFederationUtils.putReplyURL(this.wreply) : null;
        }
        if ((spMetaAlias = WSFederationMetaUtils.getMetaAliasByUri(this.request.getRequestURI())) == null || spMetaAlias.length() == 0) {
            throw new WSFederationException(WSFederationUtils.bundle.getString("nullSPEntityID"));
        }
        String spEntityId = WSFederationMetaManager.getEntityByMetaAlias(spMetaAlias);
        String spRealm = SAML2MetaUtils.getRealmByMetaAlias(spMetaAlias);
        SPSSOConfigElement spConfig = WSFederationMetaManager.getSPSSOConfig(spRealm, spEntityId);
        if (spConfig == null) {
            throw new WSFederationException(WSFederationUtils.bundle.getString("badSPEntityID"));
        }
        Map<String, List<String>> spConfigAttributes = WSFederationMetaUtils.getAttributes(spConfig);
        String accountRealmSelection = spConfigAttributes.get("AccountRealmSelection").get(0);
        if (accountRealmSelection == null) {
            accountRealmSelection = "cookie";
        }
        if ((accountRealmCookieName = spConfigAttributes.get("AccountRealmCookieName").get(0)) == null) {
            accountRealmCookieName = "amWSFederationAccountRealm";
        }
        String homeRealmDiscoveryService = spConfigAttributes.get("HomeRealmDiscoveryService").get(0);
        if (debug.messageEnabled()) {
            debug.message(classMethod + "account realm selection method is " + accountRealmSelection);
        }
        String idpIssuerName = null;
        if (this.whr != null && this.whr.length() > 0) {
            idpIssuerName = this.whr;
            if (accountRealmSelection.equals("cookie")) {
                Cookie cookie = new Cookie(accountRealmCookieName, this.whr);
                cookie.setMaxAge(31536000);
                this.response.addCookie(cookie);
            }
        } else if (accountRealmSelection.equals("user-agent")) {
            String uaHeader = this.request.getHeader("user-agent");
            if (debug.messageEnabled()) {
                debug.message(classMethod + "user-agent is :" + uaHeader);
            }
            idpIssuerName = WSFederationUtils.accountRealmFromUserAgent(uaHeader, accountRealmCookieName);
        } else if (accountRealmSelection.equals("cookie")) {
            Cookie[] cookies = this.request.getCookies();
            if (cookies != null) {
                for (int i = 0; i < cookies.length; ++i) {
                    if (!cookies[i].getName().equals(accountRealmCookieName)) continue;
                    idpIssuerName = cookies[i].getValue();
                    break;
                }
            }
        } else {
            debug.error(classMethod + "unexpected value for " + "AccountRealmSelection" + " : " + accountRealmSelection);
            throw new WSFederationException(WSFederationUtils.bundle.getString("badAccountRealm"));
        }
        FederationElement sp = WSFederationMetaManager.getEntityDescriptor(spRealm, spEntityId);
        String spIssuerName = WSFederationMetaManager.getTokenIssuerName(sp);
        if (debug.messageEnabled()) {
            debug.message(classMethod + "SP issuer name:" + spIssuerName);
        }
        String idpEntityId = null;
        if (idpIssuerName != null && idpIssuerName.length() > 0) {
            idpEntityId = WSFederationMetaManager.getEntityByTokenIssuerName(null, idpIssuerName);
        }
        if (idpEntityId == null) {
            List<String> idpList = WSFederationMetaManager.getAllRemoteIdentityProviderEntities(spRealm);
            if (idpList.size() == 0) {
                throw new WSFederationException(WSFederationUtils.bundle.getString("noIDPConfigured"));
            }
            if (idpList.size() == 1) {
                idpEntityId = idpList.get(0);
            }
        }
        FederationElement idp = null;
        if (idpEntityId != null) {
            idp = WSFederationMetaManager.getEntityDescriptor(null, idpEntityId);
        }
        WSFederationUtils.sessionProvider.setLoadBalancerCookie(this.response);
        if (idp == null) {
            StringBuffer url = new StringBuffer(homeRealmDiscoveryService);
            url.append("?wreply=");
            url.append(URLEncDec.encode((String)this.request.getRequestURL().toString()));
            if (this.wctx != null) {
                url.append("&wctx=");
                url.append(URLEncDec.encode((String)this.wctx));
            }
            if (debug.messageEnabled()) {
                debug.message(classMethod + "no account realm - redirecting to :" + url);
            }
            this.response.sendRedirect(url.toString());
            return;
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + "account realm:" + idpEntityId);
        }
        String endpoint = WSFederationMetaManager.getTokenIssuerEndpoint(idp);
        if (debug.messageEnabled()) {
            debug.message(classMethod + "endpoint:" + endpoint);
        }
        String replyURL = WSFederationMetaManager.getTokenIssuerEndpoint(sp);
        if (debug.messageEnabled()) {
            debug.message(classMethod + "replyURL:" + replyURL);
        }
        StringBuffer url = new StringBuffer(endpoint);
        url.append("?wa=");
        url.append(URLEncDec.encode((String)"wsignin1.0"));
        if (this.wctx != null) {
            url.append("&wctx=");
            url.append(URLEncDec.encode((String)this.wctx));
        }
        url.append("&wreply=");
        url.append(URLEncDec.encode((String)replyURL));
        url.append("&wct=");
        url.append(URLEncDec.encode((String)DateUtils.toUTCDateFormat((Date)new Date())));
        url.append("&wtrealm=");
        url.append(URLEncDec.encode((String)spIssuerName));
        if (debug.messageEnabled()) {
            debug.message(classMethod + "Redirecting to:" + url);
        }
        this.response.sendRedirect(url.toString());
    }
}

