/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.profile;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import com.sun.identity.wsfederation.common.WSFederationException;
import com.sun.identity.wsfederation.common.WSFederationUtils;
import com.sun.identity.wsfederation.profile.RequestedSecurityToken;
import com.sun.identity.wsfederation.profile.RequestedSecurityTokenFactory;
import java.io.InputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RequestSecurityTokenResponse {
    private static Debug debug = WSFederationUtils.debug;
    protected boolean valid = true;
    protected String recipient = null;
    protected boolean validationDone = true;
    protected String appliesTo = null;
    protected String issuer = null;
    protected RequestedSecurityToken token = null;

    public RequestSecurityTokenResponse(RequestedSecurityToken token, String appliesTo) {
        this.token = token;
        this.appliesTo = appliesTo;
    }

    public RequestSecurityTokenResponse(RequestedSecurityToken token) {
        this(token, null);
    }

    public RequestSecurityTokenResponse(Element root) throws WSFederationException {
        String classMethod = "RequestSecurityTokenResponse:RequestSecurityTokenResponse(Element)";
        if (root == null) {
            if (debug.messageEnabled()) {
                debug.message(classMethod + "null input.");
            }
            throw new WSFederationException(WSFederationUtils.bundle.getString("nullInput"));
        }
        String tag = null;
        tag = root.getLocalName();
        if (tag == null || !tag.equals("RequestSecurityTokenResponse")) {
            if (debug.messageEnabled()) {
                debug.message(classMethod + "wrong input.");
            }
            throw new WSFederationException(WSFederationUtils.bundle.getString("wrongInput"));
        }
        if (debug.messageEnabled()) {
            debug.message(classMethod + "found RequestSecurityTokenResponse.");
        }
        NodeList list = root.getChildNodes();
        int length = list.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = list.item(i);
            String name = child.getLocalName();
            if (debug.messageEnabled()) {
                debug.message(classMethod + "examining:" + name);
            }
            if (name.equals("AppliesTo")) {
                NodeList nodes = ((Element)child).getElementsByTagNameNS("http://schemas.xmlsoap.org/ws/2004/08/addressing", "Address");
                String appliesTo = nodes.item(0).getTextContent();
                if (!debug.messageEnabled()) continue;
                debug.message(classMethod + "found AppliesTo:" + appliesTo);
                continue;
            }
            if (!name.equals("RequestedSecurityToken")) continue;
            if (debug.messageEnabled()) {
                debug.message(classMethod + "found RequestedSecurityToken");
            }
            this.token = RequestedSecurityTokenFactory.createToken(child);
        }
    }

    public static RequestSecurityTokenResponse parseXML(String xml) throws WSFederationException {
        Document doc = XMLUtils.toDOMDocument((String)xml, (Debug)debug);
        Element root = doc.getDocumentElement();
        return new RequestSecurityTokenResponse(root);
    }

    public static RequestSecurityTokenResponse parseXML(InputStream is) throws WSFederationException {
        Document doc = XMLUtils.toDOMDocument((InputStream)is, (Debug)debug);
        Element root = doc.getDocumentElement();
        return new RequestSecurityTokenResponse(root);
    }

    public RequestedSecurityToken getRequestedSecurityToken() {
        return this.token;
    }

    public String getAppliesTo() {
        return this.appliesTo;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<wst:RequestSecurityTokenResponse xmlns:wst=\"http://schemas.xmlsoap.org/ws/2005/02/trust\">").append(this.token.toString()).append("<wsp:AppliesTo ").append("xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\">").append("<wsa:EndpointReference xmlns:").append("wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">").append("<wsa:Address>" + this.appliesTo + "</wsa:Address>").append("</wsa:EndpointReference>").append("</wsp:AppliesTo>").append("</wst:RequestSecurityTokenResponse>");
        return buffer.toString();
    }
}

