/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.plugins;

import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wsfederation.common.WSFederationException;
import com.sun.identity.wsfederation.common.WSFederationUtils;
import com.sun.identity.wsfederation.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.wsfederation.meta.WSFederationMetaException;
import com.sun.identity.wsfederation.meta.WSFederationMetaManager;
import com.sun.identity.wsfederation.meta.WSFederationMetaUtils;
import com.sun.identity.wsfederation.plugins.IDPAuthenticationMethodMapper;
import com.sun.identity.wsfederation.plugins.IDPAuthenticationTypeInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class DefaultIDPAuthenticationMethodMapper
implements IDPAuthenticationMethodMapper {
    Debug debug = WSFederationUtils.debug;

    public IDPAuthenticationTypeInfo getIDPAuthnContextInfo(String authenticationType, String idpEntityID, String realm) throws WSFederationException {
        String classMethod = "DefaultIDPAuthnContextMapper.getIDPAuthnContextInfo: ";
        Map<String, List<String>> attrs = null;
        HashSet<String> authTypeAndValues = null;
        IDPAuthenticationTypeInfo info = null;
        Object requestedClassRefs = null;
        String requestedClassRef = null;
        Object classRefs = null;
        String classRef = null;
        try {
            IDPSSOConfigElement config = WSFederationMetaManager.getIDPSSOConfig(realm, idpEntityID);
            attrs = WSFederationMetaUtils.getAttributes(config);
        }
        catch (WSFederationMetaException sme) {
            this.debug.error(classMethod + "get IDPSSOConfig failed:", (Throwable)((Object)sme));
            throw new WSFederationException((Throwable)((Object)sme));
        }
        List<String> values = attrs.get("idpAuthncontextClassrefMapping");
        if (values != null && values.size() != 0) {
            String value;
            StringTokenizer st;
            if (authenticationType != null) {
                for (int i = 0; i < values.size(); ++i) {
                    StringTokenizer st2;
                    String value2 = values.get(i).trim();
                    if (this.debug.messageEnabled()) {
                        this.debug.message(classMethod + "configured mapping=" + value2);
                    }
                    if (!(st2 = new StringTokenizer(value2, "|")).hasMoreTokens() || !(classRef = st2.nextToken().trim()).equals(authenticationType)) continue;
                    authTypeAndValues = new HashSet();
                    while (st2.hasMoreTokens()) {
                        String authTypeAndValue = st2.nextToken().trim();
                        if (authTypeAndValue.length() == 0) continue;
                        authTypeAndValues.add(authTypeAndValue);
                    }
                    break;
                }
            }
            if (authTypeAndValues == null && (st = new StringTokenizer(value = values.get(0).trim(), "|")).hasMoreTokens()) {
                classRef = st.nextToken().trim();
                authTypeAndValues = new HashSet<String>();
                while (st.hasMoreTokens()) {
                    String authTypeAndValue = st.nextToken().trim();
                    if (authTypeAndValue.length() == 0) continue;
                    authTypeAndValues.add(authTypeAndValue);
                }
            }
            info = new IDPAuthenticationTypeInfo(authenticationType, authTypeAndValues);
            if (this.debug.messageEnabled()) {
                this.debug.message(classMethod + "requested AuthnContextClassRef=" + requestedClassRef + "\nreturned AuthnContextClassRef=" + classRef + "\nauthTypeAndValues=" + authTypeAndValues);
            }
        }
        return info;
    }
}

