/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.meta;

import com.sun.identity.cot.COTException;
import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.plugin.configuration.ConfigurationException;
import com.sun.identity.plugin.configuration.ConfigurationInstance;
import com.sun.identity.plugin.configuration.ConfigurationManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wsfederation.common.WSFederationUtils;
import com.sun.identity.wsfederation.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.wsfederation.jaxb.entityconfig.FederationConfigElement;
import com.sun.identity.wsfederation.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.wsfederation.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.FederationElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.TokenIssuerEndpointElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.TokenIssuerNameElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.TokenSigningKeyInfoElement;
import com.sun.identity.wsfederation.jaxb.wsfederation.UriNamedClaimTypesOfferedElement;
import com.sun.identity.wsfederation.logging.LogUtil;
import com.sun.identity.wsfederation.meta.WSFederationMetaCache;
import com.sun.identity.wsfederation.meta.WSFederationMetaException;
import com.sun.identity.wsfederation.meta.WSFederationMetaServiceListener;
import com.sun.identity.wsfederation.meta.WSFederationMetaUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.bind.JAXBException;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0.SecurityTokenReferenceType;
import org.w3._2000._09.xmldsig_.X509DataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSFederationMetaManager {
    private static final String ATTR_METADATA = "sun-fm-wsfederation-metadata";
    private static final String ATTR_ENTITY_CONFIG = "sun-fm-wsfederation-entityconfig";
    private static final String SUBCONFIG_ID = "Federation";
    private static final int SUBCONFIG_PRIORITY = 0;
    private static Debug debug = WSFederationUtils.debug;
    private static CircleOfTrustManager cotm;
    private static ConfigurationInstance configInst;
    private static final String WSFEDERATION = "WS-FEDERATION";

    private WSFederationMetaManager() {
    }

    public static FederationElement getEntityDescriptor(String realm, String entityId) throws WSFederationMetaException {
        if (entityId == null) {
            return null;
        }
        if (realm == null) {
            realm = "/";
        }
        Object[] objs = new String[]{entityId, realm};
        FederationElement federation = WSFederationMetaCache.getFederation(realm, entityId);
        if (federation != null) {
            LogUtil.access(Level.FINE, "GOT_FEDERATION", (String[])objs, null);
            return federation;
        }
        try {
            Map attrs = configInst.getConfiguration(realm, entityId);
            if (attrs == null) {
                return null;
            }
            Set values = (Set)attrs.get(ATTR_METADATA);
            if (values == null || values.isEmpty()) {
                return null;
            }
            String value = (String)values.iterator().next();
            Object obj = WSFederationMetaUtils.convertStringToJAXB(value);
            if (obj instanceof FederationElement) {
                federation = (FederationElement)obj;
                WSFederationMetaCache.putFederation(realm, entityId, federation);
                LogUtil.access(Level.FINE, "GOT_FEDERATION", (String[])objs, null);
                return federation;
            }
            debug.error("WSFederationMetaManager.getFederation: invalid descriptor");
            LogUtil.error(Level.INFO, "GOT_INVALID_ENTITY_DESCRIPTOR", (String[])objs, null);
            throw new WSFederationMetaException("invalid_descriptor", objs);
        }
        catch (ConfigurationException e) {
            debug.error("WSFederationMetaManager.getFederation:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), entityId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_GET_ENTITY_DESCRIPTOR", data, null);
            throw new WSFederationMetaException((Throwable)((Object)e));
        }
        catch (JAXBException jaxbe) {
            debug.error("WSFederationMetaManager.getFederation:", (Throwable)jaxbe);
            LogUtil.error(Level.INFO, "GOT_INVALID_ENTITY_DESCRIPTOR", (String[])objs, null);
            throw new WSFederationMetaException("invalid_descriptor", objs);
        }
    }

    public static void setFederation(String realm, FederationElement federation) throws WSFederationMetaException {
        String federationId = federation.getFederationID();
        if (federationId == null) {
            federationId = "sunFMWSFederationDefaultFederationID";
        }
        if (realm == null) {
            realm = "/";
        }
        Object[] objs = new String[]{federationId, realm};
        try {
            Map attrs = WSFederationMetaUtils.convertJAXBToAttrMap(ATTR_METADATA, federation);
            Map oldAttrs = configInst.getConfiguration(realm, federationId);
            oldAttrs.put(ATTR_METADATA, attrs.get(ATTR_METADATA));
            configInst.setConfiguration(realm, federationId, oldAttrs);
            LogUtil.access(Level.INFO, "SET_ENTITY_DESCRIPTOR", (String[])objs, null);
        }
        catch (ConfigurationException e) {
            debug.error("WSFederationMetaManager.setFederation:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), federationId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_SET_ENTITY_DESCRIPTOR", data, null);
            throw new WSFederationMetaException((Throwable)((Object)e));
        }
        catch (JAXBException jaxbe) {
            debug.error("WSFederationMetaManager.setFederation:", (Throwable)jaxbe);
            LogUtil.error(Level.INFO, "SET_INVALID_ENTITY_DESCRIPTOR", (String[])objs, null);
            throw new WSFederationMetaException("invalid_descriptor", objs);
        }
    }

    public static void createFederation(String realm, FederationElement federation) throws WSFederationMetaException {
        String federationId = federation.getFederationID();
        if (federationId == null) {
            federationId = "sunFMWSFederationDefaultFederationID";
        }
        if (realm == null) {
            realm = "/";
        }
        Object[] objs = new String[]{federationId, realm};
        try {
            Map attrs = WSFederationMetaUtils.convertJAXBToAttrMap(ATTR_METADATA, federation);
            configInst.createConfiguration(realm, federationId, attrs);
            LogUtil.access(Level.INFO, "ENTITY_DESCRIPTOR_CREATED", (String[])objs, null);
        }
        catch (ConfigurationException e) {
            debug.error("WSFederationMetaManager.createFederation:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), federationId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_CREATE_ENTITY_DESCRIPTOR", data, null);
            throw new WSFederationMetaException((Throwable)((Object)e));
        }
        catch (JAXBException jaxbe) {
            debug.error("WSFederationMetaManager.createFederation:", (Throwable)jaxbe);
            LogUtil.error(Level.INFO, "CREATE_INVALID_ENTITY_DESCRIPTOR", (String[])objs, null);
            throw new WSFederationMetaException("invalid_descriptor", objs);
        }
    }

    public static void deleteFederation(String realm, String federationId) throws WSFederationMetaException {
        if (federationId == null) {
            return;
        }
        if (realm == null) {
            realm = "/";
        }
        String[] objs = new String[]{federationId, realm};
        try {
            SPSSOConfigElement spconfig;
            IDPSSOConfigElement idpconfig = WSFederationMetaManager.getIDPSSOConfig(realm, federationId);
            if (idpconfig != null) {
                WSFederationMetaManager.removeFromCircleOfTrust(idpconfig, realm, federationId);
            }
            if ((spconfig = WSFederationMetaManager.getSPSSOConfig(realm, federationId)) != null) {
                WSFederationMetaManager.removeFromCircleOfTrust(spconfig, realm, federationId);
            }
            configInst.deleteConfiguration(realm, federationId, null);
            LogUtil.access(Level.INFO, "ENTITY_DESCRIPTOR_DELETED", objs, null);
            WSFederationMetaCache.putFederation(realm, federationId, null);
        }
        catch (ConfigurationException e) {
            debug.error("WSFederationMetaManager.deleteFederation:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), federationId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_DELETE_ENTITY_DESCRIPTOR", data, null);
            throw new WSFederationMetaException((Throwable)((Object)e));
        }
    }

    public static FederationConfigElement getEntityConfig(String realm, String federationId) throws WSFederationMetaException {
        if (federationId == null) {
            return null;
        }
        if (realm == null) {
            realm = "/";
        }
        Object[] objs = new String[]{federationId, realm};
        FederationConfigElement config = WSFederationMetaCache.getEntityConfig(realm, federationId);
        if (config != null) {
            LogUtil.access(Level.FINE, "GOT_ENTITY_CONFIG", (String[])objs, null);
            return config;
        }
        try {
            Map attrs = configInst.getConfiguration(realm, federationId);
            if (attrs == null) {
                return null;
            }
            Set values = (Set)attrs.get(ATTR_ENTITY_CONFIG);
            if (values == null || values.isEmpty()) {
                return null;
            }
            String value = (String)values.iterator().next();
            Object obj = WSFederationMetaUtils.convertStringToJAXB(value);
            if (obj instanceof FederationConfigElement) {
                config = (FederationConfigElement)obj;
                WSFederationMetaCache.putEntityConfig(realm, federationId, config);
                LogUtil.access(Level.FINE, "GOT_ENTITY_CONFIG", (String[])objs, null);
                return config;
            }
            debug.error("WSFederationMetaManager.getEntityConfig: invalid config");
            LogUtil.error(Level.INFO, "GOT_INVALID_ENTITY_CONFIG", (String[])objs, null);
            throw new WSFederationMetaException("invalid_config", objs);
        }
        catch (ConfigurationException e) {
            debug.error("WSFederationMetaManager.getEntityConfig:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), federationId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_GET_ENTITY_CONFIG", data, null);
            throw new WSFederationMetaException((Throwable)((Object)e));
        }
        catch (JAXBException jaxbe) {
            debug.error("WSFederationMetaManager.getEntityConfig:", (Throwable)jaxbe);
            LogUtil.error(Level.INFO, "GOT_INVALID_ENTITY_CONFIG", (String[])objs, null);
            throw new WSFederationMetaException("invalid_config", objs);
        }
    }

    public static SPSSOConfigElement getSPSSOConfig(String realm, String federationId) throws WSFederationMetaException {
        FederationConfigElement eConfig = WSFederationMetaManager.getEntityConfig(realm, federationId);
        if (eConfig == null) {
            return null;
        }
        List list = eConfig.getIDPSSOConfigOrSPSSOConfig();
        for (Object obj : list) {
            if (!(obj instanceof SPSSOConfigElement)) continue;
            return (SPSSOConfigElement)obj;
        }
        return null;
    }

    public static IDPSSOConfigElement getIDPSSOConfig(String realm, String federationId) throws WSFederationMetaException {
        FederationConfigElement eConfig = WSFederationMetaManager.getEntityConfig(realm, federationId);
        if (eConfig == null) {
            return null;
        }
        List list = eConfig.getIDPSSOConfigOrSPSSOConfig();
        for (Object obj : list) {
            if (!(obj instanceof IDPSSOConfigElement)) continue;
            return (IDPSSOConfigElement)obj;
        }
        return null;
    }

    public static BaseConfigType getBaseConfig(String realm, String federationId) throws WSFederationMetaException {
        FederationConfigElement eConfig = WSFederationMetaManager.getEntityConfig(realm, federationId);
        if (eConfig == null) {
            return null;
        }
        return (BaseConfigType)eConfig.getIDPSSOConfigOrSPSSOConfig().get(0);
    }

    public static void setEntityConfig(String realm, FederationConfigElement config) throws WSFederationMetaException {
        String federationId = config.getFederationID();
        if (federationId == null) {
            debug.error("WSFederationMetaManager.setEntityConfig: entity ID is null");
            String[] data = new String[]{realm};
            LogUtil.error(Level.INFO, "NO_ENTITY_ID_SET_ENTITY_CONFIG", data, null);
            throw new WSFederationMetaException("empty_entityid", null);
        }
        if (realm == null) {
            realm = "/";
        }
        Object[] objs = new String[]{federationId, realm};
        try {
            Map attrs = WSFederationMetaUtils.convertJAXBToAttrMap(ATTR_ENTITY_CONFIG, config);
            Map oldAttrs = configInst.getConfiguration(realm, federationId);
            oldAttrs.put(ATTR_ENTITY_CONFIG, attrs.get(ATTR_ENTITY_CONFIG));
            configInst.setConfiguration(realm, federationId, oldAttrs);
            LogUtil.access(Level.INFO, "SET_ENTITY_CONFIG", (String[])objs, null);
        }
        catch (ConfigurationException e) {
            debug.error("WSFederationMetaManager.setEntityConfig:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), federationId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_SET_ENTITY_CONFIG", data, null);
            throw new WSFederationMetaException((Throwable)((Object)e));
        }
        catch (JAXBException jaxbe) {
            debug.error("WSFederationMetaManager.setEntityConfig:", (Throwable)jaxbe);
            LogUtil.error(Level.INFO, "SET_INVALID_ENTITY_CONFIG", (String[])objs, null);
            throw new WSFederationMetaException("invalid_config", objs);
        }
    }

    public static void createEntityConfig(String realm, FederationConfigElement config) throws WSFederationMetaException {
        String federationId = config.getFederationID();
        if (federationId == null) {
            debug.error("WSFederationMetaManager.createEntityConfig: entity ID is null");
            String[] data = new String[]{realm};
            LogUtil.error(Level.INFO, "NO_ENTITY_ID_CREATE_ENTITY_CONFIG", data, null);
            throw new WSFederationMetaException("empty_entityid", null);
        }
        if (realm == null) {
            realm = "/";
        }
        Object[] objs = new String[]{federationId, realm};
        try {
            IDPSSOConfigElement idpconfig;
            Map attrs = WSFederationMetaUtils.convertJAXBToAttrMap(ATTR_ENTITY_CONFIG, config);
            Map oldAttrs = configInst.getConfiguration(realm, federationId);
            if (oldAttrs == null) {
                LogUtil.error(Level.INFO, "NO_ENTITY_DESCRIPTOR_CREATE_ENTITY_CONFIG", (String[])objs, null);
                throw new WSFederationMetaException("entity_descriptor_not_exist", objs);
            }
            Set oldValues = (Set)oldAttrs.get(ATTR_ENTITY_CONFIG);
            if (oldValues != null && !oldValues.isEmpty()) {
                LogUtil.error(Level.INFO, "ENTITY_CONFIG_EXISTS", (String[])objs, null);
                throw new WSFederationMetaException("entity_config_exists", objs);
            }
            configInst.setConfiguration(realm, federationId, attrs);
            LogUtil.access(Level.INFO, "ENTITY_CONFIG_CREATED", (String[])objs, null);
            SPSSOConfigElement spconfig = WSFederationMetaManager.getSPSSOConfig(realm, federationId);
            if (spconfig != null) {
                WSFederationMetaManager.addToCircleOfTrust(spconfig, realm, federationId);
            }
            if ((idpconfig = WSFederationMetaManager.getIDPSSOConfig(realm, federationId)) != null) {
                WSFederationMetaManager.addToCircleOfTrust(idpconfig, realm, federationId);
            }
        }
        catch (ConfigurationException e) {
            debug.error("WSFederationMetaManager.createEntityConfig:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), federationId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_CREATE_ENTITY_CONFIG", data, null);
            throw new WSFederationMetaException((Throwable)((Object)e));
        }
        catch (JAXBException jaxbe) {
            debug.error("WSFederationMetaManager.createEntityConfig:", (Throwable)jaxbe);
            LogUtil.error(Level.INFO, "CREATE_INVALID_ENTITY_CONFIG", (String[])objs, null);
            throw new WSFederationMetaException("invalid_config", objs);
        }
    }

    private static void addToCircleOfTrust(BaseConfigType config, String realm, String federationId) {
        try {
            Map<String, List<String>> attr;
            List<String> cotAttr;
            ArrayList<String> cotList;
            if (config != null && (cotList = new ArrayList<String>(cotAttr = (attr = WSFederationMetaUtils.getAttributes(config)).get("cotlist"))) != null && !cotList.isEmpty()) {
                Iterator iter = cotList.iterator();
                while (iter.hasNext()) {
                    cotm.addCircleOfTrustMember(realm, (String)iter.next(), "wsfed", federationId);
                }
            }
        }
        catch (Exception e) {
            debug.error("WSFederationMetaManager.addToCircleOfTrust:Error while adding entity" + federationId + "to COT.", (Throwable)e);
        }
    }

    public static void deleteEntityConfig(String realm, String federationId) throws WSFederationMetaException {
        if (federationId == null) {
            return;
        }
        if (realm == null) {
            realm = "/";
        }
        Object[] objs = new String[]{federationId, realm};
        try {
            SPSSOConfigElement spconfig;
            Map oldAttrs = configInst.getConfiguration(realm, federationId);
            Set oldValues = (Set)oldAttrs.get(ATTR_ENTITY_CONFIG);
            if (oldValues == null || oldValues.isEmpty()) {
                LogUtil.error(Level.INFO, "NO_ENTITY_DESCRIPTOR_DELETE_ENTITY_CONFIG", (String[])objs, null);
                throw new WSFederationMetaException("entity_config_not_exist", objs);
            }
            IDPSSOConfigElement idpconfig = WSFederationMetaManager.getIDPSSOConfig(realm, federationId);
            if (idpconfig != null) {
                WSFederationMetaManager.removeFromCircleOfTrust(idpconfig, realm, federationId);
            }
            if ((spconfig = WSFederationMetaManager.getSPSSOConfig(realm, federationId)) != null) {
                WSFederationMetaManager.removeFromCircleOfTrust(spconfig, realm, federationId);
            }
            HashSet<String> attr = new HashSet<String>();
            attr.add(ATTR_ENTITY_CONFIG);
            configInst.deleteConfiguration(realm, federationId, attr);
            LogUtil.access(Level.INFO, "ENTITY_CONFIG_DELETED", (String[])objs, null);
            WSFederationMetaCache.putEntityConfig(realm, federationId, null);
        }
        catch (ConfigurationException e) {
            debug.error("WSFederationMetaManager.deleteEntityConfig:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), federationId, realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_DELETE_ENTITY_CONFIG", data, null);
            throw new WSFederationMetaException((Throwable)((Object)e));
        }
    }

    private static void removeFromCircleOfTrust(BaseConfigType config, String realm, String federationId) {
        try {
            Map<String, List<String>> attr;
            List<String> cotAttr;
            ArrayList<String> cotList;
            if (config != null && (cotList = new ArrayList<String>(cotAttr = (attr = WSFederationMetaUtils.getAttributes(config)).get("cotlist"))) != null && !cotList.isEmpty()) {
                Iterator iter = cotList.iterator();
                while (iter.hasNext()) {
                    String a = ((String)iter.next()).trim();
                    if (a.length() <= 0) continue;
                    cotm.removeCircleOfTrustMember(realm, a, "wsfed", federationId);
                }
            }
        }
        catch (Exception e) {
            debug.error("WSFederationMetaManager.removeFromCircleOfTrust:Error while removing entity" + federationId + "from COT.", (Throwable)e);
        }
    }

    public static List<String> getAllHostedEntities(String realm) throws WSFederationMetaException {
        ArrayList<String> hostedEntityIds = new ArrayList<String>();
        try {
            Set entityIds = configInst.getAllConfigurationNames(realm);
            if (entityIds != null && !entityIds.isEmpty()) {
                for (String federationId : entityIds) {
                    FederationConfigElement config = WSFederationMetaManager.getEntityConfig(realm, federationId);
                    if (config == null || !config.isHosted()) continue;
                    hostedEntityIds.add(federationId);
                }
            }
        }
        catch (ConfigurationException e) {
            debug.error("WSFederationMetaManager.getAllHostedEntities:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_GET_ALL_HOSTED_ENTITIES", data, null);
            throw new WSFederationMetaException((Throwable)((Object)e));
        }
        String[] objs = new String[]{realm};
        LogUtil.access(Level.FINE, "GOT_ALL_HOSTED_ENTITIES", objs, null);
        return hostedEntityIds;
    }

    public static List getAllHostedServiceProviderEntities(String realm) throws WSFederationMetaException {
        ArrayList<String> hostedSPEntityIds = new ArrayList<String>();
        List<String> hostedEntityIds = WSFederationMetaManager.getAllHostedEntities(realm);
        for (String federationId : hostedEntityIds) {
            if (WSFederationMetaManager.getSPSSOConfig(realm, federationId) == null) continue;
            hostedSPEntityIds.add(federationId);
        }
        return hostedSPEntityIds;
    }

    public static List<String> getAllHostedIdentityProviderEntities(String realm) throws WSFederationMetaException {
        ArrayList<String> hostedIDPEntityIds = new ArrayList<String>();
        List<String> hostedEntityIds = WSFederationMetaManager.getAllHostedEntities(realm);
        for (String federationId : hostedEntityIds) {
            if (WSFederationMetaManager.getIDPSSOConfig(realm, federationId) == null) continue;
            hostedIDPEntityIds.add(federationId);
        }
        return hostedIDPEntityIds;
    }

    public static List<String> getAllRemoteEntities(String realm) throws WSFederationMetaException {
        ArrayList<String> remoteEntityIds = new ArrayList<String>();
        String[] objs = new String[]{realm};
        try {
            Set entityIds = configInst.getAllConfigurationNames(realm);
            if (entityIds != null && !entityIds.isEmpty()) {
                for (String federationId : entityIds) {
                    FederationConfigElement config = WSFederationMetaManager.getEntityConfig(realm, federationId);
                    if (config != null && config.isHosted()) continue;
                    remoteEntityIds.add(federationId);
                }
            }
        }
        catch (ConfigurationException e) {
            debug.error("WSFederationMetaManager.getAllRemoteEntities:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_GET_ALL_REMOTE_ENTITIES", data, null);
            throw new WSFederationMetaException((Throwable)((Object)e));
        }
        LogUtil.access(Level.FINE, "GOT_ALL_REMOTE_ENTITIES", objs, null);
        return remoteEntityIds;
    }

    public static List<String> getAllRemoteServiceProviderEntities(String realm) throws WSFederationMetaException {
        ArrayList<String> remoteSPEntityIds = new ArrayList<String>();
        List<String> remoteEntityIds = WSFederationMetaManager.getAllRemoteEntities(realm);
        for (String federationId : remoteEntityIds) {
            if (WSFederationMetaManager.getSPSSOConfig(realm, federationId) == null) continue;
            remoteSPEntityIds.add(federationId);
        }
        return remoteSPEntityIds;
    }

    public static List<String> getAllRemoteIdentityProviderEntities(String realm) throws WSFederationMetaException {
        ArrayList<String> remoteIDPEntityIds = new ArrayList<String>();
        List<String> remoteEntityIds = WSFederationMetaManager.getAllRemoteEntities(realm);
        for (String federationId : remoteEntityIds) {
            if (WSFederationMetaManager.getIDPSSOConfig(realm, federationId) == null) continue;
            remoteIDPEntityIds.add(federationId);
        }
        return remoteIDPEntityIds;
    }

    public static String getEntityByMetaAlias(String metaAlias) throws WSFederationMetaException {
        String realm = WSFederationMetaUtils.getRealmByMetaAlias(metaAlias);
        try {
            Set entityIds = configInst.getAllConfigurationNames(realm);
            if (entityIds == null || entityIds.isEmpty()) {
                return null;
            }
            for (String federationId : entityIds) {
                FederationConfigElement config = WSFederationMetaManager.getEntityConfig(realm, federationId);
                if (config == null) continue;
                List list = config.getIDPSSOConfigOrSPSSOConfig();
                for (BaseConfigType bConfig : list) {
                    String cMetaAlias = bConfig.getMetaAlias();
                    if (cMetaAlias == null || !cMetaAlias.equals(metaAlias)) continue;
                    return federationId;
                }
            }
        }
        catch (ConfigurationException e) {
            debug.error("WSFederationMetaManager.getEntityByMetaAlias:", (Throwable)((Object)e));
            throw new WSFederationMetaException((Throwable)((Object)e));
        }
        return null;
    }

    public static String getEntityByTokenIssuerName(String realm, String issuer) throws WSFederationMetaException {
        try {
            Set entityIds = configInst.getAllConfigurationNames(realm);
            if (entityIds == null || entityIds.isEmpty()) {
                return null;
            }
            for (String federationId : entityIds) {
                FederationElement fed = WSFederationMetaManager.getEntityDescriptor(realm, federationId);
                if (!issuer.equals(WSFederationMetaManager.getTokenIssuerName(fed))) continue;
                return federationId;
            }
        }
        catch (ConfigurationException e) {
            debug.error("WSFederationMetaManager.getEntityByMetaAlias:", (Throwable)((Object)e));
            throw new WSFederationMetaException((Throwable)((Object)e));
        }
        return null;
    }

    public static String getRoleByMetaAlias(String metaAlias) throws WSFederationMetaException {
        String role = "UNKNOWN";
        String federationId = WSFederationMetaManager.getEntityByMetaAlias(metaAlias);
        if (federationId != null) {
            String realm = WSFederationMetaUtils.getRealmByMetaAlias(metaAlias);
            IDPSSOConfigElement idpConfig = WSFederationMetaManager.getIDPSSOConfig(realm, federationId);
            SPSSOConfigElement spConfig = WSFederationMetaManager.getSPSSOConfig(realm, federationId);
            if (idpConfig == null) {
                String m = spConfig.getMetaAlias();
                if (m != null && m.equals(metaAlias)) {
                    role = "SPRole";
                }
            } else if (spConfig == null) {
                String m = idpConfig.getMetaAlias();
                if (m != null && m.equals(metaAlias)) {
                    role = "IDPRole";
                }
            } else {
                String m = spConfig.getMetaAlias();
                if (m != null && m.equals(metaAlias)) {
                    role = "SPRole";
                } else {
                    m = idpConfig.getMetaAlias();
                    if (m != null && m.equals(metaAlias)) {
                        role = "IDPRole";
                    }
                }
            }
        }
        return role;
    }

    public static List<String> getAllHostedIdentityProviderMetaAliases(String realm) throws WSFederationMetaException {
        ArrayList<String> metaAliases = new ArrayList<String>();
        IDPSSOConfigElement idpConfig = null;
        List<String> hostedEntityIds = WSFederationMetaManager.getAllHostedIdentityProviderEntities(realm);
        for (String federationId : hostedEntityIds) {
            idpConfig = WSFederationMetaManager.getIDPSSOConfig(realm, federationId);
            if (idpConfig == null) continue;
            metaAliases.add(idpConfig.getMetaAlias());
        }
        return metaAliases;
    }

    public static List<String> getAllHostedServiceProviderMetaAliases(String realm) throws WSFederationMetaException {
        ArrayList<String> metaAliases = new ArrayList<String>();
        SPSSOConfigElement spConfig = null;
        List hostedEntityIds = WSFederationMetaManager.getAllHostedServiceProviderEntities(realm);
        for (String federationId : hostedEntityIds) {
            spConfig = WSFederationMetaManager.getSPSSOConfig(realm, federationId);
            if (spConfig == null) continue;
            metaAliases.add(spConfig.getMetaAlias());
        }
        return metaAliases;
    }

    public static boolean isTrustedProvider(String realm, String federationId, String trustedEntityId) throws WSFederationMetaException {
        boolean result = false;
        SPSSOConfigElement spconfig = WSFederationMetaManager.getSPSSOConfig(realm, federationId);
        if (spconfig != null) {
            result = WSFederationMetaManager.isSameCircleOfTrust(spconfig, realm, trustedEntityId);
        }
        if (result) {
            return true;
        }
        IDPSSOConfigElement idpconfig = WSFederationMetaManager.getIDPSSOConfig(realm, federationId);
        if (idpconfig != null) {
            return WSFederationMetaManager.isSameCircleOfTrust(idpconfig, realm, trustedEntityId);
        }
        return false;
    }

    private static boolean isSameCircleOfTrust(BaseConfigType config, String realm, String trustedEntityId) {
        try {
            Map<String, List<String>> attr;
            List<String> cotList;
            if (config != null && (cotList = (attr = WSFederationMetaUtils.getAttributes(config)).get("cotlist")) != null && !cotList.isEmpty()) {
                for (String cot : cotList) {
                    if (!cotm.isInCircleOfTrust(realm, cot, "wsfed", trustedEntityId)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            debug.error("WSFederationMetaManager.isSameCircleOfTrust: Error while determining two entities are in the same COT.");
            return false;
        }
    }

    public static Set<String> getAllEntities(String realm) throws WSFederationMetaException {
        HashSet<String> ret = new HashSet<String>();
        String[] objs = new String[]{realm};
        try {
            Set entityIds = configInst.getAllConfigurationNames(realm);
            if (entityIds != null && !entityIds.isEmpty()) {
                ret.addAll(entityIds);
            }
        }
        catch (ConfigurationException e) {
            debug.error("WSFederationMetaManager.getAllEntities:", (Throwable)((Object)e));
            String[] data = new String[]{e.getMessage(), realm};
            LogUtil.error(Level.INFO, "CONFIG_ERROR_GET_ALL_ENTITIES", data, null);
            throw new WSFederationMetaException((Throwable)((Object)e));
        }
        LogUtil.access(Level.FINE, "GOT_ALL_ENTITIES", objs, null);
        return ret;
    }

    public static String getTokenIssuerEndpoint(FederationElement fed) {
        for (Object o : fed.getAny()) {
            if (!(o instanceof TokenIssuerEndpointElement)) continue;
            return ((TokenIssuerEndpointElement)o).getAddress().getValue();
        }
        return null;
    }

    public static String getTokenIssuerName(FederationElement fed) {
        for (Object o : fed.getAny()) {
            if (!(o instanceof TokenIssuerNameElement)) continue;
            return ((TokenIssuerNameElement)o).getValue();
        }
        return null;
    }

    public static byte[] getTokenSigningCertificate(FederationElement fed) {
        for (Object o : fed.getAny()) {
            if (!(o instanceof TokenSigningKeyInfoElement)) continue;
            SecurityTokenReferenceType str = ((TokenSigningKeyInfoElement)o).getSecurityTokenReference();
            for (Object o1 : str.getAny()) {
                if (!(o1 instanceof X509DataType)) continue;
                for (Object o2 : ((X509DataType)o1).getX509IssuerSerialOrX509SKIOrX509SubjectName()) {
                    if (!(o2 instanceof X509DataType.X509Certificate)) continue;
                    return ((X509DataType.X509Certificate)o2).getValue();
                }
            }
        }
        return null;
    }

    public static UriNamedClaimTypesOfferedElement getUriNamedClaimTypesOffered(FederationElement fed) {
        for (Object o : fed.getAny()) {
            if (!(o instanceof UriNamedClaimTypesOfferedElement)) continue;
            return (UriNamedClaimTypesOfferedElement)o;
        }
        return null;
    }

    static {
        try {
            configInst = ConfigurationManager.getConfigurationInstance(WSFEDERATION);
            if (configInst != null) {
                configInst.addListener(new WSFederationMetaServiceListener());
            }
        }
        catch (ConfigurationException ce) {
            debug.error("WSFederationMetaManager.static: Unable to add ConfigurationListener for WSFederationCOT service.", (Throwable)((Object)ce));
            throw new ExceptionInInitializerError((Throwable)((Object)ce));
        }
        try {
            cotm = new CircleOfTrustManager();
        }
        catch (COTException se) {
            debug.error("WSFederationMetaManager constructor:", (Throwable)((Object)se));
            throw new ExceptionInInitializerError((Throwable)((Object)se));
        }
    }
}

