/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.wsfederation.common;

import com.sun.identity.plugin.datastore.DataStoreProviderException;
import com.sun.identity.saml2.common.NameIDInfo;
import com.sun.identity.saml2.common.NameIDInfoKey;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.wsfederation.common.WSFederationException;
import com.sun.identity.wsfederation.common.WSFederationUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AccountUtils {
    private static Debug debug = WSFederationUtils.debug;
    private static final String DELIM = "|";
    private static final String NAMEID_INFO_ATTRIBUTE = "com.sun.identity.wsfederation.nameidinfo.attribute";
    private static final String NAMEID_INFO_KEY_ATTRIBUTE = "com.sun.identity.wsfederation.nameidinfokey.attribute";

    public static NameIDInfo getAccountFederation(String userID, String hostEntityID, String remoteEntityID) throws WSFederationException {
        String classMethod = "AccountUtils.getAccountFederation: ";
        if (debug.messageEnabled()) {
            debug.message(classMethod);
        }
        if (userID == null) {
            throw new WSFederationException(WSFederationUtils.bundle.getString("nullUserID"));
        }
        if (hostEntityID == null) {
            throw new WSFederationException(WSFederationUtils.bundle.getString("nullHostEntityID"));
        }
        if (remoteEntityID == null) {
            throw new WSFederationException(WSFederationUtils.bundle.getString("nullRemoteEntityID"));
        }
        try {
            Set set = WSFederationUtils.dsProvider.getAttribute(userID, AccountUtils.getNameIDInfoAttribute());
            if (set == null || set.isEmpty()) {
                if (WSFederationUtils.debug.messageEnabled()) {
                    WSFederationUtils.debug.message(classMethod + "user does not have any account federations.");
                }
                return null;
            }
            String filter = hostEntityID + DELIM + remoteEntityID + DELIM;
            if (WSFederationUtils.debug.messageEnabled()) {
                WSFederationUtils.debug.message(classMethod + " filter = " + filter + " userID = " + userID);
            }
            String info = null;
            for (String value : set) {
                if (!value.startsWith(filter)) continue;
                info = value;
                break;
            }
            if (info == null) {
                if (WSFederationUtils.debug.messageEnabled()) {
                    WSFederationUtils.debug.message(classMethod + "user does not have account federation " + " corresponding to =" + filter);
                }
                return null;
            }
            return NameIDInfo.parse(info);
        }
        catch (DataStoreProviderException dse) {
            WSFederationUtils.debug.error(classMethod + "Info: DataStoreProviderException", (Throwable)((Object)dse));
            throw new WSFederationException((Throwable)((Object)dse));
        }
        catch (SAML2Exception se) {
            WSFederationUtils.debug.error(classMethod + "Info: SAML2Exception", (Throwable)((Object)se));
            throw new WSFederationException((Throwable)((Object)se));
        }
    }

    public static void setAccountFederation(NameIDInfo info, String userID) throws WSFederationException {
        String classMethod = "AccountUtils.setAccountFederation: ";
        WSFederationUtils.debug.message(classMethod);
        if (info == null) {
            throw new WSFederationException(WSFederationUtils.bundle.getString("nullNameIDInfo"));
        }
        if (userID == null) {
            throw new WSFederationException(WSFederationUtils.bundle.getString("nullUserID"));
        }
        try {
            NameIDInfoKey infoKey = new NameIDInfoKey(info.getNameIDValue(), info.getHostEntityID(), info.getRemoteEntityID());
            if (WSFederationUtils.debug.messageEnabled()) {
                WSFederationUtils.debug.message(classMethod + "info to be set:" + info.toValueString() + "," + "infoKey to be set:" + infoKey.toValueString());
            }
            String filter = info.getHostEntityID() + DELIM + info.getRemoteEntityID() + DELIM;
            String nameIDInfoAttr = AccountUtils.getNameIDInfoAttribute();
            String nameIDInfoKeyAttr = AccountUtils.getNameIDInfoKeyAttribute();
            HashSet<String> set = new HashSet<String>();
            set.add(nameIDInfoAttr);
            set.add(nameIDInfoKeyAttr);
            HashMap map = new HashMap();
            Map existMap = WSFederationUtils.dsProvider.getAttributes(userID, set);
            if (existMap == null || existMap.isEmpty()) {
                HashSet<String> set1 = new HashSet<String>();
                set1.add(infoKey.toValueString());
                map.put(nameIDInfoKeyAttr, set1);
                HashSet<String> set2 = new HashSet<String>();
                set2.add(info.toValueString());
                map.put(nameIDInfoAttr, set2);
            } else {
                HashSet<String> set1 = (HashSet<String>)existMap.get(nameIDInfoAttr);
                if (set1 != null) {
                    Iterator iter1 = set1.iterator();
                    while (iter1.hasNext()) {
                        String value = (String)iter1.next();
                        if (!value.startsWith(filter)) continue;
                        iter1.remove();
                    }
                } else {
                    set1 = new HashSet<String>();
                }
                set1.add(info.toValueString());
                map.put(nameIDInfoAttr, set1);
                HashSet<String> set2 = (HashSet<String>)existMap.get(nameIDInfoKeyAttr);
                if (set2 != null) {
                    Iterator iter2 = set2.iterator();
                    while (iter2.hasNext()) {
                        String value = (String)iter2.next();
                        if (!value.startsWith(filter)) continue;
                        iter2.remove();
                    }
                } else {
                    set2 = new HashSet<String>();
                }
                set2.add(infoKey.toValueString());
                map.put(nameIDInfoKeyAttr, set2);
            }
            if (WSFederationUtils.debug.messageEnabled()) {
                WSFederationUtils.debug.message(classMethod + " set fedinfo " + map + " userID = " + userID);
            }
            WSFederationUtils.dsProvider.setAttributes(userID, map);
        }
        catch (DataStoreProviderException dse) {
            WSFederationUtils.debug.error(classMethod + "DataStoreProviderException", (Throwable)((Object)dse));
            throw new WSFederationException((Throwable)((Object)dse));
        }
        catch (SAML2Exception se) {
            WSFederationUtils.debug.error(classMethod + "SAML2Exception", (Throwable)((Object)se));
            throw new WSFederationException((Throwable)((Object)se));
        }
    }

    public static boolean removeAccountFederation(NameIDInfo info, String userID) throws WSFederationException {
        String classMethod = "AccountUtils.removeAccountFederation: ";
        WSFederationUtils.debug.message(classMethod);
        if (info == null) {
            throw new WSFederationException(WSFederationUtils.bundle.getString("nullNameIDInfo"));
        }
        if (userID == null) {
            throw new WSFederationException(WSFederationUtils.bundle.getString("nullUserID"));
        }
        try {
            Set existingFed = WSFederationUtils.dsProvider.getAttribute(userID, AccountUtils.getNameIDInfoAttribute());
            Set existingInfoKey = WSFederationUtils.dsProvider.getAttribute(userID, AccountUtils.getNameIDInfoKeyAttribute());
            if (existingFed == null || existingFed.isEmpty()) {
                if (WSFederationUtils.debug.messageEnabled()) {
                    WSFederationUtils.debug.message(classMethod + "user does not have account federation infos.");
                }
                return false;
            }
            String infoValue = info.toValueString();
            String infoKeyValue = info.getNameIDInfoKey().toValueString();
            if (WSFederationUtils.debug.messageEnabled()) {
                WSFederationUtils.debug.message(classMethod + "info to be removed:" + infoValue + "user=" + userID + "infoKeyValue = " + infoKeyValue);
            }
            if (existingFed.contains(infoValue)) {
                existingFed.remove(infoValue);
                if (existingInfoKey != null && existingInfoKey.contains(infoKeyValue)) {
                    existingInfoKey.remove(infoKeyValue);
                }
                HashMap<String, Set> map = new HashMap<String, Set>();
                map.put(AccountUtils.getNameIDInfoAttribute(), existingFed);
                map.put(AccountUtils.getNameIDInfoKeyAttribute(), existingInfoKey);
                WSFederationUtils.dsProvider.setAttributes(userID, map);
                return true;
            }
            if (WSFederationUtils.debug.messageEnabled()) {
                WSFederationUtils.debug.message(classMethod + "account federation info not found.");
            }
            return false;
        }
        catch (DataStoreProviderException dse) {
            WSFederationUtils.debug.error(classMethod + "DataStoreProviderException", (Throwable)((Object)dse));
            throw new WSFederationException((Throwable)((Object)dse));
        }
        catch (SAML2Exception se) {
            WSFederationUtils.debug.error(classMethod + "SAML2Exception", (Throwable)((Object)se));
            throw new WSFederationException((Throwable)((Object)se));
        }
    }

    public static String getNameIDInfoAttribute() {
        return SystemPropertiesManager.get((String)NAMEID_INFO_ATTRIBUTE, (String)"sun-fm-wsfed-nameid-info");
    }

    public static String getNameIDInfoKeyAttribute() {
        return SystemPropertiesManager.get((String)NAMEID_INFO_KEY_ATTRIBUTE, (String)"sun-fm-wsfed-nameid-infokey");
    }
}

