/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.servlet;

import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.profile.NameIDMapping;
import com.sun.identity.saml2.protocol.NameIDMappingRequest;
import com.sun.identity.saml2.protocol.NameIDMappingResponse;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;

public class NameIDMappingServiceSOAP
extends HttpServlet {
    public void init() throws ServletException {
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            SAMLUtils.checkHTTPContentLength(req);
            String idpMetaAlias = SAML2MetaUtils.getMetaAliasByUri(req.getRequestURI());
            String idpEntityID = SAML2Utils.getSAML2MetaManager().getEntityByMetaAlias(idpMetaAlias);
            String realm = SAML2MetaUtils.getRealmByMetaAlias(idpMetaAlias);
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("NameIDMappingServiceSOAP.doPost : uri = " + req.getRequestURI() + ", idpMetaAlias = " + idpMetaAlias + ", idpEntityID = " + idpEntityID);
            }
            MimeHeaders headers = SAML2Utils.getHeaders(req);
            ServletInputStream is = req.getInputStream();
            SOAPMessage msg = MessageFactory.newInstance().createMessage(headers, (InputStream)is);
            Element reqElem = SAML2Utils.getSamlpElement(msg, "NameIDMappingRequest");
            NameIDMappingRequest nimRequest = ProtocolFactory.getInstance().createNameIDMappingRequest(reqElem);
            NameIDMappingResponse nimResponse = NameIDMapping.processNameIDMappingRequest(nimRequest, realm, idpEntityID);
            SOAPMessage reply = SAML2Utils.createSOAPMessage(nimResponse.toXMLString(true, true));
            if (reply != null) {
                if (reply.saveRequired()) {
                    reply.saveChanges();
                }
                resp.setStatus(200);
                SAML2Utils.putHeaders(reply.getMimeHeaders(), resp);
                ServletOutputStream os = resp.getOutputStream();
                reply.writeTo((OutputStream)os);
                os.flush();
            }
        }
        catch (SAML2Exception ex) {
            SAML2Utils.debug.error("NameIDMappingServiceSOAP", (Throwable)((Object)ex));
            resp.sendError(500, ex.getMessage());
        }
        catch (SOAPException soap) {
            SAML2Utils.debug.error("NameIDMappingServiceSOAP", (Throwable)soap);
            resp.sendError(500, soap.getMessage());
        }
    }
}

