/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.Subject;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.SubjectQueryAbstract;
import com.sun.identity.saml2.protocol.impl.RequestAbstractImpl;
import java.util.ListIterator;
import java.util.Set;
import org.w3c.dom.Element;

public abstract class SubjectQueryAbstractImpl
extends RequestAbstractImpl
implements SubjectQueryAbstract {
    protected Subject subject;

    public Subject getSubject() {
        return this.subject;
    }

    public void setSubject(Subject subject) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.subject = subject;
    }

    protected void getXMLString(Set namespaces, StringBuffer attrs, StringBuffer childElements, boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        this.validateData();
        super.getXMLString(namespaces, attrs, childElements, includeNSPrefix, declareNS);
        childElements.append(this.subject.toXMLString(includeNSPrefix, declareNS)).append("\n");
    }

    protected void validateData() throws SAML2Exception {
        if (this.subject == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("SubjectQueryAbstractImpl.getXMLString: Subject is expected");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("schemaViolation"));
        }
    }

    protected void parseDOMAttributes(Element element) throws SAML2Exception {
        super.parseDOMAttributes(element);
    }

    protected void parseDOMChileElements(ListIterator iter) throws SAML2Exception {
        Element childElement;
        String localName;
        super.parseDOMChileElements(iter);
        if (iter.hasNext() && "Subject".equals(localName = (childElement = (Element)iter.next()).getLocalName())) {
            this.subject = AssertionFactory.getInstance().createSubject(childElement);
            return;
        }
        if (SAML2SDKUtils.debug.messageEnabled()) {
            SAML2SDKUtils.debug.message("SubjectQueryAbstractImpl.parseDOMChileElements: Subject is expected");
        }
        throw new SAML2Exception(SAML2SDKUtils.bundle.getString("schemaViolation"));
    }
}

