/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.Status;
import com.sun.identity.saml2.protocol.StatusCode;
import com.sun.identity.saml2.protocol.StatusDetail;
import com.sun.identity.saml2.protocol.StatusMessage;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StatusImpl
implements Status {
    private boolean isMutable = false;
    private StatusCode statusCode = null;
    private String statusMessage = null;
    private StatusDetail statusDetail = null;

    public StatusImpl() {
        this.isMutable = true;
    }

    public StatusImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
    }

    public StatusImpl(String xmlString) throws SAML2Exception {
        Document xmlDocument = XMLUtils.toDOMDocument((String)xmlString, (Debug)SAML2SDKUtils.debug);
        if (xmlDocument == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(xmlDocument.getDocumentElement());
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.statusCode = value;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public void setStatusMessage(String value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.statusMessage = value;
    }

    public StatusDetail getStatusDetail() {
        return this.statusDetail;
    }

    public void setStatusDetail(StatusDetail value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.statusDetail = value;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        String xmlStr = null;
        if (this.statusCode != null) {
            StringBuffer xmlString = new StringBuffer(500);
            xmlString.append("<");
            if (includeNSPrefix) {
                xmlString.append("samlp:");
            }
            xmlString.append("Status");
            if (declareNS) {
                xmlString.append(" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"");
            }
            xmlString.append(">");
            xmlString.append("\n").append(this.statusCode.toXMLString(includeNSPrefix, declareNS));
            if (this.statusMessage != null && this.statusMessage.length() != 0) {
                ProtocolFactory protoFactory = ProtocolFactory.getInstance();
                StatusMessage sMessage = protoFactory.createStatusMessage(this.statusMessage);
                xmlString.append("\n").append(sMessage.toXMLString(includeNSPrefix, declareNS));
            }
            if (this.statusDetail != null) {
                xmlString.append("\n").append(this.statusDetail.toXMLString(includeNSPrefix, declareNS));
            }
            xmlString.append("\n").append("</samlp:").append("Status").append(">");
            xmlStr = xmlString.toString();
        }
        return xmlStr;
    }

    public void makeImmutable() {
        if (this.isMutable) {
            if (this.statusCode != null && this.statusCode.isMutable()) {
                this.statusCode.makeImmutable();
            }
            this.isMutable = false;
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    private void parseElement(Element element) throws SAML2Exception {
        ProtocolFactory protoFactory = ProtocolFactory.getInstance();
        NodeList nList = element.getChildNodes();
        if (nList != null && nList.getLength() > 0) {
            for (int i = 0; i < nList.getLength(); ++i) {
                Node childNode = nList.item(i);
                String cName = childNode.getLocalName();
                if (cName == null) continue;
                if (cName.equals("StatusCode")) {
                    this.statusCode = protoFactory.createStatusCode((Element)childNode);
                    this.validateStatusCode(this.statusCode);
                    continue;
                }
                if (cName.equals("StatusMessage")) {
                    this.statusMessage = XMLUtils.getElementString((Element)((Element)childNode));
                    continue;
                }
                if (!cName.equals("StatusDetail")) continue;
                this.statusDetail = protoFactory.createStatusDetail((Element)childNode);
            }
        }
    }

    protected void validateStatusCode(StatusCode statusCode) throws SAML2Exception {
        if (statusCode == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingStatusCode"));
        }
    }
}

