/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.EncryptedID;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.NameIDMappingResponse;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.impl.StatusResponseImpl;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NameIDMappingResponseImpl
extends StatusResponseImpl
implements NameIDMappingResponse {
    public final String elementName = "NameIDMappingResponse";
    NameID nameID = null;
    EncryptedID encryptedID = null;

    public NameIDMappingResponseImpl() {
        this.isMutable = true;
    }

    public NameIDMappingResponseImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
        if (this.isSigned) {
            this.signedXMLString = XMLUtils.print((Node)element);
        }
        this.makeImmutable();
    }

    public NameIDMappingResponseImpl(String xmlString) throws SAML2Exception {
        Document doc = XMLUtils.toDOMDocument((String)xmlString, (Debug)SAMLUtils.debug);
        if (doc == null) {
            throw new SAML2Exception("errorObtainingElement");
        }
        this.parseElement(doc.getDocumentElement());
        if (this.isSigned) {
            this.signedXMLString = xmlString;
        }
        this.makeImmutable();
    }

    private void parseElement(Element element) throws SAML2Exception {
        AssertionFactory af = AssertionFactory.getInstance();
        ProtocolFactory pf = ProtocolFactory.getInstance();
        if (element == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("NameIDMappingResponseImpl.parseElement: Input is null.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        String tag = null;
        tag = element.getLocalName();
        if (tag == null || !tag.equals("NameIDMappingResponse")) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("NameIDMappingResponseImpl.parseElement: not ManageNameIDResponse.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        this.responseId = element.getAttribute("ID");
        this.validateID(this.responseId);
        this.version = element.getAttribute("Version");
        this.validateVersion(this.version);
        String issueInstantStr = element.getAttribute("IssueInstant");
        this.validateIssueInstant(issueInstantStr);
        this.destination = element.getAttribute("Destination");
        this.consent = element.getAttribute("Consent");
        this.inResponseTo = element.getAttribute("InResponseTo");
        NodeList nList = element.getChildNodes();
        if (nList != null && nList.getLength() > 0) {
            for (int i = 0; i < nList.getLength(); ++i) {
                Node childNode = nList.item(i);
                String cName = childNode.getLocalName();
                if (cName == null) continue;
                if (cName.equals("Issuer")) {
                    this.issuer = af.createIssuer((Element)childNode);
                    continue;
                }
                if (cName.equals("Signature")) {
                    this.signatureString = XMLUtils.getElementString((Element)((Element)childNode));
                    this.isSigned = true;
                    continue;
                }
                if (cName.equals("Extensions")) {
                    this.extensions = pf.createExtensions((Element)childNode);
                    continue;
                }
                if (cName.equals("NameID")) {
                    this.nameID = af.createNameID((Element)childNode);
                    continue;
                }
                if (cName.equals("EncryptedID")) {
                    this.encryptedID = af.createEncryptedID((Element)childNode);
                    continue;
                }
                if (!cName.equals("Status")) continue;
                this.status = pf.createStatus((Element)childNode);
            }
        }
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        if (this.isSigned && this.signedXMLString != null) {
            return this.signedXMLString;
        }
        this.validateData();
        StringBuffer result = new StringBuffer();
        String NS = "";
        String NSP = "";
        String uri = "";
        if (declareNS) {
            uri = NS = " xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"";
        }
        if (includeNSPrefix) {
            NSP = "samlp:";
        }
        result.append("<").append(NSP).append("NameIDMappingResponse").append(uri).append(" ID=\"").append(this.responseId).append("\"");
        if (this.inResponseTo != null && this.inResponseTo.trim().length() != 0) {
            result.append(" InResponseTo=\"").append(this.inResponseTo).append("\"");
        }
        result.append(" Version=\"").append(this.version).append("\"").append(" IssueInstant=\"").append(DateUtils.toUTCDateFormat((Date)this.issueInstant)).append("\"");
        if (this.destination != null && this.destination.trim().length() != 0) {
            result.append(" Destination=\"").append(this.destination).append("\"");
        }
        if (this.consent != null && this.consent.trim().length() != 0) {
            result.append(" Consent=\"").append(this.consent).append("\"");
        }
        result.append(">");
        if (this.issuer != null) {
            result.append(this.issuer.toXMLString(includeNSPrefix, declareNS));
        }
        if (this.signatureString != null) {
            result.append(this.signatureString);
        }
        if (this.extensions != null) {
            result.append(this.extensions.toXMLString(includeNSPrefix, declareNS));
        }
        if (this.nameID != null) {
            result.append(this.nameID.toXMLString(includeNSPrefix, declareNS));
        }
        if (this.encryptedID != null) {
            result.append(this.encryptedID.toXMLString(includeNSPrefix, declareNS));
        }
        result.append(this.status.toXMLString(includeNSPrefix, declareNS));
        result.append("</").append(NSP).append("NameIDMappingResponse").append(">");
        return result.toString();
    }

    public EncryptedID getEncryptedID() {
        return this.encryptedID;
    }

    public void setEncryptedID(EncryptedID value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.encryptedID = value;
    }

    public NameID getNameID() {
        return this.nameID;
    }

    public void setNameID(NameID value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.nameID = value;
    }

    protected void validateData() throws SAML2Exception {
        if (this.nameID != null && this.encryptedID != null || this.nameID == null && this.encryptedID == null) {
            throw new SAML2Exception("nameIDMRespWrongID");
        }
    }
}

