/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.EncryptedID;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.ManageNameIDRequest;
import com.sun.identity.saml2.protocol.NewEncryptedID;
import com.sun.identity.saml2.protocol.NewID;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.impl.RequestAbstractImpl;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManageNameIDRequestImpl
extends RequestAbstractImpl
implements ManageNameIDRequest {
    public final String elementName = "ManageNameIDRequest";
    private NewEncryptedID newEncryptedID = null;
    private EncryptedID encryptedID = null;
    private NewID newID = null;
    private NameID nameid = null;
    private boolean terminate = false;

    public ManageNameIDRequestImpl() {
        this.isMutable = true;
    }

    public ManageNameIDRequestImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
        if (this.isSigned) {
            this.signedXMLString = XMLUtils.print((Node)element);
        }
        this.makeImmutable();
    }

    public ManageNameIDRequestImpl(String xmlString) throws SAML2Exception {
        Document doc = XMLUtils.toDOMDocument((String)xmlString, (Debug)SAML2SDKUtils.debug);
        if (doc == null) {
            throw new SAML2Exception("errorObtainingElement");
        }
        this.parseElement(doc.getDocumentElement());
        if (this.isSigned) {
            this.signedXMLString = xmlString;
        }
        this.makeImmutable();
    }

    private void parseElement(Element element) throws SAML2Exception {
        AssertionFactory assertionFactory = AssertionFactory.getInstance();
        ProtocolFactory protocolFactory = ProtocolFactory.getInstance();
        if (element == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ManageNameIDRequestImpl.parseElement: Input is null.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        String tag = null;
        tag = element.getLocalName();
        if (tag == null || !tag.equals("ManageNameIDRequest")) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ManageNameIDRequestImpl.parseElement:not ManageNameIDRequest.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        this.requestId = element.getAttribute("ID");
        this.validateID(this.requestId);
        this.version = element.getAttribute("Version");
        this.validateVersion(this.version);
        String issueInstantStr = element.getAttribute("IssueInstant");
        this.validateIssueInstant(issueInstantStr);
        this.destinationURI = element.getAttribute("Destination");
        this.consent = element.getAttribute("Consent");
        NodeList nList = element.getChildNodes();
        if (nList != null && nList.getLength() > 0) {
            for (int i = 0; i < nList.getLength(); ++i) {
                Node childNode = nList.item(i);
                String cName = childNode.getLocalName();
                if (cName == null) continue;
                if (cName.equals("Issuer")) {
                    this.nameID = assertionFactory.createIssuer((Element)childNode);
                    continue;
                }
                if (cName.equals("Signature")) {
                    this.signatureString = XMLUtils.getElementString((Element)((Element)childNode));
                    this.isSigned = true;
                    continue;
                }
                if (cName.equals("Extensions")) {
                    this.extensions = protocolFactory.createExtensions((Element)childNode);
                    continue;
                }
                if (cName.equals("NameID")) {
                    this.nameid = assertionFactory.createNameID((Element)childNode);
                    continue;
                }
                if (cName.equals("EncryptedID")) {
                    this.encryptedID = assertionFactory.createEncryptedID((Element)childNode);
                    continue;
                }
                if (cName.equals("NewID")) {
                    this.newID = protocolFactory.createNewID((Element)childNode);
                    continue;
                }
                if (cName.equals("NewEncryptedID")) {
                    this.newEncryptedID = protocolFactory.createNewEncryptedID((Element)childNode);
                    continue;
                }
                if (!cName.equals("Terminate")) continue;
                this.terminate = true;
            }
        }
    }

    public NewEncryptedID getNewEncryptedID() {
        return this.newEncryptedID;
    }

    public void setNewEncryptedID(NewEncryptedID value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.newEncryptedID = value;
    }

    public EncryptedID getEncryptedID() {
        return this.encryptedID;
    }

    public void setEncryptedID(EncryptedID value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.encryptedID = value;
    }

    public NewID getNewID() {
        return this.newID;
    }

    public void setNewID(NewID value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.newID = value;
    }

    public NameID getNameID() {
        return this.nameid;
    }

    public void setNameID(NameID value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.nameid = value;
    }

    public boolean getTerminate() {
        return this.terminate;
    }

    public void setTerminate(boolean value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.terminate = value;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        if (this.isSigned && this.signedXMLString != null) {
            return this.signedXMLString;
        }
        StringBuffer xml = new StringBuffer();
        if (this.newID != null && this.newEncryptedID != null) {
            throw new SAML2Exception("wrongInput");
        }
        if ((this.newID != null || this.newEncryptedID != null) && this.terminate) {
            throw new SAML2Exception("wrongInput");
        }
        String NS = "";
        String NSP = "";
        if (declareNS) {
            NS = " xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"";
        }
        if (includeNSPrefix) {
            NSP = "samlp:";
        }
        xml.append("<").append(NSP).append("ManageNameIDRequest");
        xml.append(NS).append(" ");
        xml.append(this.getAttributesString());
        xml.append(">");
        xml.append(this.getElements(includeNSPrefix, declareNS));
        if (this.nameid != null) {
            xml.append(this.nameid.toXMLString(includeNSPrefix, declareNS));
        }
        if (this.encryptedID != null) {
            xml.append(this.encryptedID.toXMLString());
        }
        if (this.newID != null) {
            xml.append(this.newID.toXMLString(includeNSPrefix, declareNS));
        }
        if (this.newEncryptedID != null) {
            xml.append(this.newEncryptedID.toXMLString());
        }
        if (this.terminate) {
            xml.append("<").append(NSP).append("Terminate/>");
        }
        xml.append("</").append(NSP).append("ManageNameIDRequest").append(">");
        return xml.toString();
    }

    public void makeImmutable() {
        if (this.isMutable) {
            super.makeImmutable();
            if (this.nameid != null && this.nameid.isMutable()) {
                this.nameid.makeImmutable();
            }
            this.isMutable = false;
        }
    }
}

