/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.protocol.impl;

import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.protocol.AuthnQuery;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.RequestedAuthnContext;
import com.sun.identity.saml2.protocol.impl.SubjectQueryAbstractImpl;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ListIterator;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AuthnQueryImpl
extends SubjectQueryAbstractImpl
implements AuthnQuery {
    protected RequestedAuthnContext requestedAuthnContext;
    protected String sessionIndex;

    public AuthnQueryImpl() {
        this.elementName = "AuthnQuery";
        this.isMutable = true;
    }

    public AuthnQueryImpl(Element element) throws SAML2Exception {
        this.parseDOMElement(element);
        this.elementName = "AuthnQuery";
        if (this.isSigned) {
            this.signedXMLString = XMLUtils.print((Node)element);
        }
    }

    public AuthnQueryImpl(String xmlString) throws SAML2Exception {
        Document xmlDocument = XMLUtils.toDOMDocument((String)xmlString, (Debug)SAML2SDKUtils.debug);
        if (xmlDocument == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseDOMElement(xmlDocument.getDocumentElement());
        this.elementName = "AuthnQuery";
        if (this.isSigned) {
            this.signedXMLString = xmlString;
        }
    }

    public RequestedAuthnContext getRequestedAuthnContext() {
        return this.requestedAuthnContext;
    }

    public void setRequestedAuthnContext(RequestedAuthnContext requestedAuthnContext) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.requestedAuthnContext = requestedAuthnContext;
    }

    public String getSessionIndex() {
        return this.sessionIndex;
    }

    public void setSessionIndex(String sessionIndex) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.sessionIndex = sessionIndex;
    }

    protected void getXMLString(Set namespaces, StringBuffer attrs, StringBuffer childElements, boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        if (declareNS) {
            namespaces.add(" xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\"".trim());
            namespaces.add(" xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"".trim());
        }
        super.getXMLString(namespaces, attrs, childElements, includeNSPrefix, declareNS);
        if (this.sessionIndex != null && this.sessionIndex.length() > 0) {
            attrs.append(" ").append("SessionIndex").append("=").append("\"").append(this.sessionIndex).append("\"");
        }
        if (this.requestedAuthnContext != null) {
            childElements.append(this.requestedAuthnContext.toXMLString(includeNSPrefix, declareNS)).append("\n");
        }
    }

    protected void parseDOMAttributes(Element element) throws SAML2Exception {
        super.parseDOMAttributes(element);
        this.sessionIndex = element.getAttribute("SessionIndex");
    }

    protected void parseDOMChileElements(ListIterator iter) throws SAML2Exception {
        super.parseDOMChileElements(iter);
        ProtocolFactory pFactory = ProtocolFactory.getInstance();
        if (iter.hasNext()) {
            Element childElement = (Element)iter.next();
            String localName = childElement.getLocalName();
            if ("RequestedAuthnContext".equals(localName)) {
                this.requestedAuthnContext = pFactory.createRequestedAuthnContext(childElement);
            } else {
                iter.previous();
            }
        }
    }
}

