/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.profile;

import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.EncryptedID;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.common.AccountUtils;
import com.sun.identity.saml2.common.NameIDInfo;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.saml2.jaxb.metadata.IDPSSODescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.NameIDMappingServiceElement;
import com.sun.identity.saml2.jaxb.metadata.SPSSODescriptorElement;
import com.sun.identity.saml2.key.EncInfo;
import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.plugins.IDPAccountMapper;
import com.sun.identity.saml2.protocol.NameIDMappingRequest;
import com.sun.identity.saml2.protocol.NameIDMappingResponse;
import com.sun.identity.saml2.protocol.NameIDPolicy;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.Status;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;

public class NameIDMapping {
    static ProtocolFactory pf = ProtocolFactory.getInstance();
    static AssertionFactory af = AssertionFactory.getInstance();
    static SAML2MetaManager metaManager = null;
    static KeyProvider keyProvider = KeyUtil.getKeyProviderInstance();
    static SessionProvider sessionProvider = null;

    public static NameIDMappingResponse initiateNameIDMappingRequest(Object session, String realm, String spEntityID, String idpEntityID, String targetSPEntityID, String targetNameIDFormat, Map paramsMap) throws SAML2Exception {
        String userID;
        block14: {
            if (spEntityID == null) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("nullSPEntityID"));
            }
            if (idpEntityID == null) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("nullIDPEntityID"));
            }
            userID = null;
            try {
                userID = sessionProvider.getPrincipalName(session);
            }
            catch (SessionException e) {
                if (!SAML2Utils.debug.messageEnabled()) break block14;
                SAML2Utils.debug.message("NameIDMapping.createNameIDMappingRequest: ", (Throwable)((Object)e));
            }
        }
        if (userID == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSSOToken"));
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("NameIDMapping.initiateNameMappingRequest: IDP EntityID is : " + idpEntityID);
            SAML2Utils.debug.message("NameIDMapping.initiateNameMappingRequest: SP HOST EntityID is : " + spEntityID);
            SAML2Utils.debug.message("NameIDMapping.initiateNameMappingRequest: target SP EntityID is : " + targetSPEntityID);
        }
        try {
            NameIDMappingServiceElement nameIDMappingService;
            String binding = SAML2Utils.getParameter(paramsMap, "binding");
            if (binding == null) {
                binding = "urn:oasis:names:tc:SAML:2.0:bindings:SOAP";
            } else if (!binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("nimServiceBindingUnsupport"));
            }
            String nimURL = SAML2Utils.getParameter(paramsMap, "nimURL");
            if (nimURL == null && (nameIDMappingService = NameIDMapping.getNameIDMappingService(realm, idpEntityID, binding)) != null) {
                nimURL = nameIDMappingService.getLocation();
            }
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("NameIDMapping.initiateNameMappingRequest: nimURL" + nimURL);
            }
            if (nimURL == null) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("nimServiceNotFound"));
            }
            NameIDMappingRequest nimRequest = NameIDMapping.createNameIDMappingRequest(userID, realm, spEntityID, idpEntityID, nimURL, targetSPEntityID, targetNameIDFormat);
            NameIDMapping.signNIMRequest(nimRequest, realm, spEntityID, false);
            IDPSSOConfigElement config = metaManager.getIDPSSOConfig(realm, idpEntityID);
            nimURL = SAML2SDKUtils.fillInBasicAuthInfo(config, nimURL);
            return NameIDMapping.doNIMBySOAP(nimRequest.toXMLString(true, true), nimURL, realm, spEntityID);
        }
        catch (SAML2MetaException sme) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
    }

    public static NameIDMappingResponse processNameIDMappingRequest(NameIDMappingRequest nimRequest, String realm, String idpEntityID) throws SAML2Exception {
        NameIDMappingResponse nimResponse = null;
        String spEntityID = nimRequest.getIssuer().getValue();
        if (spEntityID == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullSPEntityID"));
        }
        String responseID = SAML2Utils.generateID();
        if (responseID == null) {
            SAML2Utils.debug.error(SAML2Utils.bundle.getString("failedToGenResponseID"));
        }
        nimResponse = pf.createNameIDMappingResponse();
        nimResponse.setID(responseID);
        nimResponse.setInResponseTo(nimRequest.getID());
        nimResponse.setVersion("2.0");
        nimResponse.setIssueInstant(new Date());
        nimResponse.setIssuer(SAML2Utils.createIssuer(idpEntityID));
        SAML2Utils.verifyRequestIssuer(realm, idpEntityID, nimRequest.getIssuer(), nimRequest.getID());
        NameIDPolicy nameIDPolicy = nimRequest.getNameIDPolicy();
        String targetSPEntityID = nameIDPolicy.getSPNameQualifier();
        String format = nameIDPolicy.getFormat();
        Status status = null;
        if (format != null && format.length() != 0 && !format.equals("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent") && !format.equals("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified")) {
            nimResponse.setNameID(nimRequest.getNameID());
            nimResponse.setEncryptedID(nimRequest.getEncryptedID());
            status = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:InvalidNameIDPolicy", SAML2Utils.bundle.getString("targetNameIDFormatUnsupported"));
        } else if (targetSPEntityID == null || targetSPEntityID.length() == 0 || targetSPEntityID.equals(spEntityID)) {
            nimResponse.setNameID(nimRequest.getNameID());
            nimResponse.setEncryptedID(nimRequest.getEncryptedID());
            status = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:InvalidNameIDPolicy", SAML2Utils.bundle.getString("targetNameIDNoChange"));
        } else {
            IDPAccountMapper idpAcctMapper = SAML2Utils.getIDPAccountMapper(realm, idpEntityID);
            NameID nameID = NameIDMapping.getNameID(nimRequest, realm, idpEntityID);
            String userID = idpAcctMapper.getIdentity(nameID, idpEntityID, spEntityID, realm);
            NameIDInfo targetNameIDInfo = null;
            if (userID != null) {
                targetNameIDInfo = AccountUtils.getAccountFederation(userID, idpEntityID, targetSPEntityID);
            }
            if (targetNameIDInfo == null) {
                nimResponse.setNameID(nimRequest.getNameID());
                nimResponse.setEncryptedID(nimRequest.getEncryptedID());
                status = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:InvalidNameIDPolicy", SAML2Utils.bundle.getString("targetNameIDNotFound"));
            } else {
                NameID targetSPNameID = targetNameIDInfo.getNameID();
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("NameIDMapping.processNameIDMappingRequest: User ID = " + userID + ", name ID = " + targetSPNameID.toXMLString(true, true));
                }
                nimResponse.setEncryptedID(NameIDMapping.getEncryptedID(targetSPNameID, realm, spEntityID, "SPRole"));
                status = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Success", null);
            }
        }
        nimResponse.setStatus(status);
        NameIDMapping.signNIMResponse(nimResponse, realm, idpEntityID, false);
        return nimResponse;
    }

    private static NameIDMappingRequest createNameIDMappingRequest(String userID, String realm, String spEntityID, String idpEntityID, String destination, String targetSPEntityID, String targetNameIDFormat) throws SAML2Exception {
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("NameIDMapping.createNameIDMappingRequest: User ID : " + userID);
        }
        NameIDMappingRequest nimRequest = pf.createNameIDMappingRequest();
        nimRequest.setID(SAML2Utils.generateID());
        nimRequest.setVersion("2.0");
        nimRequest.setDestination(destination);
        nimRequest.setIssuer(SAML2Utils.createIssuer(spEntityID));
        nimRequest.setIssueInstant(new Date());
        NameIDMapping.setNameIDForNIMRequest(nimRequest, realm, spEntityID, idpEntityID, targetSPEntityID, targetNameIDFormat, userID);
        return nimRequest;
    }

    private static NameIDMappingResponse doNIMBySOAP(String nimRequestXMLString, String nimURL, String realm, String spEntityID) throws SAML2Exception {
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("NameIDMapping.doNIMBySOAP: NIMRequestXMLString : " + nimRequestXMLString);
            SAML2Utils.debug.message("NameIDMapping.doNIMBySOAP: NIMRedirectURL : " + nimURL);
        }
        SOAPMessage resMsg = null;
        try {
            resMsg = SAML2Utils.sendSOAPMessage(nimRequestXMLString, nimURL);
        }
        catch (SOAPException se) {
            SAML2Utils.debug.error("NameIDMapping.doNIMBySOAP: ", (Throwable)se);
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSOAPMessge"));
        }
        Element nimRespElem = SAML2Utils.getSamlpElement(resMsg, "NameIDMappingResponse");
        NameIDMappingResponse nimResponse = pf.createNameIDMappingResponse(nimRespElem);
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("NameIDMapping.doNIMBySOAP: NameIDMappingResponse without SOAP envelope:\n" + nimResponse.toXMLString(true, true));
        }
        String idpEntityID = nimResponse.getIssuer().getValue();
        Issuer resIssuer = nimResponse.getIssuer();
        String requestId = nimResponse.getInResponseTo();
        SAML2Utils.verifyResponseIssuer(realm, spEntityID, resIssuer, requestId);
        if (!NameIDMapping.verifyNIMResponse(nimResponse, realm, idpEntityID)) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignInResponse"));
        }
        return nimResponse;
    }

    private static void setNameIDForNIMRequest(NameIDMappingRequest nimRequest, String realm, String spEntityID, String idpEntityID, String targetSPEntityID, String targetNameIDFormat, String userID) throws SAML2Exception {
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("NameIDMapping.setNameIDForNIMRequest: user ID = " + userID);
        }
        NameID nameID = AssertionFactory.getInstance().createNameID();
        NameIDInfo info = AccountUtils.getAccountFederation(userID, spEntityID, idpEntityID);
        nameID.setValue(info.getNameIDValue());
        nameID.setFormat(info.getFormat());
        nameID.setNameQualifier(idpEntityID);
        nameID.setSPNameQualifier(spEntityID);
        NameIDPolicy nameIDPolicy = ProtocolFactory.getInstance().createNameIDPolicy();
        nameIDPolicy.setSPNameQualifier(targetSPEntityID);
        nameIDPolicy.setFormat(targetNameIDFormat);
        nimRequest.setNameIDPolicy(nameIDPolicy);
        boolean needEncryptIt = SAML2Utils.getWantNameIDEncrypted(realm, idpEntityID, "IDPRole");
        if (!needEncryptIt) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("NameIDMapping.setNameIDForNIMRequest: NamID doesn't need to be encrypted.");
            }
            nimRequest.setNameID(nameID);
            return;
        }
        EncryptedID encryptedID = NameIDMapping.getEncryptedID(nameID, realm, idpEntityID, "IDPRole");
        nimRequest.setEncryptedID(encryptedID);
    }

    public static NameIDMappingServiceElement getNameIDMappingService(String realm, String entityId, String binding) throws SAML2MetaException {
        IDPSSODescriptorElement idpSSODesc = metaManager.getIDPSSODescriptor(realm, entityId);
        if (idpSSODesc == null) {
            SAML2Utils.debug.error(SAML2Utils.bundle.getString("noIDPEntry"));
            return null;
        }
        List list = idpSSODesc.getNameIDMappingService();
        NameIDMappingServiceElement nimService = null;
        if (list != null && !list.isEmpty()) {
            if (binding == null) {
                return (NameIDMappingServiceElement)list.get(0);
            }
            Iterator it = list.iterator();
            while (it.hasNext()) {
                nimService = (NameIDMappingServiceElement)it.next();
                if (!binding.equalsIgnoreCase(nimService.getBinding())) continue;
                return nimService;
            }
        }
        return null;
    }

    static EncryptedID getEncryptedID(NameID nameID, String realm, String entityID, String role) throws SAML2Exception {
        javax.xml.bind.Element roled = null;
        roled = role.equals("SPRole") ? metaManager.getSPSSODescriptor(realm, entityID) : metaManager.getIDPSSODescriptor(realm, entityID);
        EncInfo encInfo = KeyUtil.getEncInfo(roled, entityID, role);
        if (encInfo == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("UnableToFindEncryptKeyInfo"));
        }
        EncryptedID encryptedID = nameID.encrypt(encInfo.getWrappingKey(), encInfo.getDataEncAlgorithm(), encInfo.getDataEncStrength(), entityID);
        return encryptedID;
    }

    private static void signNIMRequest(NameIDMappingRequest nimRequest, String realm, String spEntityID, boolean includeCert) throws SAML2Exception {
        String alias = SAML2Utils.getSigningCertAlias(realm, spEntityID, "SPRole");
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("NameIDMapping.signNIMRequest: Cert Alias is : " + alias);
            SAML2Utils.debug.message("NameIDMapping.signNIMRequest: NIMRequest before sign : " + nimRequest.toXMLString(true, true));
        }
        PrivateKey signingKey = keyProvider.getPrivateKey(alias);
        X509Certificate signingCert = null;
        if (includeCert) {
            signingCert = keyProvider.getX509Certificate(alias);
        }
        if (signingKey == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
        }
        nimRequest.sign(signingKey, signingCert);
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("NameIDMapping.signNIMRequest: NIMRequest after sign : " + nimRequest.toXMLString(true, true));
        }
    }

    private static boolean verifyNIMRequest(NameIDMappingRequest nimRequest, String realm, String spEntityID) throws SAML2Exception {
        SPSSODescriptorElement spSSODesc = metaManager.getSPSSODescriptor(realm, spEntityID);
        X509Certificate signingCert = KeyUtil.getVerificationCert(spSSODesc, spEntityID, "SPRole");
        if (signingCert != null) {
            boolean valid = nimRequest.isSignatureValid(signingCert);
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("NameIDMapping:verifyNIMRequest: Signature is : " + valid);
            }
            return valid;
        }
        throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
    }

    static void signNIMResponse(NameIDMappingResponse nimResponse, String realm, String idpEntityID, boolean includeCert) throws SAML2Exception {
        String alias = SAML2Utils.getSigningCertAlias(realm, idpEntityID, "IDPRole");
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("NameIDMapping.signNIMResponse: " + realm);
            SAML2Utils.debug.message("NameIDMapping.signNIMResponse: " + idpEntityID);
            SAML2Utils.debug.message("NameIDMapping.signNIMResponse: " + alias);
        }
        PrivateKey signingKey = keyProvider.getPrivateKey(alias);
        X509Certificate signingCert = null;
        if (includeCert) {
            signingCert = keyProvider.getX509Certificate(alias);
        }
        if (signingKey == null) {
            SAML2Utils.debug.error("NameIDMapping.signNIMResponse: Incorrect configuration for Signing Certificate.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        nimResponse.sign(signingKey, signingCert);
    }

    private static boolean verifyNIMResponse(NameIDMappingResponse nimResponse, String realm, String idpEntityID) throws SAML2Exception {
        IDPSSODescriptorElement idpSSODesc = metaManager.getIDPSSODescriptor(realm, idpEntityID);
        X509Certificate signingCert = KeyUtil.getVerificationCert(idpSSODesc, idpEntityID, "IDPRole");
        if (signingCert != null) {
            boolean valid = nimResponse.isSignatureValid(signingCert);
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("NameIDMapping.verifyNIMResponse: Signature is : " + valid);
            }
            return valid;
        }
        throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
    }

    private static NameID getNameID(NameIDMappingRequest nimRequest, String realm, String idpEntityID) {
        NameID nameID = nimRequest.getNameID();
        if (nameID == null) {
            String alias = SAML2Utils.getSigningCertAlias(realm, idpEntityID, "IDPRole");
            PrivateKey signingKey = keyProvider.getPrivateKey(alias);
            EncryptedID encryptedID = nimRequest.getEncryptedID();
            try {
                nameID = encryptedID.decrypt(signingKey);
            }
            catch (SAML2Exception ex) {
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("NameIDMapping.getNameID:", (Throwable)((Object)ex));
                }
                return null;
            }
        }
        if (!SAML2Utils.isPersistentNameID(nameID)) {
            return null;
        }
        return nameID;
    }

    static {
        try {
            metaManager = new SAML2MetaManager();
            sessionProvider = SessionManager.getProvider();
        }
        catch (SAML2MetaException se) {
            SAML2Utils.debug.error(SAML2Utils.bundle.getString("errorMetaManager"), (Throwable)((Object)se));
        }
        catch (SessionException sessE) {
            SAML2Utils.debug.error("Error retrieving session provider.", (Throwable)((Object)sessE));
        }
    }
}

