/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.profile;

import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.EncryptedID;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.common.AccountUtils;
import com.sun.identity.saml2.common.NameIDInfo;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.saml2.jaxb.metadata.AffiliationDescriptorType;
import com.sun.identity.saml2.jaxb.metadata.IDPSSODescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.ManageNameIDServiceElement;
import com.sun.identity.saml2.jaxb.metadata.SPSSODescriptorElement;
import com.sun.identity.saml2.key.EncInfo;
import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.saml2.logging.LogUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.plugins.IDPAccountMapper;
import com.sun.identity.saml2.plugins.SAML2ServiceProviderAdapter;
import com.sun.identity.saml2.plugins.SPAccountMapper;
import com.sun.identity.saml2.profile.IDPCache;
import com.sun.identity.saml2.profile.IDPSession;
import com.sun.identity.saml2.profile.ManageNameIDRequestInfo;
import com.sun.identity.saml2.profile.NameIDandSPpair;
import com.sun.identity.saml2.profile.SPCache;
import com.sun.identity.saml2.profile.SPFedSession;
import com.sun.identity.saml2.protocol.ManageNameIDRequest;
import com.sun.identity.saml2.protocol.ManageNameIDResponse;
import com.sun.identity.saml2.protocol.NewEncryptedID;
import com.sun.identity.saml2.protocol.NewID;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.RequestAbstract;
import com.sun.identity.saml2.protocol.Status;
import com.sun.identity.saml2.protocol.StatusResponse;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DoManageNameID {
    static final String className = "DoManageNameID:";
    static ProtocolFactory pf = ProtocolFactory.getInstance();
    static AssertionFactory af = AssertionFactory.getInstance();
    static SOAPConnectionFactory scf = null;
    static MessageFactory mf = null;
    static SAML2MetaManager metaManager = null;
    static KeyProvider keyProvider = KeyUtil.getKeyProviderInstance();
    static Debug debug = SAML2Utils.debug;
    static SessionProvider sessionProvider = null;

    private static void logError(String msgID, String key, String value) {
        debug.error(SAML2Utils.bundle.getString(msgID));
        String[] data = new String[]{value};
        LogUtil.error(Level.INFO, key, data, null);
    }

    private static void logAccess(String msgID, String key, String value) {
        debug.message(SAML2Utils.bundle.getString(msgID));
        String[] data = new String[]{value};
        LogUtil.access(Level.INFO, key, data, null);
    }

    public static void initiateManageNameIDRequest(HttpServletRequest request, HttpServletResponse response, String metaAlias, String remoteEntityID, Map paramsMap) throws SAML2Exception {
        Object session;
        String method;
        block24: {
            method = "DoManageNameID.initiateManageNameIDRequest: ";
            if (metaAlias == null) {
                DoManageNameID.logError("MetaAliasNotFound", "MISSING_META_ALIAS", metaAlias);
                throw new SAML2Exception(SAML2Utils.bundle.getString("nullEntityID"));
            }
            if (remoteEntityID == null) {
                DoManageNameID.logError("nullRemoteEntityID", "MISSING_ENTITY", remoteEntityID);
                throw new SAML2Exception(SAML2Utils.bundle.getString("nullRemoteEntityID"));
            }
            session = null;
            try {
                session = SessionManager.getProvider().getSession(request);
            }
            catch (SessionException se) {
                if (!debug.messageEnabled()) break block24;
                debug.message(method, (Throwable)((Object)se));
            }
        }
        String realm = SAML2MetaUtils.getRealmByMetaAlias(metaAlias);
        String hostEntityID = metaManager.getEntityByMetaAlias(metaAlias);
        String hostEntityRole = SAML2Utils.getHostEntityRole(paramsMap);
        if (session == null) {
            if (debug.messageEnabled()) {
                debug.message(method + "Session is missing." + "redirect to the authentication service");
            }
            try {
                SAML2Utils.redirectAuthentication(request, response, realm, hostEntityID, hostEntityRole);
            }
            catch (IOException ioe) {
                DoManageNameID.logError("UnableToRedirectToAuth", "REDIRECT_TO_AUTH", null);
                throw new SAML2Exception(ioe.toString());
            }
            return;
        }
        if (debug.messageEnabled()) {
            debug.message(method + "Meta Alias is : " + metaAlias);
            debug.message(method + "Remote EntityID is : " + remoteEntityID);
            debug.message(method + "Host EntityID is : " + hostEntityID);
        }
        try {
            String binding = SAML2Utils.getParameter(paramsMap, "binding");
            ManageNameIDServiceElement mniService = DoManageNameID.getMNIServiceElement(realm, remoteEntityID, hostEntityRole, binding);
            if (binding == null) {
                binding = mniService.getBinding();
            }
            if (binding == null) {
                DoManageNameID.logError("UnableTofindBinding", "METADATA_ERROR", null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("UnableTofindBinding"));
            }
            String mniURL = null;
            if (mniService != null) {
                mniURL = mniService.getLocation();
            }
            if (mniURL == null) {
                DoManageNameID.logError("mniServiceNotFound", "METADATA_ERROR", null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("mniServiceNotFound"));
            }
            String requestType = (String)paramsMap.get("requestType");
            boolean changeID = "NewID".equals(requestType);
            String affiliationID = SAML2Utils.getParameter(paramsMap, "affiliationID");
            ManageNameIDRequest mniRequest = DoManageNameID.createManageNameIDRequest(session, realm, hostEntityID, hostEntityRole, remoteEntityID, mniURL, changeID, affiliationID);
            String relayState = SAML2Utils.getParameter(paramsMap, "RelayState");
            if (relayState == null || relayState.equals("")) {
                relayState = SAML2Utils.getAttributeValueFromSSOConfig(realm, hostEntityID, hostEntityRole, "defaultRelayState");
            }
            mniRequest.setDestination(mniURL);
            DoManageNameID.saveMNIRequestInfo(request, response, paramsMap, mniRequest, relayState, hostEntityRole, session);
            String mniRequestXMLString = null;
            if (binding.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect")) {
                mniRequestXMLString = mniRequest.toXMLString(true, true);
                DoManageNameID.doMNIByHttpRedirect(mniRequestXMLString, mniURL, relayState, realm, hostEntityID, hostEntityRole, remoteEntityID, response);
            } else if (binding.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
                DoManageNameID.signMNIRequest(mniRequest, realm, hostEntityID, hostEntityRole, remoteEntityID);
                BaseConfigType config = null;
                config = hostEntityRole.equalsIgnoreCase("SPRole") ? metaManager.getIDPSSOConfig(realm, remoteEntityID) : metaManager.getSPSSOConfig(realm, remoteEntityID);
                mniURL = SAML2Utils.fillInBasicAuthInfo(config, mniURL);
                if (!DoManageNameID.doMNIBySOAP(mniRequest, mniURL, metaAlias, hostEntityRole, request, response)) {
                    throw new SAML2Exception(SAML2Utils.bundle.getString("mniFailed"));
                }
            } else if (binding.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
                DoManageNameID.signMNIRequest(mniRequest, realm, hostEntityID, hostEntityRole, remoteEntityID);
                mniRequestXMLString = mniRequest.toXMLString(true, true);
                DoManageNameID.doMNIByPOST(mniRequestXMLString, mniURL, relayState, realm, hostEntityID, hostEntityRole, remoteEntityID, response);
            }
        }
        catch (IOException ioe) {
            DoManageNameID.logError("errorCreatingMNIRequest", "CANNOT_INSTANTIATE_MNI_REQUEST", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorCreatingMNIRequest"));
        }
        catch (SAML2MetaException sme) {
            DoManageNameID.logError("metaDataError", "METADATA_ERROR", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
        catch (SessionException ssoe) {
            DoManageNameID.logError("invalidSSOToken", "INVALID_SSOTOKEN", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSSOToken"));
        }
    }

    private static void postTerminationSuccess(String hostEntityId, String realm, HttpServletRequest request, HttpServletResponse response, String userId, ManageNameIDRequest idRequest, ManageNameIDResponse idResponse, String binding) {
        SAML2ServiceProviderAdapter spAdapter;
        block3: {
            spAdapter = null;
            try {
                spAdapter = SAML2Utils.getSPAdapterClass(hostEntityId, realm);
            }
            catch (SAML2Exception e) {
                if (!debug.messageEnabled()) break block3;
                debug.message("DoManageNameID.postTerminationSuccess:", (Throwable)((Object)e));
            }
        }
        if (spAdapter != null) {
            spAdapter.postTerminateNameIDSuccess(hostEntityId, realm, request, response, userId, idRequest, idResponse, binding);
        }
    }

    public static String getMNIBindingInfo(HttpServletRequest request, String metaAlias, String hostEntityRole, String remoteEntityID) throws SAML2Exception {
        String binding = request.getParameter("binding");
        try {
            String realm;
            ManageNameIDServiceElement mniService;
            if (binding == null && (mniService = DoManageNameID.getMNIServiceElement(realm = SAML2MetaUtils.getRealmByMetaAlias(metaAlias), remoteEntityID, hostEntityRole, null)) != null) {
                binding = mniService.getBinding();
            }
        }
        catch (SessionException e) {
            DoManageNameID.logError("invalidSSOToken", "INVALID_SSOTOKEN", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSSOToken"));
        }
        if (binding == null) {
            DoManageNameID.logError("UnableTofindBinding", "METADATA_ERROR", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("UnableTofindBinding"));
        }
        return binding;
    }

    private static void signMNIRequest(ManageNameIDRequest mniRequest, String realm, String hostEntity, String hostEntityRole, String remoteEntity) throws SAML2Exception {
        DoManageNameID.signMNIRequest(mniRequest, realm, hostEntity, hostEntityRole, remoteEntity, false);
    }

    private static void signMNIRequest(ManageNameIDRequest mniRequest, String realm, String hostEntity, String hostEntityRole, String remoteEntity, boolean includeCert) throws SAML2Exception {
        String method = "signMNIRequest : ";
        boolean needRequestSign = false;
        needRequestSign = hostEntityRole.equalsIgnoreCase("IDPRole") ? SAML2Utils.getWantMNIRequestSigned(realm, remoteEntity, "SPRole") : SAML2Utils.getWantMNIRequestSigned(realm, remoteEntity, "IDPRole");
        if (!needRequestSign) {
            if (debug.messageEnabled()) {
                debug.message(method + "MNIRequest doesn't need to be signed.");
            }
            return;
        }
        String alias = SAML2Utils.getSigningCertAlias(realm, hostEntity, hostEntityRole);
        if (debug.messageEnabled()) {
            debug.message(method + "realm is : " + realm);
            debug.message(method + "hostEntity is : " + hostEntity);
            debug.message(method + "Host Entity role is : " + hostEntityRole);
            debug.message(method + "remoteEntity is : " + remoteEntity);
            debug.message(method + "Cert Alias is : " + alias);
            debug.message(method + "MNI Request before sign : " + mniRequest.toXMLString(true, true));
        }
        PrivateKey signingKey = keyProvider.getPrivateKey(alias);
        X509Certificate signingCert = null;
        if (includeCert) {
            signingCert = keyProvider.getX509Certificate(alias);
        }
        if (signingKey == null) {
            DoManageNameID.logError("missingSigningCertAlias", "METADATA_ERROR", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
        }
        mniRequest.sign(signingKey, signingCert);
        if (debug.messageEnabled()) {
            debug.message(method + "MNI Request after sign : " + mniRequest.toXMLString(true, true));
        }
    }

    private static boolean verifyMNIRequest(ManageNameIDRequest mniRequest, String realm, String remoteEntity, String hostEntity, String hostEntityRole, String destination) throws SAML2Exception, SessionException {
        boolean needVerifySignature;
        String method = "verifyMNIRequest : ";
        if (debug.messageEnabled()) {
            debug.message(method + "realm is : " + realm);
            debug.message(method + "remoteEntity is : " + remoteEntity);
            debug.message(method + "Host Entity role is : " + hostEntityRole);
        }
        if (!(needVerifySignature = SAML2Utils.getWantMNIRequestSigned(realm, hostEntity, hostEntityRole))) {
            if (debug.messageEnabled()) {
                debug.message(method + "MNIRequest doesn't need to be verified.");
            }
            return true;
        }
        boolean valid = false;
        X509Certificate signingCert = null;
        if (hostEntityRole.equalsIgnoreCase("IDPRole")) {
            SPSSODescriptorElement spSSODesc = metaManager.getSPSSODescriptor(realm, remoteEntity);
            signingCert = KeyUtil.getVerificationCert(spSSODesc, remoteEntity, "SPRole");
        } else {
            IDPSSODescriptorElement idpSSODesc = metaManager.getIDPSSODescriptor(realm, remoteEntity);
            signingCert = KeyUtil.getVerificationCert(idpSSODesc, remoteEntity, "IDPRole");
        }
        if (signingCert != null) {
            valid = mniRequest.isSignatureValid(signingCert);
            if (debug.messageEnabled()) {
                debug.message(method + "Signature is : " + valid);
            }
        } else {
            DoManageNameID.logError("missingSigningCertAlias.", "METADATA_ERROR", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
        }
        return valid;
    }

    private static void signMNIResponse(ManageNameIDResponse mniResponse, String realm, String hostEntity, String hostEntityRole, String remoteEntity) throws SAML2Exception {
        DoManageNameID.signMNIResponse(mniResponse, realm, hostEntity, hostEntityRole, remoteEntity, false);
    }

    private static void signMNIResponse(ManageNameIDResponse mniResponse, String realm, String hostEntity, String hostEntityRole, String remoteEntity, boolean includeCert) throws SAML2Exception {
        String method = "signMNIResponse : ";
        boolean needResponseSign = false;
        needResponseSign = hostEntityRole.equalsIgnoreCase("IDPRole") ? SAML2Utils.getWantMNIResponseSigned(realm, remoteEntity, "SPRole") : SAML2Utils.getWantMNIResponseSigned(realm, remoteEntity, "IDPRole");
        if (!needResponseSign) {
            if (debug.messageEnabled()) {
                debug.message(method + "MNIResponse doesn't need to be signed.");
            }
            return;
        }
        String alias = SAML2Utils.getSigningCertAlias(realm, hostEntity, hostEntityRole);
        if (debug.messageEnabled()) {
            debug.message(method + "realm is : " + realm);
            debug.message(method + "hostEntity is : " + hostEntity);
            debug.message(method + "Host Entity role is : " + hostEntityRole);
            debug.message(method + "Cert Alias is : " + alias);
            debug.message(method + "MNI Response before sign : " + mniResponse.toXMLString(true, true));
        }
        PrivateKey signingKey = keyProvider.getPrivateKey(alias);
        X509Certificate signingCert = null;
        if (includeCert) {
            signingCert = keyProvider.getX509Certificate(alias);
        }
        if (signingKey == null) {
            DoManageNameID.logError("missingSigningCertAlias", "METADATA_ERROR", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
        }
        mniResponse.sign(signingKey, signingCert);
        if (debug.messageEnabled()) {
            debug.message(method + "MNI Response after sign : " + mniResponse.toXMLString(true, true));
        }
    }

    private static boolean verifyMNIResponse(ManageNameIDResponse mniResponse, String realm, String remoteEntity, String hostEntity, String hostEntityRole, String destination) throws SAML2Exception, SessionException {
        boolean needVerifySignature;
        String method = "verifyMNIResponse : ";
        if (debug.messageEnabled()) {
            debug.message(method + "realm is : " + realm);
            debug.message(method + "remoteEntity is : " + remoteEntity);
            debug.message(method + "Host Entity role is : " + hostEntityRole);
        }
        if (!(needVerifySignature = SAML2Utils.getWantMNIResponseSigned(realm, hostEntity, hostEntityRole))) {
            if (debug.messageEnabled()) {
                debug.message(method + "MNIResponse doesn't need to be verified.");
            }
            return true;
        }
        boolean valid = false;
        X509Certificate signingCert = null;
        if (hostEntityRole.equalsIgnoreCase("IDPRole")) {
            SPSSODescriptorElement spSSODesc = metaManager.getSPSSODescriptor(realm, remoteEntity);
            signingCert = KeyUtil.getVerificationCert(spSSODesc, remoteEntity, "SPRole");
        } else {
            IDPSSODescriptorElement idpSSODesc = metaManager.getIDPSSODescriptor(realm, remoteEntity);
            signingCert = KeyUtil.getVerificationCert(idpSSODesc, remoteEntity, "IDPRole");
        }
        if (signingCert != null) {
            valid = mniResponse.isSignatureValid(signingCert);
            if (debug.messageEnabled()) {
                debug.message(method + "Signature is : " + valid);
            }
        } else {
            DoManageNameID.logError("missingSigningCertAlias", "METADATA_ERROR", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
        }
        return valid;
    }

    private static void saveMNIRequestInfo(HttpServletRequest request, HttpServletResponse response, Map paramsMap, ManageNameIDRequest mniRequest, String relayState, String hostEntityRole, Object session) throws SAML2Exception {
        String method = "saveMNIRequestInfo: ";
        if (debug.messageEnabled()) {
            debug.message(method + "hostEntityRole : " + hostEntityRole);
        }
        ManageNameIDRequest reqForSave = mniRequest;
        NameID nameID = mniRequest.getNameID();
        EncryptedID encryptedID = mniRequest.getEncryptedID();
        if (encryptedID != null) {
            NewEncryptedID newEncryptedID = mniRequest.getNewEncryptedID();
            mniRequest.setEncryptedID(null);
            mniRequest.setNewEncryptedID(null);
            reqForSave = pf.createManageNameIDRequest(mniRequest.toXMLString(true, true));
            mniRequest.setNameID(null);
            mniRequest.setNewID(null);
            mniRequest.setEncryptedID(encryptedID);
            mniRequest.setNewEncryptedID(newEncryptedID);
        }
        paramsMap.put("session", session);
        ManageNameIDRequestInfo reqInfo = new ManageNameIDRequestInfo(request, response, reqForSave, relayState, paramsMap, session);
        reqInfo.setNameID(nameID);
        if (hostEntityRole.equalsIgnoreCase("SPRole")) {
            SPCache.mniRequestHash.put((Object)mniRequest.getID(), (Object)reqInfo);
        } else {
            IDPCache.mniRequestHash.put((Object)mniRequest.getID(), (Object)reqInfo);
        }
    }

    public static void processHttpRequest(HttpServletRequest request, HttpServletResponse response, Map paramsMap) throws SAML2Exception, SessionException, ServletException {
        boolean valid;
        String hostRole;
        String hostEntity;
        String method = "processHttpRequest: ";
        String metaAlias = null;
        String remoteEntityID = null;
        String queryString = null;
        SAMLUtils.checkHTTPContentLength(request);
        String requestURL = request.getRequestURI();
        metaAlias = SAML2MetaUtils.getMetaAliasByUri(requestURL);
        if (metaAlias == null) {
            DoManageNameID.logError("MetaAliasNotFound", "MISSING_META_ALIAS", metaAlias);
            throw new SAML2Exception(SAML2Utils.bundle.getString("MetaAliasNotFound"));
        }
        ManageNameIDRequest mniRequest = DoManageNameID.getMNIRequest(request);
        remoteEntityID = mniRequest.getIssuer().getValue();
        if (remoteEntityID == null) {
            DoManageNameID.logError("nullRemoteEntityID", "MISSING_ENTITY", remoteEntityID);
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullRemoteEntityID"));
        }
        String realm = SAML2MetaUtils.getRealmByMetaAlias(metaAlias);
        boolean needToVerify = SAML2Utils.getWantMNIRequestSigned(realm, hostEntity = metaManager.getEntityByMetaAlias(metaAlias), hostRole = SAML2Utils.getHostEntityRole(paramsMap));
        if (needToVerify && !(valid = SAML2Utils.verifyQueryString(queryString = request.getQueryString(), realm, hostRole, remoteEntityID))) {
            DoManageNameID.logError("invalidSignInRequest", "MNI_REQUEST_INVALID_SIGNATURE", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignInRequest"));
        }
        String relayState = request.getParameter("RelayState");
        if (debug.messageEnabled()) {
            debug.message(method + "Meta Alias is : " + metaAlias);
            debug.message(method + "Remote EntityID is : " + remoteEntityID);
            debug.message(method + "Host Entity role is : " + hostRole);
            debug.message(method + "Relay state is : " + relayState);
        }
        try {
            ManageNameIDServiceElement mniService = DoManageNameID.getMNIServiceElement(realm, remoteEntityID, hostRole, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            String mniURL = mniService.getResponseLocation();
            if (mniURL == null) {
                mniURL = mniService.getLocation();
            }
            ManageNameIDResponse mniResponse = DoManageNameID.processManageNameIDRequest(mniRequest, metaAlias, remoteEntityID, paramsMap, mniURL, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect", request, response);
            DoManageNameID.sendMNIResponse(response, mniResponse, mniURL, relayState, realm, hostEntity, hostRole, remoteEntityID);
        }
        catch (SAML2MetaException e) {
            DoManageNameID.logError("metaDataError", "METADATA_ERROR", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
        }
    }

    public static void processSOAPRequest(HttpServletRequest request, HttpServletResponse response, Map paramsMap) throws SAML2Exception, IOException, SOAPException, SessionException, ServletException {
        String dest;
        boolean valid;
        String method = "processSOAPRequest: ";
        String metaAlias = null;
        String remoteEntityID = null;
        String requestURL = request.getRequestURI();
        String hostEntityRole = SAML2Utils.getHostEntityRole(paramsMap);
        SAMLUtils.checkHTTPContentLength(request);
        metaAlias = SAML2MetaUtils.getMetaAliasByUri(requestURL);
        if (metaAlias == null) {
            DoManageNameID.logError("MetaAliasNotFound", "MISSING_META_ALIAS", metaAlias);
            throw new SAML2Exception(SAML2Utils.bundle.getString("MetaAliasNotFound"));
        }
        SOAPMessage message = SAML2Utils.getSOAPMessage(request);
        ManageNameIDRequest mniRequest = DoManageNameID.getMNIRequest(message);
        remoteEntityID = mniRequest.getIssuer().getValue();
        if (remoteEntityID == null) {
            DoManageNameID.logError("nullRemoteEntityID", "MISSING_ENTITY", metaAlias);
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullRemoteEntityID"));
        }
        String realm = SAML2MetaUtils.getRealmByMetaAlias(metaAlias);
        String hostEntity = metaManager.getEntityByMetaAlias(metaAlias);
        if (debug.messageEnabled()) {
            debug.message(method + "Meta Alias is : " + metaAlias);
            debug.message(method + "Host EntityID is : " + hostEntity);
            debug.message(method + "Remote EntityID is : " + remoteEntityID);
        }
        if (!(valid = DoManageNameID.verifyMNIRequest(mniRequest, realm, remoteEntityID, hostEntity, hostEntityRole, dest = mniRequest.getDestination()))) {
            DoManageNameID.logError("invalidSignInRequest", "MNI_REQUEST_INVALID_SIGNATURE", metaAlias);
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignInRequest"));
        }
        ManageNameIDResponse mniResponse = DoManageNameID.processManageNameIDRequest(mniRequest, metaAlias, remoteEntityID, paramsMap, null, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", request, response);
        DoManageNameID.signMNIResponse(mniResponse, realm, hostEntity, hostEntityRole, remoteEntityID);
        SOAPMessage reply = SAML2Utils.createSOAPMessage(mniResponse.toXMLString(true, true));
        if (reply != null) {
            if (reply.saveRequired()) {
                reply.saveChanges();
            }
        } else {
            DoManageNameID.logError("errorObtainResponse", "CANNOT_INSTANTIATE_MNI_RESPONSE", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorObtainResponse"));
        }
        response.setStatus(200);
        SAML2Utils.putHeaders(reply.getMimeHeaders(), response);
        ServletOutputStream os = response.getOutputStream();
        reply.writeTo((OutputStream)os);
        os.flush();
    }

    public static boolean processManageNameIDResponse(HttpServletRequest request, HttpServletResponse response, Map paramsMap) throws SAML2Exception {
        String method = "processManageNameIDResponse: ";
        boolean success = false;
        String requestURL = request.getRequestURI();
        String metaAlias = SAML2MetaUtils.getMetaAliasByUri(requestURL);
        if (metaAlias == null) {
            DoManageNameID.logError("MetaAliasNotFound", "MISSING_META_ALIAS", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("MetaAliasNotFound"));
        }
        String hostRole = SAML2Utils.getHostEntityRole(paramsMap);
        String relayState = request.getParameter("RelayState");
        String mniRes = request.getParameter("SAMLResponse");
        String mniResStr = SAML2Utils.decodeFromRedirect(mniRes);
        if (mniResStr == null) {
            DoManageNameID.logError("nullDecodedStrFromSamlResponse", "CANNOT_DECODE_RESPONSE", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullDecodedStrFromSamlResponse"));
        }
        if (debug.messageEnabled()) {
            debug.message(method + "Meta Alias is : " + metaAlias);
            debug.message(method + "Host role is : " + hostRole);
            debug.message(method + "Relay state is : " + relayState);
            debug.message(method + "MNI Response : " + mniResStr);
        }
        ManageNameIDResponse mniResponse = null;
        try {
            String queryString;
            boolean valid;
            mniResponse = pf.createManageNameIDResponse(mniResStr);
            String realm = SAML2MetaUtils.getRealmByMetaAlias(metaAlias);
            String hostEntityID = metaManager.getEntityByMetaAlias(metaAlias);
            String remoteEntityID = mniResponse.getIssuer().getValue();
            Issuer resIssuer = mniResponse.getIssuer();
            String requestId = mniResponse.getInResponseTo();
            SAML2Utils.verifyResponseIssuer(realm, hostEntityID, resIssuer, requestId);
            boolean needToVerify = SAML2Utils.getWantMNIResponseSigned(realm, hostEntityID, hostRole);
            if (needToVerify && !(valid = SAML2Utils.verifyQueryString(queryString = request.getQueryString(), realm, hostRole, remoteEntityID))) {
                DoManageNameID.logError("invalidSignInResponse", "MNI_RESPONSE_INVALID_SIGNATURE", null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignInResponse"));
            }
            StringBuffer mniUserId = new StringBuffer();
            success = DoManageNameID.checkMNIResponse(mniResponse, realm, hostEntityID, hostRole, mniUserId);
            if (success && hostRole != null && hostRole.equals("SPRole")) {
                DoManageNameID.postTerminationSuccess(hostEntityID, realm, request, response, mniUserId.toString(), null, mniResponse, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            }
        }
        catch (SessionException e) {
            DoManageNameID.logError("invalidSSOToken", "INVALID_SSOTOKEN", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSSOToken"));
        }
        if (debug.messageEnabled()) {
            debug.message(method + "Request success : " + success);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Status processManageNameIDRequest(ManageNameIDRequest mniRequest, String realm, String hostEntityID, String remoteEntityID, String hostRole, String userID) throws Exception {
        String method = "processManageNameIDRequest: ";
        if (debug.messageEnabled()) {
            debug.message(method + "Host EntityID is : " + hostEntityID);
            debug.message(method + "Host role is : " + hostRole);
            debug.message(method + "Realm  is : " + realm);
        }
        NameID nameID = DoManageNameID.getNameIDFromMNIRequest(mniRequest, realm, hostEntityID, hostRole);
        NameIDInfo oldNameIDInfo = DoManageNameID.getNameIDInfo(userID, hostEntityID, remoteEntityID, hostRole, realm, nameID.getSPNameQualifier(), true);
        NameID oldNameID = null;
        if (oldNameIDInfo != null) {
            oldNameID = oldNameIDInfo.getNameID();
        }
        if (oldNameID == null) {
            DoManageNameID.logError("unknownPrinciapl", "UNKNOWN_PRINCIPAL", mniRequest.toXMLString(true, true));
            return SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal", null);
        }
        List spFedSessions = null;
        if (hostRole.equalsIgnoreCase("IDPRole")) {
            DoManageNameID.removeIDPFedSession(remoteEntityID);
        } else {
            spFedSessions = (List)SPCache.fedSessionListsByNameIDInfoKey.remove(oldNameIDInfo.getNameIDInfoKey().toValueString());
        }
        if (!AccountUtils.removeAccountFederation(oldNameIDInfo, userID)) {
            DoManageNameID.logError("unableToTerminate", "UNABLE_TO_TERMINATE", userID);
            return SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", SAML2Utils.bundle.getString("unableToTerminate"));
        }
        if (mniRequest.getTerminate()) {
            DoManageNameID.logAccess("requestSuccess", "SUCCESS_FED_TERMINATION", userID);
            return SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Success", SAML2Utils.bundle.getString("requestSuccess"));
        }
        NewID newID = DoManageNameID.getNewIDFromMNIRequest(mniRequest, realm, hostEntityID, hostRole);
        boolean isAffiliation = oldNameIDInfo.isAffiliation();
        String spNameQualifier = oldNameID.getSPNameQualifier();
        if (hostRole.equalsIgnoreCase("IDPRole")) {
            NameID newNameID = AssertionFactory.getInstance().createNameID();
            newNameID.setValue(oldNameID.getValue());
            newNameID.setNameQualifier(oldNameID.getNameQualifier());
            newNameID.setSPNameQualifier(spNameQualifier);
            newNameID.setFormat(oldNameID.getFormat());
            newNameID.setSPProvidedID(newID.getValue());
            NameIDInfo newNameIDinfo = new NameIDInfo(hostEntityID, isAffiliation ? spNameQualifier : remoteEntityID, newNameID, "IDPRole", isAffiliation);
            AccountUtils.setAccountFederation(newNameIDinfo, userID);
            NameIDandSPpair pair = new NameIDandSPpair(newNameID, remoteEntityID);
            IDPSession idpSession = DoManageNameID.getIDPFedSession(remoteEntityID);
            Hashtable hashtable = IDPCache.idpSessionsByIndices;
            synchronized (hashtable) {
                List list = idpSession.getNameIDandSPpairs();
                list.add(pair);
            }
            DoManageNameID.logAccess("requestSuccess", "SUCCESS_NEW_NAMEID", userID);
            return SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Success", SAML2Utils.bundle.getString("requestSuccess"));
        }
        NameID newNameID = AssertionFactory.getInstance().createNameID();
        newNameID.setValue(newID.getValue());
        newNameID.setNameQualifier(oldNameID.getNameQualifier());
        newNameID.setSPProvidedID(oldNameID.getSPProvidedID());
        newNameID.setSPNameQualifier(spNameQualifier);
        newNameID.setFormat(oldNameID.getFormat());
        NameIDInfo newNameIDInfo = new NameIDInfo(isAffiliation ? spNameQualifier : hostEntityID, remoteEntityID, newNameID, hostRole, isAffiliation);
        AccountUtils.setAccountFederation(newNameIDInfo, userID);
        if (spFedSessions != null) {
            String newInfoKeyStr = newNameIDInfo.getNameIDInfoKey().toValueString();
            String infoKeyAttribute = AccountUtils.getNameIDInfoKeyAttribute();
            List list = spFedSessions;
            synchronized (list) {
                Iterator iter = spFedSessions.iterator();
                while (iter.hasNext()) {
                    SPFedSession spFedSession = (SPFedSession)iter.next();
                    spFedSession.info = newNameIDInfo;
                    String tokenID = spFedSession.spTokenID;
                    try {
                        String[] values;
                        Object session = sessionProvider.getSession(tokenID);
                        String[] fromToken = sessionProvider.getProperty(session, infoKeyAttribute);
                        if (fromToken == null || fromToken.length == 0 || fromToken[0] == null || fromToken[0].length() == 0) {
                            values = new String[]{newInfoKeyStr};
                            sessionProvider.setProperty(session, infoKeyAttribute, values);
                            continue;
                        }
                        if (fromToken[0].indexOf(newInfoKeyStr) != -1) continue;
                        values = new String[]{fromToken[0] + ";" + newInfoKeyStr};
                        sessionProvider.setProperty(session, infoKeyAttribute, values);
                    }
                    catch (SessionException ex) {
                        debug.error("DoManageNameID.processManageNameIDRequest:", (Throwable)((Object)ex));
                    }
                }
            }
            SPCache.fedSessionListsByNameIDInfoKey.put(newInfoKeyStr, spFedSessions);
        }
        DoManageNameID.logAccess("requestSuccess", "SUCCESS_NEW_NAMEID", userID);
        return SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Success", SAML2Utils.bundle.getString("requestSuccess"));
    }

    private static ManageNameIDResponse processManageNameIDRequest(ManageNameIDRequest mniRequest, String metaAlias, String remoteEntityID, Map paramsMap, String destination, String binding, HttpServletRequest request, HttpServletResponse response) {
        String realm = SAML2MetaUtils.getRealmByMetaAlias(metaAlias);
        String hostEntityID = null;
        String hostRole = null;
        Status status = null;
        String userID = null;
        try {
            hostEntityID = metaManager.getEntityByMetaAlias(metaAlias);
            hostRole = SAML2Utils.getHostEntityRole(paramsMap);
            SAML2Utils.verifyRequestIssuer(realm, hostEntityID, mniRequest.getIssuer(), mniRequest.getID());
            if (hostRole.equalsIgnoreCase("IDPRole")) {
                IDPAccountMapper idpAcctMapper = SAML2Utils.getIDPAccountMapper(realm, hostEntityID);
                userID = idpAcctMapper.getIdentity(mniRequest, hostEntityID, realm);
            } else if (hostRole.equalsIgnoreCase("SPRole")) {
                SPAccountMapper spAcctMapper = SAML2Utils.getSPAccountMapper(realm, hostEntityID);
                userID = spAcctMapper.getIdentity(mniRequest, hostEntityID, realm);
            }
            status = userID == null ? SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Requester", "urn:oasis:names:tc:SAML:2.0:status:UnknownPrincipal", null) : DoManageNameID.processManageNameIDRequest(mniRequest, realm, hostEntityID, remoteEntityID, hostRole, userID);
        }
        catch (Exception e) {
            if (debug.messageEnabled()) {
                debug.message("DoManageNameID.processManageNameIDRequest:", (Throwable)e);
            }
            status = SAML2Utils.generateStatus("urn:oasis:names:tc:SAML:2.0:status:Responder", e.toString());
        }
        ManageNameIDResponse mniResponse = null;
        try {
            String responseID = SAML2Utils.generateID();
            if (responseID == null) {
                debug.error(SAML2Utils.bundle.getString("failedToGenResponseID"));
            }
            mniResponse = pf.createManageNameIDResponse();
            mniResponse.setStatus(status);
            mniResponse.setID(responseID);
            mniResponse.setInResponseTo(mniRequest.getID());
            mniResponse.setVersion("2.0");
            mniResponse.setIssueInstant(new Date());
            mniResponse.setIssuer(SAML2Utils.createIssuer(hostEntityID));
            if (destination != null && destination.length() != 0) {
                mniResponse.setDestination(destination);
            }
        }
        catch (SAML2Exception e) {
            debug.error("Error : ", (Throwable)((Object)e));
        }
        if (hostRole.equalsIgnoreCase("SPRole") && mniResponse.getStatus().getStatusCode().getValue().equals("urn:oasis:names:tc:SAML:2.0:status:Success")) {
            DoManageNameID.postTerminationSuccess(hostEntityID, realm, request, response, userID, mniRequest, mniResponse, binding);
        }
        return mniResponse;
    }

    private static void sendMNIResponse(HttpServletResponse response, ManageNameIDResponse mniResponse, String mniURL, String relayState, String realm, String hostEntity, String hostEntityRole, String remoteEntity) throws SAML2Exception {
        block7: {
            String method = "sendMNIResponse: ";
            try {
                String mniResXMLString = mniResponse.toXMLString(true, true);
                String encodedXML = SAML2Utils.encodeForRedirect(mniResXMLString);
                StringBuffer queryString = new StringBuffer().append("SAMLResponse").append("=").append(encodedXML);
                if (relayState != null && relayState.length() > 0 && relayState.getBytes("UTF-8").length <= 80) {
                    queryString.append("&").append("RelayState").append("=").append(URLEncDec.encode((String)relayState));
                }
                if (debug.messageEnabled()) {
                    debug.message(method + "MNI Response is : " + mniResXMLString);
                    debug.message(method + "Relay State is : " + relayState);
                }
                mniResponse.setDestination(mniURL);
                boolean needToSign = false;
                needToSign = hostEntityRole.equalsIgnoreCase("IDPRole") ? SAML2Utils.getWantMNIResponseSigned(realm, remoteEntity, "SPRole") : SAML2Utils.getWantMNIResponseSigned(realm, remoteEntity, "IDPRole");
                String signedQueryString = queryString.toString();
                if (needToSign) {
                    if (debug.messageEnabled()) {
                        debug.message(method + "QueryString has need to be signed.");
                    }
                    signedQueryString = SAML2Utils.signQueryString(signedQueryString, realm, hostEntity, hostEntityRole);
                }
                String redirectURL = mniURL + (mniURL.contains("?") ? "&" : "?") + signedQueryString;
                if (debug.messageEnabled()) {
                    debug.message(method + "redirectURL is : " + redirectURL);
                }
                response.sendRedirect(redirectURL);
            }
            catch (IOException ioe) {
                if (!debug.messageEnabled()) break block7;
                debug.message("Exception when redirecting to " + relayState, (Throwable)ioe);
            }
        }
    }

    private static ManageNameIDRequest createManageNameIDRequest(Object session, String realm, String hostEntityID, String hostEntityRole, String remoteEntityID, String destination, boolean changeID, String affiliationID) throws SAML2Exception {
        String method = "DoManageNameID.createManageNameIDRequest: ";
        NameID nameID = null;
        String userID = null;
        try {
            userID = sessionProvider.getPrincipalName(session);
            nameID = DoManageNameID.getNameID(userID, hostEntityID, remoteEntityID, hostEntityRole, affiliationID, realm);
        }
        catch (SessionException e) {
            DoManageNameID.logError("invalidSSOToken", "INVALID_SSOTOKEN", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSSOToken"));
        }
        if (debug.messageEnabled()) {
            debug.message(method + "User ID : " + userID);
            debug.message(method + "NameID : " + nameID.toXMLString());
        }
        ManageNameIDRequest mniRequest = pf.createManageNameIDRequest();
        mniRequest.setID(SAML2Utils.generateID());
        mniRequest.setVersion("2.0");
        mniRequest.setDestination(destination);
        mniRequest.setIssuer(SAML2Utils.createIssuer(hostEntityID));
        mniRequest.setIssueInstant(new Date());
        DoManageNameID.setNameIDForMNIRequest(mniRequest, nameID, changeID, realm, hostEntityID, hostEntityRole, remoteEntityID);
        if (!changeID) {
            mniRequest.setTerminate(true);
        }
        return mniRequest;
    }

    private static ManageNameIDRequest getMNIRequest(HttpServletRequest request) throws SAML2Exception {
        String binding = request.getParameter("binding");
        String samlRequest = request.getParameter("SAMLRequest");
        if (debug.messageEnabled()) {
            debug.message("DoManageNameID.getMNIRequest: SAMLRequest = " + samlRequest);
        }
        if (samlRequest == null) {
            DoManageNameID.logError("nullManageIDRequest", "CANNOT_INSTANTIATE_MNI_REQUEST", samlRequest);
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullManageIDRequest"));
        }
        if (binding != null && binding.equals("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST")) {
            return DoManageNameID.getMNIRequestFromPost(samlRequest);
        }
        String decodedStr = SAML2Utils.decodeFromRedirect(samlRequest);
        if (decodedStr == null) {
            DoManageNameID.logError("nullDecodedStrFromSamlRequest", "CANNOT_DECODE_REQUEST", samlRequest);
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullDecodedStrFromSamlRequest"));
        }
        return pf.createManageNameIDRequest(decodedStr);
    }

    private static ManageNameIDRequest getMNIRequest(SOAPMessage message) throws SAML2Exception {
        Element reqElem = SAML2Utils.getSamlpElement(message, "ManageNameIDRequest");
        ManageNameIDRequest manageRequest = pf.createManageNameIDRequest(reqElem);
        return manageRequest;
    }

    private static void doMNIByHttpRedirect(String mniRequestXMLString, String mniURL, String relayState, String realm, String hostEntity, String hostEntityRole, String remoteEntity, HttpServletResponse response) throws SAML2Exception, IOException {
        String method = "doMNIByHttpRedirect: ";
        String encodedXML = SAML2Utils.encodeForRedirect(mniRequestXMLString);
        StringBuffer queryString = new StringBuffer().append("SAMLRequest").append("=").append(encodedXML);
        if (relayState != null && relayState.length() > 0 && relayState.getBytes("UTF-8").length <= 80) {
            queryString.append("&").append("RelayState").append("=").append(URLEncDec.encode((String)relayState));
        }
        boolean needToSign = false;
        needToSign = hostEntityRole.equalsIgnoreCase("IDPRole") ? SAML2Utils.getWantMNIRequestSigned(realm, remoteEntity, "SPRole") : SAML2Utils.getWantMNIRequestSigned(realm, remoteEntity, "IDPRole");
        String signedQueryString = queryString.toString();
        if (needToSign) {
            signedQueryString = SAML2Utils.signQueryString(signedQueryString, realm, hostEntity, hostEntityRole);
        }
        String redirectURL = mniURL + (mniURL.contains("?") ? "&" : "?") + signedQueryString;
        if (debug.messageEnabled()) {
            debug.message(method + "MNIRequestXMLString : " + mniRequestXMLString);
            debug.message(method + "MNIRedirectURL : " + mniURL);
            debug.message(method + "MNIRedirectURL : " + redirectURL);
        }
        response.sendRedirect(redirectURL);
    }

    private static boolean doMNIBySOAP(ManageNameIDRequest mniRequest, String mniURL, String metaAlias, String hostRole, HttpServletRequest request, HttpServletResponse response) throws SAML2Exception {
        String method = "doMNIBySOAP: ";
        boolean success = false;
        String mniRequestXMLString = mniRequest.toXMLString(true, true);
        if (debug.messageEnabled()) {
            debug.message(method + "MNIRequestXMLString : " + mniRequestXMLString);
            debug.message(method + "MNIRedirectURL : " + mniURL);
        }
        SOAPMessage resMsg = null;
        try {
            resMsg = SAML2Utils.sendSOAPMessage(mniRequestXMLString, mniURL);
        }
        catch (SOAPException se) {
            debug.error(SAML2Utils.bundle.getString("invalidSOAPMessge"), (Throwable)se);
            return false;
        }
        Element mniRespElem = SAML2Utils.getSamlpElement(resMsg, "ManageNameIDResponse");
        ManageNameIDResponse mniResponse = pf.createManageNameIDResponse(mniRespElem);
        if (debug.messageEnabled() && mniResponse != null) {
            debug.message(method + "ManageNameIDResponse without " + "SOAP envelope:\n" + mniResponse.toXMLString());
        }
        try {
            String realm = SAML2MetaUtils.getRealmByMetaAlias(metaAlias);
            String hostEntityID = metaManager.getEntityByMetaAlias(metaAlias);
            String remoteEntityID = mniResponse.getIssuer().getValue();
            Issuer resIssuer = mniResponse.getIssuer();
            String requestId = mniResponse.getInResponseTo();
            SAML2Utils.verifyResponseIssuer(realm, hostEntityID, resIssuer, requestId);
            boolean validSign = DoManageNameID.verifyMNIResponse(mniResponse, realm, remoteEntityID, hostEntityID, hostRole, mniResponse.getDestination());
            if (!validSign) {
                DoManageNameID.logError("invalidSignInResponse", "CANNOT_INSTANTIATE_MNI_RESPONSE", null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignInResponse"));
            }
            StringBuffer mniUserId = new StringBuffer();
            success = DoManageNameID.checkMNIResponse(mniResponse, realm, hostEntityID, hostRole, mniUserId);
            if (success && hostRole.equals("SPRole")) {
                DoManageNameID.postTerminationSuccess(hostEntityID, realm, request, response, mniUserId.toString(), mniRequest, mniResponse, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
            }
        }
        catch (SessionException e) {
            debug.error(SAML2Utils.bundle.getString("invalidSSOToken"), (Throwable)((Object)e));
            throw new SAML2Exception(e.toString());
        }
        if (debug.messageEnabled()) {
            debug.message(method + "Request success : " + success);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkMNIResponse(ManageNameIDResponse mniResponse, String realm, String hostEntityID, String hostRole, StringBuffer mniUserId) throws SAML2Exception, SessionException {
        String userID;
        boolean success = false;
        String remoteEntityID = mniResponse.getIssuer().getValue();
        String requestID = mniResponse.getInResponseTo();
        ManageNameIDRequestInfo reqInfo = DoManageNameID.getMNIRequestInfo(requestID, hostRole);
        if (reqInfo == null) {
            DoManageNameID.logError("invalidInResponseToInResponse", "INVALID_MNI_RESPONSE", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidInResponseToInResponse"));
        }
        String retCode = mniResponse.getStatus().getStatusCode().getValue();
        if (retCode.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:status:Success")) {
            Object session = reqInfo.getSession();
            if (session == null) {
                DoManageNameID.logError("nullSSOToken", "INVALID_SSOTOKEN", null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("nullSSOToken"));
            }
            userID = sessionProvider.getPrincipalName(session);
            mniUserId.append(userID);
            ManageNameIDRequest origMniReq = reqInfo.getManageNameIDRequest();
            NameID oldNameID = origMniReq.getNameID();
            List spFedSessions = null;
            NameIDInfo oldNameIDInfo = DoManageNameID.getNameIDInfo(userID, hostEntityID, remoteEntityID, hostRole, realm, oldNameID.getSPNameQualifier(), true);
            if (oldNameIDInfo == null) {
                debug.error("DoManageNameID.checkMNIResponse: NameIDInfo not found.");
                return false;
            }
            if (hostRole.equalsIgnoreCase("SPRole")) {
                String infoKeyStr = oldNameIDInfo.getNameIDInfoKey().toValueString();
                spFedSessions = (List)SPCache.fedSessionListsByNameIDInfoKey.remove(infoKeyStr);
                DoManageNameID.removeInfoKeyFromSession(session, infoKeyStr);
            } else {
                DoManageNameID.removeIDPFedSession(remoteEntityID);
            }
            if (!AccountUtils.removeAccountFederation(oldNameIDInfo, userID)) {
                DoManageNameID.logError("unableToTerminate", "UNABLE_TO_TERMINATE", userID);
                return false;
            }
            if (origMniReq.getTerminate()) {
                DoManageNameID.logAccess("requestSuccess", "SUCCESS_FED_TERMINATION", userID);
                return true;
            }
            String newIDValue = origMniReq.getNewID().getValue();
            boolean isAffiliation = oldNameIDInfo.isAffiliation();
            String spNameQualifier = oldNameID.getSPNameQualifier();
            if (hostRole.equalsIgnoreCase("SPRole")) {
                NameID newNameID = AssertionFactory.getInstance().createNameID();
                newNameID.setValue(oldNameID.getValue());
                newNameID.setFormat(oldNameID.getFormat());
                newNameID.setSPProvidedID(newIDValue);
                newNameID.setSPNameQualifier(spNameQualifier);
                newNameID.setNameQualifier(oldNameID.getNameQualifier());
                NameIDInfo newNameIDInfo = new NameIDInfo(isAffiliation ? spNameQualifier : hostEntityID, remoteEntityID, newNameID, hostRole, isAffiliation);
                String newInfoKeyStr = newNameIDInfo.getNameIDInfoKey().toValueString();
                if (spFedSessions != null) {
                    SPCache.fedSessionListsByNameIDInfoKey.put(newInfoKeyStr, spFedSessions);
                }
                AccountUtils.setAccountFederation(newNameIDInfo, userID);
                try {
                    String infoKeyAttribute = AccountUtils.getNameIDInfoKeyAttribute();
                    String[] fromToken = sessionProvider.getProperty(session, infoKeyAttribute);
                    if (fromToken == null || fromToken.length == 0 || fromToken[0] == null || fromToken[0].length() == 0) {
                        String[] values = new String[]{newInfoKeyStr};
                        sessionProvider.setProperty(session, infoKeyAttribute, values);
                    } else if (fromToken[0].indexOf(newInfoKeyStr) == -1) {
                        String[] values = new String[]{fromToken[0] + ";" + newInfoKeyStr};
                        sessionProvider.setProperty(session, infoKeyAttribute, values);
                    }
                }
                catch (Exception e) {
                    debug.message("DoManageNameID.checkMNIResponse:", (Throwable)e);
                }
            } else if (hostRole.equalsIgnoreCase("IDPRole")) {
                NameID newNameID = AssertionFactory.getInstance().createNameID();
                newNameID.setValue(newIDValue);
                newNameID.setFormat(oldNameID.getFormat());
                newNameID.setSPProvidedID(oldNameID.getSPProvidedID());
                newNameID.setSPNameQualifier(spNameQualifier);
                newNameID.setNameQualifier(hostEntityID);
                NameIDInfo newNameIDInfo = new NameIDInfo(hostEntityID, isAffiliation ? spNameQualifier : remoteEntityID, newNameID, "IDPRole", isAffiliation);
                AccountUtils.setAccountFederation(newNameIDInfo, userID);
                NameIDandSPpair pair = new NameIDandSPpair(newNameID, remoteEntityID);
                IDPSession idpSession = (IDPSession)IDPCache.idpSessionsBySessionID.get(sessionProvider.getSessionID(session));
                if (idpSession != null) {
                    Hashtable hashtable = IDPCache.idpSessionsByIndices;
                    synchronized (hashtable) {
                        List list = idpSession.getNameIDandSPpairs();
                        list.add(pair);
                    }
                }
            }
        } else {
            DoManageNameID.logError("mniFailed", "INVALID_MNI_RESPONSE", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("mniFailed"));
        }
        DoManageNameID.logAccess("newNameIDSuccess", "SUCCESS_NEW_NAMEID", userID);
        success = true;
        return success;
    }

    private static ManageNameIDRequestInfo getMNIRequestInfo(String requestID, String hostRole) {
        if (hostRole.equalsIgnoreCase("SPRole")) {
            return (ManageNameIDRequestInfo)SPCache.mniRequestHash.get((Object)requestID);
        }
        if (hostRole.equalsIgnoreCase("IDPRole")) {
            return (ManageNameIDRequestInfo)IDPCache.mniRequestHash.get((Object)requestID);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static NameIDInfo getNameIDInfo(String userID, String hostEntityID, String remoteEntityID, String hostRole, String realm, String affiliationID, boolean invalidAffiIDAllowed) throws SAML2Exception {
        NameIDInfo nameInfo = null;
        if (affiliationID == null) return AccountUtils.getAccountFederation(userID, hostEntityID, remoteEntityID);
        AffiliationDescriptorType affiDesc = metaManager.getAffiliationDescriptor(realm, affiliationID);
        if (affiDesc != null) {
            if (hostRole.equals("SPRole")) {
                if (affiDesc.getAffiliateMember().contains(hostEntityID)) return AccountUtils.getAccountFederation(userID, affiliationID, remoteEntityID);
                throw new SAML2Exception(SAML2Utils.bundle.getString("spNotAffiliationMember"));
            }
            if (affiDesc.getAffiliateMember().contains(remoteEntityID)) return AccountUtils.getAccountFederation(userID, hostEntityID, affiliationID);
            throw new SAML2Exception(SAML2Utils.bundle.getString("spNotAffiliationMember"));
        }
        if (!invalidAffiIDAllowed) throw new SAML2Exception(SAML2Utils.bundle.getString("affiliationNotFound"));
        return AccountUtils.getAccountFederation(userID, hostEntityID, remoteEntityID);
    }

    private static boolean removeFedAccount(String userID, String hostEntityID, String remoteEntityID, String hostRole, String realm, String affiliationID) throws SAML2Exception {
        NameIDInfo nameInfo = DoManageNameID.getNameIDInfo(userID, hostEntityID, remoteEntityID, hostRole, realm, affiliationID, true);
        return AccountUtils.removeAccountFederation(nameInfo, userID);
    }

    private static ManageNameIDServiceElement getMNIServiceElement(String realm, String entityID, String hostEntityRole, String binding) throws SAML2MetaException, SessionException, SAML2Exception {
        ManageNameIDServiceElement mniService = null;
        String method = "getMNIServiceElement: ";
        if (debug.messageEnabled()) {
            debug.message(method + "Realm : " + realm);
            debug.message(method + "Entity ID : " + entityID);
            debug.message(method + "Host Entity Role : " + hostEntityRole);
        }
        if (hostEntityRole.equalsIgnoreCase("SPRole")) {
            mniService = DoManageNameID.getIDPManageNameIDConfig(realm, entityID, binding);
        } else if (hostEntityRole.equalsIgnoreCase("IDPRole")) {
            mniService = DoManageNameID.getSPManageNameIDConfig(realm, entityID, binding);
        } else {
            DoManageNameID.logError("nullHostEntityRole", "MISSING_ENTITY_ROLE", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullHostEntityRole"));
        }
        return mniService;
    }

    private static NameID getNameID(String userID, String hostEntityID, String remoteEntityID, String hostEntityRole, String affiliationID, String realm) throws SAML2Exception {
        NameIDInfo nameIDInfo = DoManageNameID.getNameIDInfo(userID, hostEntityID, remoteEntityID, hostEntityRole, realm, affiliationID, false);
        NameID nameID = null;
        if (nameIDInfo != null) {
            nameID = nameIDInfo.getNameID();
            if (debug.messageEnabled()) {
                debug.message("DoManageNameID.getNameID: userID = " + userID + ", nameID = " + nameID.toXMLString());
            }
        } else {
            debug.error("DoManageNameID.getNameID: " + SAML2Utils.bundle.getString("nullNameID"));
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullNameID"));
        }
        return nameID;
    }

    private static void setNameIDForMNIRequest(ManageNameIDRequest mniRequest, NameID nameID, boolean changeID, String realm, String hostEntity, String hostEntityRole, String remoteEntity) throws SAML2Exception {
        String method = "DoManageNameID.setNameIDForMNIRequest: ";
        boolean needEncryptIt = false;
        needEncryptIt = hostEntityRole.equalsIgnoreCase("IDPRole") ? SAML2Utils.getWantNameIDEncrypted(realm, remoteEntity, "SPRole") : SAML2Utils.getWantNameIDEncrypted(realm, remoteEntity, "IDPRole");
        NewID newID = null;
        if (changeID) {
            String newIDValue = SAML2Utils.createNameIdentifier();
            newID = ProtocolFactory.getInstance().createNewID(newIDValue);
            mniRequest.setNewID(newID);
        }
        mniRequest.setNameID(nameID);
        if (!needEncryptIt) {
            if (debug.messageEnabled()) {
                debug.message(method + "NamID doesn't need to be encrypted.");
            }
            return;
        }
        EncInfo encInfo = null;
        if (hostEntityRole.equalsIgnoreCase("IDPRole")) {
            SPSSODescriptorElement spSSODesc = metaManager.getSPSSODescriptor(realm, remoteEntity);
            encInfo = KeyUtil.getEncInfo(spSSODesc, remoteEntity, "SPRole");
        } else {
            IDPSSODescriptorElement idpSSODesc = metaManager.getIDPSSODescriptor(realm, remoteEntity);
            encInfo = KeyUtil.getEncInfo(idpSSODesc, remoteEntity, "IDPRole");
        }
        if (debug.messageEnabled()) {
            debug.message(method + "realm is : " + realm);
            debug.message(method + "hostEntity is : " + hostEntity);
            debug.message(method + "Host Entity role is : " + hostEntityRole);
            debug.message(method + "remoteEntity is : " + remoteEntity);
        }
        if (encInfo == null) {
            DoManageNameID.logError("UnableToFindEncryptKeyInfo", "METADATA_ERROR", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("UnableToFindEncryptKeyInfo"));
        }
        EncryptedID encryptedID = nameID.encrypt(encInfo.getWrappingKey(), encInfo.getDataEncAlgorithm(), encInfo.getDataEncStrength(), remoteEntity);
        mniRequest.setEncryptedID(encryptedID);
        if (newID != null) {
            NewEncryptedID newEncID = newID.encrypt(encInfo.getWrappingKey(), encInfo.getDataEncAlgorithm(), encInfo.getDataEncStrength(), remoteEntity);
            mniRequest.setNewEncryptedID(newEncID);
        }
    }

    private static NewID getNewIDFromMNIRequest(ManageNameIDRequest request, String realm, String hostEntityID, String hostEntityRole) throws SAML2Exception {
        boolean needDecryptIt = SAML2Utils.getWantNameIDEncrypted(realm, hostEntityID, hostEntityRole);
        if (!needDecryptIt) {
            if (debug.messageEnabled()) {
                debug.message("DoManageNameID.getNewIDFromMNIRequest: NamID doesn't need to be decrypted.");
                debug.message("DoManageNameID.getNewIDFromMNIRequest: request is " + request);
            }
            NewID newID = null;
            if (request != null) {
                newID = request.getNewID();
                debug.message("DoManageNameID.getNewIDFromMNIRequest: newid is " + newID.getValue());
            }
            return newID;
        }
        String alias = SAML2Utils.getEncryptionCertAlias(realm, hostEntityID, hostEntityRole);
        PrivateKey privateKey = keyProvider.getPrivateKey(alias);
        NewEncryptedID encryptedID = request.getNewEncryptedID();
        return encryptedID.decrypt(privateKey);
    }

    private static NameID getNameIDFromMNIRequest(ManageNameIDRequest request, String realm, String hostEntity, String hostEntityRole) throws SAML2Exception {
        String method = "DoManageNameID.getNameIDFromMNIRequest: ";
        boolean needDecryptIt = SAML2Utils.getWantNameIDEncrypted(realm, hostEntity, hostEntityRole);
        if (!needDecryptIt) {
            if (debug.messageEnabled()) {
                debug.message(method + "NamID doesn't need to be decrypted.");
            }
            return request.getNameID();
        }
        String alias = SAML2Utils.getEncryptionCertAlias(realm, hostEntity, hostEntityRole);
        if (debug.messageEnabled()) {
            debug.message(method + "realm is : " + realm);
            debug.message(method + "hostEntity is : " + hostEntity);
            debug.message(method + "Host Entity role is : " + hostEntityRole);
            debug.message(method + "Cert Alias is : " + alias);
        }
        PrivateKey privateKey = keyProvider.getPrivateKey(alias);
        EncryptedID encryptedID = request.getEncryptedID();
        return encryptedID.decrypt(privateKey);
    }

    public static ManageNameIDServiceElement getIDPManageNameIDConfig(String realm, String entityId, String binding) throws SAML2MetaException, SessionException {
        ManageNameIDServiceElement mni;
        block3: {
            mni = null;
            IDPSSODescriptorElement idpSSODesc = metaManager.getIDPSSODescriptor(realm, entityId);
            if (idpSSODesc == null) {
                debug.error(SAML2Utils.bundle.getString("noIDPEntry"));
                return null;
            }
            List list = idpSSODesc.getManageNameIDService();
            if (list == null || list.isEmpty()) break block3;
            if (binding == null) {
                return (ManageNameIDServiceElement)list.get(0);
            }
            Iterator it = list.iterator();
            while (it.hasNext() && !binding.equalsIgnoreCase((mni = (ManageNameIDServiceElement)it.next()).getBinding())) {
            }
        }
        return mni;
    }

    public static ManageNameIDServiceElement getSPManageNameIDConfig(String realm, String entityId, String binding) throws SAML2MetaException, SessionException {
        ManageNameIDServiceElement mni;
        block3: {
            mni = null;
            SPSSODescriptorElement spSSODesc = metaManager.getSPSSODescriptor(realm, entityId);
            if (spSSODesc == null) {
                return null;
            }
            List list = spSSODesc.getManageNameIDService();
            if (list == null || list.isEmpty()) break block3;
            if (binding == null) {
                return (ManageNameIDServiceElement)list.get(0);
            }
            Iterator it = list.iterator();
            while (it.hasNext() && !binding.equalsIgnoreCase((mni = (ManageNameIDServiceElement)it.next()).getBinding())) {
            }
        }
        return mni;
    }

    private static IDPSession getIDPFedSession(String spEntityID) throws SessionException {
        String method = "DoManageNameID.getIDPFedSession";
        Enumeration keys = null;
        String idpSessionIndex = null;
        IDPSession idpSession = null;
        if (IDPCache.idpSessionsByIndices == null) {
            if (debug.messageEnabled()) {
                debug.message(method + "IDPCache.idpSessionsByIndices is null.");
            }
            return null;
        }
        keys = IDPCache.idpSessionsByIndices.keys();
        if (keys == null) {
            if (debug.messageEnabled()) {
                debug.message(method + "IDPCache.idpSessionsByIndices return null.");
            }
            return null;
        }
        while (keys.hasMoreElements()) {
            String spID;
            List nameIDSPlist;
            NameIDandSPpair nameIDPair = null;
            idpSessionIndex = (String)keys.nextElement();
            idpSession = (IDPSession)IDPCache.idpSessionsByIndices.get(idpSessionIndex);
            if (idpSession == null || (nameIDSPlist = idpSession.getNameIDandSPpairs()) == null) continue;
            ListIterator iter = nameIDSPlist.listIterator();
            while (iter.hasNext() && !(spID = (nameIDPair = (NameIDandSPpair)iter.next()).getSPEntityID()).equalsIgnoreCase(spEntityID)) {
            }
        }
        return idpSession;
    }

    static void removeIDPFedSession(String spEntity) {
        String method = "removeIDPFedSession ";
        Enumeration keys = null;
        String idpSessionIndex = null;
        IDPSession idpSession = null;
        if (IDPCache.idpSessionsByIndices == null) {
            if (debug.messageEnabled()) {
                debug.message(method + "IDPCache.idpSessionsByIndices is null.");
            }
            return;
        }
        keys = IDPCache.idpSessionsByIndices.keys();
        if (keys == null) {
            if (debug.messageEnabled()) {
                debug.message(method + "IDPCache.idpSessionsByIndices return null.");
            }
            return;
        }
        block0: while (keys.hasMoreElements()) {
            List nameIDSPlist;
            NameIDandSPpair nameIDPair = null;
            idpSessionIndex = (String)keys.nextElement();
            idpSession = (IDPSession)IDPCache.idpSessionsByIndices.get(idpSessionIndex);
            if (idpSession == null || (nameIDSPlist = idpSession.getNameIDandSPpairs()) == null) continue;
            ListIterator iter = nameIDSPlist.listIterator();
            while (iter.hasNext()) {
                nameIDPair = (NameIDandSPpair)iter.next();
                String spID = nameIDPair.getSPEntityID();
                if (!spID.equalsIgnoreCase(spEntity)) continue;
                nameIDSPlist.remove(nameIDPair);
                continue block0;
            }
        }
    }

    private static void removeInfoKeyFromSession(Object session, String infoKey) throws SessionException {
        String method = "removeInfoKeyFromSession ";
        String infoKeyString = null;
        String[] values = sessionProvider.getProperty(session, AccountUtils.getNameIDInfoKeyAttribute());
        if (values != null && values.length > 0) {
            infoKeyString = values[0];
        }
        if (infoKeyString == null) {
            if (debug.messageEnabled()) {
                debug.message(method + "InfoKeyString from session is null.");
            }
            return;
        }
        if (debug.messageEnabled()) {
            debug.message(method + "InfoKeyString from session : " + infoKeyString);
            debug.message(method + "InfoKey need to delete : " + infoKey);
        }
        StringTokenizer st = new StringTokenizer(infoKeyString, ";");
        StringBuffer newInfoKey = new StringBuffer();
        if (st != null && st.hasMoreTokens()) {
            while (st.hasMoreTokens()) {
                String tmpInfoKey = st.nextToken();
                debug.message(method + "InfoKey from session : " + tmpInfoKey);
                if (infoKey.equals(tmpInfoKey)) continue;
                if (newInfoKey.length() > 0) {
                    newInfoKey.append(";");
                }
                newInfoKey.append(tmpInfoKey);
            }
            if (debug.messageEnabled()) {
                debug.message(method + "New InfoKey to session : " + newInfoKey.toString());
            }
            String[] v = new String[]{newInfoKey.toString()};
            sessionProvider.setProperty(session, AccountUtils.getNameIDInfoKeyAttribute(), v);
            if (debug.messageEnabled()) {
                debug.message(method + "New InfoKey from session : " + sessionProvider.getProperty(session, AccountUtils.getNameIDInfoKeyAttribute()));
            }
        } else {
            debug.message(method + "No InfoKey to remove.");
            return;
        }
    }

    private static void doMNIByPOST(String mniXMLString, String mniURL, String relayState, String realm, String hostEntity, String hostEntityRole, String remoteEntity, HttpServletResponse response) throws SAML2Exception, IOException {
        String encMsg = SAML2Utils.encodeForPOST(mniXMLString);
        SAML2Utils.postToTarget(response, "SAMLRequest", encMsg, "RelayState", relayState, mniURL);
    }

    public static void signMNIRequest(String certAlias, ManageNameIDRequest mniRequest) throws SAML2Exception {
        KeyProvider kp = KeyUtil.getKeyProviderInstance();
        if (kp == null) {
            SAML2Utils.debug.error("DoManageNameID.signMNIRequest: Unable to get a key provider instance.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullKeyProvider"));
        }
        mniRequest.sign(kp.getPrivateKey(certAlias), kp.getX509Certificate(certAlias));
    }

    public static void processPOSTRequest(HttpServletRequest request, HttpServletResponse response, Map paramsMap) throws SAML2Exception, IOException, SOAPException, SessionException, ServletException {
        String dest;
        boolean valid;
        String samlRequest = request.getParameter("SAMLRequest");
        if (samlRequest == null) {
            response.sendError(400, SAML2Utils.bundle.getString("MissingSAMLRequest"));
            throw new SAML2Exception(SAML2Utils.bundle.getString("MissingSAMLRequest"));
        }
        String metaAlias = SAML2MetaUtils.getMetaAliasByUri(request.getRequestURI());
        if (metaAlias == null) {
            DoManageNameID.logError("MetaAliasNotFound", "MISSING_META_ALIAS", metaAlias);
            throw new SAML2Exception(SAML2Utils.bundle.getString("MetaAliasNotFound"));
        }
        RequestAbstract mniRequest = null;
        ByteArrayInputStream bis = null;
        try {
            Document doc;
            byte[] raw = Base64.decode((String)samlRequest);
            if (raw != null && (doc = XMLUtils.toDOMDocument((InputStream)(bis = new ByteArrayInputStream(raw)), (Debug)SAML2Utils.debug)) != null) {
                mniRequest = ProtocolFactory.getInstance().createManageNameIDRequest(doc.getDocumentElement());
            }
        }
        catch (SAML2Exception se) {
            debug.error("DoManageNameID.processPOSTRequest:", (Throwable)((Object)se));
            response.sendError(400, "error getting mni req");
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullDecodedStrFromSamlResponse"));
        }
        catch (Exception e) {
            debug.error("DoManageNameID.processPOSTRequest:", (Throwable)e);
            response.sendError(500, "Error decoding request");
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullDecodedStrFromSamlResponse"));
        }
        finally {
            block21: {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception ie) {
                        if (!debug.messageEnabled()) break block21;
                        debug.message("DoManageNameID.processPOSTRequest:", (Throwable)ie);
                    }
                }
            }
        }
        String remoteEntityID = mniRequest.getIssuer().getValue();
        if (remoteEntityID == null) {
            DoManageNameID.logError("nullRemoteEntityID", "MISSING_ENTITY", metaAlias);
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullRemoteEntityID"));
        }
        String realm = SAML2MetaUtils.getRealmByMetaAlias(metaAlias);
        String hostEntityID = metaManager.getEntityByMetaAlias(metaAlias);
        String hostEntityRole = SAML2Utils.getHostEntityRole(paramsMap);
        if (debug.messageEnabled()) {
            debug.message("DoManageNameID.processPOSTRequest: Meta Alias is : " + metaAlias);
            debug.message("DoManageNameID.processPOSTRequest: Host EntityID is : " + hostEntityID);
            debug.message("DoManageNameID.processPOSTRequest: Remote EntityID is : " + remoteEntityID);
        }
        if (!(valid = DoManageNameID.verifyMNIRequest((ManageNameIDRequest)mniRequest, realm, remoteEntityID, hostEntityID, hostEntityRole, dest = mniRequest.getDestination()))) {
            DoManageNameID.logError("invalidSignInRequest", "MNI_REQUEST_INVALID_SIGNATURE", metaAlias);
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignInRequest"));
        }
        ManageNameIDServiceElement mniService = DoManageNameID.getMNIServiceElement(realm, remoteEntityID, hostEntityRole, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        String mniURL = mniService.getResponseLocation();
        if (mniURL == null) {
            mniURL = mniService.getLocation();
        }
        ManageNameIDResponse mniResponse = DoManageNameID.processManageNameIDRequest((ManageNameIDRequest)mniRequest, metaAlias, remoteEntityID, paramsMap, null, "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST", request, response);
        DoManageNameID.signMNIResponse(mniResponse, realm, hostEntityID, hostEntityRole, remoteEntityID);
        String mniRespString = mniResponse.toXMLString(true, true);
        String encMsg = SAML2Utils.encodeForPOST(mniRespString);
        String relayState = request.getParameter("RelayState");
        try {
            SAML2Utils.postToTarget(response, "SAMLResponse", encMsg, "RelayState", relayState, mniURL);
        }
        catch (Exception e) {
            debug.message("DoManageNameID.processPOSTRequest:", (Throwable)e);
            throw new SAML2Exception("Error posting to target");
        }
    }

    static String getMNIResponseFromPost(String samlResponse, HttpServletResponse response) throws SAML2Exception {
        if (samlResponse == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingSAMLResponse"));
        }
        StatusResponse resp = null;
        ByteArrayInputStream bis = null;
        try {
            Document doc;
            byte[] raw = Base64.decode((String)samlResponse);
            if (raw != null && (doc = XMLUtils.toDOMDocument((InputStream)(bis = new ByteArrayInputStream(raw)), (Debug)debug)) != null) {
                resp = ProtocolFactory.getInstance().createManageNameIDResponse(doc.getDocumentElement());
            }
        }
        catch (SAML2Exception se) {
            debug.error("DoManageNameID.getMNIResponseFromPost:", (Throwable)((Object)se));
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullDecodedStrFromSamlResponse"));
        }
        catch (Exception e) {
            debug.error("DoManageNameID.getMNIResponseFromPost:", (Throwable)e);
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullDecodedStrFromSamlResponse"));
        }
        finally {
            block15: {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception ie) {
                        if (!debug.messageEnabled()) break block15;
                        debug.message("DoManageNameID.getMNIResponseFromPost:", (Throwable)ie);
                    }
                }
            }
        }
        String respStr = resp.toXMLString();
        if (debug.messageEnabled()) {
            debug.message("DoManageNameID.getMNIResponseFromPost: " + respStr);
        }
        return respStr;
    }

    public static boolean processMNIResponsePOST(HttpServletRequest request, HttpServletResponse response, Map paramsMap) throws SAML2Exception {
        String method = "processMNIResponsePOST: ";
        boolean success = false;
        String requestURL = request.getRequestURI();
        String metaAlias = SAML2MetaUtils.getMetaAliasByUri(requestURL);
        if (metaAlias == null) {
            DoManageNameID.logError("MetaAliasNotFound", "MISSING_META_ALIAS", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("MetaAliasNotFound"));
        }
        String hostRole = SAML2Utils.getHostEntityRole(paramsMap);
        String relayState = request.getParameter("RelayState");
        String mniRes = request.getParameter("SAMLResponse");
        String mniResStr = DoManageNameID.getMNIResponseFromPost(mniRes, response);
        if (mniResStr == null) {
            DoManageNameID.logError("nullDecodedStrFromSamlResponse", "CANNOT_DECODE_RESPONSE", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullDecodedStrFromSamlResponse"));
        }
        if (debug.messageEnabled()) {
            debug.message("DoManageNameID.processMNIResponsePOST: Meta Alias is : " + metaAlias);
            debug.message("DoManageNameID.processMNIResponsePOST: Host role is : " + hostRole);
            debug.message("DoManageNameID.processMNIResponsePOST: Relay state is : " + relayState);
            debug.message("DoManageNameID.processMNIResponsePOST: MNI Response : " + mniResStr);
        }
        ManageNameIDResponse mniResponse = null;
        try {
            boolean valid;
            mniResponse = pf.createManageNameIDResponse(mniResStr);
            String realm = SAML2MetaUtils.getRealmByMetaAlias(metaAlias);
            String hostEntityID = metaManager.getEntityByMetaAlias(metaAlias);
            String remoteEntityID = mniResponse.getIssuer().getValue();
            Issuer resIssuer = mniResponse.getIssuer();
            String requestId = mniResponse.getInResponseTo();
            SAML2Utils.verifyResponseIssuer(realm, hostEntityID, resIssuer, requestId);
            boolean needToVerify = SAML2Utils.getWantMNIResponseSigned(realm, hostEntityID, hostRole);
            if (needToVerify && !(valid = DoManageNameID.verifyMNIResponse(mniResponse, realm, remoteEntityID, hostEntityID, hostRole, mniResponse.getDestination()))) {
                DoManageNameID.logError("invalidSignInResponse", "MNI_RESPONSE_INVALID_SIGNATURE", null);
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignInResponse"));
            }
            success = DoManageNameID.checkMNIResponse(mniResponse, realm, hostEntityID, hostRole, new StringBuffer());
        }
        catch (SessionException e) {
            DoManageNameID.logError("invalidSSOToken", "INVALID_SSOTOKEN", null);
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSSOToken"));
        }
        if (debug.messageEnabled()) {
            debug.message("DoManageNameID.processMNIResponsePOST: Request success : " + success);
        }
        return success;
    }

    static ManageNameIDRequest getMNIRequestFromPost(String samlRequest) throws SAML2Exception {
        debug.message("DoManageNameID.getMNIRequestFromPost: samlRequest = " + samlRequest);
        ManageNameIDRequest mniReq = null;
        ByteArrayInputStream bis = null;
        try {
            Document doc;
            byte[] raw = Base64.decode((String)samlRequest);
            if (raw != null && (doc = XMLUtils.toDOMDocument((InputStream)(bis = new ByteArrayInputStream(raw)), (Debug)SAML2Utils.debug)) != null) {
                mniReq = ProtocolFactory.getInstance().createManageNameIDRequest(doc.getDocumentElement());
            }
        }
        catch (SAML2Exception se) {
            debug.error("DoManageNameID.getMNIRequestFromPost:", (Throwable)((Object)se));
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullDecodedStrFromSamlResponse"));
        }
        catch (Exception e) {
            debug.error("DoManageNameID.getMNIRequestFromPost:", (Throwable)e);
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullDecodedStrFromSamlResponse"));
        }
        finally {
            block13: {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (Exception ie) {
                        if (!debug.messageEnabled()) break block13;
                        debug.message("DoManageNameID.getMNIRequestFromPost:", (Throwable)ie);
                    }
                }
            }
        }
        return mniReq;
    }

    static {
        try {
            scf = SOAPConnectionFactory.newInstance();
            mf = MessageFactory.newInstance();
            metaManager = new SAML2MetaManager();
            sessionProvider = SessionManager.getProvider();
        }
        catch (SOAPException se) {
            debug.error(SAML2Utils.bundle.getString("errorSOAPFactory"), (Throwable)se);
        }
        catch (SAML2MetaException se) {
            debug.error(SAML2Utils.bundle.getString("errorMetaManager"), (Throwable)((Object)se));
        }
        catch (SessionException sessE) {
            debug.error("Error retrieving session provider.", (Throwable)((Object)sessE));
        }
    }
}

