/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.profile;

import com.sun.identity.federation.message.common.AuthnContext;
import com.sun.identity.federation.message.common.EncryptedNameIdentifier;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.liberty.ws.disco.ResourceOffering;
import com.sun.identity.liberty.ws.disco.common.DiscoServiceManager;
import com.sun.identity.liberty.ws.disco.common.DiscoUtils;
import com.sun.identity.liberty.ws.disco.jaxb.ObjectFactory;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceIDType;
import com.sun.identity.liberty.ws.disco.jaxb.ResourceOfferingType;
import com.sun.identity.liberty.ws.disco.jaxb.ServiceInstanceType;
import com.sun.identity.liberty.ws.disco.plugins.jaxb.DiscoEntryElement;
import com.sun.identity.liberty.ws.interfaces.ResourceIDMapper;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.liberty.ws.security.SessionSubject;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml2.assertion.Advice;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.Attribute;
import com.sun.identity.saml2.assertion.AttributeStatement;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.assertion.Subject;
import com.sun.identity.saml2.assertion.SubjectConfirmation;
import com.sun.identity.saml2.assertion.SubjectConfirmationData;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.jaxb.metadata.IDPSSODescriptorElement;
import com.sun.identity.saml2.key.EncInfo;
import com.sun.identity.saml2.key.KeyUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DiscoveryBootstrap {
    private AttributeStatement bootstrapStatement = null;
    private List assertions = null;
    private Object session = null;

    public DiscoveryBootstrap(Object session, Subject sub, String authnContextClassRef, String wscID, String realm) throws SAML2Exception {
        this.session = session;
        try {
            ArrayList<Attribute> attributeList = new ArrayList<Attribute>();
            ArrayList<String> resourceOfferings = new ArrayList<String>();
            String offering = this.getResourceOffering(authnContextClassRef, sub, wscID, realm);
            resourceOfferings.add(offering);
            Attribute attribute = AssertionFactory.getInstance().createAttribute();
            attribute.setName("urn:liberty:disco:2003-08:DiscoveryResourceOffering");
            attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
            attribute.setAttributeValueString(resourceOfferings);
            attributeList.add(attribute);
            this.bootstrapStatement = AssertionFactory.getInstance().createAttributeStatement();
            this.bootstrapStatement.setAttribute(attributeList);
        }
        catch (Exception ex) {
            SAML2Utils.debug.error("DiscoveryBootstrap.DiscoveryBootstrap: while creating discovery bootstrap statement", (Throwable)ex);
            throw new SAML2Exception(ex);
        }
    }

    private String getResourceOffering(String authnContextClassRef, Subject subject, String wscID, String realm) throws SAML2Exception {
        DiscoEntryElement discoEntry;
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("DiscoveryBootstrap.getResourceOffering:Init");
        }
        if ((discoEntry = DiscoServiceManager.getBootstrappingDiscoEntry()) == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingUnivID"));
        }
        String[] values = null;
        try {
            values = SessionManager.getProvider().getProperty(this.session, "sun.am.UniversalIdentifier");
        }
        catch (SessionException se) {
            throw new SAML2Exception((Throwable)((Object)se));
        }
        if (values == null || values.length == 0) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingDiscoOffering"));
        }
        String univID = values[0];
        try {
            ResourceOfferingType offering = discoEntry.getResourceOffering();
            ServiceInstanceType serviceInstance = offering.getServiceInstance();
            String providerID = serviceInstance.getProviderID();
            if (!DiscoServiceManager.useImpliedResource()) {
                ResourceIDMapper idMapper = DiscoServiceManager.getResourceIDMapper(providerID);
                if (idMapper == null) {
                    idMapper = DiscoServiceManager.getDefaultResourceIDMapper();
                }
                ObjectFactory fac = new ObjectFactory();
                ResourceIDType resourceID = fac.createResourceIDType();
                String resourceIDValue = idMapper.getResourceID(providerID, univID);
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("DiscoveryBootstrap.getResourceOffering: ResourceID Value:" + resourceIDValue);
                }
                resourceID.setValue(resourceIDValue);
                offering.setResourceID(resourceID);
            }
            ArrayList<DiscoEntryElement> discoEntryList = new ArrayList<DiscoEntryElement>();
            discoEntryList.add(discoEntry);
            SessionSubject sessionSubject = null;
            if (DiscoServiceManager.encryptNIinSessionContext()) {
                String encAlias = SAML2Utils.getEncryptionCertAlias(realm, providerID, "IDPRole");
                IDPSSODescriptorElement idpSSODesc = SAML2Utils.getSAML2MetaManager().getIDPSSODescriptor(realm, providerID);
                EncInfo encInfo = KeyUtil.getEncInfo(idpSSODesc, wscID, "IDPRole");
                NameIdentifier ni = EncryptedNameIdentifier.getEncryptedNameIdentifier(DiscoveryBootstrap.convertSPNameID(subject.getNameID()), providerID, encInfo.getWrappingKey(), encInfo.getDataEncAlgorithm(), encInfo.getDataEncStrength());
                sessionSubject = new SessionSubject(ni, DiscoveryBootstrap.convertSC(subject.getSubjectConfirmation()), DiscoveryBootstrap.convertIDPNameID(subject.getNameID()));
            } else {
                sessionSubject = new SessionSubject(DiscoveryBootstrap.convertSPNameID(subject.getNameID()), DiscoveryBootstrap.convertSC(subject.getSubjectConfirmation()), DiscoveryBootstrap.convertIDPNameID(subject.getNameID()));
            }
            AuthnContext authnContext = new AuthnContext(authnContextClassRef, null);
            authnContext.setMinorVersion(2);
            SessionContext invocatorSession = new SessionContext(sessionSubject, authnContext, providerID);
            Map map = DiscoUtils.checkPolicyAndHandleDirectives(univID, null, discoEntryList, null, invocatorSession, wscID, this.session);
            List offerings = (List)map.get("offerings");
            if (offerings.isEmpty()) {
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("DiscoveryBootstrap.getResourceOffering:no ResourceOffering");
                }
                throw new SAML2Exception(SAML2Utils.bundle.getString("missingDiscoOffering"));
            }
            ResourceOffering resourceOffering = (ResourceOffering)offerings.get(0);
            this.assertions = (List)map.get("credentials");
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("DiscoveryBootstrap.getResourceOffering: Resource Offering:" + resourceOffering);
            }
            return resourceOffering.toString();
        }
        catch (Exception ex) {
            SAML2Utils.debug.error("DiscoveryBootstrap.getResourceOffering:Exception while creating resource offering.", (Throwable)ex);
            throw new SAML2Exception(ex);
        }
    }

    public AttributeStatement getBootstrapStatement() {
        return this.bootstrapStatement;
    }

    public Advice getCredentials() throws SAML2Exception {
        Advice advice = null;
        if (this.assertions != null && this.assertions.size() != 0) {
            ArrayList<String> assertionStrs = new ArrayList<String>();
            Iterator iter = this.assertions.iterator();
            while (iter.hasNext()) {
                Assertion assertion = (Assertion)iter.next();
                assertionStrs.add(assertion.toString(true, true));
            }
            advice = AssertionFactory.getInstance().createAdvice();
            advice.setAdditionalInfo(assertionStrs);
        }
        return advice;
    }

    private static NameIdentifier convertSPNameID(NameID nameId) throws SAMLException {
        return new NameIdentifier(nameId.getValue(), nameId.getSPNameQualifier(), nameId.getFormat());
    }

    private static IDPProvidedNameIdentifier convertIDPNameID(NameID nameId) throws SAMLException {
        return new IDPProvidedNameIdentifier(nameId.getValue(), nameId.getNameQualifier(), nameId.getFormat());
    }

    private static com.sun.identity.saml.assertion.SubjectConfirmation convertSC(List subjectConfirmations) throws SAMLException {
        List content;
        if (subjectConfirmations == null || subjectConfirmations.isEmpty()) {
            return null;
        }
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)subjectConfirmations.get(0);
        com.sun.identity.saml.assertion.SubjectConfirmation samlSC = new com.sun.identity.saml.assertion.SubjectConfirmation(subjectConfirmation.getMethod());
        SubjectConfirmationData scData = subjectConfirmation.getSubjectConfirmationData();
        if (scData != null && (content = scData.getContent()) != null && !content.isEmpty()) {
            samlSC.setSubjectConfirmationData((String)content.get(0));
        }
        return samlSC;
    }
}

