/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.profile;

import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml2.assertion.Assertion;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.AssertionIDRef;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.jaxb.entityconfig.BaseConfigType;
import com.sun.identity.saml2.jaxb.metadata.AssertionIDRequestServiceElement;
import com.sun.identity.saml2.jaxb.metadata.AttributeAuthorityDescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.AuthnAuthorityDescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.IDPSSODescriptorElement;
import com.sun.identity.saml2.jaxb.metadata.RoleDescriptorType;
import com.sun.identity.saml2.jaxb.metadata.SPSSODescriptorElement;
import com.sun.identity.saml2.key.KeyUtil;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.plugins.AssertionIDRequestMapper;
import com.sun.identity.saml2.profile.IDPCache;
import com.sun.identity.saml2.protocol.AssertionIDRequest;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.Response;
import com.sun.identity.saml2.protocol.Status;
import com.sun.identity.saml2.protocol.StatusCode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Element;

public class AssertionIDRequestUtil {
    static KeyProvider keyProvider = KeyUtil.getKeyProviderInstance();
    static SAML2MetaManager metaManager = SAML2Utils.getSAML2MetaManager();
    static Hashtable assertionIDRequestMapperCache = new Hashtable();
    static final String MIME_TYPE_ASSERTION = "application/samlassertion+xml";

    private AssertionIDRequestUtil() {
    }

    public static Response sendAssertionIDRequest(AssertionIDRequest assertionIDRequest, String samlAuthorityEntityID, String role, String realm, String binding) throws SAML2Exception {
        StringBuffer location = new StringBuffer();
        RoleDescriptorType roled = AssertionIDRequestUtil.getRoleDescriptorAndLocation(samlAuthorityEntityID, role, realm, binding, location);
        if (binding.equalsIgnoreCase("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")) {
            AssertionIDRequestUtil.signAssertionIDRequest(assertionIDRequest, realm, false);
            return AssertionIDRequestUtil.sendAssertionIDRequestBySOAP(assertionIDRequest, location.toString(), realm, samlAuthorityEntityID, role, roled);
        }
        throw new SAML2Exception(SAML2Utils.bundle.getString("unsupportedBinding"));
    }

    public static Assertion sendAssertionIDRequestURI(String assertionID, String samlAuthorityEntityID, String role, String realm) throws SAML2Exception {
        StringBuffer locationSB = new StringBuffer();
        AssertionIDRequestUtil.getRoleDescriptorAndLocation(samlAuthorityEntityID, role, realm, "urn:oasis:names:tc:SAML:2.0:bindings:URI", locationSB);
        if (locationSB.indexOf("?") == -1) {
            locationSB.append("?");
        } else {
            locationSB.append("&");
        }
        locationSB.append("ID=").append(assertionID);
        String location = AssertionIDRequestUtil.fillInBasicAuthInfo(locationSB.toString(), realm, samlAuthorityEntityID, role);
        URL url = null;
        try {
            url = new URL(location);
        }
        catch (MalformedURLException me) {
            throw new SAML2Exception(me.getMessage());
        }
        try {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setInstanceFollowRedirects(false);
            conn.setUseCaches(false);
            conn.setDoOutput(false);
            conn.connect();
            int respCode = conn.getResponseCode();
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AssertionIDRequestUtil.sendAssertionIDRequestURI: Response code = " + respCode + ", Response message = " + conn.getResponseMessage());
            }
            if (respCode != 200) {
                return null;
            }
            String contentType = conn.getContentType();
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AssertionIDRequestUtil.sendAssertionIDRequestURI: Content type = " + contentType);
            }
            if (contentType == null || contentType.indexOf(MIME_TYPE_ASSERTION) == -1) {
                return null;
            }
            int contentLength = conn.getContentLength();
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AssertionIDRequestUtil.sendAssertionIDRequestURI: Content length = " + contentLength);
            }
            BufferedInputStream bin = new BufferedInputStream(conn.getInputStream());
            StringBuffer contentSB = new StringBuffer();
            byte[] content = new byte[2048];
            if (contentLength != -1) {
                int left;
                int read = 0;
                int totalRead = 0;
                while (totalRead < contentLength && (read = bin.read(content, 0, (left = contentLength - totalRead) < content.length ? left : content.length)) != -1) {
                    if (read <= 0) continue;
                    totalRead += read;
                    contentSB.append(new String(content, 0, read));
                }
            } else {
                int numbytes;
                int totalRead = 0;
                while ((numbytes = bin.read(content)) != -1) {
                    totalRead += numbytes;
                    contentSB.append(new String(content, 0, numbytes));
                }
            }
            return AssertionFactory.getInstance().createAssertion(contentSB.toString());
        }
        catch (IOException ioex) {
            SAML2Utils.debug.error("AssertionIDRequest.sendAssertionIDRequestURI:", (Throwable)ioex);
            throw new SAML2Exception(ioex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void processAssertionIDRequestURI(HttpServletRequest request, HttpServletResponse response, String samlAuthorityEntityID, String role, String realm) throws IOException {
        String assertionID = request.getParameter("ID");
        if (assertionID == null) {
            response.sendError(400, SAML2Utils.bundle.getString("nullAssertionID"));
            return;
        }
        AssertionIDRequestMapper aidReqMapper = null;
        try {
            aidReqMapper = AssertionIDRequestUtil.getAssertionIDRequestMapper(realm, samlAuthorityEntityID, role);
        }
        catch (SAML2Exception ex) {
            response.sendError(500, ex.getMessage());
            return;
        }
        try {
            aidReqMapper.authenticateRequesterURI(request, response, samlAuthorityEntityID, role, realm);
        }
        catch (SAML2Exception ex) {
            response.sendError(403, ex.getMessage());
            return;
        }
        Assertion assertion = (Assertion)IDPCache.assertionByIDCache.get((Object)assertionID);
        if (assertion == null) {
            response.sendError(404, SAML2Utils.bundle.getString("invalidAssertionID"));
            return;
        }
        response.setContentType(MIME_TYPE_ASSERTION);
        response.addHeader("Cache-Control", "no-cache, no-store");
        response.addHeader("Pragma", "no-cache");
        String content = null;
        try {
            content = assertion.toXMLString(true, true);
        }
        catch (SAML2Exception ex) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AssertionIDRequestUtil.processAssertionIDRequestURI:", (Throwable)((Object)ex));
            }
            response.sendError(500, ex.getMessage());
            return;
        }
        byte[] bytes = null;
        try {
            bytes = content.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ueex) {
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AssertionIDRequestUtil.processAssertionIDRequestURI:", (Throwable)ueex);
            }
            response.sendError(500, ueex.getMessage());
            return;
        }
        response.setContentLength(bytes.length);
        BufferedOutputStream bos = null;
        try {
            bos = new BufferedOutputStream((OutputStream)response.getOutputStream());
            bos.write(bytes, 0, bytes.length);
        }
        catch (IOException ioex) {
            SAML2Utils.debug.error("AssertionIDRequestUtil.processAssertionIDRequestURI:", (Throwable)ioex);
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException ioex) {
                    SAML2Utils.debug.error("AssertionIDRequestUtil.processAssertionIDRequestURI:", (Throwable)ioex);
                }
            }
        }
    }

    public static Response processAssertionIDRequest(AssertionIDRequest assertionIDRequest, HttpServletRequest request, HttpServletResponse response, String samlAuthorityEntityID, String role, String realm) throws SAML2Exception {
        try {
            AssertionIDRequestUtil.verifyAssertionIDRequest(assertionIDRequest, samlAuthorityEntityID, role, realm);
        }
        catch (SAML2Exception se) {
            SAML2Utils.debug.error("AssertionIDRequestUtil.processAssertionIDRequest:", (Throwable)((Object)se));
            return SAML2Utils.getErrorResponse(assertionIDRequest, "urn:oasis:names:tc:SAML:2.0:status:Requester", null, se.getMessage(), samlAuthorityEntityID);
        }
        Issuer issuer = assertionIDRequest.getIssuer();
        String spEntityID = issuer.getValue();
        javax.xml.bind.Element roled = null;
        try {
            if ("IDPRole".equals(role)) {
                roled = metaManager.getIDPSSODescriptor(realm, samlAuthorityEntityID);
            } else if ("AuthnAuthRole".equals(role)) {
                roled = metaManager.getAuthnAuthorityDescriptor(realm, samlAuthorityEntityID);
            } else if ("AttrAuthRole".equals(role)) {
                roled = metaManager.getAttributeAuthorityDescriptor(realm, samlAuthorityEntityID);
            }
        }
        catch (SAML2MetaException sme) {
            SAML2Utils.debug.error("AssertionIDRequestUtil.processAssertionIDRequest:", (Throwable)((Object)sme));
            return SAML2Utils.getErrorResponse(assertionIDRequest, "urn:oasis:names:tc:SAML:2.0:status:Responder", null, sme.getMessage(), samlAuthorityEntityID);
        }
        if (roled == null) {
            return SAML2Utils.getErrorResponse(assertionIDRequest, "urn:oasis:names:tc:SAML:2.0:status:Requester", null, SAML2Utils.bundle.getString("samlAuthorityNotFound"), samlAuthorityEntityID);
        }
        ArrayList<Assertion> returnAssertions = null;
        List assertionIDRefs = assertionIDRequest.getAssertionIDRefs();
        Iterator iter = assertionIDRefs.iterator();
        while (iter.hasNext()) {
            AssertionIDRef assertionIDRef = (AssertionIDRef)iter.next();
            String assertionID = assertionIDRef.getValue();
            Assertion assertion = (Assertion)IDPCache.assertionByIDCache.get((Object)assertionID);
            if (assertion == null) continue;
            if (returnAssertions == null) {
                returnAssertions = new ArrayList<Assertion>();
            }
            returnAssertions.add(assertion);
        }
        ProtocolFactory protocolFactory = ProtocolFactory.getInstance();
        Response samlResp = protocolFactory.createResponse();
        samlResp.setAssertion(returnAssertions);
        samlResp.setID(SAML2Utils.generateID());
        samlResp.setInResponseTo(assertionIDRequest.getID());
        samlResp.setVersion("2.0");
        samlResp.setIssueInstant(new Date());
        Status status = protocolFactory.createStatus();
        StatusCode statusCode = protocolFactory.createStatusCode();
        statusCode.setValue("urn:oasis:names:tc:SAML:2.0:status:Success");
        status.setStatusCode(statusCode);
        samlResp.setStatus(status);
        Issuer respIssuer = AssertionFactory.getInstance().createIssuer();
        respIssuer.setValue(samlAuthorityEntityID);
        samlResp.setIssuer(respIssuer);
        AssertionIDRequestUtil.signResponse(samlResp, samlAuthorityEntityID, role, realm, false);
        return samlResp;
    }

    private static RoleDescriptorType getRoleDescriptorAndLocation(String samlAuthorityEntityID, String role, String realm, String binding, StringBuffer location) throws SAML2Exception {
        javax.xml.bind.Element roled;
        List aIDReqServices;
        block13: {
            aIDReqServices = null;
            roled = null;
            try {
                if (role == null) {
                    throw new SAML2Exception(SAML2Utils.bundle.getString("unsupportedRole"));
                }
                if (role.equals("IDPRole")) {
                    IDPSSODescriptorElement idpd = metaManager.getIDPSSODescriptor(realm, samlAuthorityEntityID);
                    if (idpd == null) {
                        throw new SAML2Exception(SAML2Utils.bundle.getString("idpNotFound"));
                    }
                    aIDReqServices = idpd.getAssertionIDRequestService();
                    roled = idpd;
                    break block13;
                }
                if (role.equals("AuthnAuthRole")) {
                    AuthnAuthorityDescriptorElement attrd = metaManager.getAuthnAuthorityDescriptor(realm, samlAuthorityEntityID);
                    if (attrd == null) {
                        throw new SAML2Exception(SAML2Utils.bundle.getString("authnAuthorityNotFound"));
                    }
                    aIDReqServices = attrd.getAssertionIDRequestService();
                    roled = attrd;
                    break block13;
                }
                if (role.equals("AttrAuthRole")) {
                    AttributeAuthorityDescriptorElement aad = metaManager.getAttributeAuthorityDescriptor(realm, samlAuthorityEntityID);
                    if (aad == null) {
                        throw new SAML2Exception(SAML2Utils.bundle.getString("attrAuthorityNotFound"));
                    }
                    aIDReqServices = aad.getAssertionIDRequestService();
                    roled = aad;
                    break block13;
                }
                throw new SAML2Exception(SAML2Utils.bundle.getString("unsupportedRole"));
            }
            catch (SAML2MetaException sme) {
                SAML2Utils.debug.error("AssertionIDRequest.getRoleDescriptorAndLocation:", (Throwable)((Object)sme));
                throw new SAML2Exception(SAML2Utils.bundle.getString("metaDataError"));
            }
        }
        if (binding == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("unsupportedBinding"));
        }
        if (aIDReqServices == null || aIDReqServices.isEmpty()) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("aIDReqServiceNotFound"));
        }
        Iterator iter = aIDReqServices.iterator();
        while (iter.hasNext()) {
            AssertionIDRequestServiceElement aIDReqService = (AssertionIDRequestServiceElement)iter.next();
            if (!binding.equalsIgnoreCase(aIDReqService.getBinding())) continue;
            location.append(aIDReqService.getLocation());
            break;
        }
        if (location.length() == 0) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("unsupportedBinding"));
        }
        return roled;
    }

    private static void signAssertionIDRequest(AssertionIDRequest assertionIDRequest, String realm, boolean includeCert) throws SAML2Exception {
        String spEntityID = assertionIDRequest.getIssuer().getValue();
        String alias = SAML2Utils.getSigningCertAlias(realm, spEntityID, "SPRole");
        PrivateKey signingKey = keyProvider.getPrivateKey(alias);
        X509Certificate signingCert = null;
        if (includeCert) {
            signingCert = keyProvider.getX509Certificate(alias);
        }
        if (signingKey != null) {
            assertionIDRequest.sign(signingKey, signingCert);
        }
    }

    private static void verifyAssertionIDRequest(AssertionIDRequest assertionIDRequest, String samlAuthorityEntityID, String role, String realm) throws SAML2Exception {
        Issuer issuer = assertionIDRequest.getIssuer();
        String requestedEntityID = issuer.getValue();
        if (!SAML2Utils.isSourceSiteValid(issuer, realm, samlAuthorityEntityID)) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("assertionIDRequestIssuerInvalid"));
        }
        SPSSODescriptorElement spSSODesc = metaManager.getSPSSODescriptor(realm, requestedEntityID);
        if (spSSODesc == null) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("assertionIDRequestIssuerNotFound"));
        }
        X509Certificate signingCert = KeyUtil.getVerificationCert(spSSODesc, requestedEntityID, "SPRole");
        if (signingCert != null) {
            boolean valid = assertionIDRequest.isSignatureValid(signingCert);
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AssertionIDRequestUtil.verifyAssertionIDRequest: Signature validity is : " + valid);
            }
            if (!valid) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignatureAssertionIDRequest"));
            }
        } else {
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
        }
    }

    private static void signResponse(Response response, String samlAuthorityEntityID, String role, String realm, boolean includeCert) throws SAML2Exception {
        String alias = SAML2Utils.getSigningCertAlias(realm, samlAuthorityEntityID, role);
        PrivateKey signingKey = keyProvider.getPrivateKey(alias);
        X509Certificate signingCert = null;
        if (includeCert) {
            signingCert = keyProvider.getX509Certificate(alias);
        }
        if (signingKey != null) {
            response.sign(signingKey, signingCert);
        }
    }

    private static String fillInBasicAuthInfo(String location, String realm, String samlAuthorityEntityID, String role) {
        BaseConfigType config;
        block7: {
            config = null;
            try {
                if (role.equals("IDPRole")) {
                    config = metaManager.getIDPSSOConfig(realm, samlAuthorityEntityID);
                } else if (role.equals("AuthnAuthRole")) {
                    config = metaManager.getAuthnAuthorityConfig(realm, samlAuthorityEntityID);
                } else if (role.equals("AttrAuthRole")) {
                    config = metaManager.getAttributeAuthorityConfig(realm, samlAuthorityEntityID);
                }
            }
            catch (SAML2MetaException sme) {
                if (!SAML2Utils.debug.messageEnabled()) break block7;
                SAML2Utils.debug.message("AssertionIDRequestUtil.getSSOConfig:", (Throwable)((Object)sme));
            }
        }
        return SAML2Utils.fillInBasicAuthInfo(config, location);
    }

    private static Response sendAssertionIDRequestBySOAP(AssertionIDRequest assertionIDRequest, String location, String realm, String samlAuthorityEntityID, String role, RoleDescriptorType roled) throws SAML2Exception {
        String aIDReqStr = assertionIDRequest.toXMLString(true, true);
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("AssertionIDRequestUtil.sendAssertionIDRequestBySOAP: assertionIDRequest = " + aIDReqStr);
            SAML2Utils.debug.message("AssertionIDRequestUtil.sendAssertionIDRequestBySOAP: location = " + location);
        }
        location = AssertionIDRequestUtil.fillInBasicAuthInfo(location, realm, samlAuthorityEntityID, role);
        SOAPMessage resMsg = null;
        try {
            resMsg = SAML2Utils.sendSOAPMessage(aIDReqStr, location);
        }
        catch (SOAPException se) {
            SAML2Utils.debug.error("AssertionIDRequestUtil.sendAssertionIDRequestBySOAP:", (Throwable)se);
            throw new SAML2Exception(SAML2Utils.bundle.getString("errorSendingAssertionIDRequest"));
        }
        Element respElem = SAML2Utils.getSamlpElement(resMsg, "Response");
        Response response = ProtocolFactory.getInstance().createResponse(respElem);
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("AssertionIDRequestUtil.sendAssertionIDRequestBySOAP: response = " + response.toXMLString(true, true));
        }
        AssertionIDRequestUtil.verifyResponse(response, assertionIDRequest, samlAuthorityEntityID, role, roled);
        return response;
    }

    private static void verifyResponse(Response response, AssertionIDRequest assertionIDRequest, String samlAuthorityEntityID, String role, RoleDescriptorType roled) throws SAML2Exception {
        String aIDReqID = assertionIDRequest.getID();
        if (aIDReqID != null && !aIDReqID.equals(response.getInResponseTo())) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidInResponseToAssertionIDRequest"));
        }
        Issuer respIssuer = response.getIssuer();
        if (respIssuer == null) {
            return;
        }
        if (!samlAuthorityEntityID.equals(respIssuer.getValue())) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("responseIssuerMismatch"));
        }
        X509Certificate signingCert = KeyUtil.getVerificationCert(roled, samlAuthorityEntityID, role);
        if (signingCert != null) {
            boolean valid = response.isSignatureValid(signingCert);
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AssertionIDRequestUtil .verifyResponse: Signature validity is : " + valid);
            }
            if (!valid) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("invalidSignatureOnResponse"));
            }
        } else {
            throw new SAML2Exception(SAML2Utils.bundle.getString("missingSigningCertAlias"));
        }
    }

    private static AssertionIDRequestMapper getAssertionIDRequestMapper(String realm, String samlAuthorityEntityID, String role) throws SAML2Exception {
        String aidReqMapperName = null;
        AssertionIDRequestMapper aidReqMapper = null;
        try {
            aidReqMapperName = SAML2Utils.getAttributeValueFromSSOConfig(realm, samlAuthorityEntityID, role, "assertionIDRequestMapper");
            if (aidReqMapperName == null) {
                aidReqMapperName = "com.sun.identity.saml2.plugins.DefaultAssertionIDRequestMapper";
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("AssertionIDRequestUtil.getAssertionIDRequestMapper: use " + aidReqMapperName);
                }
            }
            if ((aidReqMapper = (AssertionIDRequestMapper)assertionIDRequestMapperCache.get(aidReqMapperName)) == null) {
                aidReqMapper = (AssertionIDRequestMapper)Class.forName(aidReqMapperName).newInstance();
                assertionIDRequestMapperCache.put(aidReqMapperName, aidReqMapper);
            } else if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("AssertionIDRequestUtil.getAssertionIDRequestMapper: got the AssertionIDRequestMapper from cache");
            }
        }
        catch (Exception ex) {
            SAML2Utils.debug.error("AssertionIDRequestUtil.getAssertionIDRequestMapper:", (Throwable)ex);
            throw new SAML2Exception(ex);
        }
        return aidReqMapper;
    }
}

