/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.plugins;

import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.saml2.meta.SAML2MetaException;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.meta.SAML2MetaUtils;
import com.sun.identity.saml2.plugins.SAML2IDPFinder;
import com.sun.identity.saml2.profile.SPSSOFederate;
import com.sun.identity.saml2.protocol.AuthnRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SAML2IDPProxyImpl
implements SAML2IDPFinder {
    public List getPreferredIDP(AuthnRequest authnRequest, String hostProviderID, String realm, HttpServletRequest request, HttpServletResponse response) throws SAML2Exception {
        SAML2Utils.debug.message("SAML2IDPProxyImpl.getPreferredIDP:Init");
        try {
            String useIntroductionForProxying;
            SAML2MetaManager sm = new SAML2MetaManager();
            if (sm == null) {
                throw new SAML2Exception(SAML2Utils.bundle.getString("errorMetaManager"));
            }
            SPSSOConfigElement spEntityCfg = sm.getSPSSOConfig(realm, authnRequest.getIssuer().getValue());
            Map spConfigAttrsMap = null;
            if (spEntityCfg != null) {
                spConfigAttrsMap = SAML2MetaUtils.getAttributes(spEntityCfg);
            }
            if ((useIntroductionForProxying = SPSSOFederate.getParameter(spConfigAttrsMap, "useIntroductionForIDPProxy")) == null || !useIntroductionForProxying.equals("true")) {
                List proxyIDPs = (List)spConfigAttrsMap.get("idpProxyList");
                if (proxyIDPs == null || proxyIDPs.isEmpty()) {
                    SAML2Utils.debug.error("SAML2IDPProxyImpl.getPrefferedIDP:Preferred IDPs are null.");
                    return null;
                }
                ArrayList providerIDs = new ArrayList();
                providerIDs.add(proxyIDPs.iterator().next());
                return providerIDs;
            }
            return null;
        }
        catch (SAML2MetaException ex) {
            SAML2Utils.debug.error("SAML2IDPProxyImpl.getPreferredIDP: meta Exception in retrieving the preferred IDP", (Throwable)((Object)ex));
            return null;
        }
        catch (Exception e) {
            SAML2Utils.debug.error("SAML2IDPProxyImpl.getPreferredIDP: Exception in retrieving the preferred IDP", (Throwable)e);
            return null;
        }
    }
}

