/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.plugins;

import com.sun.identity.saml2.assertion.AuthnContext;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.plugins.SPAuthnContextMapper;
import com.sun.identity.saml2.profile.SPCache;
import com.sun.identity.saml2.profile.SPSSOFederate;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.saml2.protocol.RequestedAuthnContext;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DefaultSPAuthnContextMapper
implements SPAuthnContextMapper {
    static String DEFAULT = "default";

    public RequestedAuthnContext getRequestedAuthnContext(String realm, String hostEntityID, Map paramsMap) throws SAML2Exception {
        Iterator i;
        Set authCtxSet;
        Integer authLevel;
        List authContextClassRef;
        block18: {
            authContextClassRef = (List)paramsMap.get("AuthnContextClassRef");
            List authLevelList = (List)paramsMap.get("AuthLevel");
            authLevel = null;
            if (authLevelList != null && !authLevelList.isEmpty()) {
                try {
                    authLevel = new Integer((String)authLevelList.iterator().next());
                }
                catch (NumberFormatException nfe) {
                    if (SAML2Utils.debug.messageEnabled()) {
                        SAML2Utils.debug.message("not a valid integer", (Throwable)nfe);
                    }
                }
                catch (Exception e) {
                    if (!SAML2Utils.debug.messageEnabled()) break block18;
                    SAML2Utils.debug.message("error getting integer object", (Throwable)e);
                }
            }
        }
        if (authLevel == null) {
            authLevel = this.getAuthLevelFromAdvice(paramsMap);
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("authLevel in Query:" + authLevel);
            SAML2Utils.debug.message("authContextClassRef in Query:" + authContextClassRef);
        }
        Map authRefMap = DefaultSPAuthnContextMapper.getAuthRefMap(realm, hostEntityID);
        ArrayList<String> authCtxList = new ArrayList<String>();
        if (authContextClassRef != null && !authContextClassRef.isEmpty()) {
            Iterator i2 = authContextClassRef.iterator();
            while (i2.hasNext()) {
                String authClassRef = DefaultSPAuthnContextMapper.prefixIfRequired((String)i2.next());
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("DefaultSPAuthnContextMapper: authClassRef=" + authClassRef);
                }
                authCtxList.add(authClassRef);
            }
        }
        if (authLevel != null) {
            authCtxSet = authRefMap.keySet();
            i = authCtxSet.iterator();
            while (i.hasNext()) {
                Integer aLevel;
                String className = (String)i.next();
                if (DEFAULT.equals(className) || (aLevel = (Integer)authRefMap.get(className)) == null || aLevel < authLevel) continue;
                authCtxList.add(className);
            }
        }
        if ((authCtxList == null || authCtxList.isEmpty()) && authRefMap != null && !authRefMap.isEmpty()) {
            authCtxSet = authRefMap.keySet();
            i = authCtxSet.iterator();
            while (i.hasNext()) {
                String val = (String)i.next();
                if (val == null || val.equals(DEFAULT)) continue;
                authCtxList.add(val);
            }
        }
        if (authCtxList.isEmpty()) {
            authCtxList.add("urn:oasis:names:tc:SAML:2.0:ac:classes:PasswordProtectedTransport");
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("SPCache.authContextHash is: " + SPCache.authContextHash);
            SAML2Utils.debug.message("authCtxList is: " + authCtxList);
        }
        String authCtxComparison = SPSSOFederate.getParameter(paramsMap, "AuthComparison");
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("AuthComparison in Query:" + authCtxComparison);
        }
        if (!(authCtxComparison != null && DefaultSPAuthnContextMapper.isValidAuthComparison(authCtxComparison) || (authCtxComparison = SAML2Utils.getAttributeValueFromSSOConfig(realm, hostEntityID, "SPRole", "spAuthncontextComparisonType")) == null || DefaultSPAuthnContextMapper.isValidAuthComparison(authCtxComparison))) {
            authCtxComparison = null;
        }
        RequestedAuthnContext reqCtx = ProtocolFactory.getInstance().createRequestedAuthnContext();
        reqCtx.setAuthnContextClassRef(authCtxList);
        reqCtx.setComparison(authCtxComparison);
        return reqCtx;
    }

    private Integer getAuthLevelFromAdvice(Map paramsMap) {
        Integer level = null;
        List advices = (List)paramsMap.get("sunamcompositeadvice");
        if (advices != null && !advices.isEmpty()) {
            Node adviceNode;
            String adviceXML = URLEncDec.decode((String)((String)advices.iterator().next()));
            if (SAML2Utils.debug.messageEnabled()) {
                SAML2Utils.debug.message("DefaultSPAuthnContextMapper:adviceXML=" + adviceXML);
            }
            Set authLevelvalues = null;
            Document document = XMLUtils.toDOMDocument((String)adviceXML, (Debug)SAML2Utils.debug);
            if (document != null && (adviceNode = XMLUtils.getRootNode((Document)document, (String)"Advices")) != null) {
                Map advicePair = XMLUtils.parseAttributeValuePairTags((Node)adviceNode);
                authLevelvalues = (Set)advicePair.get("AuthLevelConditionAdvice");
            }
            if (authLevelvalues != null && !authLevelvalues.isEmpty()) {
                Iterator iter = authLevelvalues.iterator();
                while (iter.hasNext()) {
                    String authLevelvalue = (String)iter.next();
                    if (authLevelvalue == null || authLevelvalue.length() == 0) continue;
                    int index = authLevelvalue.indexOf(":");
                    String authLevelStr = null;
                    authLevelStr = index != -1 ? authLevelvalue.substring(index + 1).trim() : authLevelvalue;
                    try {
                        Integer authLevel = new Integer(authLevelStr);
                        if (level != null && level.compareTo(authLevel) <= 0) continue;
                        level = authLevel;
                    }
                    catch (Exception nex) {}
                }
            }
        }
        return level;
    }

    public int getAuthLevel(RequestedAuthnContext reqCtx, AuthnContext authnContext, String realm, String hostEntityID, String idpEntityID) throws SAML2Exception {
        Map authRefMap = (Map)SPCache.authContextHash.get(hostEntityID + "|" + realm);
        if (authRefMap == null || authRefMap.isEmpty()) {
            authRefMap = DefaultSPAuthnContextMapper.getAuthRefMap(realm, hostEntityID);
        }
        int authLevel = 0;
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("DefaultSPAuthnContextMapper:hostEntityID:" + hostEntityID);
            SAML2Utils.debug.message("DefaultSPAuthnContextMapper:realm:" + realm);
            SAML2Utils.debug.message("DefaultSPAuthnContextMapper:MAP:" + authRefMap);
            SAML2Utils.debug.message("DefaultSPAuthnContextMapper:HASH:" + SPCache.authContextHash);
        }
        String authnClassRef = null;
        if (authnContext != null) {
            authnClassRef = authnContext.getAuthnContextClassRef();
        }
        if (reqCtx != null && authnClassRef != null && !this.isAuthnContextMatching(reqCtx.getAuthnContextClassRef(), authnClassRef, reqCtx.getComparison(), realm, hostEntityID)) {
            throw new SAML2Exception(SAML2Utils.bundle.getString("invalidAuthnContextClassRef"));
        }
        Integer authLevelInt = null;
        if (authnClassRef != null && authnClassRef.length() > 0) {
            if (authRefMap != null && !authRefMap.isEmpty()) {
                authLevelInt = (Integer)authRefMap.get(authnClassRef);
            }
        } else if (authRefMap != null && !authRefMap.isEmpty()) {
            authLevelInt = (Integer)authRefMap.get(DEFAULT);
        }
        if (authLevelInt != null) {
            authLevel = authLevelInt;
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("DefaultSPAuthnContextMapper:authnClRef:" + authnClassRef);
            SAML2Utils.debug.message("DefaultSPAuthnContextMapper:authLevel :" + authLevel);
        }
        return authLevel;
    }

    public boolean isAuthnContextMatching(List requestedACClassRefs, String acClassRef, String comparison, String realm, String hostEntityID) {
        Map authRefMap = DefaultSPAuthnContextMapper.getAuthRefMap(realm, hostEntityID);
        return SAML2Utils.isAuthnContextMatching(requestedACClassRefs, acClassRef, comparison, authRefMap);
    }

    private static Map getAuthnCtxFromSPConfig(String realm, String hostEntityID) {
        List authContextClassRefConfig = SAML2Utils.getAllAttributeValueFromSSOConfig(realm, hostEntityID, "SPRole", "spAuthncontextClassrefMapping");
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message("DefaultSPAuthnContextMapper: List:" + authContextClassRefConfig);
        }
        LinkedHashMap<String, Integer> authRefMap = new LinkedHashMap<String, Integer>();
        if (authContextClassRefConfig != null && authContextClassRefConfig.size() != 0) {
            Iterator i = authContextClassRefConfig.iterator();
            while (i.hasNext()) {
                Integer authLevel;
                String authClass;
                boolean isDefault;
                block11: {
                    StringTokenizer st;
                    block10: {
                        isDefault = false;
                        String authRefVal = (String)i.next();
                        if (authRefVal.endsWith("|" + DEFAULT)) {
                            authRefVal = authRefVal.substring(0, authRefVal.length() - DEFAULT.length());
                            isDefault = true;
                        }
                        st = new StringTokenizer(authRefVal, "|");
                        authClass = null;
                        try {
                            authClass = st.nextToken();
                        }
                        catch (Exception e) {
                            if (!SAML2Utils.debug.messageEnabled()) break block10;
                            SAML2Utils.debug.message("AuthnContextClassRef not found");
                        }
                    }
                    if (!st.hasMoreTokens()) continue;
                    authLevel = null;
                    try {
                        authLevel = new Integer(st.nextToken());
                    }
                    catch (NumberFormatException nfe) {
                        if (!SAML2Utils.debug.messageEnabled()) break block11;
                        SAML2Utils.debug.message("DefaultSPAuthnContextMapper.getAuthnCtxFromSPConfig:", (Throwable)nfe);
                    }
                }
                if (SAML2Utils.debug.messageEnabled()) {
                    SAML2Utils.debug.message("DefaultSPAuthnContextMapper.getAuthnCtxFromSPConfig: AuthLevel is " + authLevel);
                }
                if (authLevel == null) continue;
                if (isDefault && !authRefMap.containsKey(DEFAULT)) {
                    authRefMap.put(DEFAULT, authLevel);
                }
                if (authClass == null) continue;
                authRefMap.put(DefaultSPAuthnContextMapper.prefixIfRequired(authClass), authLevel);
            }
        }
        return Collections.unmodifiableMap(authRefMap);
    }

    private static boolean isValidAuthComparison(String authComparison) {
        return authComparison.equals("exact") || authComparison.equals("maximum") || authComparison.equals("minimum") || authComparison.equals("better");
    }

    private static Map getAuthRefMap(String realm, String hostEntityID) {
        Map authRefMap;
        block4: {
            String key = hostEntityID + "|" + realm;
            authRefMap = (Map)SPCache.authContextHash.get(key);
            if (authRefMap == null) {
                try {
                    authRefMap = DefaultSPAuthnContextMapper.getAuthnCtxFromSPConfig(realm, hostEntityID);
                    if (authRefMap != null && !authRefMap.isEmpty()) {
                        SPCache.authContextHash.put(key, authRefMap);
                    }
                }
                catch (Exception e) {
                    if (!SAML2Utils.debug.messageEnabled()) break block4;
                    SAML2Utils.debug.message("DefaultSPAuthnContextMapper.getAuthRefMap:", (Throwable)e);
                }
            }
        }
        return authRefMap;
    }

    private static String prefixIfRequired(String authClassRef) {
        if (authClassRef != null && authClassRef.indexOf(58) == -1) {
            return "urn:oasis:names:tc:SAML:2.0:ac:classes:" + authClassRef;
        }
        return authClassRef;
    }
}

