/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.plugins;

import com.sun.identity.plugin.datastore.DataStoreProviderException;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.Attribute;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.plugins.DefaultAttributeMapper;
import com.sun.identity.saml2.plugins.IDPAttributeMapper;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultIDPAttributeMapper
extends DefaultAttributeMapper
implements IDPAttributeMapper {
    public DefaultIDPAttributeMapper() {
        debug.message("DefaultIDPAttributeMapper.Constructor");
    }

    public List getAttributes(Object session, String hostEntityID, String remoteEntityID, String realm) throws SAML2Exception {
        if (hostEntityID == null) {
            throw new SAML2Exception(bundle.getString("nullHostEntityID"));
        }
        if (realm == null) {
            throw new SAML2Exception(bundle.getString("nullHostEntityID"));
        }
        if (session == null) {
            throw new SAML2Exception(bundle.getString("nullSSOToken"));
        }
        try {
            Map valueMap;
            ArrayList<Attribute> attributes;
            Map configMap;
            block22: {
                if (!SessionManager.getProvider().isValid(session)) {
                    if (debug.warningEnabled()) {
                        debug.warning("DefaultIDPAttributeMapper.getAttributes: Invalid session");
                    }
                    return null;
                }
                configMap = this.getConfigAttributeMap(realm, remoteEntityID, "SPRole");
                if (debug.messageEnabled()) {
                    debug.message("DefaultIDPAttributeMapper.getAttr:remote SP attribute map = " + configMap);
                }
                if (configMap == null || configMap.isEmpty()) {
                    configMap = this.getConfigAttributeMap(realm, hostEntityID, "IDPRole");
                    if (configMap == null || configMap.isEmpty()) {
                        if (debug.messageEnabled()) {
                            debug.message("DefaultIDPAttributeMapper.getAttr:Configuration map is not defined.");
                        }
                        return null;
                    }
                    if (debug.messageEnabled()) {
                        debug.message("DefaultIDPAttributeMapper.getAttributes:hosted IDP attribute map=" + configMap);
                    }
                }
                attributes = new ArrayList<Attribute>();
                HashSet localAttributes = new HashSet();
                localAttributes.addAll(configMap.values());
                valueMap = null;
                try {
                    valueMap = dsProvider.getAttributes(SessionManager.getProvider().getPrincipalName(session), localAttributes);
                }
                catch (DataStoreProviderException dse) {
                    if (!debug.warningEnabled()) break block22;
                    debug.warning("DefaultIDPAttributeMapper.getAttributes: Datastore exception", (Throwable)((Object)dse));
                }
            }
            Iterator iter = configMap.keySet().iterator();
            while (iter.hasNext()) {
                String samlAttribute = (String)iter.next();
                String localAttribute = (String)configMap.get(samlAttribute);
                String[] localAttributeValues = null;
                if (valueMap != null && !valueMap.isEmpty()) {
                    Set values = (Set)valueMap.get(localAttribute);
                    if (values == null || values.isEmpty()) {
                        if (debug.messageEnabled()) {
                            debug.message("DefaultIDPAttributeMapper.getAttribute: user profile does not have value for " + localAttribute + " but is going to check ssotoken:");
                        }
                    } else {
                        localAttributeValues = values.toArray(new String[values.size()]);
                    }
                }
                if (localAttributeValues == null) {
                    localAttributeValues = SessionManager.getProvider().getProperty(session, localAttribute);
                }
                if (localAttributeValues == null || localAttributeValues.length == 0) {
                    if (!debug.messageEnabled()) continue;
                    debug.message("DefaultIDPAttributeMapper.getAttribute: user does not have " + localAttribute);
                    continue;
                }
                attributes.add(this.getSAMLAttribute(samlAttribute, localAttributeValues));
            }
            return attributes;
        }
        catch (SAML2Exception sme) {
            debug.error("DefaultIDPAttribute.getAttributes: SAML Exception", (Throwable)((Object)sme));
            throw new SAML2Exception((Throwable)((Object)sme));
        }
        catch (SessionException se) {
            debug.error("DefaultIDPAttribute.getAttributes: SessionException", (Throwable)((Object)se));
            throw new SAML2Exception((Throwable)((Object)se));
        }
    }

    protected Attribute getSAMLAttribute(String name, String[] values) throws SAML2Exception {
        if (name == null) {
            throw new SAML2Exception(bundle.getString("nullInput"));
        }
        AssertionFactory factory = AssertionFactory.getInstance();
        Attribute attribute = factory.createAttribute();
        attribute.setName(name);
        if (values != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < values.length; ++i) {
                list.add(XMLUtils.escapeSpecialCharacters((String)values[i]));
            }
            attribute.setAttributeValueString(list);
        }
        return attribute;
    }
}

