/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.ecp.impl;

import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.ecp.ECPResponse;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ECPResponseImpl
implements ECPResponse {
    private static final String RESPONSE = "Response";
    private Boolean mustUnderstand;
    private String actor;
    private String assertionConsumerServiceURL;
    private boolean isMutable = false;

    public ECPResponseImpl() {
        this.isMutable = true;
    }

    public ECPResponseImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
    }

    public ECPResponseImpl(String xmlString) throws SAML2Exception {
        Document xmlDocument = XMLUtils.toDOMDocument((String)xmlString, (Debug)SAML2SDKUtils.debug);
        if (xmlDocument == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(xmlDocument.getDocumentElement());
    }

    public Boolean isMustUnderstand() {
        return this.mustUnderstand;
    }

    public void setMustUnderstand(Boolean mustUnderstand) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.mustUnderstand = mustUnderstand;
    }

    public String getActor() {
        return this.actor;
    }

    public void setActor(String actor) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.actor = actor;
    }

    public String getAssertionConsumerServiceURL() {
        return this.assertionConsumerServiceURL;
    }

    public void setAssertionConsumerServiceURL(String url) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.assertionConsumerServiceURL = url;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        this.validateData();
        StringBuffer xml = new StringBuffer(300);
        xml.append("<");
        if (includeNSPrefix) {
            xml.append("ecp:");
        }
        xml.append(RESPONSE);
        if (declareNS) {
            xml.append(" ").append("xmlns:ecp=\"urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp\"").append(" ").append("xmlns:soap-env=\"http://schemas.xmlsoap.org/soap/envelope/\"");
        }
        xml.append(" ").append("soap-env:").append("mustUnderstand").append("=").append("\"").append(this.mustUnderstand.toString()).append("\"").append(" ").append("soap-env:").append("actor").append("=").append("\"").append(this.actor).append("\"").append(" ").append("AssertionConsumerServiceURL").append("=").append("\"").append(this.assertionConsumerServiceURL).append("\"").append(">").append("</ecp:").append(RESPONSE).append(">");
        return xml.toString();
    }

    public void makeImmutable() {
        if (this.isMutable) {
            this.isMutable = false;
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    private void parseElement(Element element) throws SAML2Exception {
        if (element == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPResponseImpl.parseElement: Input is null.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        String localName = element.getLocalName();
        if (!RESPONSE.equals(localName)) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPResponseImpl.parseElement: element local name should be Response");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalidECPResponse"));
        }
        String namespaceURI = element.getNamespaceURI();
        if (!"urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp".equals(namespaceURI)) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPResponseImpl.parseElement: element namespace should be urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalidECPNamesapce"));
        }
        String str = XMLUtils.getNodeAttributeValueNS((Node)element, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"mustUnderstand");
        this.mustUnderstand = SAML2SDKUtils.StringToBoolean(str);
        this.actor = XMLUtils.getNodeAttributeValueNS((Node)element, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"actor");
        this.assertionConsumerServiceURL = XMLUtils.getNodeAttributeValue((Node)element, (String)"AssertionConsumerServiceURL");
        this.validateData();
    }

    protected void validateData() throws SAML2Exception {
        if (this.assertionConsumerServiceURL == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPResponseImpl.validateData: AssertionConsumerServiceURL is missing in the ecp:Response");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingAssertionConsumerServiceURLECPResponse"));
        }
        if (this.mustUnderstand == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPResponseImpl.validateData: mustUnderstand is missing in the ecp:Response");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingMustUnderstandECPResponse"));
        }
        if (this.actor == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPResponseImpl.validateData: actor is missing in the ecp:Response");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingActorECPResponse"));
        }
    }
}

