/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.ecp.impl;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.Issuer;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.ecp.ECPRequest;
import com.sun.identity.saml2.protocol.IDPList;
import com.sun.identity.saml2.protocol.ProtocolFactory;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ECPRequestImpl
implements ECPRequest {
    private static final String REQUEST = "Request";
    private Issuer issuer;
    private IDPList idpList;
    private Boolean mustUnderstand;
    private String actor;
    private String providerName;
    private Boolean isPassive;
    private boolean isMutable = false;

    public ECPRequestImpl() {
        this.isMutable = true;
    }

    public ECPRequestImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
    }

    public ECPRequestImpl(String xmlString) throws SAML2Exception {
        Document xmlDocument = XMLUtils.toDOMDocument((String)xmlString, (Debug)SAML2SDKUtils.debug);
        if (xmlDocument == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(xmlDocument.getDocumentElement());
    }

    public Issuer getIssuer() {
        return this.issuer;
    }

    public void setIssuer(Issuer issuer) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.issuer = issuer;
    }

    public IDPList getIDPList() {
        return this.idpList;
    }

    public void setIDPList(IDPList idpList) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.idpList = idpList;
    }

    public Boolean isMustUnderstand() {
        return this.mustUnderstand;
    }

    public void setMustUnderstand(Boolean mustUnderstand) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.mustUnderstand = mustUnderstand;
    }

    public String getActor() {
        return this.actor;
    }

    public void setActor(String actor) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.actor = actor;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public void setProviderName(String providerName) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.providerName = providerName;
    }

    public Boolean isPassive() {
        return this.isPassive;
    }

    public void setIsPassive(Boolean isPassive) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.isPassive = isPassive;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        this.validateData();
        StringBuffer xml = new StringBuffer(300);
        xml.append("<");
        if (includeNSPrefix) {
            xml.append("ecp:");
        }
        xml.append(REQUEST);
        if (declareNS) {
            xml.append(" ").append("xmlns:ecp=\"urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp\"").append(" ").append("xmlns:soap-env=\"http://schemas.xmlsoap.org/soap/envelope/\"");
        }
        xml.append(" ").append("soap-env:").append("mustUnderstand").append("=").append("\"").append(this.mustUnderstand.toString()).append("\"").append(" ").append("soap-env:").append("actor").append("=").append("\"").append(this.actor).append("\"");
        if (this.providerName != null) {
            xml.append(" ").append("ProviderName").append("=").append("\"").append(this.providerName).append("\"");
        }
        if (this.isPassive != null) {
            xml.append(" ").append("IsPassive").append("=").append("\"").append(this.isPassive.toString()).append("\"");
        }
        xml.append(">").append("\n").append(this.issuer.toXMLString(includeNSPrefix, declareNS));
        if (this.idpList != null) {
            xml.append("\n").append(this.idpList.toXMLString(includeNSPrefix, declareNS));
        }
        xml.append("\n").append("</ecp:").append(REQUEST).append(">");
        return xml.toString();
    }

    public void makeImmutable() {
        if (this.isMutable) {
            this.isMutable = false;
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    private void parseElement(Element element) throws SAML2Exception {
        if (element == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPRequestImpl.parseElement: Input is null.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        String localName = element.getLocalName();
        if (!REQUEST.equals(localName)) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPRequestImpl.parseElement: element local name should be Request");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalidECPRequest"));
        }
        String namespaceURI = element.getNamespaceURI();
        if (!"urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp".equals(namespaceURI)) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPRequestImpl.parseElement: element namespace should be urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalidECPNamesapce"));
        }
        String str = XMLUtils.getNodeAttributeValueNS((Node)element, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"mustUnderstand");
        this.mustUnderstand = SAML2SDKUtils.StringToBoolean(str);
        this.actor = XMLUtils.getNodeAttributeValueNS((Node)element, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"actor");
        this.providerName = XMLUtils.getNodeAttributeValue((Node)element, (String)"ProviderName");
        str = XMLUtils.getNodeAttributeValue((Node)element, (String)"IsPassive");
        this.isPassive = SAML2SDKUtils.StringToBoolean(str);
        NodeList nList = element.getChildNodes();
        if (nList != null && nList.getLength() > 0) {
            for (int i = 0; i < nList.getLength(); ++i) {
                Node childNode = nList.item(i);
                if (childNode.getNodeType() != 1) continue;
                String cName = childNode.getLocalName();
                if (cName.equals("Issuer")) {
                    this.validateIssuer();
                    this.issuer = AssertionFactory.getInstance().createIssuer((Element)childNode);
                    continue;
                }
                if (cName.equals("IDPList")) {
                    this.validateIDPList();
                    this.idpList = ProtocolFactory.getInstance().createIDPList((Element)childNode);
                    continue;
                }
                if (SAML2SDKUtils.debug.messageEnabled()) {
                    SAML2SDKUtils.debug.message("ECPRequestImpl.parseElement: ECP Request has invalid child element");
                }
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalidElementECPReq"));
            }
        }
        this.validateData();
    }

    private void validateIssuer() throws SAML2Exception {
        if (this.issuer != null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPRequestImpl.validateIssuer: ECP Request has too many Issuer Element");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("ecpReqTooManyIssuer"));
        }
        if (this.idpList != null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPRequestImpl.validateIssuer: Issuer should be first child element in ECP Request");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("ecpReqIssuerNotFirst"));
        }
    }

    private void validateIDPList() throws SAML2Exception {
        if (this.idpList != null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPRequestImpl.validateIssuer: ECP Request has too many IDPList Element");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("ecpReqTooManyIDPList"));
        }
    }

    protected void validateData() throws SAML2Exception {
        if (this.mustUnderstand == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPRequestImpl.validateData: mustUnderstand is missing in the ecp:Request");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingMustUnderstandECPRequest"));
        }
        if (this.actor == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPRequestImpl.validateData: actor is missing in the ecp:Request");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingActorECPRequest"));
        }
        if (this.issuer == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPRequestImpl.validateData: Issuer is missing in the ecp:Request");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingIssuerECPRequest"));
        }
    }
}

