/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.ecp.impl;

import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.saml2.ecp.ECPRelayState;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ECPRelayStateImpl
implements ECPRelayState {
    private String value;
    private Boolean mustUnderstand;
    private String actor;
    private boolean isMutable = false;

    public ECPRelayStateImpl() {
        this.isMutable = true;
    }

    public ECPRelayStateImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
    }

    public ECPRelayStateImpl(String xmlString) throws SAML2Exception {
        Document xmlDocument = XMLUtils.toDOMDocument((String)xmlString, (Debug)SAML2SDKUtils.debug);
        if (xmlDocument == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(xmlDocument.getDocumentElement());
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.value = value;
    }

    public Boolean isMustUnderstand() {
        return this.mustUnderstand;
    }

    public void setMustUnderstand(Boolean mustUnderstand) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.mustUnderstand = mustUnderstand;
    }

    public String getActor() {
        return this.actor;
    }

    public void setActor(String actor) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.actor = actor;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        this.validateData();
        StringBuffer xml = new StringBuffer(300);
        xml.append("<");
        if (includeNSPrefix) {
            xml.append("ecp:");
        }
        xml.append("RelayState");
        if (declareNS) {
            xml.append(" ").append("xmlns:ecp=\"urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp\"").append(" ").append("xmlns:soap-env=\"http://schemas.xmlsoap.org/soap/envelope/\"");
        }
        xml.append(" ").append("soap-env:").append("mustUnderstand").append("=").append("\"").append(this.mustUnderstand.toString()).append("\"").append(" ").append("soap-env:").append("actor").append("=").append("\"").append(this.actor).append("\"").append(">").append(this.value).append("</ecp:").append("RelayState").append(">");
        return xml.toString();
    }

    public void makeImmutable() {
        if (this.isMutable) {
            this.isMutable = false;
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }

    private void parseElement(Element element) throws SAML2Exception {
        if (element == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPRelayStateImpl.parseElement: Input is null.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        String localName = element.getLocalName();
        if (!"RelayState".equals(localName)) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPRelayStateImpl.parseElement: element local name should be RelayState");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalidECPRelayState"));
        }
        String namespaceURI = element.getNamespaceURI();
        if (!"urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp".equals(namespaceURI)) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPRelayStateImpl.parseElement: element namespace should be urn:oasis:names:tc:SAML:2.0:profiles:SSO:ecp");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalidECPNamesapce"));
        }
        String str = XMLUtils.getNodeAttributeValueNS((Node)element, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"mustUnderstand");
        this.mustUnderstand = SAML2SDKUtils.StringToBoolean(str);
        this.actor = XMLUtils.getNodeAttributeValueNS((Node)element, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"actor");
        this.value = XMLUtils.getElementValue((Element)element);
        this.validateData();
    }

    protected void validateData() throws SAML2Exception {
        if (this.value == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPRelayStateImpl.validateData: value is missing in the ecp:RelayState");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingECPRelayState"));
        }
        if (this.mustUnderstand == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPRelayStateImpl.validateData: mustUnderstand is missing in the ecp:RelayState");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingMustUnderstandECPRelayState"));
        }
        if (this.actor == null) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ECPRelayStateImpl.validateData: actor is missing in the ecp:RelayState");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingActorECPRelayState"));
        }
    }
}

