/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.common;

import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.URLEncDec;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.StringTokenizer;

public class QuerySignatureUtil {
    private QuerySignatureUtil() {
    }

    public static String sign(String queryString, PrivateKey privateKey) throws SAML2Exception {
        String classMethod = "QuerySignatureUtil.sign: ";
        if (queryString == null || queryString.length() == 0 || privateKey == null) {
            SAML2Utils.debug.error(classMethod + "Either input query string or private key is null.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullInput"));
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "Input query string:\n" + queryString);
        }
        String alg = privateKey.getAlgorithm();
        Signature sig = null;
        String algURI = null;
        if (alg.equals("RSA")) {
            try {
                sig = Signature.getInstance("SHA1withRSA");
                algURI = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new SAML2Exception(nsae);
            }
        } else if (alg.equals("DSA")) {
            try {
                sig = Signature.getInstance("SHA1withDSA");
                algURI = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new SAML2Exception(nsae);
            }
        } else {
            SAML2Utils.debug.error(classMethod + "Algorithm not supported: " + alg);
            throw new SAML2Exception(SAML2Utils.bundle.getString("algorithmNotSupported"));
        }
        if (queryString.charAt(queryString.length() - 1) != '&') {
            queryString = queryString + "&";
        }
        queryString = queryString + "SigAlg=" + URLEncDec.encode((String)algURI);
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "Final string to be signed:\n" + queryString);
        }
        try {
            sig.initSign(privateKey);
        }
        catch (InvalidKeyException ike) {
            throw new SAML2Exception(ike);
        }
        try {
            sig.update(queryString.getBytes());
        }
        catch (SignatureException se1) {
            throw new SAML2Exception(se1);
        }
        byte[] sigBytes = null;
        try {
            sigBytes = sig.sign();
        }
        catch (SignatureException se2) {
            throw new SAML2Exception(se2);
        }
        if (sigBytes == null || sigBytes.length == 0) {
            SAML2Utils.debug.error(classMethod + "Generated signature is null");
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullSigGenerated"));
        }
        Base64 encoder = new Base64();
        String encodedSig = Base64.encode((byte[])sigBytes);
        queryString = queryString + "&Signature=" + URLEncDec.encode((String)encodedSig);
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "Signed query string:\n" + queryString);
        }
        return queryString;
    }

    public static boolean verify(String queryString, X509Certificate cert) throws SAML2Exception {
        int encSigValueIndex;
        String encSigValue;
        int sigAlgValueIndex;
        String sigAlgValue;
        String classMethod = "QuerySignatureUtil.verify: ";
        if (queryString == null || queryString.length() == 0 || cert == null) {
            SAML2Utils.debug.error(classMethod + "Input query string or certificate is null");
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullInput"));
        }
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "Query string to be verifed:\n" + queryString);
        }
        StringTokenizer st = new StringTokenizer(queryString, "&");
        String token = null;
        String samlReq = null;
        String samlRes = null;
        String relay = null;
        String sigAlg = null;
        String encSig = null;
        while (st.hasMoreTokens()) {
            token = st.nextToken();
            if (token.startsWith("SAMLRequest")) {
                samlReq = token;
                continue;
            }
            if (token.startsWith("SAMLResponse")) {
                samlRes = token;
                continue;
            }
            if (token.startsWith("RelayState")) {
                relay = token;
                continue;
            }
            if (token.startsWith("SigAlg")) {
                sigAlg = token;
                continue;
            }
            if (!token.startsWith("Signature")) continue;
            encSig = token;
        }
        if (sigAlg == null || sigAlg.equals("")) {
            SAML2Utils.debug.error(classMethod + "Null SigAlg query parameter.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullSigAlg"));
        }
        if (encSig == null || encSig.equals("")) {
            SAML2Utils.debug.error(classMethod + "Null Signature query parameter.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullSig"));
        }
        String newQueryString = null;
        newQueryString = samlReq != null ? samlReq : samlRes;
        if (relay != null) {
            newQueryString = newQueryString + "&" + relay;
        }
        newQueryString = newQueryString + "&" + sigAlg;
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "Query string to be verifed (re-arranged):\n" + newQueryString);
        }
        if ((sigAlgValue = sigAlg.substring((sigAlgValueIndex = sigAlg.indexOf(61)) + 1)) == null || sigAlgValue.equals("")) {
            SAML2Utils.debug.error(classMethod + "Null SigAlg query parameter value.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullSigAlg"));
        }
        sigAlgValue = URLEncDec.decode((String)sigAlgValue);
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "SigAlg query parameter value: " + sigAlgValue);
        }
        if ((encSigValue = encSig.substring((encSigValueIndex = encSig.indexOf(61)) + 1)) == null || encSigValue.equals("")) {
            SAML2Utils.debug.message(classMethod + "Null Signature query parameter value.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("nullSig"));
        }
        encSigValue = URLEncDec.decode((String)encSigValue);
        if (SAML2Utils.debug.messageEnabled()) {
            SAML2Utils.debug.message(classMethod + "Signature query parameter value:\n" + encSigValue);
        }
        byte[] signature = null;
        Base64 decoder = new Base64();
        signature = Base64.decode((String)encSigValue);
        Signature sig = null;
        if (sigAlgValue.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            try {
                sig = Signature.getInstance("SHA1withDSA");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new SAML2Exception(nsae);
            }
        } else if (sigAlgValue.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
            try {
                sig = Signature.getInstance("SHA1withRSA");
            }
            catch (NoSuchAlgorithmException nsae) {
                throw new SAML2Exception(nsae);
            }
        } else {
            SAML2Utils.debug.error(classMethod + "Signature algorithm not supported.");
            throw new SAML2Exception(SAML2Utils.bundle.getString("algNotSupported"));
        }
        try {
            sig.initVerify(cert);
        }
        catch (InvalidKeyException ike) {
            throw new SAML2Exception(ike);
        }
        try {
            sig.update(newQueryString.getBytes());
        }
        catch (SignatureException se1) {
            throw new SAML2Exception(se1);
        }
        boolean result = false;
        try {
            result = sig.verify(signature);
        }
        catch (SignatureException se2) {
            throw new SAML2Exception(se2);
        }
        return result;
    }
}

