/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.assertion.impl;

import com.sun.identity.saml2.assertion.AssertionFactory;
import com.sun.identity.saml2.assertion.BaseID;
import com.sun.identity.saml2.assertion.EncryptedID;
import com.sun.identity.saml2.assertion.NameID;
import com.sun.identity.saml2.assertion.Subject;
import com.sun.identity.saml2.assertion.SubjectConfirmation;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SubjectImpl
implements Subject {
    private List subjectConfirmations = new ArrayList();
    private BaseID baseId = null;
    private NameID nameId = null;
    private EncryptedID encryptedId = null;
    private boolean isMutable = true;
    public static final String SUBJECT_ELEMENT = "Subject";
    public static final String SUBJECT_CONFIRMATION_ELEMENT = "SubjectConfirmation";
    public static final String BASE_ID_ELEMENT = "BaseID";
    public static final String NAME_ID_ELEMENT = "NameID";
    public static final String ENCRYPTED_ID_ELEMENT = "EncryptedID";

    public SubjectImpl() {
    }

    public SubjectImpl(String xml) throws SAML2Exception {
        Document document = XMLUtils.toDOMDocument((String)xml, (Debug)SAML2SDKUtils.debug);
        if (document == null) {
            SAML2SDKUtils.debug.error("SubjectImpl.processElement(): invalid XML input");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        Element rootElement = document.getDocumentElement();
        this.processElement(rootElement);
        this.makeImmutable();
    }

    public SubjectImpl(Element element) throws SAML2Exception {
        this.processElement(element);
        this.makeImmutable();
    }

    private void processElement(Element element) throws SAML2Exception {
        if (element == null) {
            SAML2SDKUtils.debug.error("SubjectImpl.processElement(): invalid root element");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_element"));
        }
        String elemName = element.getLocalName();
        if (elemName == null) {
            SAML2SDKUtils.debug.error("SubjectImpl.processElement(): local name missing");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_local_name"));
        }
        if (!elemName.equals(SUBJECT_ELEMENT)) {
            SAML2SDKUtils.debug.error("SubjectImpl.processElement(): invalid local name " + elemName);
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("invalid_local_name"));
        }
        NodeList nodes = element.getChildNodes();
        int numOfNodes = nodes.getLength();
        if (numOfNodes < 1) {
            SAML2SDKUtils.debug.error("SubjectImpl.processElement(): subject has no subelements");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_subelements"));
        }
        int nextElem = 0;
        Node child = nodes.item(nextElem);
        while (child.getNodeType() != 1) {
            if (++nextElem >= numOfNodes) {
                SAML2SDKUtils.debug.error("SubjectImpl.processElement(): subject has no subelements");
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missing_subelements"));
            }
            child = nodes.item(nextElem);
        }
        String childName = child.getLocalName();
        if (childName != null) {
            if (childName.equals(SUBJECT_CONFIRMATION_ELEMENT)) {
                this.subjectConfirmations.add(AssertionFactory.getInstance().createSubjectConfirmation((Element)child));
            } else if (childName.equals(BASE_ID_ELEMENT)) {
                this.baseId = AssertionFactory.getInstance().createBaseID((Element)child);
            } else if (childName.equals(NAME_ID_ELEMENT)) {
                this.nameId = AssertionFactory.getInstance().createNameID((Element)child);
            } else if (childName.equals(ENCRYPTED_ID_ELEMENT)) {
                this.encryptedId = AssertionFactory.getInstance().createEncryptedID((Element)child);
            } else {
                SAML2SDKUtils.debug.error("SubjectImpl.processElement(): unexpected subelement " + childName);
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("unexpected_subelement"));
            }
        }
        if (++nextElem >= numOfNodes) {
            return;
        }
        while (nextElem < numOfNodes) {
            child = nodes.item(nextElem);
            if (child.getNodeType() == 1 && (childName = child.getLocalName()) != null) {
                if (childName.equals(SUBJECT_CONFIRMATION_ELEMENT)) {
                    this.subjectConfirmations.add(AssertionFactory.getInstance().createSubjectConfirmation((Element)child));
                } else {
                    SAML2SDKUtils.debug.error("SubjectImpl.processElement(): unexpected subelement " + childName);
                    throw new SAML2Exception(SAML2SDKUtils.bundle.getString("unexpected_subelement"));
                }
            }
            ++nextElem;
        }
    }

    public EncryptedID getEncryptedID() {
        return this.encryptedId;
    }

    public void setEncryptedID(EncryptedID value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.encryptedId = value;
    }

    public NameID getNameID() {
        return this.nameId;
    }

    public void setNameID(NameID value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.nameId = value;
    }

    public List getSubjectConfirmation() {
        return this.subjectConfirmations;
    }

    public void setSubjectConfirmation(List confirmations) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.subjectConfirmations = confirmations;
    }

    public BaseID getBaseID() {
        return this.baseId;
    }

    public void setBaseID(BaseID value) throws SAML2Exception {
        if (!this.isMutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.baseId = value;
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws SAML2Exception {
        int length;
        StringBuffer sb = new StringBuffer(2000);
        String NS = "";
        String appendNS = "";
        if (declareNS) {
            NS = " xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"";
        }
        if (includeNSPrefix) {
            appendNS = "saml:";
        }
        sb.append("<").append(appendNS).append(SUBJECT_ELEMENT).append(NS).append(">\n");
        boolean idFound = false;
        if (this.baseId != null) {
            sb.append(this.baseId.toXMLString(includeNSPrefix, false));
            idFound = true;
        }
        if (this.nameId != null) {
            if (idFound) {
                SAML2SDKUtils.debug.error("SubjectImpl.toXMLString(): more than one types of id specified");
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("too_many_ids_specified"));
            }
            sb.append(this.nameId.toXMLString(includeNSPrefix, false));
            idFound = true;
        }
        if (this.encryptedId != null) {
            if (idFound) {
                SAML2SDKUtils.debug.error("SubjectImpl.toXMLString(): more than one types of id specified");
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("too_many_ids_specified"));
            }
            sb.append(this.encryptedId.toXMLString(includeNSPrefix, false));
            idFound = true;
        }
        if ((length = this.subjectConfirmations.size()) == 0) {
            if (!idFound) {
                SAML2SDKUtils.debug.error("SubjectImpl.toXMLString(): Need at least one id or one subject confirmation in a subject");
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("need_at_least_one_id_or_on_SubjectConfirmation"));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                SubjectConfirmation sc = (SubjectConfirmation)this.subjectConfirmations.get(i);
                sb.append(sc.toXMLString(includeNSPrefix, false));
            }
        }
        sb.append("</").append(appendNS).append(SUBJECT_ELEMENT).append(">");
        return sb.toString();
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public void makeImmutable() {
        if (this.isMutable) {
            if (this.subjectConfirmations != null) {
                int length = this.subjectConfirmations.size();
                for (int i = 0; i < length; ++i) {
                    SubjectConfirmation subjectConfirmation = (SubjectConfirmation)this.subjectConfirmations.get(i);
                    subjectConfirmation.makeImmutable();
                }
                this.subjectConfirmations = Collections.unmodifiableList(this.subjectConfirmations);
            }
            if (this.baseId != null) {
                this.baseId.makeImmutable();
            }
            if (this.nameId != null) {
                this.nameId.makeImmutable();
            }
            this.isMutable = false;
        }
    }

    public boolean isMutable() {
        return this.isMutable;
    }
}

