/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml2.assertion.impl;

import com.sun.identity.saml2.assertion.Action;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2SDKUtils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActionImpl
implements Action {
    private String action = null;
    private String namespace = null;
    private boolean mutable = true;

    private void parseElement(Element element) throws SAML2Exception {
        Node att;
        if (element == null) {
            SAML2SDKUtils.debug.message("ActionImpl.parseElement: Input is null.");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("nullInput"));
        }
        String tag = null;
        tag = element.getLocalName();
        if (tag == null || !tag.equals("Action")) {
            SAML2SDKUtils.debug.message("ActionImpl.parseElement: not Action.");
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
        }
        NamedNodeMap atts = element.getAttributes();
        if (atts != null && (att = atts.getNamedItem("Namespace")) != null) {
            this.namespace = ((Attr)att).getValue().trim();
        }
        if (this.namespace == null || this.namespace.length() == 0) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ActionImpl.parseElement: Namespace is empty or missing.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingAttribute"));
        }
        NodeList nodes = element.getChildNodes();
        int nodeCount = nodes.getLength();
        if (nodeCount > 0) {
            for (int i = 0; i < nodeCount; ++i) {
                Node currentNode = nodes.item(i);
                if (currentNode.getNodeType() != 1) continue;
                if (SAML2SDKUtils.debug.messageEnabled()) {
                    SAML2SDKUtils.debug.message("ActionImpl.parseElement: Illegal value of the element.");
                }
                throw new SAML2Exception(SAML2SDKUtils.bundle.getString("wrongInput"));
            }
        }
        this.action = XMLUtils.getElementValue((Element)element);
        if (this.action == null || this.action.trim().length() == 0) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ActionImpl.parseElement: Action value is null or empty.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingElementValue"));
        }
        this.mutable = false;
    }

    public ActionImpl() {
    }

    public ActionImpl(Element element) throws SAML2Exception {
        this.parseElement(element);
    }

    public ActionImpl(String xmlString) throws SAML2Exception {
        Document doc = XMLUtils.toDOMDocument((String)xmlString, (Debug)SAML2SDKUtils.debug);
        if (doc == null) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("errorObtainingElement"));
        }
        this.parseElement(doc.getDocumentElement());
    }

    public void makeImmutable() {
        this.mutable = false;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public String getValue() {
        return this.action;
    }

    public void setValue(String value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.action = value;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String value) throws SAML2Exception {
        if (!this.mutable) {
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("objectImmutable"));
        }
        this.namespace = value;
    }

    public String toXMLString() throws SAML2Exception {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNS, boolean declareNS) throws SAML2Exception {
        if (this.action == null || this.action.trim().length() == 0) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ActionImpl.toXMLString: Action value is null or empty.");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("emptyElementValue"));
        }
        if (this.namespace == null || this.namespace.trim().length() == 0) {
            if (SAML2SDKUtils.debug.messageEnabled()) {
                SAML2SDKUtils.debug.message("ActionImpl.toXMLString: Namespace is empty or missing");
            }
            throw new SAML2Exception(SAML2SDKUtils.bundle.getString("missingAttribute"));
        }
        StringBuffer result = new StringBuffer(1000);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "saml:";
        }
        if (declareNS) {
            uri = " xmlns:saml=\"urn:oasis:names:tc:SAML:2.0:assertion\"";
        }
        result.append("<").append(prefix).append("Action").append(uri).append(" Namespace=\"").append(this.namespace).append("\">");
        result.append(this.action);
        result.append("</").append(prefix).append("Action>");
        return result.toString();
    }
}

