/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.protocol;

import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Status {
    private StatusCode statusCode = null;
    private String statusMessage = null;
    private Element statusDetail = null;

    Status() {
    }

    public Status(Element status) throws SAMLException {
        String tag = null;
        if (status == null) {
            SAMLUtils.debug.message("Status: null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        tag = status.getLocalName();
        if (tag == null || !tag.equals("Status")) {
            SAMLUtils.debug.message("Status: wrong input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        NodeList nl = status.getChildNodes();
        int length = nl.getLength();
        for (int k = 0; k < length; ++k) {
            Node child = nl.item(k);
            String childName = child.getLocalName();
            if (childName == null) continue;
            if (childName.equals("StatusCode")) {
                if (this.statusCode != null) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Status: contained more than one <StatusCode>");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
                }
                this.statusCode = new StatusCode((Element)child);
                continue;
            }
            if (childName.equals("StatusMessage")) {
                String message = XMLUtils.getElementValue((Element)((Element)child));
                if (message == null || message.length() == 0) {
                    SAMLUtils.debug.message("Status: Empty StatusMessage.");
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("emptyElement"));
                }
                if (this.statusMessage != null) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Status: included more than one <StatusMessage>");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
                }
                this.statusMessage = message;
                continue;
            }
            if (childName.equals("StatusDetail")) {
                if (this.statusDetail != null) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Status: included more than one <StatusDetail>");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
                }
                this.statusDetail = (Element)child;
                continue;
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Status: contained wrong element:" + childName);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (this.statusCode == null) {
            SAMLUtils.debug.message("Status: missing <StatusCode>.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
    }

    public Status(StatusCode code, String message, Element detail) throws SAMLException {
        if (code == null) {
            SAMLUtils.debug.message("Status: null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        this.statusCode = code;
        if (message != null && message.length() == 0) {
            SAMLUtils.debug.message("Status: Empty StatusMessage.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("emptyElement"));
        }
        this.statusMessage = message;
        this.statusDetail = detail;
    }

    public Status(StatusCode code) throws SAMLException {
        if (code == null) {
            SAMLUtils.debug.message("Status: null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        this.statusCode = code;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public Element getStatusDetail() {
        return this.statusDetail;
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean includeNS, boolean declareNS) {
        StringBuffer xml = new StringBuffer(200);
        String prefix = "";
        String uri = "";
        if (includeNS) {
            prefix = "samlp:";
        }
        if (declareNS) {
            uri = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
        }
        xml.append("<").append(prefix).append("Status").append(uri).append(">\n").append(this.statusCode.toString(includeNS, false));
        if (this.statusMessage != null) {
            xml.append("<").append(prefix).append("StatusMessage>").append(this.statusMessage).append("</").append(prefix).append("StatusMessage>\n");
        }
        if (this.statusDetail != null) {
            xml.append("<").append(prefix).append("StatusDetail>\n");
            NodeList nl = this.statusDetail.getChildNodes();
            int len = nl.getLength();
            for (int i = 0; i < len; ++i) {
                xml.append(XMLUtils.print((Node)nl.item(i)));
            }
            xml.append("</").append(prefix).append("StatusDetail>\n");
        }
        xml.append("</").append(prefix).append("Status>\n");
        return xml.toString();
    }
}

