/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.common;

import com.sun.identity.common.PeriodicGroupRunnable;
import com.sun.identity.common.ScheduleableGroupAction;
import com.sun.identity.common.SystemConfigurationException;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.common.SystemTimerPool;
import com.sun.identity.common.TaskRunnable;
import com.sun.identity.common.TimerPool;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.SAMLClient;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AudienceRestrictionCondition;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.Condition;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtilsCommon;
import com.sun.identity.saml.plugins.PartnerAccountMapper;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.servlet.POSTCleanUpRunnable;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.encode.URLEncDec;
import com.sun.identity.shared.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SAMLUtils
extends SAMLUtilsCommon {
    public static final String HTTP_MAX_CONTENT_LENGTH = "com.sun.identity.saml.request.maxContentLength";
    public static final int defaultMaxLength = 16384;
    public static final String DEFAULT_CONTENT_LENGTH = String.valueOf(16384);
    private static int maxContentLength = 0;
    private static Map idTimeMap = Collections.synchronizedMap(new HashMap());
    private static TaskRunnable cGoThrough = null;
    private static TaskRunnable cPeriodic = null;
    private static Object ssoToken;

    private SAMLUtils() {
    }

    public static String generateAssertionID() {
        String id;
        String encodedID;
        block4: {
            encodedID = SAMLUtils.generateID();
            if (encodedID == null) {
                return null;
            }
            id = null;
            try {
                id = SystemConfigurationUtil.getServerID(SAMLServiceManager.getServerProtocol(), SAMLServiceManager.getServerHost(), Integer.parseInt(SAMLServiceManager.getServerPort()), SAMLServiceManager.getServerURI());
            }
            catch (Exception ex) {
                if (!debug.messageEnabled()) break block4;
                debug.message("SAMLUtil:generateAssertionID: exception obtain serverID:", (Throwable)ex);
            }
        }
        if (id == null) {
            return encodedID;
        }
        return encodedID + id;
    }

    public static boolean checkQuery(Element element, String queryname) {
        String tag = element.getLocalName();
        if (tag == null) {
            return false;
        }
        if (tag.equals("Query") || tag.equals("SubjectQuery")) {
            NamedNodeMap nm = element.getAttributes();
            int len = nm.getLength();
            boolean found = false;
            for (int j = 0; j < len; ++j) {
                Attr attr = (Attr)nm.item(j);
                String attrName = attr.getLocalName();
                if (attrName == null || !attrName.equals("type") || !attr.getNodeValue().equals(queryname + "Type")) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        } else if (!tag.equals(queryname)) {
            return false;
        }
        return true;
    }

    public static String generateSourceID(String siteURL) {
        if (siteURL == null || siteURL.length() == 0) {
            debug.error("SAMLUtils.genrateSourceID: empty siteURL.");
            return null;
        }
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA");
        }
        catch (Exception e) {
            debug.error("SAMLUtils.generateSourceID: Exception when generating digest:", (Throwable)e);
            return null;
        }
        md.update(SAMLUtils.stringToByteArray(siteURL));
        byte[] byteResult = md.digest();
        String result = null;
        try {
            result = Base64.encode((byte[])byteResult).trim();
        }
        catch (Exception e) {
            debug.error("SAMLUtils.generateSourceID: Exception:", (Throwable)e);
        }
        return result;
    }

    public static String generateAssertionHandle() {
        byte[] idBytes;
        String id;
        byte[] bytes;
        block5: {
            if (random == null) {
                return null;
            }
            bytes = new byte[20];
            random.nextBytes(bytes);
            id = null;
            try {
                id = SystemConfigurationUtil.getServerID(SAMLServiceManager.getServerProtocol(), SAMLServiceManager.getServerHost(), Integer.parseInt(SAMLServiceManager.getServerPort()), SAMLServiceManager.getServerURI());
            }
            catch (Exception ex) {
                if (!debug.messageEnabled()) break block5;
                debug.message("SAMLUtil:generateAssertionHandle: exception obtain serverID:", (Throwable)ex);
            }
        }
        if (id != null && (idBytes = SAMLUtils.stringToByteArray(id)).length < bytes.length) {
            for (int i = 1; i <= idBytes.length; ++i) {
                bytes[bytes.length - i] = idBytes[idBytes.length - i];
            }
        }
        return SAMLUtils.byteArrayToString(bytes);
    }

    public static byte[] hexStringToByteArray(String hexString) {
        int read = hexString.length();
        byte[] byteArray = new byte[read / 2];
        int i = 0;
        int j = 0;
        while (i < read) {
            String part = hexString.substring(i, i + 2);
            byteArray[j] = new Short(Integer.toString(Integer.parseInt(part, 16))).byteValue();
            ++i;
            ++i;
            ++j;
        }
        return byteArray;
    }

    public static String hexStringToBase64(String hexString) {
        String encodedID;
        block4: {
            int read = hexString.length();
            byte[] byteArray = new byte[read / 2];
            int i = 0;
            int j = 0;
            while (i < read) {
                String part = hexString.substring(i, i + 2);
                byteArray[j] = new Short(Integer.toString(Integer.parseInt(part, 16))).byteValue();
                ++i;
                ++i;
                ++j;
            }
            encodedID = null;
            try {
                encodedID = Base64.encode((byte[])byteArray).trim();
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block4;
                debug.message("SAMLUtil:hexStringToBase64: exception encode input:", (Throwable)e);
            }
        }
        if (debug.messageEnabled()) {
            debug.message("base 64 source id is :" + encodedID);
        }
        return encodedID;
    }

    public static SAMLServiceManager.SOAPEntry getSourceSite(String issuer) {
        if (issuer == null) {
            return null;
        }
        Map entries = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        if (entries == null) {
            debug.error("SAMLUtils.isOnPartnerURLList: PartnerURL list is null.");
            return null;
        }
        Iterator entryIter = entries.values().iterator();
        boolean found = false;
        SAMLServiceManager.SOAPEntry srcSite = null;
        String theIssuer = null;
        while (entryIter.hasNext()) {
            srcSite = (SAMLServiceManager.SOAPEntry)entryIter.next();
            if (srcSite == null || (theIssuer = srcSite.getIssuer()) == null || !theIssuer.equals(issuer)) continue;
            found = true;
            break;
        }
        if (found) {
            return srcSite;
        }
        return null;
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("usage : java SAMLUtils <host_name>");
            return;
        }
        System.out.println(SAMLUtils.generateSourceID(args[0]));
    }

    public static boolean isCorrectConfirmationMethod(SubjectConfirmation sc) {
        if (sc == null) {
            return false;
        }
        Set cmSet = sc.getConfirmationMethod();
        if (cmSet == null || cmSet.size() != 1) {
            if (debug.messageEnabled()) {
                debug.message("SAMLUtils.isCorrectConfirmationMethod: missing ConfirmationMethod in the Subject.");
            }
            return false;
        }
        String conMethod = (String)cmSet.iterator().next();
        if (conMethod == null || !conMethod.equals("urn:com:sun:identity")) {
            if (debug.messageEnabled()) {
                debug.message("SAMLUtils.isCorrectConfirmationMethod: wrong ConfirmationMethod value.");
            }
            return false;
        }
        return true;
    }

    public static boolean isAuthNAssertion(Assertion assertion) {
        if (assertion == null) {
            return false;
        }
        if (!assertion.isTimeValid() || !assertion.isSignatureValid()) {
            return false;
        }
        Set statements = assertion.getStatement();
        Statement statement = null;
        Iterator iterator = statements.iterator();
        while (iterator.hasNext()) {
            statement = (Statement)iterator.next();
            if (statement.getStatementType() != 1) continue;
            return true;
        }
        return false;
    }

    public static byte[] stringToByteArray(String input) {
        char[] chars = input.toCharArray();
        byte[] bytes = new byte[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            bytes[i] = (byte)chars[i];
        }
        return bytes;
    }

    public static String getServerID(String idTypeString) {
        if (idTypeString == null) {
            return null;
        }
        int len = idTypeString.length();
        String id = null;
        if (len >= 2) {
            id = idTypeString.substring(len - 2, len);
            return id;
        }
        return null;
    }

    public static String getServerURL(String str) {
        String id = SAMLUtils.getServerID(str);
        if (id == null) {
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("SAMLUtils.getServerURL: id=" + id);
        }
        String remoteUrl = null;
        try {
            remoteUrl = SystemConfigurationUtil.getServerFromID(id);
        }
        catch (SystemConfigurationException se) {
            if (debug.messageEnabled()) {
                debug.message("SAMLUtils.getServerURL: ServerEntryNotFoundException for " + id);
            }
            return null;
        }
        String thisUrl = SAMLServiceManager.getServerURL();
        if (debug.messageEnabled()) {
            debug.message("SAMLUtils.getServerURL: remoteUrl=" + remoteUrl + ", thisUrl=" + thisUrl);
        }
        if (remoteUrl == null || thisUrl == null || remoteUrl.equals(thisUrl)) {
            return null;
        }
        return remoteUrl;
    }

    public static String getFullServiceURL(String shortUrl) {
        String result;
        block3: {
            result = null;
            try {
                URL u = new URL(shortUrl);
                URL weburl = SystemConfigurationUtil.getServiceURL("samlassertionmanager", u.getProtocol(), u.getHost(), u.getPort(), u.getPath());
                result = weburl.toString();
                if (debug.messageEnabled()) {
                    debug.message("SAMLUtils.getFullServiceURL:full remote URL is: " + result);
                }
            }
            catch (Exception e) {
                if (!debug.warningEnabled()) break block3;
                debug.warning("SAMLUtils.getFullServiceURL:Exception:", (Throwable)e);
            }
        }
        return result;
    }

    public static void addEnvParamsFromAssertion(Map envParameters, Assertion assertion, Subject subject) {
        Set statements = assertion.getStatement();
        Statement statement = null;
        Iterator stmtIter = null;
        List attrs = null;
        Iterator attrIter = null;
        Attribute attribute = null;
        Element attrValue = null;
        List attrValues = null;
        String attrName = null;
        String attrValueString = null;
        if (statements != null && !statements.isEmpty()) {
            stmtIter = statements.iterator();
            while (stmtIter.hasNext()) {
                statement = (Statement)stmtIter.next();
                if (statement.getStatementType() != 3 || !subject.equals(((AttributeStatement)statement).getSubject())) continue;
                attrs = ((AttributeStatement)statement).getAttribute();
                attrIter = attrs.iterator();
                while (attrIter.hasNext()) {
                    attribute = (Attribute)attrIter.next();
                    try {
                        attrValues = attribute.getAttributeValue();
                    }
                    catch (Exception e) {
                        debug.error("SAMLUtils.addEnvParamsFromAssertion: cannot obtain attribute value:", (Throwable)e);
                        continue;
                    }
                    attrName = attribute.getAttributeName();
                    attrValue = (Element)attrValues.get(0);
                    if (attrValues.size() == 1 && !XMLUtils.hasElementChild((Node)attrValue)) {
                        attrValueString = XMLUtils.getElementValue((Element)attrValue);
                        try {
                            if (debug.messageEnabled()) {
                                debug.message("SAMLUtils.addEnvParamsFromAssertion: attrName = " + attrName + " attrValue = " + attrValueString);
                            }
                            envParameters.put(attrName, attrValueString);
                        }
                        catch (Exception e) {}
                        continue;
                    }
                    try {
                        envParameters.put(attrName, attrValues);
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public static int getMaxContentLength() {
        return maxContentLength;
    }

    public static void checkHTTPContentLength(HttpServletRequest request) throws ServletException {
        if (maxContentLength != 0) {
            int length = request.getContentLength();
            if (debug.messageEnabled()) {
                debug.message("HttpRequest content length= " + length);
            }
            if (length > maxContentLength) {
                if (debug.messageEnabled()) {
                    debug.message("content length too large" + length);
                }
                throw new ServletException(bundle.getString("largeContentLength"));
            }
        }
    }

    public static void postToTarget(HttpServletResponse response, List assertion, String targeturl, Map attrMap) throws IOException {
        PrintWriter out = response.getWriter();
        out.println("<HTML>");
        out.println("<HEAD>\n");
        out.println("<TITLE>Access rights validated</TITLE>\n");
        out.println("</HEAD>\n");
        out.println("<BODY Onload=\"document.forms[0].submit()\">");
        Iterator it = null;
        if (debug.messageEnabled()) {
            out.println("<H1>Access rights validated</H1>\n");
            out.println("<meta http-equiv=\"refresh\" content=\"20\">\n");
            out.println("<P>We have verified your access rights <STRONG></STRONG> according to the assertion shown below. \n");
            out.println("You are being redirected to the resource.\n");
            out.println("Please wait ......\n");
            out.println("</P>\n");
            out.println("<HR><P>\n");
            if (assertion != null) {
                it = assertion.iterator();
                while (it.hasNext()) {
                    out.println(SAMLUtils.displayXML((String)it.next()));
                }
            }
            out.println("</P>\n");
        }
        out.println("<FORM METHOD=\"POST\" ACTION=\"" + targeturl + "\">");
        if (assertion != null) {
            it = assertion.iterator();
            while (it.hasNext()) {
                out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"ASSERTION\"");
                out.println("VALUE=\"" + URLEncDec.encode((String)((String)it.next())) + "\">");
            }
        }
        if (attrMap != null && !attrMap.isEmpty()) {
            StringBuffer attrNamesSB = new StringBuffer();
            Set entrySet = attrMap.entrySet();
            Iterator iter = entrySet.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String attrName = SAMLUtils.HTMLEncode((String)entry.getKey(), '\"');
                String attrValue = SAMLUtils.HTMLEncode((String)entry.getValue(), '\"');
                out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"" + attrName + "\" VALUE=\"" + attrValue + "\">");
                if (attrNamesSB.length() > 0) {
                    attrNamesSB.append(":");
                }
                attrNamesSB.append(attrName);
            }
            out.println("<INPUT TYPE=\"HIDDEN\" NAME=\"ATTRIBUTENAMES\" VALUE=\"" + attrNamesSB + "\">");
        }
        out.println("</FORM>");
        out.println("</BODY></HTML>");
        out.close();
    }

    public static boolean postYN(String targetIn) {
        debug.message("Inside postYN()");
        if (targetIn == null || targetIn.length() == 0) {
            return false;
        }
        Set targets = (Set)SAMLServiceManager.getAttribute("iplanet-am-saml-post-to-target-urls");
        if (targets == null || targets.size() == 0) {
            return false;
        }
        URL targetUrl = null;
        try {
            targetUrl = new URL(targetIn);
        }
        catch (MalformedURLException me) {
            debug.error("SAMLUtils:postYN(): Malformed URL passed");
            return false;
        }
        String targetInHost = targetUrl.getHost();
        int targetInPort = targetUrl.getPort();
        String targetInPath = targetUrl.getPath();
        String targetToCompare = targetInHost.toLowerCase() + ":" + String.valueOf(targetInPort) + "/" + targetInPath;
        return targets.contains(targetToCompare);
    }

    public static String HTMLEncode(String srcStr, char ch) {
        int toIndex;
        if (srcStr == null) {
            return null;
        }
        int fromIndex = 0;
        StringBuffer dstSB = new StringBuffer();
        while ((toIndex = srcStr.indexOf(ch, fromIndex)) != -1) {
            dstSB.append(srcStr.substring(fromIndex, toIndex)).append("&#" + ch + ";");
            fromIndex = toIndex + 1;
        }
        dstSB.append(srcStr.substring(fromIndex));
        return dstSB.toString();
    }

    public static String displayXML(String input) {
        debug.message("In displayXML ");
        StringCharacterIterator iter = new StringCharacterIterator(input);
        StringBuffer buf = new StringBuffer();
        char c = iter.first();
        while (c != '\uffff') {
            if (c == '>') {
                buf.append("&gt;");
            } else if (c == '<') {
                buf.append("&lt;");
            } else if (c == '\n') {
                buf.append("<BR>\n");
            } else {
                buf.append(c);
            }
            c = iter.next();
        }
        return buf.toString();
    }

    public static List getListOfAssertions(List assertions) {
        ArrayList<Assertion> returnAssertions;
        block4: {
            returnAssertions = new ArrayList<Assertion>();
            try {
                if (assertions != null) {
                    Iterator it = assertions.iterator();
                    while (it.hasNext()) {
                        Document doc = XMLUtils.toDOMDocument((String)((String)it.next()), (Debug)debug);
                        Element root = doc.getDocumentElement();
                        if (root == null) continue;
                        Assertion assertion = new Assertion(root);
                        returnAssertions.add(assertion);
                    }
                }
            }
            catch (Exception e) {
                if (!debug.messageEnabled()) break block4;
                debug.message("SAMLUtils.getListOfAssertions : Exception : ", (Throwable)e);
            }
        }
        return returnAssertions;
    }

    public static byte[] getResponseBytes(Response samlResponse) throws SAMLException {
        byte[] ret = null;
        try {
            ret = samlResponse.toString(true, true, true).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException ue) {
            if (debug.messageEnabled()) {
                debug.message("getResponseBytes : ", (Throwable)ue);
            }
            throw new SAMLException(ue.getMessage());
        }
        return ret;
    }

    public static Response getResponse(byte[] bytes) {
        Response temp = null;
        if (bytes == null) {
            return null;
        }
        try {
            temp = Response.parseXML(new ByteArrayInputStream(bytes));
        }
        catch (SAMLException se) {
            debug.error("getResponse : ", (Throwable)((Object)se));
        }
        return temp;
    }

    public static boolean verifyResponse(Response response, String requestUrl, HttpServletRequest request) {
        if (!response.isSignatureValid()) {
            debug.message("verifyResponse: Response's signature is invalid.");
            return false;
        }
        String recipient = response.getRecipient();
        if (recipient == null || recipient.length() == 0 || !SAMLUtils.equalURL(recipient, requestUrl) && !SAMLUtils.equalURL(recipient, SAMLUtils.getLBURL(requestUrl, request))) {
            debug.error("verifyResponse : Incorrect Recipient.");
            return false;
        }
        if (!response.getStatus().getStatusCode().getValue().endsWith(":Success")) {
            debug.error("verifyResponse : Incorrect StatusCode value.");
            return false;
        }
        return true;
    }

    private static String getLBURL(String requestUrl, HttpServletRequest request) {
        String host = request.getHeader("host");
        if (host == null) {
            return requestUrl;
        }
        int index = requestUrl.indexOf("//");
        if (index == -1) {
            return requestUrl;
        }
        StringBuffer sb = new StringBuffer(200);
        sb.append(requestUrl.substring(0, index + 2)).append(host);
        String rest = requestUrl.substring(index + 2, requestUrl.length());
        index = rest.indexOf("/");
        if (index != -1) {
            sb.append(rest.substring(index, rest.length()));
        }
        if (debug.messageEnabled()) {
            debug.message("getLBURL: LBURL = " + sb.toString());
        }
        return sb.toString().trim();
    }

    public static List getStrAssertions(List assertions) {
        ArrayList<String> returnAssertions = new ArrayList<String>();
        if (assertions != null) {
            Iterator it = assertions.iterator();
            while (it.hasNext()) {
                returnAssertions.add(((Assertion)it.next()).toString(true, true));
            }
        }
        return returnAssertions;
    }

    public static boolean verifySignature(Response samlResponse) {
        return samlResponse == null || samlResponse.isSigned() && samlResponse.isSignatureValid();
    }

    public static Map getAttributeMap(SAMLServiceManager.SOAPEntry partnerdest, List assertions, Subject subject, String target) throws Exception {
        String srcID = partnerdest.getSourceID();
        String name = null;
        Map<String, String> attrMap = new HashMap<String, String>();
        PartnerAccountMapper paMapper = partnerdest.getPartnerAccountMapper();
        if (paMapper != null) {
            Map map = paMapper.getUser(assertions, srcID, target);
            name = (String)map.get("name");
            attrMap = (Map)map.get("attribute");
        }
        if (attrMap == null) {
            attrMap = new HashMap();
        }
        attrMap.put("USER_NAME", name);
        if (debug.messageEnabled()) {
            debug.message("getAttributeMap : name = " + name + ", attrMap = " + attrMap);
        }
        return attrMap;
    }

    public static Map verifyAssertionAndGetSSMap(Response response) {
        Subject subject = null;
        SAMLServiceManager.SOAPEntry srcSite = null;
        List assertions = response.getAssertion();
        Iterator iter = assertions.iterator();
        Assertion assertion = null;
        String aIDString = null;
        String issuer = null;
        Iterator stmtIter = null;
        Statement statement = null;
        int stmtType = -1;
        Subject sub = null;
        SubjectConfirmation subConf = null;
        Set confMethods = null;
        String confMethod = null;
        Date date = null;
        while (iter.hasNext()) {
            Conditions conds;
            assertion = (Assertion)iter.next();
            aIDString = assertion.getAssertionID();
            if (idTimeMap.containsKey(aIDString)) {
                debug.error("verifyAssertion AndGetSSMap: Assertion: " + aIDString + " is used.");
                return null;
            }
            issuer = assertion.getIssuer();
            srcSite = SAMLUtils.getSourceSite(issuer);
            if (srcSite == null) {
                debug.error("verifyAsserti onAndGetSSMap: issuer is not on the Partner list.");
                return null;
            }
            if (!assertion.isSignatureValid()) {
                debug.error("verifyAssertion AndGetSSMap: assertion's signature is not valid.");
                return null;
            }
            if (!assertion.isTimeValid()) {
                debug.error("verifyAssertion AndGetSSMap: assertion's time is not valid.");
                return null;
            }
            stmtIter = assertion.getStatement().iterator();
            while (stmtIter.hasNext()) {
                statement = (Statement)stmtIter.next();
                stmtType = statement.getStatementType();
                if (stmtType != 1 && stmtType != 3 && stmtType != 2) continue;
                sub = ((SubjectStatement)statement).getSubject();
                subConf = sub.getSubjectConfirmation();
                if (subConf == null || (confMethods = subConf.getConfirmationMethod()) == null || confMethods.size() != 1) {
                    debug.error("verify AssertionAndGetSSMap: missing or extra ConfirmationMethod.");
                    return null;
                }
                confMethod = (String)confMethods.iterator().next();
                if (confMethod == null || !confMethod.equals("urn:oasis:names:tc:SAML:1.0:cm:bearer")) {
                    debug.error("verify AssertionAndGetSSMap:wrong ConfirmationMethod.");
                    return null;
                }
                if (stmtType != 1 || subject != null) continue;
                subject = sub;
            }
            if (debug.messageEnabled()) {
                debug.message("Adding " + aIDString + " to idTimeMap.");
            }
            if ((conds = assertion.getConditions()) != null && (date = conds.getNotOnorAfter()) != null) {
                cGoThrough.addElement((Object)aIDString);
                idTimeMap.put(aIDString, new Long(date.getTime()));
                continue;
            }
            cPeriodic.addElement((Object)aIDString);
            idTimeMap.put(aIDString, aIDString);
        }
        if (subject == null || srcSite == null) {
            debug.error("verifyAssertion AndGetSSMap: couldn't find Subject.");
            return null;
        }
        HashMap<String, Object> ssMap = new HashMap<String, Object>();
        ssMap.put("subject", subject);
        ssMap.put("sourceSite", srcSite);
        ssMap.put("assertion", assertions);
        return ssMap;
    }

    private static boolean checkCondition(Assertion assertion) throws IOException {
        if (assertion == null) {
            return false;
        }
        if (!assertion.isSignatureValid()) {
            debug.error(bundle.getString("assertionSignatureNotValid"));
            return false;
        }
        if (!assertion.isTimeValid()) {
            debug.error(bundle.getString("assertionTimeNotValid"));
            return false;
        }
        Conditions cnds = assertion.getConditions();
        Set audienceCnd = new HashSet();
        audienceCnd = cnds.getAudienceRestrictionCondition();
        Iterator it = null;
        if (audienceCnd != null && !audienceCnd.isEmpty()) {
            it = audienceCnd.iterator();
            while (it.hasNext()) {
                if (((AudienceRestrictionCondition)it.next()).evaluate() == Condition.INDETERMINATE) {
                    if (!debug.messageEnabled()) continue;
                    debug.message("Audience RestrictionConditions is indeterminate.");
                    continue;
                }
                debug.error("Failed AudienceRestrictionCondition");
                return false;
            }
        }
        return true;
    }

    public static Subject examAssertions(List assertions) throws IOException {
        if (assertions == null) {
            return null;
        }
        boolean validation = false;
        Subject subject = null;
        Iterator iter = assertions.iterator();
        while (iter.hasNext()) {
            Assertion assertion = (Assertion)iter.next();
            if (!SAMLUtils.checkCondition(assertion)) {
                return null;
            }
            debug.message("Passed checking Conditions!");
            Set statements = new HashSet();
            statements = assertion.getStatement();
            if (statements == null || statements.isEmpty()) {
                debug.error(bundle.getString("noStatement"));
                return null;
            }
            Iterator iterator = statements.iterator();
            while (iterator.hasNext()) {
                Statement statement = (Statement)iterator.next();
                subject = ((SubjectStatement)statement).getSubject();
                SubjectConfirmation sc = subject.getSubjectConfirmation();
                Set cm = new HashSet();
                cm = sc.getConfirmationMethod();
                if (cm == null || cm.isEmpty()) {
                    debug.error("Subject confirmation method is null");
                    return null;
                }
                String conMethod = (String)cm.iterator().next();
                if (conMethod != null && assertion.getMajorVersion() == 1 && (assertion.getMinorVersion() == 1 && conMethod.equals(SAMLConstants.CONFIRMATION_METHOD_ARTIFACT) || assertion.getMinorVersion() == 0 && conMethod.equals("urn:oasis:names:tc:SAML:1.0:cm:artifact-01"))) {
                    if (debug.messageEnabled()) {
                        debug.message("Correct Confirmation method");
                    }
                } else {
                    debug.error("Wrong Confirmation Method.");
                    return null;
                }
                if (!(statement instanceof AuthenticationStatement)) continue;
                validation = true;
            }
        }
        if (!validation) {
            debug.error(bundle.getString("noSSOAssertion"));
            return null;
        }
        return subject;
    }

    public static boolean checkSignatureValid(String xmlString, String idAttribute, String issuer) {
        SAMLServiceManager.SOAPEntry srcSite;
        String certAlias = null;
        boolean valid = true;
        Map entries = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
        if (entries != null && (srcSite = (SAMLServiceManager.SOAPEntry)entries.get(issuer)) != null) {
            certAlias = srcSite.getCertAlias();
        }
        try {
            XMLSignatureManager manager = XMLSignatureManager.getInstance();
            valid = manager.verifyXMLSignature(xmlString, idAttribute, certAlias);
        }
        catch (Exception e) {
            debug.warning("SAMLUtils.checkSignatureValid: signature validation exception", (Throwable)e);
            valid = false;
        }
        if (!valid && debug.messageEnabled()) {
            debug.message("SAMLUtils.checkSignatureValid: Couldn't verify signature.");
        }
        return valid;
    }

    public static void setMimeHeaders(MimeHeaders headers, HttpServletResponse response) {
        if (headers == null || response == null) {
            debug.message("SAMLUtils.setMimeHeaders : null input");
            return;
        }
        Iterator iter = headers.getAllHeaders();
        while (iter.hasNext()) {
            MimeHeader header = (MimeHeader)iter.next();
            String[] values = headers.getHeader(header.getName());
            if (values.length == 1) {
                response.setHeader(header.getName(), header.getValue());
                continue;
            }
            StringBuffer concat = new StringBuffer();
            int i = 0;
            while (i < values.length) {
                if (i != 0) {
                    concat.append(',');
                }
                concat.append(values[i++]);
            }
            response.setHeader(header.getName(), concat.toString());
        }
    }

    public static MimeHeaders getMimeHeaders(HttpServletRequest req) {
        MimeHeaders headers = new MimeHeaders();
        if (req == null) {
            debug.message("SAMLUtils.getMimeHeaders: null input");
            return headers;
        }
        Enumeration enumerator = req.getHeaderNames();
        while (enumerator.hasMoreElements()) {
            String headerName = (String)enumerator.nextElement();
            String headerValue = req.getHeader(headerName);
            StringTokenizer values = new StringTokenizer(headerValue, ",");
            while (values.hasMoreTokens()) {
                headers.addHeader(headerName, values.nextToken().trim());
            }
        }
        return headers;
    }

    public static String getLoginRedirectURL(HttpServletRequest req) {
        String qs = req.getQueryString();
        String gotoUrl = req.getRequestURL().toString();
        String key = null;
        if (qs != null && qs.length() > 0) {
            gotoUrl = gotoUrl + "?" + qs;
            int startIdx = -1;
            int endIdx = -1;
            StringBuffer result = new StringBuffer();
            startIdx = qs.indexOf((String)SAMLServiceManager.getAttribute("iplanet-am-saml-target-specifier"));
            if (startIdx > 0) {
                result.append(qs.substring(0, startIdx - 1));
            }
            if ((endIdx = qs.indexOf("&", startIdx)) != -1) {
                if (startIdx == 0) {
                    result.append(qs.substring(endIdx + 1));
                } else {
                    result.append(qs.substring(endIdx));
                }
            }
            key = result.toString();
        }
        String reqUrl = SAMLServiceManager.getServerURL();
        String redirectUrl = null;
        redirectUrl = key == null || key.equals("") ? reqUrl + "/UI/Login?goto=" + URLEncDec.encode((String)gotoUrl) : reqUrl + "/UI/Login?" + key + "&goto=" + URLEncDec.encode((String)gotoUrl);
        if (debug.messageEnabled()) {
            debug.message("Redirect to auth login via:" + redirectUrl);
        }
        return redirectUrl;
    }

    public static Map processArtifact(String[] artifact, String target) throws SAMLException {
        List assts = null;
        Subject assertionSubject = null;
        AssertionArtifact firstArtifact = null;
        Map sessMap = null;
        try {
            assts = SAMLClient.artifactQueryHandler(artifact, null);
            assertionSubject = SAMLUtils.examAssertions(assts);
            if (assertionSubject == null) {
                return null;
            }
            firstArtifact = new AssertionArtifact(artifact[0]);
            String sid = firstArtifact.getSourceID();
            Map partner = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
            if (partner == null) {
                throw new SAMLException(bundle.getString("nullPartnerUrl"));
            }
            SAMLServiceManager.SOAPEntry partnerdest = (SAMLServiceManager.SOAPEntry)partner.get(sid);
            if (partnerdest == null) {
                throw new SAMLException(bundle.getString("failedAccountMapping"));
            }
            sessMap = SAMLUtils.getAttributeMap(partnerdest, assts, assertionSubject, target);
        }
        catch (Exception se) {
            debug.error("SAMLUtils.processArtifact :", (Throwable)se);
            throw new SAMLException(bundle.getString("failProcessArtifact"));
        }
        return sessMap;
    }

    public static Object generateSession(HttpServletRequest request, HttpServletResponse response, Map attrMap) throws SAMLException {
        HashMap<String, String> sessionInfoMap = new HashMap<String, String>();
        sessionInfoMap.put("realm", "/");
        sessionInfoMap.put("principalName", (String)attrMap.get("USER_NAME"));
        Object session = null;
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            session = sessionProvider.createSession(sessionInfoMap, request, response, null);
            SAMLUtils.setAttrMapInSession(sessionProvider, attrMap, session);
        }
        catch (SessionException se) {
            throw new SAMLException((Throwable)((Object)se));
        }
        return session;
    }

    public static Map processResponse(Response samlResponse, String target) throws SAMLException {
        boolean isSignedandValid;
        List assertions = null;
        SAMLServiceManager.SOAPEntry partnerdest = null;
        Subject assertionSubject = null;
        if (samlResponse.isSigned() && !(isSignedandValid = SAMLUtils.verifySignature(samlResponse))) {
            throw new SAMLException(bundle.getString("invalidResponse"));
        }
        Map ssMap = SAMLUtils.verifyAssertionAndGetSSMap(samlResponse);
        if (debug.messageEnabled()) {
            debug.message("processResponse: ssMap = " + ssMap);
        }
        if (ssMap == null) {
            throw new SAMLException(bundle.getString("invalidAssertion"));
        }
        assertionSubject = (Subject)ssMap.get("subject");
        if (assertionSubject == null) {
            throw new SAMLException(bundle.getString("nullSubject"));
        }
        partnerdest = (SAMLServiceManager.SOAPEntry)ssMap.get("sourceSite");
        if (partnerdest == null) {
            throw new SAMLException(bundle.getString("failedAccountMapping"));
        }
        assertions = (List)ssMap.get("assertion");
        Map sessMap = null;
        try {
            sessMap = SAMLUtils.getAttributeMap(partnerdest, assertions, assertionSubject, target);
        }
        catch (Exception se) {
            debug.error("SAMLUtils.processResponse :", (Throwable)se);
            throw new SAMLException(bundle.getString("failProcessResponse"));
        }
        return sessMap;
    }

    private static void setAttrMapInSession(SessionProvider sessionProvider, Map attrMap, Object session) throws SessionException {
        if (attrMap != null && !attrMap.isEmpty()) {
            Set entrySet = attrMap.entrySet();
            Iterator iter = entrySet.iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String attrName = (String)entry.getKey();
                String attrValues = (String)entry.getValue();
                if (attrName.equals("") || attrValues.equals("")) continue;
                String[] attrValueArray = new String[]{attrValues};
                sessionProvider.setProperty(session, attrName, attrValueArray);
                if (!debug.messageEnabled()) continue;
                debug.message("SAMLUtils.setAttrMapInSessioin: AttrMap:" + attrName + " , " + attrValues);
            }
        }
    }

    private static boolean equalURL(String url1, String url2) {
        try {
            int port2;
            URL u1 = new URL(url1);
            URL u2 = new URL(url2);
            int port1 = u1.getPort();
            if (port1 == -1) {
                port1 = u1.getDefaultPort();
            }
            if ((port2 = u2.getPort()) == -1) {
                port2 = u2.getDefaultPort();
            }
            return u1.getProtocol().equalsIgnoreCase(u2.getProtocol()) && u1.getHost().equalsIgnoreCase(u2.getHost()) && port1 == port2 && u1.getPath().equalsIgnoreCase(u2.getPath());
        }
        catch (MalformedURLException m) {
            debug.message("Error in SAMLUtils.equalURL", (Throwable)m);
            return false;
        }
    }

    static {
        if (SystemConfigurationUtil.isServerMode()) {
            long period = (Integer)SAMLServiceManager.getAttribute("iplanet-am-saml-cleanup-interval") * 1000;
            cGoThrough = new POSTCleanUpRunnable(period, idTimeMap);
            TimerPool timerPool = SystemTimerPool.getTimerPool();
            timerPool.schedule(cGoThrough, new Date((System.currentTimeMillis() + period) / 1000L * 1000L));
            ScheduleableGroupAction periodicAction = new ScheduleableGroupAction(){

                public void doGroupAction(Object obj) {
                    idTimeMap.remove(obj);
                }
            };
            cPeriodic = new PeriodicGroupRunnable(periodicAction, period, 180000L, true);
            timerPool.schedule(cPeriodic, new Date((System.currentTimeMillis() + period) / 1000L * 1000L));
        }
        try {
            maxContentLength = Integer.parseInt(SystemConfigurationUtil.getProperty(HTTP_MAX_CONTENT_LENGTH, DEFAULT_CONTENT_LENGTH));
        }
        catch (NumberFormatException ne) {
            debug.error("Wrong format of SAML request max content length. Take default value.");
            maxContentLength = 16384;
        }
    }
}

