/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml;

import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.AssertionManagerClient;
import com.sun.identity.saml.AssertionManagerIF;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class AssertionManagerImpl
implements AssertionManagerIF {
    private static AssertionManager assertionManager;
    private static Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkInitialization() throws SAMLException {
        if (assertionManager == null) {
            Object object = lock;
            synchronized (object) {
                if (assertionManager == null) {
                    try {
                        assertionManager = AssertionManager.getInstance();
                    }
                    catch (SAMLException samle) {
                        SAMLUtils.debug.error("AssertionManagerImpl: Unable to get AssertionManager", (Throwable)((Object)samle));
                        throw samle;
                    }
                }
            }
        }
    }

    public void checkForLocal() {
        AssertionManagerClient.isLocal = true;
    }

    public String createAssertion(String ssoToken) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        Object token = null;
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            token = sessionProvider.getSession(ssoToken);
        }
        catch (SessionException ssoe) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManagerImpl:createAssertion(SSO) " + (Object)((Object)ssoe));
            }
            throw new SAMLException(ssoe.getMessage());
        }
        Assertion a = assertionManager.createAssertion(token);
        return a.toString(true, true);
    }

    public String createAssertion(String ssoToken, List attributes) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        Object token = null;
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            token = sessionProvider.getSession(ssoToken);
        }
        catch (SessionException ssoe) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManagerImpl:createAssertion(SSO + attrs) " + (Object)((Object)ssoe));
            }
            throw new SAMLException(ssoe.getMessage());
        }
        LinkedList<Attribute> ll = new LinkedList<Attribute>();
        Iterator iter = attributes.iterator();
        while (iter.hasNext()) {
            ll.add(new Attribute(XMLUtils.toDOMDocument((String)((String)iter.next()), (Debug)SAMLUtils.debug).getDocumentElement()));
        }
        Assertion a = assertionManager.createAssertion(token, ll);
        return a.toString(true, true);
    }

    public String createAssertionArtifact(String assertion, String target) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        Assertion a = new Assertion(XMLUtils.toDOMDocument((String)assertion, (Debug)SAMLUtils.debug).getDocumentElement());
        AssertionArtifact aa = assertionManager.createAssertionArtifact(a, SAMLUtils.byteArrayToString(Base64.decode((String)target)));
        return aa.getAssertionArtifact();
    }

    public String getAssertion(String artifact, Set destID) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        HashSet<String> destSet = new HashSet<String>();
        Iterator it = destID.iterator();
        while (it.hasNext()) {
            destSet.add(SAMLUtils.byteArrayToString(Base64.decode((String)((String)it.next()))));
        }
        Assertion a = assertionManager.getAssertion(new AssertionArtifact(artifact), destSet);
        return a.toString(true, true);
    }

    public String getAssertion(String artifact, String destID) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        Assertion a = assertionManager.getAssertion(new AssertionArtifact(artifact), SAMLUtils.byteArrayToString(Base64.decode((String)destID)));
        return a.toString(true, true);
    }

    public String getAssertionByIdRef(String idref, Set destID) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        HashSet<String> destSet = new HashSet<String>();
        Iterator it = destID.iterator();
        while (it.hasNext()) {
            destSet.add(SAMLUtils.byteArrayToString(Base64.decode((String)((String)it.next()))));
        }
        Assertion a = assertionManager.getAssertion(new AssertionIDReference(idref), destSet);
        return a.toString(true, true);
    }

    public String getAssertionByIdRef(String idref, String destID) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        Assertion a = assertionManager.getAssertion(new AssertionIDReference(idref), SAMLUtils.byteArrayToString(Base64.decode((String)destID)));
        return a.toString(true, true);
    }

    public String getAssertionByIdRefToken(String idref, String ssoToken) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        Object token = null;
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            token = sessionProvider.getSession(ssoToken);
        }
        catch (SessionException ssoe) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManagerImpl:getAssertionByIdRefToken: " + (Object)((Object)ssoe));
            }
            throw new SAMLException(ssoe.getMessage());
        }
        Assertion a = assertionManager.getAssertion(new AssertionIDReference(idref), token);
        return a.toString(true, true);
    }

    public Set getAssertionArtifacts(String ssoToken) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            Object token = sessionProvider.getSession(ssoToken);
            return assertionManager.getAssertionArtifacts(token);
        }
        catch (SessionException ssoe) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManagerImpl:getAssertionArtifacts: " + (Object)((Object)ssoe));
            }
            throw new SAMLException(ssoe.getMessage());
        }
    }

    public Set getAssertions(String ssoToken) throws SAMLException {
        AssertionManagerImpl.checkInitialization();
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            Object token = sessionProvider.getSession(ssoToken);
            return assertionManager.getAssertions(token);
        }
        catch (SessionException ssoe) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AssertionManagerImpl:getAssertions: " + (Object)((Object)ssoe));
            }
            throw new SAMLException(ssoe.getMessage());
        }
    }

    static {
        lock = new Object();
    }
}

