/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.jaxrpc.JAXRPCHelper;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import com.sun.identity.shared.xml.XMLUtils;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class AssertionManagerClient {
    private static String SERVICE_NAME = "samlassertionmanager";
    static boolean checkedForLocal;
    static boolean isLocal;
    private boolean useLocal;
    private static SOAPClient remoteStub;
    private static AssertionManager assertionManager;
    private SOAPClient stub;

    public AssertionManagerClient() throws SAMLException {
        if (!checkedForLocal) {
            try {
                remoteStub = AssertionManagerClient.getServiceEndPoint(SystemConfigurationUtil.getProperty("com.iplanet.am.server.protocol"), SystemConfigurationUtil.getProperty("com.iplanet.am.server.host"), SystemConfigurationUtil.getProperty("com.iplanet.am.server.port"), SystemConfigurationUtil.getProperty("com.iplanet.am.services.deploymentDescriptor"));
                remoteStub.send("checkForLocal", null, null, null);
                if (isLocal) {
                    SAMLUtils.debug.warning("AMC(): Using local service");
                    assertionManager = AssertionManager.getInstance();
                }
                checkedForLocal = true;
            }
            catch (Exception e) {
                if (SAMLUtils.debug.warningEnabled()) {
                    SAMLUtils.debug.warning("AssertionManagerClient()Exception", (Throwable)e);
                }
                throw new SAMLException(e.getMessage());
            }
        }
        if (isLocal) {
            this.useLocal = true;
        } else {
            this.stub = remoteStub;
        }
    }

    public AssertionManagerClient(String url) throws SAMLException {
        try {
            String[] urls = new String[]{url};
            this.stub = new SOAPClient(urls);
            this.useLocal = false;
        }
        catch (Exception e) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AssertionManagerClient() Exception", (Throwable)e);
            }
            throw new SAMLException(e.getMessage());
        }
    }

    public AssertionManagerClient(String[] urls) throws SAMLException {
        try {
            this.stub = new SOAPClient(urls);
            this.useLocal = false;
        }
        catch (Exception e) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AssertionManagerClient() Exception", (Throwable)e);
            }
            throw new SAMLException(e.getMessage());
        }
    }

    private static SOAPClient getServiceEndPoint(String protocol, String hostname, String port, String uri) throws Exception {
        URL weburl = SystemConfigurationUtil.getServiceURL(SERVICE_NAME, protocol, hostname, Integer.parseInt(port), uri);
        String iurl = weburl.toString();
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("AssertionManagerClient with URL: " + iurl);
        }
        String[] urls = new String[]{iurl};
        return new SOAPClient(urls);
    }

    private static SOAPClient getRemoteStub() throws SAMLException {
        SOAPClient remoteStub = null;
        try {
            URL u = new URL(JAXRPCHelper.getValidURL((String)SERVICE_NAME));
            remoteStub = AssertionManagerClient.getServiceEndPoint(u.getProtocol(), u.getHost(), Integer.toString(u.getPort()), u.getPath());
            remoteStub.send("checkForLocal", null, null, null);
        }
        catch (Exception ee) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:getRemoteStub: generic error: ", (Throwable)ee);
            }
            throw new SAMLException(ee.getMessage());
        }
        return remoteStub;
    }

    public Assertion createAssertion(Object token) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.createAssertion(token);
        }
        String assertion = null;
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            assertion = (String)this.stub.send("createAssertion", sessionProvider.getSessionID(token), null);
            return new Assertion(XMLUtils.toDOMDocument((String)assertion, (Debug)SAMLUtils.debug).getDocumentElement());
        }
        catch (Exception re) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:createAssertion(SSO)", (Throwable)re);
            }
            throw new SAMLException(re.getMessage());
        }
    }

    public Assertion createAssertion(Object token, List attributes) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.createAssertion(token, attributes);
        }
        if (attributes == null || attributes.isEmpty()) {
            return this.createAssertion(token);
        }
        String assertion = null;
        try {
            LinkedList<String> attrs = new LinkedList<String>();
            Iterator iter = attributes.iterator();
            while (iter.hasNext()) {
                Attribute attribute = (Attribute)iter.next();
                attrs.add(attribute.toString(true, true));
            }
            SessionProvider sessionProvider = SessionManager.getProvider();
            Object[] args = new Object[]{sessionProvider.getSessionID(token), attrs};
            assertion = (String)this.stub.send("createAssertion", args, null, null);
            return new Assertion(XMLUtils.toDOMDocument((String)assertion, (Debug)SAMLUtils.debug).getDocumentElement());
        }
        catch (Exception re) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:createAssertion(SSO, attrs)", (Throwable)re);
            }
            throw new SAMLException(re.getMessage());
        }
    }

    public AssertionArtifact createAssertionArtifact(Assertion assertion, String target) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.createAssertionArtifact(assertion, target);
        }
        String aa = null;
        try {
            Object[] args = new Object[]{assertion.toString(true, true), Base64.encode((byte[])SAMLUtils.stringToByteArray(target))};
            aa = (String)this.stub.send("createAssertionArtifact", args, null, null);
            return new AssertionArtifact(aa);
        }
        catch (Exception re) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:createAssertionArtifact:", (Throwable)re);
            }
            throw new SAMLException(re.getMessage());
        }
    }

    public Assertion getAssertion(AssertionIDReference idRef, Set destID) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertion(idRef, destID);
        }
        String assertion = null;
        try {
            HashSet<String> destSet = new HashSet<String>();
            if (destID != null && !destID.isEmpty()) {
                Iterator it = destID.iterator();
                while (it.hasNext()) {
                    destSet.add(Base64.encode((byte[])SAMLUtils.stringToByteArray((String)it.next())));
                }
            }
            Object[] args = new Object[]{idRef.getAssertionIDReference(), destSet};
            assertion = (String)this.stub.send("getAssertionByIdRef", args, null, null);
            return new Assertion(XMLUtils.toDOMDocument((String)assertion, (Debug)SAMLUtils.debug).getDocumentElement());
        }
        catch (Exception re) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:getAssertion: " + idRef, (Throwable)re);
            }
            throw new SAMLException(re.getMessage());
        }
    }

    public Assertion getAssertion(AssertionIDReference idRef, String destID) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertion(idRef, destID);
        }
        String assertion = null;
        try {
            if (destID == null || destID.length() == 0) {
                destID = " ";
            }
            Object[] args = new Object[]{idRef.getAssertionIDReference(), Base64.encode((byte[])SAMLUtils.stringToByteArray(destID))};
            assertion = (String)this.stub.send("getAssertionByIdRef", args, null, null);
            return new Assertion(XMLUtils.toDOMDocument((String)assertion, (Debug)SAMLUtils.debug).getDocumentElement());
        }
        catch (Exception re) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:getAssertion: " + idRef, (Throwable)re);
            }
            throw new SAMLException(re.getMessage());
        }
    }

    public Assertion getAssertion(AssertionArtifact artifact, Set destID) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertion(artifact, destID);
        }
        String assertion = null;
        try {
            if (destID == null || destID.isEmpty()) {
                SAMLUtils.debug.error("AssertionManagerClient:getAssertion(AssertionArtifact, Set): destID set is null");
                throw new SAMLException("nullInput");
            }
            HashSet<String> destSet = new HashSet<String>();
            Iterator it = destID.iterator();
            while (it.hasNext()) {
                destSet.add(Base64.encode((byte[])SAMLUtils.stringToByteArray((String)it.next())));
            }
            Object[] args = new Object[]{artifact.getAssertionArtifact(), destSet};
            assertion = (String)this.stub.send("getAssertion", args, null, null);
            return new Assertion(XMLUtils.toDOMDocument((String)assertion, (Debug)SAMLUtils.debug).getDocumentElement());
        }
        catch (Exception re) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:getAssertion: " + artifact, (Throwable)re);
            }
            throw new SAMLException(re.getMessage());
        }
    }

    protected Assertion getAssertion(AssertionArtifact artifact, String destID) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertion(artifact, destID);
        }
        String assertion = null;
        try {
            Object[] args = new Object[]{artifact.getAssertionArtifact(), Base64.encode((byte[])SAMLUtils.stringToByteArray(destID))};
            assertion = (String)this.stub.send("getAssertion", args, null, null);
            return new Assertion(XMLUtils.toDOMDocument((String)assertion, (Debug)SAMLUtils.debug).getDocumentElement());
        }
        catch (Exception re) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:getAssertion: " + artifact, (Throwable)re);
            }
            throw new SAMLException(re.getMessage());
        }
    }

    public Assertion getAssertion(AssertionIDReference idRef, Object token) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertion(idRef, token);
        }
        String assertion = null;
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            Object[] args = new Object[]{idRef.getAssertionIDReference(), sessionProvider.getSessionID(token)};
            assertion = (String)this.stub.send("getAssertionByIdRefToken", args, null, null);
            return new Assertion(XMLUtils.toDOMDocument((String)assertion, (Debug)SAMLUtils.debug).getDocumentElement());
        }
        catch (Exception re) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:getAssertion: " + idRef, (Throwable)re);
            }
            throw new SAMLException(re.getMessage());
        }
    }

    public Set getAssertionArtifacts(Object token) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertionArtifacts(token);
        }
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            return (Set)this.stub.send("getAssertionArtifacts", sessionProvider.getSessionID(token), null);
        }
        catch (Exception re) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:getAssertionArtifacts: ", (Throwable)re);
            }
            throw new SAMLException(re.getMessage());
        }
    }

    public Set getAssertions(Object token) throws SAMLException {
        if (this.useLocal) {
            return assertionManager.getAssertions(token);
        }
        try {
            SessionProvider sessionProvider = SessionManager.getProvider();
            return (Set)this.stub.send("getAssertions", sessionProvider.getSessionID(token), null);
        }
        catch (Exception re) {
            if (SAMLUtils.debug.warningEnabled()) {
                SAMLUtils.debug.warning("AMC:getAssertions: ", (Throwable)re);
            }
            throw new SAMLException(re.getMessage());
        }
    }
}

