/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.multiprotocol;

import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.multiprotocol.MultiProtocolUtils;
import com.sun.identity.multiprotocol.SingleLogoutHandler;
import com.sun.identity.multiprotocol.SingleLogoutManager;
import com.sun.identity.plugin.session.SessionException;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.plugin.session.SessionProvider;
import com.sun.identity.saml2.common.SAML2Exception;
import com.sun.identity.saml2.common.SAML2Utils;
import com.sun.identity.saml2.jaxb.entityconfig.IDPSSOConfigElement;
import com.sun.identity.saml2.jaxb.entityconfig.SPSSOConfigElement;
import com.sun.identity.saml2.jaxb.metadata.SPSSODescriptorElement;
import com.sun.identity.saml2.meta.SAML2MetaManager;
import com.sun.identity.saml2.profile.IDPCache;
import com.sun.identity.saml2.profile.IDPSession;
import com.sun.identity.saml2.profile.LogoutUtil;
import com.sun.identity.saml2.profile.NameIDandSPpair;
import com.sun.identity.shared.debug.Debug;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SAML2SingleLogoutHandler
implements SingleLogoutHandler {
    private Debug debug = null;

    public SAML2SingleLogoutHandler() {
        SingleLogoutManager.getInstance();
        this.debug = SingleLogoutManager.debug;
    }

    public int doIDPSingleLogout(Set userSession, String userID, HttpServletRequest request, HttpServletResponse response, boolean isSOAPInitiated, boolean isIDPInitiated, String protocol, String realm, String idpEntityID, String spEntityID, String relayState, String singleLogoutRequestXML, String singleLogoutResponseXML, int currentStatus) throws Exception {
        SingleLogoutManager.getInstance();
        SingleLogoutManager.debug.message("SAML2SingleLogoutHandler.doIDPSingleLogout : start");
        if (!this.isSessionUsedInSAML2(userSession, userID)) {
            this.debug.message("SAML2SingleLogoutHander.doIDPSLO : no action");
            return 4;
        }
        if (isSOAPInitiated) {
            SAML2MetaManager saml2Manager = new SAML2MetaManager();
            String idpMetaAlias = this.findIDPMetaAlias(idpEntityID, spEntityID, realm, protocol, saml2Manager);
            if (idpMetaAlias == null) {
                return 4;
            }
            if (this.debug.messageEnabled()) {
                this.debug.message("SAML2SingleLogoutHandler: userID=" + userID + ", session=" + userSession + ", isSOAInited=" + isSOAPInitiated + ", isIDPInited=" + isIDPInitiated + ", protocol=" + protocol + ", relam=" + realm + ", idpEntityID=" + idpEntityID + ", spEntityID=" + spEntityID + ", status=" + currentStatus + "\nlogout Request XML=" + singleLogoutRequestXML + "\nlogout response XML=" + singleLogoutResponseXML);
            }
            String idpEntityId = saml2Manager.getEntityByMetaAlias(idpMetaAlias);
            return this.handleSOAPInitiatedSingleLogout(userSession, userID, request, response, realm, idpMetaAlias, idpEntityId, relayState, saml2Manager);
        }
        this.debug.message("SAML2SingleLogoutHandler.doIDPSLO : HTTP initiated SLO");
        String redirectURL = MultiProtocolUtils.geServerBaseURL(request) + "/IDPSloInit?" + "binding" + "=" + "urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect" + "&" + "RelayState" + "=" + URLEncoder.encode(relayState, "UTF-8");
        if (this.debug.messageEnabled()) {
            this.debug.message("SAML2SingleLogoutHandler.doIDPSLO: HTTP init, redirect to " + redirectURL);
        }
        response.sendRedirect(redirectURL);
        return 3;
    }

    private String findIDPMetaAlias(String idpEntityID, String spEntityID, String realm, String protocol, SAML2MetaManager saml2Manager) {
        try {
            List hostedIdps = saml2Manager.getAllHostedIdentityProviderEntities(realm);
            if (this.debug.messageEnabled()) {
                this.debug.message("SAML2SingleLogoutHandler.findIDPMetaAlias:  all hosted SAML2 IDPs = " + hostedIdps);
            }
            if (hostedIdps == null || hostedIdps.isEmpty()) {
                return null;
            }
            CircleOfTrustManager cotManager = new CircleOfTrustManager();
            Set cots = cotManager.getAllActiveCirclesOfTrust(realm);
            int num = hostedIdps.size();
            for (int i = 0; i < num; ++i) {
                String idpId = (String)hostedIdps.get(i);
                Iterator it = cots.iterator();
                while (it.hasNext()) {
                    Set providers;
                    String cotName = (String)it.next();
                    if (this.debug.messageEnabled()) {
                        this.debug.message("SAML2SLOHandler.findIDPMetaAlias:  check COT = " + cotName);
                    }
                    if ((providers = cotManager.listCircleOfTrustMember(realm, cotName, "saml2")) == null || !providers.contains(idpId) || (providers = cotManager.listCircleOfTrustMember(realm, cotName, protocol)) == null || !providers.contains(idpEntityID) || spEntityID != null && spEntityID.length() != 0 && !providers.contains(spEntityID)) continue;
                    if (SingleLogoutManager.debug.messageEnabled()) {
                        SingleLogoutManager.debug.message("SAML2SingleLogoutHandler.findIDPMetaAlias : found IDP " + idpId + " in COT " + cotName);
                    }
                    IDPSSOConfigElement config = saml2Manager.getIDPSSOConfig(realm, idpId);
                    return config.getMetaAlias();
                }
            }
        }
        catch (Exception e) {
            SingleLogoutManager.debug.error("SAML2SingleLogoutHandler.findIDPMetaAlias", (Throwable)e);
        }
        return null;
    }

    private boolean isSessionUsedInSAML2(Set userSession, String userId) {
        if (userSession == null || userSession.isEmpty()) {
            return false;
        }
        Object session = userSession.iterator().next();
        return MultiProtocolUtils.usedInProtocol(session, "saml2");
    }

    private int handleSOAPInitiatedSingleLogout(Set userSession, String userID, HttpServletRequest request, HttpServletResponse response, String realm, String idpMetaAlias, String idpEntityId, String relayState, SAML2MetaManager saml2Manager) throws SAML2Exception, SessionException {
        this.debug.message("SAML2SingleLogoutHanlder: handleSOAPInitiatedSLO");
        Object session = null;
        SessionProvider provider = SessionManager.getProvider();
        if (userSession != null && !userSession.isEmpty()) {
            session = userSession.iterator().next();
            if (!provider.isValid(session)) {
                return 4;
            }
        } else {
            return 4;
        }
        if (this.debug.messageEnabled()) {
            this.debug.message("SAML2SLOHandler.handleSOAPSLO: handler session " + session + " for user " + userID);
        }
        String[] sessIndex = provider.getProperty(session, "SAML2IDPSessionIndex");
        if (this.debug.messageEnabled()) {
            this.debug.message("SAML2SLOHandler.handleSOAPSLO: session index = " + sessIndex);
        }
        if (sessIndex == null || sessIndex.length == 0) {
            if (this.debug.warningEnabled()) {
                this.debug.warning("SAML2SLOHandler.handleSOAPSLO: Null session index for " + session);
            }
            return 4;
        }
        IDPSession idpSession = (IDPSession)IDPCache.idpSessionsByIndices.get(sessIndex[0]);
        if (idpSession == null) {
            this.debug.error("SAML2SLOHanlder.handleSOAPSLO: IDP no longer has this session index " + sessIndex[0]);
            return 2;
        }
        List list = idpSession.getNameIDandSPpairs();
        int n = list.size();
        if (this.debug.messageEnabled()) {
            this.debug.message("SAML2SLOHanlder.handleSOAPSLO: NameIDandSPpair for " + sessIndex[0] + " is " + list + ", size=" + n);
        }
        NameIDandSPpair pair = null;
        int soapFailCount = 0;
        for (int i = 0; i < n; ++i) {
            pair = (NameIDandSPpair)list.get(i);
            String spEntityID = pair.getSPEntityID();
            if (this.debug.messageEnabled()) {
                this.debug.message("SAML2SLOHanlder.handleSOAPSLO: SP for " + sessIndex[0] + " is " + spEntityID);
            }
            SPSSODescriptorElement sp = null;
            sp = SAML2Utils.getSAML2MetaManager().getSPSSODescriptor(realm, spEntityID);
            List slosList = sp.getSingleLogoutService();
            SPSSOConfigElement spConfig = SAML2Utils.getSAML2MetaManager().getSPSSOConfig(realm, spEntityID);
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("role", "IDPRole");
            try {
                LogoutUtil.doLogout(idpMetaAlias, spEntityID, slosList, null, "urn:oasis:names:tc:SAML:2.0:bindings:SOAP", relayState, sessIndex[0], pair.getNameID(), request, response, paramsMap, spConfig);
                continue;
            }
            catch (SAML2Exception ex) {
                this.debug.error("SAML2SLOHandler:handleSOAPSLO.doLogout", (Throwable)((Object)ex));
                ++soapFailCount;
            }
        }
        int retStatus = 0;
        if (soapFailCount == n) {
            retStatus = 2;
        } else if (soapFailCount > 0) {
            retStatus = 1;
        }
        MultiProtocolUtils.invalidateSession(session, request, response, "saml2");
        IDPCache.idpSessionsByIndices.remove(sessIndex[0]);
        IDPCache.authnContextCache.remove(sessIndex[0]);
        if (this.debug.messageEnabled()) {
            this.debug.message("SAML2SLOHandler.doSOAPSLO: return status for " + session + " is " + retStatus);
        }
        return retStatus;
    }
}

