/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.multiprotocol;

import com.sun.identity.cot.CircleOfTrustManager;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.jaxb.entityconfig.IDPDescriptorConfigElement;
import com.sun.identity.federation.meta.IDFFMetaManager;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.FSSessionPartner;
import com.sun.identity.federation.services.logout.FSLogoutStatus;
import com.sun.identity.federation.services.logout.FSLogoutUtil;
import com.sun.identity.federation.services.logout.FSSingleLogoutHandler;
import com.sun.identity.liberty.ws.meta.jaxb.IDPDescriptorType;
import com.sun.identity.multiprotocol.MultiProtocolUtils;
import com.sun.identity.multiprotocol.SingleLogoutHandler;
import com.sun.identity.multiprotocol.SingleLogoutManager;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IDFFSingleLogoutHandler
implements SingleLogoutHandler {
    public int doIDPSingleLogout(Set userSession, String userID, HttpServletRequest request, HttpServletResponse response, boolean isSOAPInitiated, boolean isIDPInitiated, String protocol, String realm, String idpEntityID, String spEntityID, String relayState, String singleLogoutRequestXML, String singleLogoutResponseXML, int currentStatus) throws Exception {
        SingleLogoutManager.debug.message("IDFFSingleLogoutHandler.doIDPSLO : start");
        String idpMetaAlias = this.findIDPMetaAlias(idpEntityID, spEntityID, realm, protocol);
        if (idpMetaAlias == null) {
            return 4;
        }
        if (SingleLogoutManager.debug.messageEnabled()) {
            SingleLogoutManager.debug.message("IDFFSingleLogoutHandler: IDFF idp meta alias=" + idpMetaAlias + ", userID=" + userID + ", session=" + userSession + ", isSOAInitiated=" + isSOAPInitiated + ", isIDPInitiated=" + isIDPInitiated + ", protocol=" + protocol + ", relam=" + realm + ", idpEntityID=" + idpEntityID + ", spEntityID=" + spEntityID + ", status=" + currentStatus + "\nlogout Request XML=" + singleLogoutRequestXML + "\nlogout response XML=" + singleLogoutResponseXML);
        }
        IDFFMetaManager idffManager = new IDFFMetaManager(null);
        String idpEntityId = idffManager.getEntityIDByMetaAlias(idpMetaAlias);
        if (!FSLogoutUtil.liveConnectionsExist(userID, idpMetaAlias)) {
            return 4;
        }
        if (isSOAPInitiated) {
            return this.handleSOAPInitiatedSingleLogout(userSession, userID, request, response, realm, idpMetaAlias, idpEntityId, relayState, idffManager);
        }
        SingleLogoutManager.debug.message("IDFFSingleLogoutHandler.doIDPSLO : HTTP initiated SLO");
        if (!MultiProtocolUtils.usedInProtocol(request, "idff")) {
            return 4;
        }
        String redirectURL = MultiProtocolUtils.geServerBaseURL(request) + "/liberty-logout?" + "metaAlias" + "=" + idpMetaAlias + "&" + "RelayState" + "=" + URLEncoder.encode(relayState, "UTF-8");
        if (SingleLogoutManager.debug.messageEnabled()) {
            SingleLogoutManager.debug.message("IDFFSingleLogoutHandler.doIDPSLO : HTTP init, redirect to " + redirectURL);
        }
        response.sendRedirect(redirectURL);
        return 3;
    }

    private int handleSOAPInitiatedSingleLogout(Set userSession, String userID, HttpServletRequest request, HttpServletResponse response, String realm, String idpMetaAlias, String idpEntityId, String relayState, IDFFMetaManager metaManager) throws Exception {
        Object ssoToken = null;
        if (userSession != null && !userSession.isEmpty()) {
            ssoToken = userSession.iterator().next();
        } else {
            FSSessionManager manager = FSSessionManager.getInstance(idpMetaAlias);
            List sessions = manager.getSessionList(userID);
            if (sessions != null && !sessions.isEmpty()) {
                ssoToken = sessions.iterator().next();
            } else {
                return 4;
            }
        }
        FSUtils.debug.message("creating FSSingleLogoutHandler");
        HashMap providerMap = FSLogoutUtil.getCurrentProvider(userID, idpEntityId, ssoToken);
        if (providerMap != null) {
            FSSessionPartner currentSessionProvider = (FSSessionPartner)providerMap.get("PartnerSession");
            String sessionIndex = (String)providerMap.get("SessionIndex");
            if (currentSessionProvider != null) {
                IDPDescriptorType hostedProviderDesc = metaManager.getIDPDescriptor(realm, idpEntityId);
                IDPDescriptorConfigElement hostedConfig = metaManager.getIDPDescriptorConfig(realm, idpEntityId);
                FSSingleLogoutHandler handlerObj = new FSSingleLogoutHandler();
                handlerObj.setHostedDescriptor(hostedProviderDesc);
                handlerObj.setHostedDescriptorConfig(hostedConfig);
                handlerObj.setHostedEntityId(idpEntityId);
                handlerObj.setHostedProviderRole("IDP");
                handlerObj.setMetaAlias(idpMetaAlias);
                handlerObj.setSingleLogoutProtocol("http://projectliberty.org/profiles/slo-idp-soap");
                handlerObj.setRelayState(relayState);
                handlerObj.setRealm(realm);
                FSLogoutStatus logoutStatus = handlerObj.handleSingleLogout(response, request, currentSessionProvider, userID, sessionIndex, false, ssoToken);
                if (SingleLogoutManager.debug.messageEnabled()) {
                    SingleLogoutManager.debug.message("IDFFSLOHandler.handleSOAPInitiatedSLO: logout status=" + logoutStatus.toString());
                }
                if (logoutStatus.getStatus().equalsIgnoreCase("samlp:Success")) {
                    return 0;
                }
                return 2;
            }
        }
        return 4;
    }

    private String findIDPMetaAlias(String idpEntityID, String spEntityID, String realm, String protocol) {
        try {
            IDFFMetaManager idffManager = new IDFFMetaManager(null);
            List hostedIdps = idffManager.getAllHostedIdentityProviderIDs(realm);
            if (hostedIdps == null || hostedIdps.isEmpty()) {
                return null;
            }
            CircleOfTrustManager cotManager = new CircleOfTrustManager();
            Set cots = cotManager.getAllActiveCirclesOfTrust(realm);
            int num = hostedIdps.size();
            for (int i = 0; i < num; ++i) {
                String idpId = (String)hostedIdps.get(i);
                Iterator it = cots.iterator();
                while (it.hasNext()) {
                    String cotName = (String)it.next();
                    Set providers = cotManager.listCircleOfTrustMember(realm, cotName, "idff");
                    if (providers == null || !providers.contains(idpId) || (providers = cotManager.listCircleOfTrustMember(realm, cotName, protocol)) == null || !providers.contains(idpEntityID) || spEntityID != null && !providers.contains(spEntityID)) continue;
                    if (SingleLogoutManager.debug.messageEnabled()) {
                        SingleLogoutManager.debug.message("IDFFSingleLogoutHandler.findIDPMetaAlias : found IDP " + idpId + " in COT " + cotName);
                    }
                    IDPDescriptorConfigElement config = idffManager.getIDPDescriptorConfig(realm, idpId);
                    return config.getMetaAlias();
                }
            }
        }
        catch (Exception e) {
            SingleLogoutManager.debug.error("IDFFSingleLogoutHandler.findIDPMetaAlias", (Throwable)e);
        }
        return null;
    }
}

