/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UsageDirectiveHeader {
    private String ref = null;
    private String id = null;
    private Boolean mustUnderstand = null;
    private String actor = null;
    private List elements = null;

    public UsageDirectiveHeader(String ref) throws SOAPBindingException {
        if (ref == null) {
            String msg = Utils.bundle.getString("refAttributeNull");
            Utils.debug.error("UsageDirectiveHeader: " + msg);
            throw new SOAPBindingException(msg);
        }
        this.ref = ref;
    }

    UsageDirectiveHeader(Element usageDirectiveElement) throws SOAPBindingException {
        this.ref = XMLUtils.getNodeAttributeValue((Node)usageDirectiveElement, (String)"ref");
        this.id = XMLUtils.getNodeAttributeValue((Node)usageDirectiveElement, (String)"id");
        String str = XMLUtils.getNodeAttributeValueNS((Node)usageDirectiveElement, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"mustUnderstand");
        if (str != null && str.length() > 0) {
            try {
                this.mustUnderstand = Utils.StringToBoolean(str);
            }
            catch (Exception pe) {
                String msg = Utils.bundle.getString("invalidMustUnderstand");
                Utils.debug.error("UsageDirectiveHeader: " + msg, (Throwable)pe);
                throw new SOAPBindingException(msg);
            }
        }
        this.actor = XMLUtils.getNodeAttributeValueNS((Node)usageDirectiveElement, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"actor");
        NodeList nl = usageDirectiveElement.getChildNodes();
        int length = nl.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1) continue;
            if (this.elements == null) {
                this.elements = new ArrayList();
            }
            this.elements.add(child);
        }
    }

    public String getRef() {
        return this.ref;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getMustUnderstand() {
        return this.mustUnderstand;
    }

    public String getActor() {
        return this.actor;
    }

    public List getElements() {
        return this.elements;
    }

    public void setRef(String ref) {
        if (ref != null) {
            this.ref = ref;
        }
    }

    public void setMustUnderstand(Boolean mustUnderstand) {
        this.mustUnderstand = mustUnderstand;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public void setElements(List elements) {
        this.elements = elements;
    }

    public void setSignFlag(boolean signFlag) {
        this.id = signFlag ? SAMLUtils.generateID() : null;
    }

    void addToParent(Element headerE) {
        Document doc = headerE.getOwnerDocument();
        Element usageDirectiveHeaderE = doc.createElementNS("urn:liberty:sb:2003-08", "sb:UsageDirective");
        headerE.appendChild(usageDirectiveHeaderE);
        usageDirectiveHeaderE.setAttributeNS(null, "ref", this.ref);
        if (this.id != null) {
            usageDirectiveHeaderE.setAttributeNS(null, "id", this.id);
        }
        if (this.mustUnderstand != null) {
            usageDirectiveHeaderE.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "S:mustUnderstand", Utils.BooleanToString(this.mustUnderstand));
        }
        if (this.actor != null) {
            usageDirectiveHeaderE.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "S:actor", this.actor);
        }
        if (this.elements != null && !this.elements.isEmpty()) {
            Iterator iter = this.elements.iterator();
            while (iter.hasNext()) {
                Element childE = (Element)iter.next();
                usageDirectiveHeaderE.appendChild(doc.importNode(childE, true));
            }
        }
    }
}

