/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.liberty.ws.soapbinding.WebServiceAuthenticator;
import com.sun.identity.plugin.configuration.ConfigurationActionEvent;
import com.sun.identity.plugin.configuration.ConfigurationException;
import com.sun.identity.plugin.configuration.ConfigurationInstance;
import com.sun.identity.plugin.configuration.ConfigurationListener;
import com.sun.identity.plugin.configuration.ConfigurationManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class SOAPBindingService
implements ConfigurationListener {
    static final String SERVICE_NAME = "sunIdentityServerSOAPBinding";
    static final String REQUEST_HANDLER_LIST_ATTR = "RequestHandlerList";
    static final String WEB_SERVICE_AUTHENTICATOR_ATTR = "WebServiceAuthenticator";
    static final String SUPPORTED_AUTHENTICATION_MECHANISMS_ATTR = "SupportedAuthenticationMechanisms";
    static final String ENFORCE_ONLY_KNOWN_PROVIDER_ATTR = "EnforceOnlyKnownProvider";
    static ConfigurationInstance ci = null;
    static HashMap supportedSOAPActionsMap = new HashMap();
    static HashMap handlers = new HashMap();
    static WebServiceAuthenticator wsAuthenticator = null;
    static Set supportedAuthMechs = null;
    static boolean enforceOnlyKnownProvider = true;

    private SOAPBindingService() {
    }

    static WebServiceAuthenticator getWebServiceAuthenticator() {
        return wsAuthenticator;
    }

    static Set getSupportedAuthenticationMechanisms() {
        return supportedAuthMechs;
    }

    static boolean enforceOnlyKnownProviders() {
        if (Utils.debug.messageEnabled()) {
            Utils.debug.message("SOAPBindingService.enforceOnlyKnownProviders");
        }
        return enforceOnlyKnownProvider;
    }

    public void configChanged(ConfigurationActionEvent e) {
        if (Utils.debug.messageEnabled()) {
            Utils.debug.message("Utils.configChanged");
        }
        SOAPBindingService.setValues();
    }

    private static void setValues() {
        Map attrMap = null;
        try {
            attrMap = ci.getConfiguration(null, null);
        }
        catch (ConfigurationException ce) {
            Utils.debug.error("SOAPBindingService.setValues:", (Throwable)((Object)ce));
            return;
        }
        supportedSOAPActionsMap.clear();
        handlers.clear();
        Set values = (Set)attrMap.get(REQUEST_HANDLER_LIST_ATTR);
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            String value = (String)iter.next();
            StringTokenizer stz = new StringTokenizer(value, "|");
            String key = null;
            String class_ = null;
            String soapActions = null;
            while (stz.hasMoreTokens()) {
                String token = stz.nextToken();
                if (token.startsWith("key=")) {
                    key = token.substring(4);
                    continue;
                }
                if (token.startsWith("class=")) {
                    class_ = token.substring(6);
                    continue;
                }
                if (!token.startsWith("soapActions=")) continue;
                soapActions = token.substring(12);
            }
            if (key != null && class_ != null) {
                try {
                    handlers.put(key, Class.forName(class_).newInstance());
                    if (soapActions == null) continue;
                    StringTokenizer stz2 = new StringTokenizer(soapActions);
                    ArrayList<String> list = null;
                    while (stz2.hasMoreTokens()) {
                        if (list == null) {
                            list = new ArrayList<String>();
                        }
                        list.add(stz2.nextToken());
                    }
                    if (list == null) continue;
                    supportedSOAPActionsMap.put(key, list);
                }
                catch (Throwable t) {
                    Utils.debug.error("Utils.setValues class = " + class_, t);
                }
                continue;
            }
            if (!Utils.debug.warningEnabled()) continue;
            Utils.debug.warning("Utils.setValues: Invalid syntax for Request Handler List: " + value);
        }
        values = (Set)attrMap.get(WEB_SERVICE_AUTHENTICATOR_ATTR);
        if (values.isEmpty()) {
            wsAuthenticator = null;
        } else {
            String class_ = (String)values.iterator().next();
            try {
                wsAuthenticator = (WebServiceAuthenticator)Class.forName(class_).newInstance();
            }
            catch (Exception ex) {
                if (Utils.debug.warningEnabled()) {
                    Utils.debug.warning("Utils.setValues: Unable to instantiate WebServiceAuthenticator", (Throwable)ex);
                }
                wsAuthenticator = null;
            }
        }
        supportedAuthMechs = (Set)attrMap.get(SUPPORTED_AUTHENTICATION_MECHANISMS_ATTR);
        Set valuesEnforceOnlyKnownProvider = (Set)attrMap.get(ENFORCE_ONLY_KNOWN_PROVIDER_ATTR);
        if (valuesEnforceOnlyKnownProvider != null && !valuesEnforceOnlyKnownProvider.isEmpty()) {
            String enforce = (String)valuesEnforceOnlyKnownProvider.iterator().next();
            enforceOnlyKnownProvider = Boolean.valueOf(enforce);
        }
    }

    static {
        try {
            ci = ConfigurationManager.getConfigurationInstance("SOAP_BINDING");
            ci.addListener(new SOAPBindingService());
            SOAPBindingService.setValues();
        }
        catch (ConfigurationException ce) {
            Utils.debug.error("SOAPBindingService.static:", (Throwable)((Object)ce));
        }
    }
}

