/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.shared.DateUtils;
import com.sun.identity.shared.xml.XMLUtils;
import java.text.ParseException;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ConsentHeader {
    private String uri = null;
    private Date timestamp = null;
    private String id = null;
    private Boolean mustUnderstand = null;
    private String actor = null;

    public ConsentHeader(String uri) {
        this.uri = uri;
    }

    ConsentHeader(Element consentElement) throws SOAPBindingException {
        this.uri = XMLUtils.getNodeAttributeValue((Node)consentElement, (String)"uri");
        this.id = XMLUtils.getNodeAttributeValue((Node)consentElement, (String)"id");
        String str = XMLUtils.getNodeAttributeValueNS((Node)consentElement, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"mustUnderstand");
        if (str != null && str.length() > 0) {
            try {
                this.mustUnderstand = Utils.StringToBoolean(str);
            }
            catch (Exception pe) {
                String msg = Utils.bundle.getString("invalidMustUnderstand");
                Utils.debug.error("ConsentHeader: " + msg, (Throwable)pe);
                throw new SOAPBindingException(msg);
            }
        }
        if ((str = XMLUtils.getNodeAttributeValue((Node)consentElement, (String)"timestamp")) != null && str.length() > 0) {
            try {
                this.timestamp = DateUtils.stringToDate((String)str);
            }
            catch (ParseException pe) {
                String msg = Utils.bundle.getString("invalidTimestamp");
                Utils.debug.error("ConsentHeader: " + msg, (Throwable)pe);
                throw new SOAPBindingException(msg);
            }
        }
        this.actor = XMLUtils.getNodeAttributeValueNS((Node)consentElement, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"actor");
    }

    public String getUri() {
        return this.uri;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getId() {
        return this.id;
    }

    public Boolean getMustUnderstand() {
        return this.mustUnderstand;
    }

    public String getActor() {
        return this.actor;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setMustUnderstand(Boolean mustUnderstand) {
        this.mustUnderstand = mustUnderstand;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public void setSignFlag(boolean signFlag) {
        this.id = signFlag ? SAMLUtils.generateID() : null;
    }

    void addToParent(Element headerE) {
        Document doc = headerE.getOwnerDocument();
        Element consentHeaderE = doc.createElementNS("urn:liberty:sb:2003-08", "sb:Consent");
        headerE.appendChild(consentHeaderE);
        consentHeaderE.setAttributeNS(null, "uri", this.uri);
        if (this.timestamp != null) {
            consentHeaderE.setAttributeNS(null, "timestamp", DateUtils.toUTCDateFormat((Date)this.timestamp));
        }
        if (this.id != null) {
            consentHeaderE.setAttributeNS(null, "id", this.id);
        }
        if (this.mustUnderstand != null) {
            consentHeaderE.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "S:mustUnderstand", Utils.BooleanToString(this.mustUnderstand));
        }
        if (this.actor != null) {
            consentHeaderE.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "S:actor", this.actor);
        }
    }
}

