/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.soapbinding;

import com.sun.identity.common.HttpURLConnectionManager;
import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.liberty.ws.security.SecurityUtils;
import com.sun.identity.liberty.ws.soapbinding.Message;
import com.sun.identity.liberty.ws.soapbinding.SOAPBindingException;
import com.sun.identity.liberty.ws.soapbinding.SOAPFaultException;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.liberty.ws.soapbinding.WSX509KeyManager;
import com.sun.identity.saml.xmlsig.JKSKeyProvider;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Security;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Client {
    private static TransformerFactory tfactory = TransformerFactory.newInstance();
    private static KeyManager[] kms = null;
    private static TrustManager[] tms = null;
    private static X509KeyManager defaultX509km = null;
    private static String defaultCertAlias = null;
    private static final String SOAP_KEYSTORE_FILE_PROP = "com.sun.identity.liberty.ws.soap.truststore";
    private static final String SOAP_KEYSTORE_PASS_FILE_PROP = "com.sun.identity.liberty.ws.soap.storepass";
    private static final String SOAP_KEYSTORE_TYPE_PROP = "com.sun.identity.liberty.ws.soap.storetype";
    private static final String SOAP_PRIVATE_KEY_PASS_FILE_PROP = "com.sun.identity.liberty.ws.soap.keypass";
    private static final String SOAP_TRUST_MNGR_PROP = "com.sun.identity.liberty.ws.soap.trustmanager";
    private static final String SOAP_TRUST_SECMNGR_ALGO_PROP = "com.sun.identity.liberty.ws.soap.securitymanager.algorithm";

    private Client() {
    }

    public static Message sendRequest(Message req, String connectTo) throws SOAPBindingException, SOAPFaultException {
        return Client.sendRequest(req, connectTo, null, null);
    }

    public static Message sendRequest(Message req, String connectTo, String certAlias) throws SOAPBindingException, SOAPFaultException {
        return Client.sendRequest(req, connectTo, certAlias, null);
    }

    public static Message sendRequest(Message req, String connectTo, String certAlias, String soapAction) throws SOAPBindingException, SOAPFaultException {
        URLConnection con = null;
        try {
            con = Client.getConnection(connectTo, certAlias);
        }
        catch (Exception e) {
            Utils.debug.error("Client:sendRequest", (Throwable)e);
            throw new SOAPBindingException(e.getMessage());
        }
        if (soapAction == null || soapAction.length() == 0) {
            soapAction = "";
        }
        con.setRequestProperty("SOAPAction", soapAction);
        Document doc = null;
        int securityProfileType = req.getSecurityProfileType();
        if (securityProfileType == 0 || securityProfileType == 3) {
            doc = req.toDocument(true);
        } else {
            Element sigElem = SecurityUtils.signMessage(req);
            if (sigElem == null) {
                String msg = Utils.bundle.getString("cannotSignRequest");
                Utils.debug.error("Client.sendRequest: " + msg);
                throw new SOAPBindingException(msg);
            }
            doc = sigElem.getOwnerDocument();
        }
        if (Utils.debug.messageEnabled()) {
            Utils.debug.message("Client.sendRequest: signed request\n" + req);
        }
        OutputStream os = null;
        try {
            os = con.getOutputStream();
            Transformer transformer = tfactory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(doc.getDocumentElement()), new StreamResult(os));
        }
        catch (Exception e) {
            Utils.debug.error("Client:sendRequest", (Throwable)e);
            throw new SOAPBindingException(e.getMessage());
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception e) {
                    Utils.debug.error("Client:sendRequest", (Throwable)e);
                }
            }
        }
        Message resp = null;
        InputStream is = null;
        try {
            is = con.getInputStream();
            resp = new Message(is);
            if (resp.getSOAPFault() != null) {
                throw new SOAPFaultException(resp);
            }
            Utils.enforceProcessingRules(resp, req.getCorrelationHeader().getMessageID(), false);
        }
        catch (IOException e) {
            Utils.debug.error("Client:sendRequest", (Throwable)e);
            throw new SOAPBindingException(e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    Utils.debug.error("Client:sendRequest", (Throwable)e);
                }
            }
        }
        resp.setProtocol(con.getURL().getProtocol());
        if (resp.getSecurityProfileType() != 0 && !SecurityUtils.verifyMessage(resp)) {
            String msg = Utils.bundle.getString("cannotVerifySignature");
            Utils.debug.error("Client.sendRequest: " + msg);
            throw new SOAPBindingException(msg);
        }
        return resp;
    }

    private static URLConnection getConnection(String endpoint, String certAlias) throws Exception {
        URL url = new URL(endpoint);
        HttpURLConnection con = HttpURLConnectionManager.getConnection((URL)url);
        if (Utils.debug.messageEnabled()) {
            Utils.debug.message("Client.getConnection: con class = " + con.getClass());
        }
        if (con instanceof HttpsURLConnection) {
            if (kms == null) {
                Client.initializeJSSE();
            }
            Client.kms[0] = certAlias != null ? new WSX509KeyManager(defaultX509km, certAlias) : new WSX509KeyManager(defaultX509km, defaultCertAlias);
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(kms, tms, null);
            HttpsURLConnection scon = (HttpsURLConnection)con;
            scon.setSSLSocketFactory(ctx.getSocketFactory());
        } else if (Utils.debug.warningEnabled()) {
            Utils.debug.warning("Client.getConnection: not instance of HttpsURLConnection, client cert not selected.");
        }
        con.setDoInput(true);
        con.setDoOutput(true);
        con.setRequestProperty("content-type", "text/xml");
        return con;
    }

    private static void initializeJSSE() throws Exception {
        Security.removeProvider("SunJSSE");
        Security.insertProviderAt((java.security.Provider)new Provider(), 1);
        String algorithm = SystemPropertiesManager.get((String)SOAP_TRUST_SECMNGR_ALGO_PROP);
        if (algorithm == null || algorithm.length() <= 0) {
            algorithm = "SunX509";
        }
        JKSKeyProvider jkskp = Client.createKeyProvider();
        KeyStore trustStore = jkskp.getKeyStore();
        KeyManagerFactory kf = KeyManagerFactory.getInstance(algorithm);
        kf.init(trustStore, jkskp.getPrivateKeyPass().toCharArray());
        kms = kf.getKeyManagers();
        defaultX509km = (X509KeyManager)kms[0];
        Client.defineTrustManager(trustStore, algorithm);
    }

    private static void defineTrustManager(KeyStore trustStore, String algorithm) throws SOAPBindingException {
        boolean error = false;
        try {
            TrustManagerFactory tf = TrustManagerFactory.getInstance(algorithm);
            tf.init(trustStore);
            TrustManager[] defaultTrustManagers = tf.getTrustManagers();
            String trustManagerDefinition = SystemPropertiesManager.get((String)SOAP_TRUST_MNGR_PROP);
            if (trustManagerDefinition != null && trustManagerDefinition.length() > 0) {
                tms = new TrustManager[defaultTrustManagers.length + 1];
                Client.tms[0] = (TrustManager)Class.forName(trustManagerDefinition).newInstance();
                for (int i = 0; i < defaultTrustManagers.length; ++i) {
                    Client.tms[i + 1] = defaultTrustManagers[i];
                }
            } else {
                tms = defaultTrustManagers;
            }
        }
        catch (ClassNotFoundException cnfe) {
            Utils.debug.error("Client.defineTrustManager class not found: ", (Throwable)cnfe);
            error = true;
        }
        catch (InstantiationException ie) {
            Utils.debug.error("Client.defineTrustManager cannot instantiate: ", (Throwable)ie);
            error = true;
        }
        catch (NoSuchAlgorithmException nsae) {
            Utils.debug.error("Client.defineTrustManager no algorithm: ", (Throwable)nsae);
            error = true;
        }
        catch (IllegalAccessException iae) {
            Utils.debug.error("Client.defineTrustManager illegal access: ", (Throwable)iae);
            error = true;
        }
        catch (KeyStoreException kse) {
            Utils.debug.error("Client.defineTrustManager keystore: ", (Throwable)kse);
            error = true;
        }
        if (error) {
            String msg = Utils.bundle.getString("cannotDefineTrustManager");
            throw new SOAPBindingException(msg);
        }
    }

    private static boolean useSpecificTrustStore() {
        return SystemConfigurationUtil.getProperty(SOAP_KEYSTORE_FILE_PROP) != null && SystemConfigurationUtil.getProperty(SOAP_KEYSTORE_PASS_FILE_PROP) != null && SystemConfigurationUtil.getProperty(SOAP_KEYSTORE_TYPE_PROP) != null && SystemConfigurationUtil.getProperty(SOAP_PRIVATE_KEY_PASS_FILE_PROP) != null;
    }

    private static JKSKeyProvider createKeyProvider() {
        JKSKeyProvider jksKp = Client.useSpecificTrustStore() ? new JKSKeyProvider(SOAP_KEYSTORE_FILE_PROP, SOAP_KEYSTORE_PASS_FILE_PROP, SOAP_KEYSTORE_TYPE_PROP, SOAP_PRIVATE_KEY_PASS_FILE_PROP) : new JKSKeyProvider();
        return jksKp;
    }

    static {
        defaultCertAlias = SystemPropertiesManager.get((String)"com.sun.identity.liberty.ws.soap.certalias");
    }
}

