/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.security;

import com.sun.identity.common.SystemConfigurationUtil;
import com.sun.identity.liberty.ws.common.wsse.BinarySecurityToken;
import com.sun.identity.liberty.ws.disco.EncryptedResourceID;
import com.sun.identity.liberty.ws.security.SecurityAssertion;
import com.sun.identity.liberty.ws.security.SecurityTokenException;
import com.sun.identity.liberty.ws.security.SecurityTokenManager;
import com.sun.identity.liberty.ws.security.SecurityTokenManagerImpl;
import com.sun.identity.liberty.ws.security.SessionContext;
import com.sun.identity.plugin.session.SessionManager;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.shared.configuration.SystemPropertiesManager;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.encode.Base64;
import com.sun.identity.shared.jaxrpc.SOAPClient;
import com.sun.identity.shared.locale.Locale;
import com.sun.identity.shared.xml.XMLUtils;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.ResourceBundle;

public final class SecurityTokenManagerClient {
    private static String SERVICE_NAME = "securitytokenmanager";
    private static boolean checkedForLocal;
    private static boolean isLocal;
    private boolean useLocal;
    private static SOAPClient remoteStub;
    private SecurityTokenManager securityTokenManager;
    private String ssoToken = null;
    private SOAPClient stub;
    static ResourceBundle bundle;

    public SecurityTokenManagerClient(Object credential) throws SecurityTokenException {
        if (!checkedForLocal) {
            try {
                remoteStub = SecurityTokenManagerClient.getServiceEndPoint(SystemPropertiesManager.get((String)"com.iplanet.am.server.protocol"), SystemPropertiesManager.get((String)"com.iplanet.am.server.host"), SystemPropertiesManager.get((String)"com.iplanet.am.server.port"), SystemPropertiesManager.get((String)"com.iplanet.am.services.deploymentDescriptor"));
                remoteStub.send("checkForLocal", null, null, null);
                if (SecurityTokenManagerImpl.isLocal) {
                    isLocal = true;
                    SecurityTokenManager.debug.warning("STMC(): Using local service");
                    this.securityTokenManager = new SecurityTokenManager(credential);
                }
                checkedForLocal = true;
            }
            catch (Exception e) {
                checkedForLocal = true;
                if (SecurityTokenManager.debug.warningEnabled()) {
                    SecurityTokenManager.debug.warning("SecurityTokenManagerClient()Exception", (Throwable)e);
                }
                throw new SecurityTokenException(e.getMessage());
            }
        }
        if (isLocal) {
            this.useLocal = true;
        } else {
            this.stub = remoteStub;
            try {
                this.ssoToken = SessionManager.getProvider().getSessionID(credential);
                this.stub.send("initialization", (Object)this.ssoToken, null, this.ssoToken);
            }
            catch (Exception e) {
                if (SecurityTokenManager.debug.warningEnabled()) {
                    SecurityTokenManager.debug.warning("SecurityTokenManagerClient()Exception", (Throwable)e);
                }
                throw new SecurityTokenException(e.getMessage());
            }
        }
    }

    public SecurityTokenManagerClient(String url, Object credential) throws SecurityTokenException {
        try {
            this.ssoToken = SessionManager.getProvider().getSessionID(credential);
            String[] urls = new String[]{url};
            this.stub = new SOAPClient(urls);
            this.stub.send("initialization", (Object)this.ssoToken, null, this.ssoToken);
            this.useLocal = false;
        }
        catch (Exception e) {
            if (SecurityTokenManager.debug.warningEnabled()) {
                SecurityTokenManager.debug.warning("STMC() Exception", (Throwable)e);
            }
            throw new SecurityTokenException(e.getMessage());
        }
    }

    private static SOAPClient getServiceEndPoint(String protocol, String hostname, String port, String uri) throws Exception {
        int intPort = Integer.parseInt(port);
        URL weburl = SystemConfigurationUtil.getServiceURL(SERVICE_NAME, protocol, hostname, intPort, uri);
        String iurl = weburl.toString();
        if (SecurityTokenManager.debug.messageEnabled()) {
            SecurityTokenManager.debug.message("SecurityTokenManagerClient with URL: " + iurl);
        }
        String[] urls = new String[]{iurl};
        return new SOAPClient(urls);
    }

    private static SOAPClient getRemoteStub() throws SecurityTokenException {
        SOAPClient remoteStub;
        Exception ee;
        boolean foundServer;
        block8: {
            foundServer = false;
            ee = null;
            remoteStub = null;
            try {
                Iterator serverList = SystemConfigurationUtil.getServerList().iterator();
                while (serverList.hasNext() && !foundServer) {
                    URL u = new URL((String)serverList.next());
                    remoteStub = SecurityTokenManagerClient.getServiceEndPoint(u.getProtocol(), u.getHost(), Integer.toString(u.getPort()), u.getPath());
                    try {
                        remoteStub.send("checkForLocal", null, null, null);
                        if (SecurityTokenManager.debug.messageEnabled()) {
                            SecurityTokenManager.debug.message("STMC(): Using the remote URL: " + u.toString());
                        }
                        foundServer = true;
                        if (!SecurityTokenManager.debug.warningEnabled()) continue;
                        SecurityTokenManager.debug.warning("STMC:getRemoteStub: remote server being used: " + u.toString());
                    }
                    catch (Exception e) {
                        ee = e;
                        if (!SecurityTokenManager.debug.warningEnabled()) continue;
                        SecurityTokenManager.debug.warning("STMC:getRemoteStub: server (" + u.toString() + ") error: ", (Throwable)e);
                    }
                }
            }
            catch (Exception f) {
                ee = f;
                if (!SecurityTokenManager.debug.warningEnabled()) break block8;
                SecurityTokenManager.debug.warning("STMC:getRemoteStub: generic error: ", (Throwable)f);
            }
        }
        if (!foundServer) {
            if (ee != null) {
                throw new SecurityTokenException(ee.getMessage());
            }
            throw new SecurityTokenException(bundle.getString("serverNotFound"));
        }
        return remoteStub;
    }

    public void setCertAlias(String certAlias) throws SecurityTokenException {
        if (this.useLocal) {
            this.securityTokenManager.setCertAlias(certAlias);
        } else {
            try {
                Object[] obj = new Object[]{certAlias, Boolean.TRUE};
                this.stub.send("setCertificate", obj, null, this.ssoToken);
            }
            catch (Exception e) {
                if (SecurityTokenManager.debug.warningEnabled()) {
                    SecurityTokenManager.debug.warning("STMC:setCertAlias()", (Throwable)e);
                }
                throw new SecurityTokenException(e.getMessage());
            }
        }
    }

    public void setCertificate(X509Certificate cert) throws SecurityTokenException {
        if (this.useLocal) {
            this.securityTokenManager.setCertificate(cert);
        } else {
            try {
                String certString = Base64.encode((byte[])cert.getEncoded());
                Object[] obj = new Object[]{certString, Boolean.FALSE};
                this.stub.send("setCertificate", obj, null, this.ssoToken);
            }
            catch (Exception e) {
                if (SecurityTokenManager.debug.warningEnabled()) {
                    SecurityTokenManager.debug.warning("STMC:setCertificate()", (Throwable)e);
                }
                throw new SecurityTokenException(e.getMessage());
            }
        }
    }

    public BinarySecurityToken getX509CertificateToken() throws SecurityTokenException {
        if (this.useLocal) {
            return this.securityTokenManager.getX509CertificateToken();
        }
        String bst = null;
        try {
            bst = (String)this.stub.send("getX509CertificateToken", null, null, this.ssoToken);
            return new BinarySecurityToken(XMLUtils.toDOMDocument((String)bst, (Debug)SecurityTokenManager.debug).getDocumentElement());
        }
        catch (Exception e) {
            if (SecurityTokenManager.debug.warningEnabled()) {
                SecurityTokenManager.debug.warning("STMC:getX509CertificateToken()", (Throwable)e);
            }
            throw new SecurityTokenException(e.getMessage());
        }
    }

    public SecurityAssertion getSAMLAuthenticationToken(NameIdentifier senderIdentity) throws SecurityTokenException, SAMLException {
        if (this.useLocal) {
            return this.securityTokenManager.getSAMLAuthenticationToken(senderIdentity);
        }
        try {
            String ni = senderIdentity.toString(true, true);
            String assertion = (String)this.stub.send("getSAMLAuthenticationToken", (Object)ni, null, this.ssoToken);
            return new SecurityAssertion(XMLUtils.toDOMDocument((String)assertion, (Debug)SecurityTokenManager.debug).getDocumentElement());
        }
        catch (Exception re) {
            if (SecurityTokenManager.debug.warningEnabled()) {
                SecurityTokenManager.debug.warning("STMC:getSAMLAuthenticationToken()", (Throwable)re);
            }
            throw new SAMLException(re.getMessage());
        }
    }

    public SecurityAssertion getSAMLAuthorizationToken(NameIdentifier senderIdentity, SessionContext invocatorSession, String resourceID, boolean includeAuthN, boolean includeResourceAccessStatement, String recipientProviderID) throws SecurityTokenException, SAMLException {
        if (this.useLocal) {
            return this.securityTokenManager.getSAMLAuthorizationToken(senderIdentity, invocatorSession, resourceID, includeAuthN, includeResourceAccessStatement, recipientProviderID);
        }
        try {
            String ni = senderIdentity.toString(true, true);
            String sc = invocatorSession.toXMLString(true, true);
            Object[] obj = new Object[]{ni, sc, resourceID, Boolean.FALSE, includeAuthN, includeResourceAccessStatement, recipientProviderID};
            String assertion = (String)this.stub.send("getSAMLAuthorizationToken", obj, null, this.ssoToken);
            return new SecurityAssertion(XMLUtils.toDOMDocument((String)assertion, (Debug)SecurityTokenManager.debug).getDocumentElement());
        }
        catch (Exception e) {
            if (SecurityTokenManager.debug.warningEnabled()) {
                SecurityTokenManager.debug.warning("STMC:createAssertionArtifact:", (Throwable)e);
            }
            throw new SecurityTokenException(e.getMessage());
        }
    }

    public SecurityAssertion getSAMLAuthorizationToken(NameIdentifier senderIdentity, SessionContext invocatorSession, EncryptedResourceID encResourceID, boolean includeAuthN, boolean includeResourceAccessStatement, String recipientProviderID) throws SecurityTokenException, SAMLException {
        if (this.useLocal) {
            return this.securityTokenManager.getSAMLAuthorizationToken(senderIdentity, invocatorSession, encResourceID, includeAuthN, includeResourceAccessStatement, recipientProviderID);
        }
        String assertion = null;
        try {
            String ni = senderIdentity.toString(true, true);
            String sc = invocatorSession.toXMLString(true, true);
            String resourceID = encResourceID.toString();
            Object[] obj = new Object[]{ni, sc, resourceID, Boolean.TRUE, includeAuthN, includeResourceAccessStatement, recipientProviderID};
            assertion = (String)this.stub.send("getSAMLAuthorizationToken", obj, null, this.ssoToken);
            return new SecurityAssertion(XMLUtils.toDOMDocument((String)assertion, (Debug)SecurityTokenManager.debug).getDocumentElement());
        }
        catch (Exception e) {
            if (SecurityTokenManager.debug.warningEnabled()) {
                SecurityTokenManager.debug.warning("STMC:getSAMLAuthorizationToken() ", (Throwable)e);
            }
            throw new SecurityTokenException(e.getMessage());
        }
    }

    static {
        bundle = Locale.getInstallResourceBundle((String)"libLibertySecurity");
    }
}

