/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.liberty.ws.paos;

import com.sun.identity.liberty.ws.paos.PAOSException;
import com.sun.identity.liberty.ws.paos.PAOSUtils;
import com.sun.identity.liberty.ws.soapbinding.Utils;
import com.sun.identity.shared.debug.Debug;
import com.sun.identity.shared.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PAOSResponse {
    private String refToMessageID = null;
    private Boolean mustUnderstand;
    private String actor;

    public PAOSResponse(String refToMessageID, Boolean mustUnderstand, String actor) throws PAOSException {
        this.refToMessageID = refToMessageID;
        this.mustUnderstand = mustUnderstand;
        this.actor = actor;
        this.validateData();
    }

    public PAOSResponse(Element element) throws PAOSException {
        this.parseElement(element);
    }

    public PAOSResponse(String xmlString) throws PAOSException {
        Document xmlDocument = XMLUtils.toDOMDocument((String)xmlString, (Debug)PAOSUtils.debug);
        if (xmlDocument == null) {
            throw new PAOSException(PAOSUtils.bundle.getString("errorPAOSResponseElement"));
        }
        this.parseElement(xmlDocument.getDocumentElement());
    }

    public String getRefToMessageID() {
        return this.refToMessageID;
    }

    public void setRefToMessageID(String refToMessageID) {
        this.refToMessageID = refToMessageID;
    }

    public Boolean isMustUnderstand() {
        return this.mustUnderstand;
    }

    public void setMustUnderstand(Boolean mustUnderstand) {
        this.mustUnderstand = mustUnderstand;
    }

    public String getActor() {
        return this.actor;
    }

    public void setActor(String actor) {
        this.actor = actor;
    }

    public String toXMLString() throws PAOSException {
        return this.toXMLString(true, false);
    }

    public String toXMLString(boolean includeNSPrefix, boolean declareNS) throws PAOSException {
        this.validateData();
        StringBuffer xml = new StringBuffer(300);
        xml.append("<");
        if (includeNSPrefix) {
            xml.append("paos").append(":");
        }
        xml.append("Response");
        if (declareNS) {
            xml.append(" xmlns:").append("paos").append("=\"").append("urn:liberty:paos:2003-08").append("\" xmlns:").append("soap-env").append("=\"").append("http://schemas.xmlsoap.org/soap/envelope/").append("\"");
        }
        if (this.refToMessageID != null) {
            xml.append(" ").append("refToMessageID").append("=\"").append(this.refToMessageID).append("\"");
        }
        xml.append(" ").append("soap-env").append(":").append("mustUnderstand").append("=\"").append(this.mustUnderstand.toString()).append("\"").append(" ").append("soap-env").append(":").append("actor").append("=\"").append(this.actor).append("\"></");
        if (includeNSPrefix) {
            xml.append("paos").append(":");
        }
        xml.append("Response").append(">");
        return xml.toString();
    }

    private void parseElement(Element element) throws PAOSException {
        if (element == null) {
            if (PAOSUtils.debug.messageEnabled()) {
                PAOSUtils.debug.message("PAOSResponse.parseElement: Input is null.");
            }
            throw new PAOSException(PAOSUtils.bundle.getString("nullInput"));
        }
        String localName = element.getLocalName();
        if (!"Response".equals(localName)) {
            if (PAOSUtils.debug.messageEnabled()) {
                PAOSUtils.debug.message("PAOSResponse.parseElement: element local name should be Response");
            }
            throw new PAOSException(PAOSUtils.bundle.getString("invalidPAOSResponse"));
        }
        String namespaceURI = element.getNamespaceURI();
        if (!"urn:liberty:paos:2003-08".equals(namespaceURI)) {
            if (PAOSUtils.debug.messageEnabled()) {
                PAOSUtils.debug.message("PAOSResponse.parseElement: element namespace should be urn:liberty:paos:2003-08");
            }
            throw new PAOSException(PAOSUtils.bundle.getString("invalidPAOSNamesapce"));
        }
        this.refToMessageID = XMLUtils.getNodeAttributeValue((Node)element, (String)"refToMessageID");
        String str = XMLUtils.getNodeAttributeValueNS((Node)element, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"mustUnderstand");
        try {
            this.mustUnderstand = Utils.StringToBoolean(str);
        }
        catch (Exception ex) {
            throw new PAOSException(PAOSUtils.bundle.getString("invalidValueMustUnderstand"));
        }
        this.actor = XMLUtils.getNodeAttributeValueNS((Node)element, (String)"http://schemas.xmlsoap.org/soap/envelope/", (String)"actor");
        this.validateData();
    }

    private void validateData() throws PAOSException {
        if (this.mustUnderstand == null) {
            if (PAOSUtils.debug.messageEnabled()) {
                PAOSUtils.debug.message("PAOSResponse.validateData: mustUnderstand is missing in the paos:Response");
            }
            throw new PAOSException(PAOSUtils.bundle.getString("missingMustUnderstandPAOSResponse"));
        }
        if (this.actor == null) {
            if (PAOSUtils.debug.messageEnabled()) {
                PAOSUtils.debug.message("PAOSResponse.validateData: actor is missing in the paos:Response");
            }
            throw new PAOSException(PAOSUtils.bundle.getString("missingActorPAOSResponse"));
        }
    }
}

